<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- English Revision: 1864135 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_socache_redis.xml.meta">

<name>mod_socache_redis</name>
<description>Fournisseur de cache d'objets partagé basé sur Redis.</description>
<status>Extension</status>
<sourcefile>mod_socache_redis.c</sourcefile>
<identifier>socache_redis_module</identifier>
<compatibility>Disponible à partir de la version 2.4.39 du serveur HTTP Apache</compatibility>

<summary>
    <p><module>mod_socache_redis</module> implémente un fournisseur de cache
    d'objets partagé qui permet la création et l'accès à un cache hébergé par le
    système de mise en cache d'objets en mémoire partagée à hautes performances
    <a href="https://redis.io/">Redis</a>.
    </p>

    <p>La méthode "create" de ce fournisseur de cache d'objets partagé nécessite
    une liste en mémoire de spécifications hôte/port séparées par des virgules.
    Si vous utilisez ce fournisseur dans une directive de configuration d'un autre
    module comme <directive module="mod_ssl">SSLSessionCache</directive>,
    spécifiez la liste des serveurs sous la forme du paramètre optionnel "arg" :</p>

    <highlight language="config">
        SSLSessionCache redis:redis.example.com:12345,redis2.example.com:12345
    </highlight>

    <p>Vous trouverez une description détaillée des autres fournisseurs de cache
    d'objets partagé <a href="../socache.html">ici</a>.
    </p>

</summary>

<directivesynopsis>
<name>RedisConnPoolTTL</name>
<description>Durée de vie du jeu de connexions avec le(s) serveur(s) Redis.</description>
<syntax>RedisConnPoolTTL <em>num</em>[<em>units</em>]</syntax>
<default>RedisConnPoolTTL 15s</default>
<contextlist>
<context>server config</context>
<context>virtual host</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.4.39 du serveur HTTP Apache.</compatibility>

<usage>
    <p>Cette directive permet de définir la durée pendant laquelle les
    connexions inactives avec le(s) serveur(s) Redis seront conservées
    (plateformes threadées seulement).</p>
    
    <p>Les valeurs valides pour <directive>RedisConnPoolTTL</directive> sont des
    durées limitées à 1 heure . 0 signifie aucune limite.</p>

    <note><p>Par défaut, l'unité de ces valeurs est la secondes, mais on peut
    spécifier via un suffixe des valeurs en millisecondes (ms), en secondes (s),
    en minutes (min) ou en heures (h).
    </p></note>

    <example>
    <highlight language="config">
# Définit une durée de vie de 10 minutes
RedisConnPoolTTL 10min
# Définit une durée de vie de 60 secondes
RedisConnPoolTTL 60
    </highlight>
    </example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>RedisTimeout</name>
<description>Durée maximale de lecture/écriture sur la connexion avec le(s)
serveur(s) Redis.</description>
<syntax>RedisTimeout <em>num</em>[<em>units</em>]</syntax>
<default>RedisTimeout 5s</default>
<contextlist>
<context>server config</context>
<context>virtual host</context>
</contextlist>
<compatibility>Disponible à partir de la version 2.4.39 du serveur HTTP Apache.</compatibility>

<usage>
    <p>Cette directive permet de définir la durée maximale de lecture/écriture
    sur la connexion avec le(s) serveur(s) Redis.</p>
    
    <p>Les valeurs valides pour <directive>RedisTimeout</directive> sont des
    durées limitées à 1 heure . 0 signifie aucune limite.</p>

    <note><p>Par défaut, l'unité de ces valeurs est la secondes, mais on peut
    spécifier via un suffixe des valeurs en millisecondes (ms), en secondes (s),
    en minutes (min) ou en heures (h).
    </p></note>

    <example>
    <highlight language="config">
# Définit une durée de 10 minutes
RedisTimeout 10min
# Définit une durée de 60 secondes
RedisTimeout 60
    </highlight>
    </example>
</usage>
</directivesynopsis>

</modulesynopsis>
