<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1874455 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_ssl.xml.meta">

<name>mod_ssl</name>
<description>Chiffrement de haut niveau basé sur les protocoles Secure
Sockets Layer (SSL) et Transport Layer Security (TLS)</description>
<status>Extension</status>
<sourcefile>mod_ssl.c</sourcefile>
<identifier>ssl_module</identifier>

<summary>
<p>Ce module fournit le support SSL v3 et TLS v1 au serveur HTTP
Apache. SSL v2 n'est plus supporté.</p>

<p>Ce module s'appuie sur <a href="http://www.openssl.org/">OpenSSL</a>
pour fournir le moteur de chiffrement.</p>

<p>D'autres détails, discussions et exemples sont fournis dans la <a
href="../ssl/">documentation SSL</a>.</p>
</summary>

<section id="envvars"><title>Variables d'environnement</title>

<p>Ce module peut être configuré pour fournir aux espaces de nommage SSI
et CGI de nombreux éléments d'informations concernant SSL par le biais
de variables d'environnement supplémentaires. Par défaut, et pour
des raisons de performances, ces informations ne sont pas fournies (Voir
la directive <directive>SSLOptions</directive> StdEnvVars ci-dessous).
Les variables générées se trouvent dans la table ci-dessous.
Ces informations peuvent également être disponible sous des noms différents
à des fins de compatibilité ascendante. Reportez-vous au chapitre <a
href="../ssl/ssl_compat.html">Compatibilité</a> pour plus de détails à
propos des variables de compatibilité.</p>

<table border="1">
<columnspec><column width=".3"/><column width=".2"/><column width=".5"/>
</columnspec>
<tr>
 <th><a name="table3">Nom de la variable :</a></th>
 <th>Type de valeur :</th>
 <th>Description :</th>
</tr>
<tr><td><code>HTTPS</code></td>                         <td>drapeau</td>
<td>HTTPS est utilisé.</td></tr>
<tr><td><code>SSL_PROTOCOL</code></td>                  <td>chaîne</td>
<td>La version du protocole SSL (SSLv3, TLSv1, TLSv1.1, TLSv1.2)</td></tr>
<tr><td><code>SSL_SESSION_ID</code></td>                <td>chaîne</td>
<td>L'identifiant de session SSL codé en hexadécimal</td></tr>
<tr><td><code>SSL_SESSION_RESUMED</code></td>           <td>chaîne</td>
<td>Session SSL initiale ou reprise. Note : plusieurs requêtes peuvent
être servies dans le cadre de la même session SSL (initiale ou reprise)
si les connexions persistantes (HTTP KeepAlive) sont utilisées</td></tr>
<tr><td><code>SSL_SECURE_RENEG</code></td>              <td>chaîne</td>
<td><code>true</code> si la renégociation sécurisée est supportée,
<code>false</code> dans le cas contraire</td></tr>
<tr><td><code>SSL_CIPHER</code></td>                    <td>chaîne</td>
<td>Le nom de l'algorithme de chiffrement</td></tr>
<tr><td><code>SSL_CIPHER_EXPORT</code></td>             <td>chaîne</td>
<td><code>true</code> si l'algorithme de chiffrement est un algorithme
exporté</td></tr>
<tr><td><code>SSL_CIPHER_USEKEYSIZE</code></td>         <td>nombre</td>
<td>Nombre de bits de chiffrement (réellement utilisés)</td></tr>
<tr><td><code>SSL_CIPHER_ALGKEYSIZE</code></td>         <td>nombre</td>
<td>Nombre de bits de chiffrement (possible)</td></tr>
<tr><td><code>SSL_COMPRESS_METHOD</code></td>           <td>chaîne</td>
<td>Méthode de compression SSL négociée</td></tr>

<tr><td><code>SSL_VERSION_INTERFACE</code></td>         <td>chaîne</td>
<td>La version du programme mod_ssl</td></tr>
<tr><td><code>SSL_VERSION_LIBRARY</code></td>           <td>chaîne</td>
<td>La version du programme OpenSSL</td></tr>
<tr><td><code>SSL_CLIENT_M_VERSION</code></td>          <td>chaîne</td>
<td>La version du certificat client</td></tr>
<tr><td><code>SSL_CLIENT_M_SERIAL</code></td>           <td>chaîne</td>
<td>Le numéro de série du certificat client</td></tr>
<tr><td><code>SSL_CLIENT_S_DN</code></td>               <td>chaîne</td>
<td>Le DN sujet du certificat client</td></tr>
<tr><td><code>SSL_CLIENT_S_DN_</code><em>x509</em></td> <td>chaîne</td>
<td>Elément du DN sujet du client</td></tr>
<tr><td><code>SSL_CLIENT_SAN_Email_</code><em>n</em></td> <td>chaîne</td>
<td>Les entrées d'extension subjectAltName du certificat client de type rfc822Name</td></tr>
<tr><td><code>SSL_CLIENT_SAN_DNS_</code><em>n</em></td> <td>chaîne</td>
<td>Les entrées d'extension subjectAltName du certificat client de type dNSName</td></tr>
<tr><td><code>SSL_CLIENT_SAN_OTHER_msUPN_</code><em>n</em></td>
<td>chaîne</td>    <td>Extensions subjectAltName de type otherName du
certificat client, forme Microsoft du nom principal de l'utilisateur (OID 1.3.6.1.4.1.311.20.2.3)</td></tr>
<tr><td><code>SSL_CLIENT_I_DN</code></td>               <td>chaîne</td>
<td>DN de l'émetteur du certificat du client</td></tr>
<tr><td><code>SSL_CLIENT_I_DN_</code><em>x509</em></td> <td>chaîne</td>
<td>Elément du DN de l'émetteur du certificat du client</td></tr>
<tr><td><code>SSL_CLIENT_V_START</code></td>            <td>chaîne</td>
<td>Validité du certificat du client (date de début)</td></tr>
<tr><td><code>SSL_CLIENT_V_END</code></td>              <td>chaîne</td>
<td>Validité du certificat du client (date de fin)</td></tr>
<tr><td><code>SSL_CLIENT_V_REMAIN</code></td>           <td>chaîne</td>
<td>Nombre de jours avant expiration du certificat du client</td></tr>
<tr><td><code>SSL_CLIENT_A_SIG</code></td>              <td>chaîne</td>
<td>Algorithme utilisé pour la signature du certificat du client</td></tr>
<tr><td><code>SSL_CLIENT_A_KEY</code></td>              <td>chaîne</td>
<td>Algorithme utilisé pour la clé publique du certificat du client</td></tr>
<tr><td><code>SSL_CLIENT_CERT</code></td>               <td>chaîne</td>
<td>Certificat du client au format PEM</td></tr>
<tr><td><code>SSL_CLIENT_CERT_CHAIN_</code><em>n</em></td>
<td>chaîne</td>    <td>Certificats de la chaîne de certification du
client au format PEM</td></tr>
<tr><td><code>SSL_CLIENT_CERT_RFC4523_CEA</code></td>   <td>chaîne</td>
<td>Numéro de série et fournisseur du certificat. le format correspond à
celui de la CertificateExactAssertion dans la RFC4523</td></tr>
<tr><td><code>SSL_CLIENT_VERIFY</code></td>             <td>chaîne</td>
<td><code>NONE</code>, <code>SUCCESS</code>, <code>GENEROUS</code> ou
<code>FAILED:</code><em>raison</em></td></tr>
<tr><td><code>SSL_SERVER_M_VERSION</code></td>          <td>chaîne</td>
<td>La version du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_M_SERIAL</code></td>           <td>chaîne</td>    <td>

The serial of the server certificate</td></tr>
<tr><td><code>SSL_SERVER_S_DN</code></td>               <td>chaîne</td>
<td>DN sujet du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_S_DN_</code><em>x509</em></td> <td>chaîne</td>
<td>Elément du DN sujet du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_SAN_Email_</code><em>n</em></td>
<td>chaîne</td>  <td>Les entrées d'extension subjectAltName du
certificat de serveur de type rfc822Name</td></tr>
<tr><td><code>SSL_SERVER_SAN_DNS_</code><em>n</em></td> <td>chaîne</td>
<td>Les entrées d'extension subjectAltName du
certificat de serveur de type dNSName</td></tr>
<tr><td><code>SSL_SERVER_SAN_OTHER_dnsSRV_</code><em>n</em></td>
<td>chaîne</td>    <td>Extensions subjectAltName de type otherName du
certificat serveur, sous la forme SRVName (OID 1.3.6.1.5.5.7.8.7, RFC 4985)</td></tr>
<tr><td><code>SSL_SERVER_I_DN</code></td>               <td>chaîne</td>
<td>DN de l'émetteur du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_I_DN_</code><em>x509</em></td> <td>chaîne</td>
<td>Elément du DN de l'émetteur du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_V_START</code></td>            <td>chaîne</td>
<td>Validité du certificat du serveur (date de dédut)</td></tr>
<tr><td><code>SSL_SERVER_V_END</code></td>              <td>chaîne</td>
<td>Validité du certificat du serveur (date de fin)</td></tr>
<tr><td><code>SSL_SERVER_A_SIG</code></td>              <td>chaîne</td>
<td>Algorithme utilisé pour la signature du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_A_KEY</code></td>              <td>chaîne</td>
<td>Algorithme utilisé pour la clé publique du certificat du serveur</td></tr>
<tr><td><code>SSL_SERVER_CERT</code></td>               <td>chaîne</td>
<td>Certificat du serveur au format PEM</td></tr>
<tr><td><code>SSL_SRP_USER</code></td>                  <td>chaîne</td>
<td>nom d'utilisateur SRP</td></tr>
<tr><td><code>SSL_SRP_USERINFO</code></td>              <td>chaîne</td>
<td>informations sur l'utilisateur SRP</td></tr>
<tr><td><code>SSL_TLS_SNI</code></td>                   <td>string</td>
<td>Contenu de l'extension SNI TLS (si supporté par ClientHello)</td></tr>
</table>

<p><em>x509</em> spécifie un élément de DN X.509 parmi
<code>C,ST,L,O,OU,CN,T,I,G,S,D,UID,Email</code>. A partir de la version
2.2.0 d'Apache, <em>x509</em> peut aussi comporter un suffixe numérique
<code>_n</code>. Si le DN en question comporte plusieurs attributs de
noms identiques, ce suffixe constitue un index débutant à zéro et
permettant de sélectionner un
attribut particulier. Par exemple, si le DN sujet du certificat du
serveur comporte deux champs OU, on peut utiliser
<code>SSL_SERVER_S_DN_OU_0</code> et <code>SSL_SERVER_S_DN_OU_1</code>
pour référencer chacun d'entre eux. Un nom de variable sans suffixe
<code>_n</code> est équivalent au même nom avec le suffixe
<code>_0</code>, ce qui correspond au premier attribut (ou au seul)
caractérisant le DN.
Lorsque la table d'environnement est remplie en utilisant l'option
<code>StdEnvVars</code> de la directive <directive
module="mod_ssl">SSLOptions</directive>, le premier attribut (ou le
seul) caractérisant le DN est enregistré avec un nom sans suffixe ;
autrement dit, aucune entrée possédant comme suffixe <code>_0</code>
n'est enregistrée.</p>

<p>A partir de la version 2.4.32 de httpd, on peut ajouter le suffixe
<em>_RAW</em> à <em>x509</em> dans un composant DN afin d'empêcher la conversion
de la valeur de l'attribut en UTF-8. Il doit être placé après le suffixe index
(s'il existe). On utilisera par exemple <code>SSL_SERVER_S_DN_OU_RAW</code> ou
<code>SSL_SERVER_S_DN_OU_0_RAW</code>.</p>

<p>Le format des variables <em>*_DN</em> a changé depuis la version
2.3.11 d'Apache HTTPD. Voir l'option <code>LegacyDNStringFormat</code>
de la directive <directive module="mod_ssl">SSLOptions</directive> pour
plus de détails.</p>

<p><code>SSL_CLIENT_V_REMAIN</code> n'est disponible qu'à partir de la
version 2.1.</p>

<p>Plusieurs variables d'environnement additionnelles peuvent être
utilisées dans les expressions <directive>SSLRequire</directive>, ou
dans les formats de journalisation personnalisés :</p>

<note><pre>HTTP_USER_AGENT        PATH_INFO             AUTH_TYPE
HTTP_REFERER           QUERY_STRING          SERVER_SOFTWARE
HTTP_COOKIE            REMOTE_HOST           API_VERSION
HTTP_FORWARDED         REMOTE_IDENT          TIME_YEAR
HTTP_HOST              IS_SUBREQ             TIME_MON
HTTP_PROXY_CONNECTION  DOCUMENT_ROOT         TIME_DAY
HTTP_ACCEPT            SERVER_ADMIN          TIME_HOUR
THE_REQUEST            SERVER_NAME           TIME_MIN
REQUEST_FILENAME       SERVER_PORT           TIME_SEC
REQUEST_METHOD         SERVER_PROTOCOL       TIME_WDAY
REQUEST_SCHEME         REMOTE_ADDR           TIME
REQUEST_URI            REMOTE_USER</pre></note>

<p>Dans ces contextes, deux formats spéciaux peuvent aussi être utilisés
:</p>

<dl>
  <dt><code>ENV:<em>nom_variable</em></code></dt>
  <dd>Correspond à la variable d'environnement standard
  <em>nom_variable</em>.</dd>

  <dt><code>HTTP:<em>nom_en-tête</em></code></dt>
  <dd>Correspond à la valeur de l'en-tête de requête dont le nom est
  <em>nom_en-tête</em>.</dd>
</dl>

</section>

<section id="logformats"><title>Formats de journaux
personnalisés</title>

<p>Lorsque <module>mod_ssl</module> est compilé dans le serveur Apache
ou même chargé (en mode DSO), des fonctions supplémentaires sont
disponibles pour le <a
href="mod_log_config.html#formats">Format de journal personnalisé</a> du
module <module>mod_log_config</module>. A ce titre, la fonction de
format d'eXtension ``<code>%{</code><em>nom-var</em><code>}x</code>''
peut être utilisée pour présenter en extension toute variable fournie
par tout module, et en particulier celles fournies par mod_ssl et que
vous trouverez dans la table ci-dessus.</p>
<p>
A des fins de compatibilité ascendante, il existe une fonction de format
cryptographique supplémentaire
``<code>%{</code><em>nom</em><code>}c</code>''. Vous trouverez toutes
les informations à propos de cette fonction dans le chapitre <a
href="../ssl/ssl_compat.html">Compatibilité</a>.</p>
<example><title>Exemple</title>
<highlight language="config">
CustomLog "logs/ssl_request_log" "%t %h %{SSL_PROTOCOL}x %{SSL_CIPHER}x \"%r\" %b"
</highlight>
</example>
<p>Ces formats sont disponibles même si l'option <code>StdEnvVars</code> de la
directive <directive module="mod_ssl">SSLOptions</directive> n'a pas été
définie.</p>
</section>

<section id="notes"><title>Information à propos de la requête</title>

<p><module>mod_ssl</module> enregistre des informations à propos de la
requête que l'on peut restituer dans les journaux avec la chaîne de
format <code>%{<em>nom</em>}n</code> via le module
<module>mod_log_config</module>.</p>

<p>Les informations enregistrées sont les suivantes :</p>

<dl>
  <dt><code>ssl-access-forbidden</code></dt>
  <dd>Cette information contient la valeur <code>1</code> si l'accès a
  été refusé suite à une directive <directive>SSLRequire</directive> ou
  <directive>SSLRequireSSL</directive>.</dd>

  <dt><code>ssl-secure-reneg</code></dt>
  <dd>Si <module>mod_ssl</module> a été compilé avec une version
  d'OpenSSL qui supporte la renégociation sécurisée, si SSL est utilisé
  pour la connexion courante et si le client supporte lui aussi la
  renégociation sécurisée, cette information contiendra la valeur
  <code>1</code>. Si le client ne supporte pas la renégociation
  sécurisée, l'information contiendra la valeur <code>0</code>. Si
  <module>mod_ssl</module> n'a pas été compilé avec une version
  d'OpenSSL qui supporte la renégociation sécurisée, ou si SSL n'est pas
  utilisé pour la connexion courante, le contenu de l'information ne
  sera pas défini.</dd>
</dl>

</section>

<section id="expressionparser"><title>Extension pour l'interprétation
des expressions</title>

<p>Lorsque <module>mod_ssl</module> est compilé statiquement avec
Apache, ou même chargé dynamiquement (en tant que module DSO), toute <a
name="envvars">variable</a> en provenance de <module>mod_ssl</module> peut
être utilisée pour l'<a href="../expr.html">interprétation des
expression ap_expr</a>. Les variables peuvent être référencées en
utilisant la syntaxe ``<code>%{</code><em>varname</em><code>}</code>''.
A partir de la version 2.4.18, on peut aussi utiliser la syntaxe de
style <module>mod_rewrite</module>
``<code>%{SSL:</code><em>varname</em><code>}</code>'', ou la syntaxe de
style fonction ``<code>ssl(</code><em>varname</em><code>)</code>''.</p>
<example><title>Exemple (en utilisant <module>mod_headers</module>)</title>
<highlight language="config">
Header set X-SSL-PROTOCOL "expr=%{SSL_PROTOCOL}"
Header set X-SSL-CIPHER "expr=%{SSL:SSL_CIPHER}"
</highlight>
</example>
<p>Cette fonctionnalité est disponible même si l'option
<code>StdEnvVars</code> de la directive <directive
module="mod_ssl">SSLOptions</directive> n'a pas été définie.</p>
</section>

<section id="authzproviders"><title>Fournisseurs d'autorisation
disponibles avec Require</title>

  <p><module>mod_ssl</module> propose quelques fournisseurs
  d'autorisation à utiliser avec la directive <directive
  module="mod_authz_core">Require</directive> du module
  <module>mod_authz_core</module>.</p>

  <section id="reqssl"><title>Require ssl</title>

    <p>Le fournisseur <code>ssl</code> refuse l'accès si une connexion
    n'est pas chiffrée avec SSL. L'effet est similaire à celui de la
    directive <directive>SSLRequireSSL</directive>.</p>


    <highlight language="config">
      Require ssl
</highlight>


  </section>

  <section id="reqverifyclient"><title>Require ssl-verify-client</title>

    <p>Le fournisseur <code>ssl</code> autorise l'accès si
    l'utilisateur est authentifié via un certificat client valide. Ceci
    n'a un effet que si <code>SSLVerifyClient optional</code> est actif.</p>

    <p>Dans l'exemple suivant, l'accès est autorisé si le client est
    authentifié via un certificat client ou par nom d'utilisateur/mot de
    passe :</p>

    <highlight language="config">
Require ssl-verify-client
Require valid-user      
    </highlight>

  </section>

</section>

<directivesynopsis>
<name>SSLPassPhraseDialog</name>
<description>Méthode utilisée pour entrer le mot de passe pour les clés
privées chiffrées</description>
<syntax>SSLPassPhraseDialog <em>type</em></syntax>
<default>SSLPassPhraseDialog builtin</default>
<contextlist><context>server config</context></contextlist>

<usage>
<p>
Lors de son démarrage, Apache doit lire les différents fichiers de
certificats (voir la directive <directive
module="mod_ssl">SSLCertificateFile</directive>) et de clés privées
(voir la directive <directive
module="mod_ssl">SSLCertificateKeyFile</directive>) des serveurs
virtuels où SSL est activé. Comme, pour des raisons de sécurité, les
fichiers de clés privées sont en général chiffrés,  mod_ssl doit
demander à l'administrateur un mot de passe pour déchiffrer ces
fichiers. L'argument <em>type</em> permet de choisir la manière dont
cette demande peut être formulée parmi les trois suivantes :</p>
<ul>
<li><code>builtin</code>
    <p>
    C'est la méthode par défaut, et un dialogue interactive de terminal
    s'ouvre au cours du démarrage juste avant qu'Apache ne se détache du
    terminal. A ce moment, l'administrateur doit entrer manuellement un
    mot de passe pour chaque fichier de clé privée chiffré. Etant donné
    qu'il peut y avoir un grand nombre de serveurs virtuels configurés
    avec SSL activé, le protocole de réutilisation suivant est utilisé
    pour minimiser le dialogue : lorsqu'un fichier de clé privée est
    chiffré, tous les mots de passe connus (au début, il n'y en a aucun,
    bien entendu) sont essayés. Si l'un de ces mots de passe connus
    convient, aucun dialogue ne s'ouvrira pour ce fichier de
    clé privée particulier. Si aucun ne convient, un autre mot de passe
    sera demandé à partir du terminal et sera mis en mémoire pour le
    fichier de clé privée suivant (pour lequel il pourra éventuellement
    être réutilisé).</p>
    <p>
    Cette méthode confère à mod_ssl une grande souplesse (car pour N
    fichiers de clé privée chiffrés, vous <em>pouvez</em> utiliser N
    mots de passe différents - mais vous devrez alors tous les fournir,
    bien entendu), tout en minimisant le dialogue de terminal (vous
    pouvez en effet utiliser un seul mot de passe pour les N fichiers de
    clé privée et vous n'aurez alors à l'entrer qu'une seule
    fois).</p></li>

<li><code>|/chemin/vers/programme [arguments...]</code>

   <p>Ce mode permet d'utiliser un programme externe qui va se présenter
   comme une redirection vers un périphérique d'entrée particulier ; le
   texte de prompt standard utilisé pour le mode <code>builtin</code>
   est envoyé au programme sur <code>stdin</code>, et celui-ci doit
   renvoyer des mots de passe sur <code>stdout</code>. Si
   plusieurs mots de passe sont requis (ou si un mot de passe incorrect
   a été entré), un texte de prompt supplémentaire sera écrit après le
   retour du premier mot de passe, et d'autres mots de passe devront
   alors être réécrits.</p></li>

<li><code>exec:/chemin/vers/programme</code>
    <p>
    Ici, un programme externe est appelé au démarrage du serveur pour
    chaque fichier de clé privée chiffré.Il est appelé avec deux
    arguments (le premier est de la forme
    ``<code>nom-serveur:port</code>'', le second
    est ``<code>RSA</code>'', ``<code>DSA</code>'', ``<code>ECC</code>''
    ou un index entier commençant à 3 si plus de 3 clés ont été
    configurées), qui
    indiquent pour quels serveur et algorithme il doit écrire le mot de
    passe correspondant sur <code>stdout</code>. Avec les versions 2.4.8
    (non réalisée) et
    2.4.9, il est appelé avec un seul argument, une chaîne de la forme
    "<code>servername:portnumber:index</code>" (où <code>index</code>
    est un nombre entier commençant à zéro), qui spécifie le serveur,
    le port TCP et un numéro de certificat. Le but recherché est
    l'exécution de vérifications de sécurité préalables permettant de
    s'assurer que le système n'est pas victime d'une attaque, et de ne
    fournir le mot de passe que si toutes les vérifications ont été
    effectuées avec succès.</p>
    <p>
    Ces vérifications de sécurité, ainsi que la manière dont le mot de
    passe est déterminé peuvent être aussi sophistiqués que vous le
    désirez. Mod_ssl ne définit que l'interface : un programme
    exécutable qui écrit le mot de passe sur <code>stdout</code>. Ni
    plus, ni moins ! Ainsi, si vous êtes vraiment paranoïaque en matière
    de sécurité, voici votre interface. Tout le reste doit être confié à
    l'administrateur à titre d'exercice, car les besoins en sécurité
    locale sont très différents.</p>
    <p>
    L'algorithme de réutilisation est utilisé ici aussi. En d'autres
    termes, le programme externe n'est appelé qu'une fois par mot de
    passe unique.</p></li>
</ul>
<example><title>Exemple</title>
<highlight language="config">
SSLPassPhraseDialog "exec:/usr/local/apache/sbin/pp-filter"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLRandomSeed</name>
<description>Source de déclenchement du Générateur de Nombres
Pseudo-Aléatoires (PRNG)</description>
<syntax>SSLRandomSeed <em>contexte</em> <em>source</em>
[<em>nombre</em>]</syntax>
<contextlist><context>server config</context></contextlist>

<usage>
<p>
Cette directive permet de définir une ou plusieurs sources de
déclenchement du Générateur de Nombres Pseudo-Aléatoires (PRNG) dans
OpenSSL au démarrage du serveur (si <em>contexte</em> a pour valeur
<code>startup</code>) et/ou juste avant l'établissement d'une nouvelle
connexion SSL (si <em>contexte</em> a pour valeur <code>connect</code>).
Cette directive ne peut être utilisée qu'au niveau du serveur global car
le PRNG est un service global.</p>
<p>
Les différentes valeurs de <em>source</em> disponibles sont :</p>
<ul>
<li><code>builtin</code>
    <p>Cette source de déclenchement intégrée est toujours disponible.  Son
    utilisation consomme un minimum de cycles CPU en cours d'exécution, et son
    utilisation ne présente de ce fait aucun problème. La source utilisée pour
    déclencher le PRNG contient la date courante, l'identifiant du processus
    courant et un extrait de 128 octets aléatoirement choisi dans la pile. Ceci
    présente un inconvénient car le caractère aléatoire de cette source n'est
    pas vraiment fort, et au démarrage (lorsque la structure d'échanges n'est
    pas encore disponible), cette source ne produit que quelques octets
    d'entropie.  Vous devez donc toujours utiliser une source de déclenchement
    additionnelle, au moins pour le démarrage.</p></li>
<li><code>file:/chemin/vers/source</code>
    <p>
    Cette variante utilise un fichier externe
    <code>file:/chemin/vers/source</code> comme source de déclenchement
    du PRNG. Lorsque <em>nombre</em> est spécifié, seuls les
    <em>nombre</em> premiers octets du fichier forment l'entropie (et
    <em>nombre</em> est fourni comme premier argument à
    <code>/chemin/vers/source</code>). Lorsque <em>nombre</em> n'est pas
    spécifié, l'ensemble du fichier forme l'entropie (et <code>0</code>
    est fourni comme premier argument à
    <code>/chemin/vers/source</code>). Utilisez cette source en
    particulier au démarrage, par exemple avec un fichier de
    périphérique <code>/dev/random</code> et/ou
    <code>/dev/urandom</code> (qui sont en général présent sur les
    plate-formes dérivées d'Unix modernes comme FreeBSD et Linux).</p>
    <p><em>Soyez cependant prudent</em> : en général,
    <code>/dev/random</code> ne fournit que l'entropie dont il dispose
    réellement ; en d'autres termes, lorsque vous demandez 512 octets
    d'entropie, si le périphérique ne dispose que de 100 octets, deux
    choses peuvent se produire : sur certaines plates-formes, vous ne
    recevez que les 100 octets, alors que sur d'autres, la lecture se
    bloque jusqu'à ce qu'un nombre suffisant d'octets soit disponible
    (ce qui peut prendre beaucoup de temps). Il est préférable ici
    d'utiliser le périphérique <code>/dev/urandom</code>, car il ne se
    bloque jamais et fournit vraiment la quantité de données demandées.
    Comme inconvénient, les données reçues ne sont pas forcément de la
    meilleure qualité.</p></li>

<li><code>exec:/chemin/vers/programme</code>
    <p>
    Cette variante utilise un exécutable externe
    <code>/chemin/vers/programme</code> comme source de déclenchement du
    PRNG. Lorsque <em>nombre</em> est spécifié, seules les
    <em>nombre</em> premiers octets de son flux <code>stdout</code>
    forment l'entropie. Lorsque <em>nombre</em> n'est pas spécifié,
    l'intégralité des données produites sur <code>stdout</code> forment
    l'entropie. N'utilisez cette variante qu'au démarrage où une source
    de déclenchement fortement aléatoire est nécessaire, en utilisant
    un programme externe (comme dans l'exemple
    ci-dessous avec l'utilitaire <code>truerand</code> basé sur la
    bibliothèque <em>truerand</em> de AT&amp;T que vous trouverez
    dans la distribution de mod_ssl). Bien entendu, l'utilisation de
    cette variante dans un contexte "connection" ralentit le serveur de
    manière trop importante, et en général, vous devez donc éviter
    d'utiliser des programmes externes dans ce contexte.</p></li>
<li><code>egd:/chemin/vers/socket-egd</code> (Unix seulement)
    <p>Cette variante utilise le socket de domaine Unix du Démon
    Générateur d'Entropie externe ou Entropy Gathering Daemon ou EGD
    (voir <a
    href="http://www.lothar.com/tech/crypto/">http://www.lothar.com/tech
    /crypto/</a>) pour déclencher le PRNG. N'utilisez cette variante que
    si votre plate-forme ne possède pas de périphérique random ou
    urandom.</p></li>
</ul>
<example><title>Exemple</title>
<highlight language="config">
SSLRandomSeed startup builtin
SSLRandomSeed startup "file:/dev/random"
SSLRandomSeed startup "file:/dev/urandom" 1024
SSLRandomSeed startup "exec:/usr/local/bin/truerand" 16
SSLRandomSeed connect builtin
SSLRandomSeed connect "file:/dev/random"
SSLRandomSeed connect "file:/dev/urandom" 1024
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLSessionCache</name>
<description>Type du cache de session SSL global et
inter-processus</description>
<syntax>SSLSessionCache <em>type</em></syntax>
<default>SSLSessionCache none</default>
<contextlist><context>server config</context></contextlist>

<usage>
<p>
Cette directive permet de configurer le type de stockage du cache de
session SSL global et inter-processus. Ce cache est une fonctionnalité
optionnelle qui accélère le traitement parallèle des requêtes. Pour ce
qui est des requêtes vers un même processus du serveur (via HTTP
keep-alive), OpenSSL met en cache les informations de session SSL en
interne. Mais comme les clients modernes demandent des images en ligne
et d'autres données via des requêtes parallèles (un nombre de quatre
requêtes parallèles est courant), ces requêtes vont être servies par
<em>plusieurs</em> processus du serveur pré-déclenchés. Ici, un cache
inter-processus permet d'éviter des négociations de session
inutiles.</p>
<p>
Les quatre <em>type</em>s de stockage suivants sont actuellement
supportés :</p>
<ul>
<li><code>none</code>

    <p>Cette valeur désactive le cache de session global et
    inter-processus, ce qui va ralentir le serveur de manière sensible
    et peut poser problème avec certains navigateurs, en particulier si
    les certificats clients sont activés. Cette configuration n'est pas
    recommandée.</p></li>

<li><code>nonenotnull</code>

    <p>Cette valeur désactive tout cache de session global et
    inter-processus. Cependant, elle force OpenSSL à envoyer un
    identifiant de session non nul afin de s'adapter aux clients bogués
    qui en nécessitent un.</p></li>

<li><code>dbm:/chemin/vers/fichier-données</code>

    <p>Cette valeur utilise un fichier de hashage DBM sur disque local
    pour synchroniser les caches OpenSSL locaux en mémoire des processus
    du serveur. Ce cache de session peut être sujet à des problèmes de
    fiabilité sous forte charge. Pour l'utiliser, le module
    <module>mod_socache_dbm</module> doit être chargé.</p></li>

<li><code>shmcb:/chemin/vers/fichier-données</code>[<code>(</code><em>nombre</em><code>)</code>]

    <p>Cette valeur utilise un tampon cyclique à hautes performances
    (d'une taille d'environ <em>nombre</em> octets) dans un segment de
    mémoire partagée en RAM (établi via
    <code>/chemin/vers/fichier-données</code>, pour synchroniser les
    caches OpenSSL locaux en mémoire des processus du serveur. C'est le
    type de cache de session recommandé. Pour l'utiliser, le module
    <module>mod_socache_shmcb</module> doit être chargé.</p></li>

<li><code>dc:UNIX:/chemin/vers/socket</code>

    <p>Cette valeur utilise les bibliothèques de mise en cache de
    sessions distribuée sur <a
    href="http://distcache.sourceforge.net/">distcache</a>.
    L'argument doit spécifier le serveur ou mandataire à utiliser en
    utilisant la syntaxe d'adressage distcache ; par exemple,
    <code>UNIX:/chemin/vers/socket</code> spécifie une socket de domaine
    Unix (en général un mandataire de dc_client local) ;
    <code>IP:serveur.example.com:9001</code> spécifie une adresse IP.
    Pour l'utiliser, le module <module>mod_socache_dc</module> doit être
    chargé.</p></li>

</ul>

<example><title>Exemples</title>
<highlight language="config">
SSLSessionCache "dbm:/usr/local/apache/logs/ssl_gcache_data"
SSLSessionCache "shmcb:/usr/local/apache/logs/ssl_gcache_data(512000)"
</highlight>
</example>

<p>Le mutex <code>ssl-cache</code> permet de sérialiser l'accès au cache
de session afin d'éviter toute corruption. Ce mutex peut être configuré
via la directive <directive module="core">Mutex</directive>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLSessionCacheTimeout</name>
<description>Nombre de secondes avant l'expiration d'une session SSL
dans le cache de sessions</description>
<syntax>SSLSessionCacheTimeout <em>secondes</em></syntax>
<default>SSLSessionCacheTimeout 300</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>S'applique aussi à la reprise de session TLS (RFC 5077) à
partir de la version 2.4.10 du serveur HTTP Apache</compatibility>

<usage>
<p>
Cette directive permet de définir la durée de vie en secondes des
informations stockées dans le cache de sessions SSL global et
inter-processus, dans le cache OpenSSL interne en mémoire et pour
les sessions réinitialisées par la reprise de session TLS (RFC 5077). elle peut
être définie à une valeur d'environ 15 à des fins de test, mais à une
valeur très supérieure comme 300 en production.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLSessionCacheTimeout 600
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLEngine</name>
<description>Interrupteur marche/arrêt du moteur SSL</description>
<syntax>SSLEngine on|off|optional</syntax>
<default>SSLEngine off</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>
Cette directive permet d'activer/désactiver le moteur du protocole
SSL/TLS. Elle doit être utilisée dans une section <directive
module="core" type="section">VirtualHost</directive> pour activer
SSL/TLS pour ce serveur virtuel particulier. Par défaut, le moteur du
protocole SSL/TLS est désactivé pour le serveur principal et tous les
serveurs virtuels configurés.</p>
<example><title>Exemple</title>
<highlight language="config">
&lt;VirtualHost _default_:443&gt;
SSLEngine on
#...
&lt;/VirtualHost&gt;
</highlight>
</example>
<p>Depuis la version 2.1 d'Apache, la directive
<directive>SSLEngine</directive> peut être définie à
<code>optional</code>, ce qui active le support de <a
href="http://www.ietf.org/rfc/rfc2817.txt">RFC 2817</a>, Upgrading to
TLS Within HTTP/1.1. Pour le moment, aucun navigateur web ne supporte
RFC 2817.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLFIPS</name>
<description>Coimmutateur du mode SSL FIPS</description>
<syntax>SSLFIPS on|off</syntax>
<default>SSLFIPS off</default>
<contextlist><context>server config</context></contextlist>

<usage>
<p>
Cette directive permet d'activer/désactiver l'utilisation du drapeau
FIPS_mode de la bibliothèque SSL. Elle doit être définie dans le
contexte du serveur principal, et n'accepte pas les configurations
sources de conflits (SSLFIPS on suivi de SSLFIPS off par exemple). Le
mode s'applique à toutes les opérations de la bibliothèque SSL.
</p>
<p>
Si httpd a été compilé avec une bibliothèque SSL qui ne supporte pas le
drapeau FIPS_mode, la directive <code>SSLFIPS on</code> échouera.
Reportez-vous au document sur la politique de sécurité FIPS 140-2 de la
bibliothèque du fournisseur SSL, pour les prérequis spécifiques
nécessaires à l'utilisation de mod_ssl selon un mode d'opération
approuvé par FIPS 140-2 ; notez que mod_ssl en lui-même n'est pas
validé, mais peut être décrit comme utilisant un module de chiffrement
validé par FIPS 140-2, lorsque tous les composants sont assemblés et mis
en oeuvre selon les recommandations de la politique de sécurité
applicable.
</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProtocol</name>
<description>Indique les versions du protocole SSL/TLS
disponibles</description>
<syntax>SSLProtocol [+|-]<em>protocole</em> ...</syntax>
<default>SSLProtocol all -SSLv3 (jusqu'à la version 2.4.16 : all)</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>
Cette directive permet de définir quelles versions du protocole SSL/TLS
seront acceptées lors de l'initialisation d'une nouvelle connexion.</p>
<p>
Les <em>protocole</em>s disponibles sont les suivants (sensibles à la
casse) :</p>
<ul>
<li><code>SSLv3</code>
    <p>
    Il s'agit du protocole Secure Sockets Layer (SSL) version 3.0 de
    Netscape Corporation. C'est le successeur de SSLv2 et le
    prédécesseur de TLSv1, mais est considéré comme
    obsolète dans la <a href="http://www.ietf.org/rfc/rfc7568.txt">RFC
    7568</a></p></li>

<li><code>TLSv1</code>
    <p>
    Il s'agit du protocole  Transport Layer Security (TLS) version 1.0.
    C'est le successeur de SSLv3, et il est défini dans la <a
    href="http://www.ietf.org/rfc/rfc2246.txt">RFC2246</a>. Il est
    supporté par la plupart des clients.</p></li>

<li><code>TLSv1.1</code> (à partir de la version 1.0.1 d'OpenSSL)
    <p>
    Une révision du protocole TLS 1.0 définie dans la <a
    href="http://www.ietf.org/rfc/rfc4346.txt">RFC 4346</a>.</p></li>

<li><code>TLSv1.2</code> (à partir de la version 1.0.1 d'OpenSSL)
    <p>
    Une révision du protocole TLS 1.1 définie dans la <a
    href="http://www.ietf.org/rfc/rfc5246.txt">RFC 5246</a>.</p></li>

<li><code>TLSv1.3</code> (à partir de la version 1.1.1 d'OpenSSL)
     <p>
     Une nouvelle version du protocole TLS définie dans la <a
     href="http://www.ietf.org/rfc/rfc8446.txt">RFC 8446</a>.</p></li>

<li><code>all</code>
    <p>
    C'est un raccourci pour ``<code>+SSLv3 +TLSv1</code>'' ou - à partir
    de la version 1.0.1 d'OpenSSL - ``<code>+SSLv3 +TLSv1 +TLSv1.1
    +TLSv1.2</code>'' (sauf si OpenSSL a été compilé avec l'option
    ``no-ssl3'', auquel cas <code>all</code> n'inclura pas
    <code>+SSLv3</code>).</p></li>
</ul>
<example><title>Exemple</title>
<highlight language="config">
SSLProtocol TLSv1
</highlight>
</example>
<note>
<title>La directive <directive>SSLProtocol</directive> et les serveurs virtuels
basés sur le nom</title>
<p>
Avant OpenSSL 1.1.1, et même si l'indication du nom de serveur (Server Name
Indication ou SNI) permettait de déterminer le serveur virtuel cible assez tôt
au cours de la négociation TLS, il était impossible de changer de version de
protocole TLS à ce point, si bien que le <directive>SSLProtocol</directive>
négocié se basait toujours sur celui du <em>serveur virtuel de base</em> (le
premier serveur virtuel déclaré avec le couple <code>IP:port</code> de la
connexion).
</p>
<p>
A partir de la version 2.4.42, si le serveur HTTP Apache est compilé avec une
version 1.1.1. ou supérieure d'OpenSSL, et si le client fournit la SNI dans la
négociation TLS, le <directive>SSLProtocol</directive> de chaque serveur virtuel
(basé sur le nom) pourra être pris en compte et le sera.
</p>
<p>
A des fins de compatibilité avec les versions précédentes, si un serveur virtuel
basé sur le nom n'a aucune directive <directive>SSLProtocol</directive> définie,
c'est le protocole du serveur virtuel de base qui s'appliquera, <strong>à
moins</strong> qu'une directive <directive>SSLProtocol</directive> ne soit
configurée au niveau global, auquel cas c'est le protocole défini par cette
directive qui s'appliquera (ce dernier cas relève cependant plus d'un
comportement logique que d'un souci de compatibilité).
</p>
</note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCipherSuite</name>
<description>Algorithmes de chiffrement disponibles pour la négociation
au cours de l'initialisation de la connexion SSL</description>
<syntax>SSLCipherSuite [<em>protocol</em>] <em>cipher-spec</em></syntax>
<default>SSLCipherSuite DEFAULT (dépend de la version d'OpenSSL
installée)</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context></contextlist>
<override>AuthConfig</override>

<usage>
<p>
Cette directive complexe utilise la chaîne <em>cipher-spec</em>
contenant la liste des algorithmes de chiffrement OpenSSL que le client
peut utiliser au cours de la phase d'initialisation de la connexion SSL. La
spécification optionnelle du protocole permet de configurer la suite
d'algorithmes de chiffrement pour une version spécifique de SSL. Une des valeurs
possibles est "SSL" pour toutes les versions du protocole SSL jusqu'à TLSv1.2
compris.
</p>
<p>
Notez que cette directive peut être utilisée aussi bien dans un contexte
de serveur que dans un contexte de répertoire. Dans un contexte de
serveur, elle s'applique à l'initialisation SSL standard lorsqu'une
connexion est établie. Dans un contexte de répertoire, elle force une
renégociation SSL avec la liste d'algorithmes de chiffrement spécifiée
après la lecture d'une requête HTTP, mais avant l'envoi de la réponse
HTTP.</p>
<p>
Si la bibliothèque SSL supporte TLSv1.3 (versions d'OpenSSL 1.1.1 et
supérieures), il est possible de spécifier le paramètre "TLSv1.3" pour
configurer la suite d'algorithmes de chiffrement pour ce protocole. Comme
TLSv1.3 n'autorise pas la renégociation, spécifier pour lui des algorithmes de
chiffrement dans un contexte de répertoire n'est pas autorisé</p>
<p>
Pour obtenir la liste des noms d'algorithmes de chiffrement pour TLSv1.3, se
référer à la <a
href="https://www.openssl.org/docs/manmaster/man3/SSL_CTX_set_ciphersuites.html">the
OpenSSL documentation</a>.</p>
<p>
La liste d'algorithmes de chiffrement SSL spécifiée par l'argument
<em>cipher-spec</em> comporte quatre attributs principaux auxquels
s'ajoutent quelques attributs secondaires :</p>
<ul>
<li><em>Algorithme d'échange de clés</em>:<br />
    RSA, Diffie-Hellman, Elliptic Curve Diffie-Hellman, Secure Remote Password.
</li>
<li><em>Algorithme d'authentification</em>:<br />
    RSA, Diffie-Hellman, DSS, ECDSA, ou none.
</li>
<li><em>Algorithme de chiffrement</em>:<br />
    AES, DES, Triple-DES, RC4, RC2, IDEA, etc...
</li>
<li><em>Algorithme de condensé MAC</em>:<br />
    MD5, SHA ou SHA1, SHA256, SHA384.
</li>
</ul>
<p>L'algorithme de chiffrement peut aussi provenir de l'extérieur. Les
algorithmes SSLv2 ne sont plus supportés.
Pour définir les algorithmes à utiliser, on
peut soit spécifier tous les algorithmes à la fois, soit utiliser des
alias pour spécifier une liste d'algorithmes dans leur ordre de
préférence (voir <a href="#table1">Table 1</a>). Les algorithmes et
alias effectivement disponibles dépendent de la version d'openssl
utilisée. Les versions ultérieures d'openssl sont susceptibles d'inclure
des algorithmes supplémentaires.</p>

<table border="1">
<columnspec><column width=".5"/><column width=".5"/></columnspec>
<tr><th><a name="table1">Symbole</a></th> <th>Description</th></tr>
<tr><td colspan="2"><em>Algorithme d'échange de clés :</em></td></tr>
<tr><td><code>kRSA</code></td>   <td>Echange de clés RSA</td></tr>
<tr><td><code>kDHr</code></td>   <td>Echange de clés Diffie-Hellman avec
clé RSA</td></tr>
<tr><td><code>kDHd</code></td>   <td>Echange de clés Diffie-Hellman avec
clé DSA</td></tr>
<tr><td><code>kEDH</code></td>   <td>Echange de clés Diffie-Hellman
temporaires (pas de certificat)</td>   </tr>
<tr><td><code>kSRP</code></td>   <td>échange de clés avec mot de passe
distant sécurisé (SRP)</td></tr>
<tr><td colspan="2"><em>Algorithmes d'authentification :</em></td></tr>
<tr><td><code>aNULL</code></td>  <td>Pas d'authentification</td></tr>
<tr><td><code>aRSA</code></td>   <td>Authentification RSA</td></tr>
<tr><td><code>aDSS</code></td>   <td>Authentification DSS</td> </tr>
<tr><td><code>aDH</code></td>    <td>Authentification Diffie-Hellman</td></tr>
<tr><td colspan="2"><em>Algorithmes de chiffrement :</em></td></tr>
<tr><td><code>eNULL</code></td>  <td>Pas de chiffrement</td>         </tr>
<tr><td><code>NULL</code></td>   <td>alias pour eNULL</td>         </tr>
<tr><td><code>AES</code></td>    <td>Chiffrement AES</td>        </tr>
<tr><td><code>DES</code></td>    <td>Chiffrement DES</td>        </tr>
<tr><td><code>3DES</code></td>   <td>Chiffrement Triple-DES</td> </tr>
<tr><td><code>RC4</code></td>    <td>Chiffrement RC4</td>       </tr>
<tr><td><code>RC2</code></td>    <td>Chiffrement RC2</td>       </tr>
<tr><td><code>IDEA</code></td>   <td>Chiffrement IDEA</td>       </tr>
<tr><td colspan="2"><em>Algorithmes de condensés MAC </em>:</td></tr>
<tr><td><code>MD5</code></td>    <td>Fonction de hashage MD5</td></tr>
<tr><td><code>SHA1</code></td>   <td>Fonction de hashage SHA1</td></tr>
<tr><td><code>SHA</code></td>    <td>alias pour SHA1</td> </tr>
<tr><td><code>SHA256</code></td> <td>Fonction de hashage SHA256</td> </tr>
<tr><td><code>SHA384</code></td> <td>Fonction de hashage SHA384</td> </tr>
<tr><td colspan="2"><em>Alias :</em></td></tr>
<tr><td><code>SSLv3</code></td>  <td>tous les algorithmes de chiffrement
SSL version 3.0</td> </tr>
<tr><td><code>TLSv1</code></td>  <td>tous les algorithmes de chiffrement
TLS version 1.0</td> </tr>
<tr><td><code>EXP</code></td>    <td>tous les algorithmes de chiffrement
externes</td>  </tr>
<tr><td><code>EXPORT40</code></td> <td>tous les algorithmes de chiffrement
externes limités à 40 bits</td>  </tr>
<tr><td><code>EXPORT56</code></td> <td>tous les algorithmes de chiffrement
externes limités à 56 bits</td>  </tr>
<tr><td><code>LOW</code></td>    <td>tous les algorithmes de chiffrement
faibles (non externes, DES simple)</td></tr>
<tr><td><code>MEDIUM</code></td> <td>tous les algorithmes avec
chiffrement 128 bits</td> </tr>
<tr><td><code>HIGH</code></td>   <td>tous les algorithmes
utilisant Triple-DES</td>     </tr>
<tr><td><code>RSA</code></td>    <td>tous les algorithmes
utilisant l'échange de clés RSA</td> </tr>
<tr><td><code>DH</code></td>     <td>tous les algorithmes
utilisant l'échange de clés Diffie-Hellman</td> </tr>
<tr><td><code>EDH</code></td>    <td>tous les algorithmes
utilisant l'échange de clés Diffie-Hellman temporaires</td> </tr>
<tr><td><code>ECDH</code></td>   <td>Echange de clés Elliptic Curve Diffie-Hellman</td>   </tr>
<tr><td><code>ADH</code></td>    <td>tous les algorithmes
utilisant l'échange de clés Diffie-Hellman anonymes</td> </tr>
<tr><td><code>AECDH</code></td>    <td>tous les algorithmes utilisant
l'échange de clés Elliptic Curve Diffie-Hellman</td> </tr>
<tr><td><code>SRP</code></td>    <td>tous les algorithmes utilisant
l'échange de clés avec mot de passe distant sécurisé (SRP)</td> </tr>
<tr><td><code>DSS</code></td>    <td>tous les algorithmes
utilisant l'authentification DSS</td> </tr>
<tr><td><code>ECDSA</code></td>    <td>tous les algorithmes utilisant
l'authentification ECDSA</td> </tr>
<tr><td><code>aNULL</code></td>   <td>tous les algorithmes n'utilisant
aucune authentification</td> </tr>
</table>
<p>
Cela devient intéressant lorsque tous ces symboles sont combinés
ensemble pour spécifier les algorithmes disponibles et l'ordre dans
lequel vous voulez les utiliser. Pour simplifier tout cela, vous
disposez aussi d'alias (<code>SSLv3, TLSv1, EXP, LOW, MEDIUM,
HIGH</code>) pour certains groupes d'algorithmes. Ces symboles peuvent
être reliés par des préfixes pour former la chaîne <em>algorithmes</em>.
Les préfixes disponibles sont :</p>
<ul>
<li>none: ajoute l'algorithme à la liste</li>
<li><code>+</code>: déplace les algorithmes qui conviennent à la
place courante dans la liste</li>
<li><code>-</code>: supprime l'algorithme de la liste (peut être rajouté
plus tard)</li>
<li><code>!</code>: supprime définitivement l'algorithme de la liste (ne
peut <strong>plus</strong> y être rajouté plus tard)</li>
</ul>

<note>
<title>Les algorithmes <code>aNULL</code>, <code>eNULL</code> et
<code>EXP</code> sont toujours désactivés</title>
<p>Depuis la version 2.4.7, les
algorithmes de type null ou destinés à l'exportation sont toujours
désactivés car mod_ssl ajoute obligatoirement
<code>!aNULL:!eNULL:!EXP</code> à toute chaîne d'algorithme de
chiffrement à l'initialisation.</p>
</note>

<p>Pour vous simplifier la vie, vous pouvez utiliser la commande
``<code>openssl ciphers -v</code>'' qui vous fournit un moyen simple de
créer la chaîne <em>algorithmes</em> avec succès. La chaîne
<em>algorithmes</em> par défaut dépend de la version des bibliothèques
SSL installées. Supposons qu'elle contienne
``<code>RC4-SHA:AES128-SHA:HIGH:MEDIUM:!aNULL:!MD5</code>'', ce qui
stipule de mettre <code>RC4-SHA</code> et <code>AES128-SHA</code> en
premiers, car ces algorithmes présentent un bon compromis entre vitesse
et sécurité. Viennent ensuite les algorithmes de sécurité élevée et
moyenne. En fin de compte, les algorithmes qui n'offrent aucune
authentification sont exclus, comme les algorithmes anonymes
Diffie-Hellman pour SSL, ainsi que tous les algorithmes qui utilisent
<code>MD5</code> pour le hashage, car celui-ci est reconnu comme
insuffisant.</p>
<example>
<pre>
$ openssl ciphers -v 'RC4-SHA:AES128-SHA:HIGH:MEDIUM:!aNULL:!MD5'
RC4-SHA                 SSLv3 Kx=RSA      Au=RSA  Enc=RC4(128)  Mac=SHA1
AES128-SHA              SSLv3 Kx=RSA      Au=RSA  Enc=AES(128)  Mac=SHA1
DHE-RSA-AES256-SHA      SSLv3 Kx=DH       Au=RSA  Enc=AES(256)  Mac=SHA1
...                     ...               ...     ...           ...
SEED-SHA                SSLv3 Kx=RSA      Au=RSA  Enc=SEED(128) Mac=SHA1
PSK-RC4-SHA             SSLv3 Kx=PSK      Au=PSK  Enc=RC4(128)  Mac=SHA1
KRB5-RC4-SHA            SSLv3 Kx=KRB5     Au=KRB5 Enc=RC4(128)  Mac=SHA1
</pre>
</example>
<p>Vous trouverez la liste complète des algorithmes RSA &amp; DH
spécifiques à SSL dans la <a href="#table2">Table 2</a>.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLCipherSuite RSA:!EXP:!NULL:+HIGH:+MEDIUM:-LOW
</highlight>
</example>
<table border="1">
<columnspec><column width=".3"/><column width=".1"/><column width=".13"/>
<column width=".1"/><column width=".13"/><column width=".1"/>
<column width=".13"/></columnspec>
<tr><th><a name="table2">Symbole algorithme</a></th> <th>Protocole</th>
<th>Echange de clés</th> <th>Authentification</th> <th>Chiffrement</th>
<th>Condensé MAC</th> <th>Type</th> </tr>
<tr><td colspan="7"><em>Algorithmes RSA :</em></td></tr>
<tr><td><code>DES-CBC3-SHA</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>3DES(168)</td> <td>SHA1</td> <td></td> </tr>
<tr><td><code>IDEA-CBC-SHA</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>IDEA(128)</td> <td>SHA1</td> <td></td> </tr>
<tr><td><code>RC4-SHA</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>RC4(128)</td> <td>SHA1</td> <td></td> </tr>
<tr><td><code>RC4-MD5</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>RC4(128)</td> <td>MD5</td> <td></td> </tr>
<tr><td><code>DES-CBC-SHA</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>DES(56)</td> <td>SHA1</td> <td></td> </tr>
<tr><td><code>EXP-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>RSA(512)</td> <td>RSA</td> <td>DES(40)</td> <td>SHA1</td> <td> export</td> </tr>
<tr><td><code>EXP-RC2-CBC-MD5</code></td> <td>SSLv3</td> <td>RSA(512)</td> <td>RSA</td> <td>RC2(40)</td> <td>MD5</td> <td>  export</td> </tr>
<tr><td><code>EXP-RC4-MD5</code></td> <td>SSLv3</td> <td>RSA(512)</td> <td>RSA</td> <td>RC4(40)</td> <td>MD5</td> <td>  export</td> </tr>
<tr><td><code>NULL-SHA</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>None</td> <td>SHA1</td> <td></td> </tr>
<tr><td><code>NULL-MD5</code></td> <td>SSLv3</td> <td>RSA</td> <td>RSA</td> <td>None</td> <td>MD5</td> <td></td> </tr>
<tr><td colspan="7"><em>Algorithmes Diffie-Hellman :</em></td></tr>
<tr><td><code>ADH-DES-CBC3-SHA</code></td> <td>SSLv3</td> <td>DH</td> <td>None</td> <td>3DES(168)</td> <td>SHA1</td> <td></td> </tr>
<tr><td><code>ADH-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>DH</td> <td>None</td> <td>DES(56)</td> <td>SHA1</td> <td></td> </tr>
<tr><td><code>ADH-RC4-MD5</code></td> <td>SSLv3</td> <td>DH</td> <td>None</td> <td>RC4(128)</td> <td>MD5</td> <td></td> </tr>
<tr><td><code>EDH-RSA-DES-CBC3-SHA</code></td> <td>SSLv3</td> <td>DH</td> <td>RSA</td> <td>3DES(168)</td> <td>SHA1</td> <td></td> </tr>
<tr><td><code>EDH-DSS-DES-CBC3-SHA</code></td> <td>SSLv3</td> <td>DH</td> <td>DSS</td> <td>3DES(168)</td> <td>SHA1</td> <td></td> </tr>
<tr><td><code>EDH-RSA-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>DH</td> <td>RSA</td> <td>DES(56)</td> <td>SHA1</td> <td></td> </tr>
<tr><td><code>EDH-DSS-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>DH</td> <td>DSS</td> <td>DES(56)</td> <td>SHA1</td> <td></td> </tr>
<tr><td><code>EXP-EDH-RSA-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>DH(512)</td> <td>RSA</td> <td>DES(40)</td> <td>SHA1</td> <td> export</td> </tr>
<tr><td><code>EXP-EDH-DSS-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>DH(512)</td> <td>DSS</td> <td>DES(40)</td> <td>SHA1</td> <td> export</td> </tr>
<tr><td><code>EXP-ADH-DES-CBC-SHA</code></td> <td>SSLv3</td> <td>DH(512)</td> <td>None</td> <td>DES(40)</td> <td>SHA1</td> <td> export</td> </tr>
<tr><td><code>EXP-ADH-RC4-MD5</code></td> <td>SSLv3</td> <td>DH(512)</td> <td>None</td> <td>RC4(40)</td> <td>MD5</td> <td>  export</td> </tr>
</table>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCertificateFile</name>
<description>Fichier de données contenant les informations de certificat X.509 du serveur
codées au format PEM ou identificateur de jeton</description>
<syntax>SSLCertificateFile <var>file-path</var>|<var>certid</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>L'option <var>certid</var> est disponible à partir de la version
2.4.42 du serveur HTTP Apache.</compatibility>

<usage>
<p>Cette directive permet de définir le fichier de données contenant les
informations de certificat X.509 du serveur codées au format PEM ou
l'identificateur de certificat via un jeton cryptographique. Si on utilise un
fichier au format PEM, ce dernier doit contenir au minimum un certificat
d'entité finale (feuille).
La directive peut être utilisée plusieurs fois (elle référence des
fichiers différents) pour accepter plusieurs algorithmes
d'authentification au niveau du serveur - souvent RSA, DSA et ECC. Le
nombre d'algorithmes supportés dépend de la version d'OpenSSL utilisée
avec mod_ssl : à partir de la version 1.0.0, la commande <code>openssl
list-public-key-algorithms</code> affiche la liste des algorithmes
supportés. Voir aussi la note ci-dessous à propos des limitations des versions
d'OpenSSL antérieures à 1.0.2 et la manière de les contourner.
</p>

<p>Les fichiers peuvent aussi contenir des certificats de CA
intermédiaires triés depuis la feuille vers la racine. Cette
fonctionnalité est disponible depuis la version 2.4.8 du serveur HTTP
Apache, et rend obsolète la directive <directive
module="mod_ssl">SSLCertificateChainFile</directive>. A partir de la
version 1.0.2 d'OpenSSL, il est alors possible de configurer la chaîne
de certification en fonction du certificat.</p>

<p>Depuis la version 2.4.7 du serveur HTTP Apache, on peut aussi ajouter
des paramètres DH personnalisés et un nom EC
curve pour les clés éphémères à la fin du premier fichier défini par la
directive <directive module="mod_ssl">SSLCertificateFile</directive>.
Ces paramètres peuvent être générés avec les commandes <code>openssl
dhparam</code> et <code>openssl ecparam</code>, et ils peuvent être
ajoutés tel quel à la fin du premier fichier de certificat. En effet,
seul le premier fichier de certificat défini peut être utilisé pour
enregistrer des paramètres personnalisés, car ces derniers s'appliquent
indépendamment de l'algorithme d'authentification utilisé.
</p>

<p>Enfin, il est aussi possible d'ajouter la clé privée du certificat de
l'entité finale au fichier de certificat, ce qui permet de se passer
d'une directive <directive
module="mod_ssl">SSLCertificateKeyFile</directive> séparée. Cette
pratique est cependant fortement déconseillée. En effet, les fichiers de
certificats qui contiennent de tels clés embarquées doivent être définis
avant les certificats en utilisant un fichier de clé séparé. En outre,
si la clé est chiffrée, une boîte de dialogue pour entrer le mot de
passe de la clé s'ouvre au démarrage du serveur.
</p>

<p>Plutôt que de stocker les certificats et les clés privées dans des fichiers,
on peut utiliser un identificateur de certificat pour identifier un certificat
stocké dans un jeton. Actuellement, seuls les <a
href="https://tools.ietf.org/html/rfc7512">URIs PKCS#11</a> sont reconnus comme
identificateurs de certificats et peuvent être utilisés en conjonction avec le
moteur OpenSSL <code>pkcs11</code>. Si la directive <directive
module="mod_ssl">SSLCertificateKeyFile</directive> est absente, le certificat et
la clé privée peuvent être chargés avec l'identificateur spécifié via la
directive <directive module="mod_ssl">SSLCertificateFile</directive>.</p>

<note>
<title>Interopérabilité des paramètres DH avec les nombres premiers de
plus de 1024 bits</title>
<p>
Depuis la version 2.4.7, mod_ssl utilise des
paramètres DH standardisés avec des nombres premiers de 2048, 3072 et
4096 bits, et avec des nombres premiers de 6144 et 8192 bits depuis la
version 2.4.10 (voir <a href="http://www.ietf.org/rfc/rfc3526.txt">RFC
3526</a>), et les fournit aux clients en fonction de la longueur de la
clé du certificat RSA/DSA. En particulier avec les clients basés sur
Java (versions 7 et antérieures), ceci peut provoquer des erreurs au
cours de la négociation - voir cette <a
href="../ssl/ssl_faq.html#javadh">réponse de la FAQ SSL</a> pour
contourner les problèmes de ce genre.
</p>
</note>

<note>
<title>Paramètres DH par défaut lorsqu'on utilise plusieurs certificats et une
version d'OpenSSL antérieure à 1.0.2.</title>
<p>
Lorsqu'on utilise plusieurs certificats pour supporter différents algorithmes
d'authentification (comme RSA, DSA, mais principalement ECC) et une
version d'OpenSSL antérieure à 1.0.2, il est recommandé soit d'utiliser des
paramètres DH spécifiques (solution à privilégier) en les ajoutant au premier
fichier certificat (comme décrit ci-dessus), soit d'ordonner les directives
<directive>SSLCertificateFile</directive> de façon à ce que les certificats
RSA/DSA soit placés <strong>après</strong> les certificats ECC.
</p>
<p>
Cette limitation est présente dans les anciennes versions d'OpenSSL qui
présentent toujours le dernier certificat configuré, au lieu
de laisser le serveur HTTP Apache déterminer le certificat sélectionné lors de
la phase de négociation de la connexion (lorsque les paramètres DH doivent être
envoyés à l'hôte distant).
De ce fait, le serveur peut sélectionner des paramètres DH par défaut basés sur
la longueur de la clé du mauvais certificat (les clés ECC sont beaucoup plus
petites que les clés RSA/DSA et leur longueur n'est pas pertinente pour la
sélection des nombres premiers DH).
</p>
<p>
Ce problème peut être résolu en créant et configurant des paramètres DH
spécifiques (comme décrit ci-dessus), car ils l'emportent toujours sur les
paramètres DH par défaut, et vous pourrez ainsi utiliser une longueur spécifique
et appropriée.
</p>
</note>

<example><title>Exemple</title>
<highlight language="config">
# Exemple utilisant un fichier codé en PEM.
SSLCertificateFile "/usr/local/apache2/conf/ssl.crt/server.crt"
# Exemple d'utilisation d'un certificat et d'une clé privés issus d'un jeton
# PKCS#11 :
SSLCertificateFile "pkcs11:token=My%20Token%20Name;id=45"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCertificateKeyFile</name>
<description>Fichier contenant la clé privée du serveur codée en
PEM</description>
<syntax>SSLCertificateKeyFile <var>file-path</var>|<var>keyid</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility><var>keyid</var> est disponible à partir de la version 2.4.42 du
serveur HTTP Apache.</compatibility>

<usage>
<p>
Cette directive permet de définir le fichier contenant la clé privée du serveur
codée en PEM ou l'identifiant de la clé via un jeton cryptographique défini. Si
la clé privée est chiffrée, une boîte de dialogue demandant le mot de passe de
cette dernière s'ouvre au démarrage du serveur.</p>

<p>
Cette directive peut être utilisée plusieurs fois pour référencer
différents noms de fichiers, afin de supporter plusieurs algorithmes
pour l'authentification du serveur. A chaque directive <directive
module="mod_ssl">SSLCertificateKeyFile</directive> doit être associée
une directive <directive>SSLCertificateFile</directive> correspondante.
</p>

<p>
La clé privé peut aussi être ajoutée au fichier défini par la directive
<directive module="mod_ssl">SSLCertificateFile</directive>, mais cette
pratique est fortement déconseillée. En effet, les fichiers de
certificats qui comportent une telle clé doivent être définis après les
certificats en utilisant un fichier de clé séparé.</p>

<p>Plutôt que de stocker des clés privées dans des fichiers, il est possible
d'identifier une clé privée via un identifiant stocké dans un jeton.
Actuellement, seuls les <a href="https://tools.ietf.org/html/rfc7512">PKCS#11
URIs</a> sont reconnus comme identifiants de clés privées et peuvent être
utilisés en conjonction avec le moteur OpenSSL <code>pkcs11</code>.</p>

<example><title>Exemple</title>
<highlight language="config">
# Pour utiliser une clé privée stockée dans fichier encodé PEM :
SSLCertificateKeyFile "/usr/local/apache2/conf/ssl.key/server.key"
# Pour utiliser une clé privée à partir d'un jeton PKCS#11 :
SSLCertificateKeyFile "pkcs11:token=My%20Token%20Name;id=45"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCertificateChainFile</name>
<description>Fichier contenant les certificats de CA du serveur codés en
PEM</description>
<syntax>SSLCertificateChainFile <var>file-path</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<note><title>SSLCertificateChainFile est obsolète</title>
<p><code>SSLCertificateChainFile</code> est devenue obsolète avec la
version 2.4.8, lorsque la directive
<directive module="mod_ssl">SSLCertificateFile</directive> a été étendue
pour supporter aussi les certificats de CA intermédiaires dans le
fichier de certificats du serveur.</p>
</note>
<p>
Cette directive permet de définir le fichier optionnel
<em>tout-en-un</em> où vous pouvez rassembler les certificats des
Autorités de Certification (CA) qui forment la chaîne de certification
du certificat du serveur. Cette chaîne débute par le certificat de la CA
qui a délivré le certificat du serveur et peut remonter jusqu'au
certificat de la CA racine. Un tel fichier contient la simple
concaténation des différents certificats de CA codés en PEM, en général
dans l'ordre de la chaîne de certification.</p>
<p>Elle doit être utilisée à la place et/ou en complément de la
directive <directive module="mod_ssl">SSLCACertificatePath</directive>
pour construire explicitement la chaîne de certification du serveur qui
est envoyée au navigateur en plus du certificat du serveur. Elle s'avère
particulièrement utile pour éviter les conflits avec les certificats de
CA lorsqu'on utilise l'authentification du client. Comme le fait de
placer un certificat de CA de la chaîne de certification du serveur dans
la directive <directive
module="mod_ssl">SSLCACertificatePath</directive> produit le même effet
pour la construction de la chaîne de certification, cette directive a
pour effet colatéral de faire accepter les certificats clients fournis
par cette même CA, au cours de l'authentification du client.</p>
<p>
Soyez cependant prudent : fournir la chaîne de certification ne
fonctionne que si vous utilisez un <em>simple</em> certificat de
serveur RSA <em>ou</em> DSA. Si vous utilisez une paire de certificats
couplés RSA+DSA , cela ne fonctionnera que si les deux certificats
utilisent vraiment <em>la même</em> chaîne de certification. Dans le cas
contraire, la confusion risque de s'installer au niveau des
navigateurs.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLCertificateChainFile "/usr/local/apache2/conf/ssl.crt/ca.crt"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCACertificatePath</name>
<description>Répertoire des certificats de CA codés en PEM pour
l'authentification des clients</description>
<syntax>SSLCACertificatePath <em>chemin-répertoire</em></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>
Cette directive permet de définir le répertoire où sont stockés les
certificats des Autorités de Certification (CAs) pour les clients
auxquels vous avez à faire. On les utilise pour vérifier le certificat
du client au cours de l'authentification de ce dernier.</p>
<p>
Les fichiers de ce répertoire doivent être codés en PEM et ils sont
accédés via des noms de fichier sous forme de condensés ou hash. Il ne
suffit donc pas de placer les fichiers de certificats dans ce répertoire
: vous devez aussi créer des liens symboliques nommés
<em>valeur-de-hashage</em><code>.N</code>, et vous devez toujours vous
assurer que ce répertoire contient les liens symboliques appropriés.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLCACertificatePath "/usr/local/apache2/conf/ssl.crt/"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCACertificateFile</name>
<description>Fichier contenant une concaténation des certificats de CA
codés en PEM pour l'authentification des clients</description>
<syntax>SSLCACertificateFile <var>file-path</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>
Cette directive permet de définir le fichier <em>tout-en-un</em> où vous
pouvez rassembler les certificats des Autorités de Certification (CAs)
pour les clients auxquels vous avez à faire. On les utilise pour
l'authentification des clients. Un tel fichier contient la simple
concaténation des différents fichiers de certificats codés en PEM, par
ordre de préférence. Cette directive peut être utilisée à la place et/ou
en complément de la directive <directive
module="mod_ssl">SSLCACertificatePath</directive>.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLCACertificateFile "/usr/local/apache2/conf/ssl.crt/ca-bundle-client.crt"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCADNRequestFile</name>
<description>Fichier contenant la concaténation des certificats de CA
codés en PEM pour la définition de noms de CA acceptables</description>
<syntax>SSLCADNRequestFile <var>file-path</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>Lorsque mod_ssl demande un certificat client, une liste de <em>noms
d'Autorités de Certification acceptables</em> est envoyée au client au
cours de la phase d'initialisation de la connexion SSL. Le client peut
alors utiliser cette liste de noms de CA pour sélectionner un certificat
client approprié parmi ceux dont il dispose.</p>

<p>Si aucune des directives <directive
module="mod_ssl">SSLCADNRequestPath</directive> ou <directive
module="mod_ssl">SSLCADNRequestFile</directive> n'est définie, la liste
de noms de CsA acceptables envoyée au client est la liste des noms de
tous les certificats de CA spécifiés par les directives <directive
module="mod_ssl">SSLCACertificateFile</directive> et <directive
module="mod_ssl">SSLCACertificatePath</directive> ; en d'autres termes,
c'est la liste des noms de CAs qui sera effectivement utilisée pour
vérifier le certificat du client.</p>

<p>Dans certaines situations, il est utile de pouvoir envoyer
une liste de noms de CA acceptables qui diffère de la liste des CAs
effectivement utilisés pour vérifier le certificat du client ;
considérons par exemple le cas où le certificat du client est signé par
des CAs intermédiaires. On peut ici utiliser les directives <directive
module="mod_ssl">SSLCADNRequestPath</directive> et/ou <directive
module="mod_ssl">SSLCADNRequestFile</directive>, et les noms de CA
acceptables seront alors extraits de l'ensemble des certificats contenus
dans le répertoire et/ou le fichier définis par cette paire de
directives.</p>

<p><directive module="mod_ssl">SSLCADNRequestFile</directive> doit
spécifier un fichier <em>tout-en-un</em> contenant une concaténation des
certificats de CA codés en PEM.</p>

<example><title>Exemple</title>
<highlight language="config">
SSLCADNRequestFile "/usr/local/apache2/conf/ca-names.crt"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCADNRequestPath</name>
<description>Répertoire contenant des fichiers de certificats de CA
codés en PEM pour la définition de noms de CA acceptables</description>
<syntax>SSLCADNRequestPath <em>chemin-répertoire</em></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>

<p>Cette directive optionnelle permet de définir la liste de <em>noms de
CAs acceptables</em> qui sera envoyée au client lorsqu'un certificat de
client est demandé. Voir la directive <directive
module="mod_ssl">SSLCADNRequestFile</directive> pour plus de
détails.</p>

<p>Les fichiers de ce répertoire doivent être codés en PEM et ils sont
accédés via des noms de fichier sous forme de condensés ou hash. Il ne
suffit donc pas de placer les fichiers de certificats dans ce répertoire
: vous devez aussi créer des liens symboliques nommés
<em>valeur-de-hashage</em><code>.N</code>, et vous devez toujours vous
assurer que ce répertoire contient les liens symboliques appropriés.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLCADNRequestPath "/usr/local/apache2/conf/ca-names.crt/"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCARevocationPath</name>
<description>Répertoire des CRLs de CA codés en PEM pour
l'authentification des clients</description>
<syntax>SSLCARevocationPath <em>chemin-répertoire</em></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>
Cette directive permet de définir le répertoire où sont stockées les
Listes de Révocation de Certificats (CRL) des Autorités de Certification
(CAs) pour les clients auxquels vous avez à faire. On les utilise pour
révoquer les certificats des clients au cours de l'authentification de
ces derniers.</p>
<p>
Les fichiers de ce répertoire doivent être codés en PEM et ils sont
accédés via des noms de fichier sous forme de condensés ou hash. Il ne
suffit donc pas de placer les fichiers de CRL dans ce répertoire
: vous devez aussi créer des liens symboliques nommés
<em>valeur-de-hashage</em><code>.N</code>, et vous devez toujours vous
assurer que ce répertoire contient les liens symboliques appropriés.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLCARevocationPath "/usr/local/apache2/conf/ssl.crl/"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCARevocationFile</name>
<description>Fichier contenant la concaténation des CRLs des CA codés en
PEM pour l'authentification des clients</description>
<syntax>SSLCARevocationFile <var>file-path</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>
Cette directive permet de définir le fichier <em>tout-en-un</em> où sont
rassemblées les Listes de Révocation de Certificats (CRLs) des Autorités
de certification (CAs) pour les clients auxquels vous avez à faire. On
les utilise pour l'authentification des clients. Un tel fichier contient
la simple concaténation des différents fichiers de CRLs codés en PEM,
dans l'ordre de préférence. Cette directive peut être utilisée à la
place et/ou en complément de la directive <directive
module="mod_ssl">SSLCARevocationPath</directive>.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLCARevocationFile
"/usr/local/apache2/conf/ssl.crl/ca-bundle-client.crl"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCARevocationCheck</name>
<description>Active la vérification des révocations basée sur les CRL</description>
<syntax>SSLCARevocationCheck chain|leaf|none [<em>flag</em>s ...]</syntax>
<default>SSLCARevocationCheck none</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Le drapeau optionnel <em>flag</em>s est disponible à partir de la
version 2.4.21 du serveur HTTP Apache</compatibility>

<usage>
<p>
Active la vérification des révocations basée sur les Listes de
Révocations de Certificats (CRL). Au moins une des directives <directive
module="mod_ssl">SSLCARevocationFile</directive> ou <directive
module="mod_ssl">SSLCARevocationPath</directive> doit être définie.
Lorsque cette directive est définie à <code>chain</code> (valeur
recommandée), les vérifications CRL sont effectuées sur tous les
certificats de la chaîne, alors que la valeur <code>leaf</code> limite
la vérification au certificat hors chaîne (la feuille).
</p>
<p><em>flag</em>s peut prendre comme valeurs </p>
<ul>
<li><code>no_crl_for_cert_ok</code>
<p>
Avant la version 2.3.15, les vérifications CRL dans mod_ssl
réussissaient même si aucune CRL n'était trouvée dans les chemins
définis par les directives <directive
module="mod_ssl">SSLCARevocationFile</directive> ou <directive
module="mod_ssl">SSLCARevocationPath</directive>.</p>
<p>Le comportement a
changé avec l'introduction de la  directive
<directive>SSLCARevocationFile</directive> : par défaut avec
<code>chain</code> ou <code>leaf</code>, les CRLs <em>doivent</em> être présentes pour que la
validation réussisse ; dans le cas contraire, elle échouera avec une
erreur <code>"unable to get certificate CRL"</code>.</p>
<p>La valeur <code>no_crl_for_cert_ok</code> du drapeau <em>flag</em> permet de
retrouver le comportement précédent.</p>
</li>
</ul>
<example><title>Exemple</title>
<highlight language="config">
SSLCARevocationCheck chain
</highlight>
</example>
<example><title>Compatibilité avec la branche 2.2</title>
<highlight language="config">
SSLCARevocationCheck chain no_crl_for_cert_ok
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLVerifyClient</name>
<description>Niveau de vérification du certificat client</description>
<syntax>SSLVerifyClient <em>niveau</em></syntax>
<default>SSLVerifyClient none</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context></contextlist>
<override>AuthConfig</override>

<usage>
<p>
Cette directive permet de définir le niveau de vérification du
certificat pour l'authentification du client. Notez que cette directive
peut être utilisée à la fois dans les contextes du serveur principal et
du répertoire. Dans le contexte du serveur principal, elle s'applique au
processus d'authentification du client utilisé au cours de la
négociation SSL standard lors de l'établissement d'une connexion. Dans
un contexte de répertoire, elle force une renégociation SSL avec le
niveau de vérification du client spécifié, après la lecture d'une
requête HTTP, mais avant l'envoi de la réponse HTTP.</p>
<p>
Les valeurs de <em>niveau</em> disponibles sont les suivantes :</p>
<ul>
<li><strong>none</strong>:
     aucun certificat client n'est requis</li>
<li><strong>optional</strong>:
     le client <em>peut</em> présenter un certificat valide</li>
<li><strong>require</strong>:
     le client <em>doit</em> présenter un certificat valide</li>
<li><strong>optional_no_ca</strong>:
     le client peut présenter un certificat valide, mais il n'est pas
     nécessaire que ce dernier soit vérifiable (avec succès). Cette option ne
     peut pas être utilisée lors de l'authentification du client.</li>
</ul>
<example><title>Exemple</title>
<highlight language="config">
SSLVerifyClient require
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLVerifyDepth</name>
<description>Profondeur maximale des certificats de CA pour la
vérification des certificats clients</description>
<syntax>SSLVerifyDepth <em>nombre</em></syntax>
<default>SSLVerifyDepth 1</default>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context></contextlist>
<override>AuthConfig</override>

<usage>
<p>
Cette directive permet de spécifier la profondeur maximale à laquelle
mod_ssl va effectuer sa vérification avant de décider que le client ne
possède pas de certificat valide. Notez que cette directive peut être
utilisée à la fois dans les contextes du serveur principal et de
répertoire. Dans le contexte du serveur principal, elle s'applique au
processus d'authentification du client utilisé au cours de la
négociation SSL standard lors de l'établissement d'une connexion. Dans
un contexte de répertoire, elle force une renégociation SSL avec le
client selon la nouvelle profondeur spécifiée, après la lecture d'une
requête HTTP, mais avant l'envoi de la réponse HTTP.</p>
<p>
La profondeur correspond au nombre maximum de fournisseurs de
certificats intermédiaires, c'est à dire le nombre maximum de
certificats de CA que l'on est autorisé à suivre lors de la vérification
du certificat du client. Une profondeur de 0 signifie que seuls les
certificats clients auto-signés sont acceptés ; la profondeur par défaut
de 1 signifie que le certificat client peut être soit auto-signé, soit
signé par une CA connue directement du serveur (c'est à dire que le
certificat de la CA doit être référencé par la directive <directive
module="mod_ssl">SSLCACertificatePath</directive>), etc...</p>
<example><title>Exemple</title>
<highlight language="config">
SSLVerifyDepth 10
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLSRPVerifierFile</name>
<description>Chemin du fichier de vérification SRP</description>
<syntax>SSLSRPVerifierFile <var>file-path</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible depuis la version 2.4.4 du serveur HTTP
Apache, si la version 1.0.1 ou supérieure d'OpenSSL est utilisée.</compatibility>

<usage>
<p>
Cette directive permet d'activer TLS-SRP et de définir le chemin du
fichier de vérification OpenSSL SRP (Mot de passe distant sécurisé)
contenant les noms d'utilisateurs TLS-SRP, les vérificateurs, les
"grains de sel" (salts), ainsi que les paramètres de groupe.</p>
<example><title>Exemple</title>
SSLSRPVerifierFile "/path/to/file.srpv"
</example>
<p>
Le fichier de vérification peut être créé via l'utilitaire en ligne de
commande <code>openssl</code> :</p>
<example><title>Création du fichier de vérification SRP</title>
openssl srp -srpvfile passwd.srpv -userinfo "some info" -add username
</example>
<p>La valeur affectée au paramètre optionnel <code>-userinfo</code> est
enregistrée dans la variable d'environnement
<code>SSL_SRP_USERINFO</code>.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLSRPUnknownUserSeed</name>
<description>Source d'aléa pour utilisateur SRP inconnu</description>
<syntax>SSLSRPUnknownUserSeed <em>secret-string</em></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible depuis la version 2.4.4 du serveur HTTP
Apache, si la version 1.0.1 ou supérieure d'OpenSSL est utilisée.</compatibility>

<usage>
<p>
Cette directive permet de définir la source d'aléa à utiliser
pour les utilisateurs SRP inconnus, ceci afin de combler les manques en
cas d'existence d'un tel utilisateur. Elle définit une chaîne secrète. Si
cette directive n'est pas définie, Apache renverra une alerte
UNKNOWN_PSK_IDENTITY aux clients qui fournissent un nom d'utilisateur
inconnu.
</p>
<example><title>Exemple</title>
SSLSRPUnknownUserSeed "secret"
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLOptions</name>
<description>Configure différentes options d'exécution du moteur SSL</description>
<syntax>SSLOptions [+|-]<em>option</em> ...</syntax>
<contextlist><context>server config</context>
<context>virtual host</context>
<context>directory</context>
<context>.htaccess</context></contextlist>
<override>Options</override>

<usage>
<p>
Cette directive permet de contrôler différentes options d'exécution du
moteur SSL dans un contexte de répertoire. Normalement, si plusieurs
<code>SSLOptions</code> peuvent s'appliquer à un répertoire, c'est la
plus spécifique qui est véritablement prise en compte ; les options ne
se combinent pas entre elles. Elles se combinent cependant entre elles
si elles sont <em>toutes</em> précédées par un symbole plus
(<code>+</code>) ou moins (<code>-</code>). Toute option précédée d'un
<code>+</code> est ajoutée aux options actuellement en vigueur, et toute
option précédée d'un <code>-</code> est supprimée de ces mêmes
options.
</p>
<p>
Les <em>option</em>s disponibles sont :</p>
<ul>
<li><code>StdEnvVars</code>
    <p>
    Lorsque cette option est activée, le jeu standard de variables
    d'environnement SSL relatives à CGI/SSI est créé. Cette option est
    désactivée par défaut pour des raisons de performances, car
    l'extraction des informations constitue une opération assez coûteuse
    en ressources. On n'active donc en général cette option que pour les
    requêtes CGI et SSI.</p>
</li>
<li><code>ExportCertData</code>
    <p>
    Lorsque cette option est activée, des variables d'environnement
    CGI/SSI supplémentaires sont créées : <code>SSL_SERVER_CERT</code>,
    <code>SSL_CLIENT_CERT</code> et
    <code>SSL_CLIENT_CERT_CHAIN_</code><em>n</em> (avec <em>n</em> =
    0,1,2,..). Elles contiennent les certificats X.509 codés en PEM du
    serveur et du client pour la connexion HTTPS courante, et peuvent
    être utilisées par les scripts CGI pour une vérification de
    certificat plus élaborée. De plus, tous les autres certificats de la
    chaîne de certificats du client sont aussi fournis. Tout ceci gonfle
    un peu l'environnement, et c'est la raison pour laquelle vous ne
    devez activer cette option qu'à la demande.</p>
</li>
<li><code>FakeBasicAuth</code>
    <p>
    Lorsque cette option est activée, le Nom Distinctif (DN) sujet du
    certificat client X509 est traduit en un nom d'utilisateur pour
    l'autorisation HTTP de base. Cela signifie que les méthodes
    d'authentification standard d'Apache peuvent être utilisées pour le
    contrôle d'accès. Le nom d'utilisateur est tout simplement le Sujet
    du certificat X509 du client (il peut être déterminé en utilisant la
    commande OpenSSL <code>openssl x509</code> : <code>openssl x509
    -noout -subject -in </code><em>certificat</em><code>.crt</code>).
    Notez qu'aucun mot de passe n'est envoyé par l'utilisateur. Chaque
    entrée du fichier des utilisateurs doit comporter ce mot de passe :
    ``<code>xxj31ZMTZzkVA</code>'', qui est la version chiffrée en DES
    du mot ``<code>password</code>''. Ceux qui travaillent avec un
    chiffrement basé sur MD5 (par exemple sous FreeBSD ou BSD/OS,
    etc...) doivent utiliser le condensé MD5 suivant pour le même mot :
    ``<code>$1$OXLyS...$Owx8s2/m9/gfkcRVXzgoE/</code>''.</p>

    <p>Notez que la directive <directive
    module="mod_auth_basic">AuthBasicFake</directive> implémentée par le
    module <module>mod_auth_basic</module> peut être utilisée d'une
    manière plus générale comme simulation d'authentification basique,
    ce qui permet de contrôler la structure nom utilisateur/mot de
    passe.</p>
</li>
<li><code>StrictRequire</code>
    <p>
    Cette option <em>force</em> l'interdiction d'accès lorsque
    <code>SSLRequireSSL</code> ou <code>SSLRequire</code> a décidé que
    l'accès devait être interdit. Par défaut, dans le cas où
    une directive ``<code>Satisfy any</code>'' est utilisée, et si
    d'autres restrictions d'accès ont été franchies, on passe en général
    outre l'interdiction d'accès due à <code>SSLRequireSSL</code> ou
    <code>SSLRequire</code> (parce que c'est ainsi que le mécanisme
    <code>Satisfy</code> d'Apache doit fonctionner). Pour des
    restrictions d'accès plus strictes, vous pouvez cependant utiliser
    <code>SSLRequireSSL</code> et/ou <code>SSLRequire</code> en
    combinaison avec une option ``<code>SSLOptions
    +StrictRequire</code>''. Une directive ``<code>Satisfy Any</code>''
    n'a alors aucune chance d'autoriser l'accès si mod_ssl a décidé de
    l'interdire.</p>
</li>
<li><code>OptRenegotiate</code>
    <p>
    Cette option active la gestion optimisée de la renégociation des
    connexions SSL intervenant lorsque les directives SSL sont utilisées
    dans un contexte de répertoire. Par défaut un schéma strict est
    appliqué, et <em>chaque</em> reconfiguration des paramètres SSL au
    niveau du répertoire implique une phase de renégociation SSL
    <em>complète</em>. Avec cette option, mod_ssl essaie d'éviter les
    échanges non nécessaires en effectuant des vérifications de
    paramètres plus granulaires (mais tout de même efficaces).
    Néanmoins, ces vérifications granulaires peuvent ne pas correspondre
    à ce qu'attend l'utilisateur, et il est donc recommandé de n'activer
    cette option que dans un contexte de répertoire.</p>
</li>
<li><code>LegacyDNStringFormat</code>
    <p>
    Cette option permet d'agir sur la manière dont les valeurs des
    variables <code>SSL_{CLIENT,SERVER}_{I,S}_DN</code> sont formatées.
    Depuis la version 2.3.11, Apache HTTPD utilise par défaut un format
    compatible avec la RFC 2253. Ce format utilise des virgules comme
    délimiteurs entre les attributs, permet l'utilisation de caractères
    non-ASCII (qui sont alors convertis en UTF8), échappe certains
    caractères spéciaux avec des slashes inversés, et trie les attributs
    en plaçant l'attribut "C" en dernière position.</p>

    <p>Si l'option <code>LegacyDNStringFormat</code> est présente, c'est
    l'ancien format qui sera utilisé : les attributs sont triés avec
    l'attribut "C" en première position, les séparateurs sont des
    slashes non inversés, les caractères non-ASCII ne sont pas supportés
    et le support des caractères spéciaux n'est pas fiable.
    </p>
</li>
</ul>
<example><title>Exemple</title>
<highlight language="config">
SSLOptions +FakeBasicAuth -StrictRequire
&lt;Files ~ "\.(cgi|shtml)$"&gt;
    SSLOptions +StdEnvVars -ExportCertData
&lt;/Files&gt;
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLRequireSSL</name>
<description>Interdit l'accès lorsque la requête HTTP n'utilise pas
SSL</description>
<syntax>SSLRequireSSL</syntax>
<contextlist><context>directory</context>
<context>.htaccess</context></contextlist>
<override>AuthConfig</override>

<usage>
<p><!-- XXX: I think the syntax is wrong -->
Cette directive interdit l'accès si HTTP sur SSL (c'est à dire HTTPS)
n'est pas activé pour la connexion courante. Ceci est très pratique dans
un serveur virtuel où SSL est activé ou dans un répertoire pour se
protéger des erreurs de configuration qui pourraient donner accès à des
ressources protégées. Lorsque cette directive est présente, toutes les
requêtes qui n'utilisent pas SSL sont rejetées.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLRequireSSL
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLRequire</name>
<description>N'autorise l'accès que lorsqu'une expression booléenne
complexe et arbitraire est vraie</description>
<syntax>SSLRequire <em>expression</em></syntax>
<contextlist><context>directory</context>
<context>.htaccess</context></contextlist>
<override>AuthConfig</override>

<usage>
<note><title>SSLRequire est obsolète</title>
<p><code>SSLRequire</code> est obsolète et doit en général être
remplacée par l'expression <a
href="mod_authz_core.html#reqexpr">Require</a>. La syntaxe <a
href="../expr.html">ap_expr</a> de l'expression <code>Require</code> est
une extension de la syntaxe de <code>SSLRequire</code>, avec les
différences suivantes :</p>

<p>Avec <code>SSLRequire</code>, les opérateurs de comparaison
<code>&lt;</code>, <code>&lt;=</code>, ... sont strictement équivalents
aux opérateurs <code>lt</code>, <code>le</code>, ... , et fonctionnent
selon une méthode qui compare tout d'abord la longueur des deux chaînes,
puis l'ordre alphabétique. Les expressions <a
href="../expr.html">ap_expr</a>, quant à elles, possèdent deux jeux
d'opérateurs de comparaison : les opérateurs <code>&lt;</code>,
<code>&lt;=</code>, ... effectuent une comparaison alphabétique de
chaînes, alors que les opérateurs <code>-lt</code>, <code>-le</code>,
... effectuent une comparaison d'entiers. Ces derniers possèdent aussi
des alias sans tiret initial : <code>lt</code>, <code>le</code>, ...
</p>

</note>

<p>Cette directive permet de spécifier une condition générale d'accès
qui doit être entièrement satisfaite pour que l'accès soit autorisé.
C'est une directive très puissante, car la condition d'accès spécifiée
est une expression booléenne complexe et arbitraire contenant un nombre
quelconque de vérifications quant aux autorisations d'accès.</p>
<p>
L'<em>expression</em> doit respecter la syntaxe suivante (fournie ici
sous la forme d'une notation dans le style de la grammaire BNF) :</p>
<blockquote>
<pre>
expr     ::= "<strong>true</strong>" | "<strong>false</strong>"
           | "<strong>!</strong>" expr
           | expr "<strong>&amp;&amp;</strong>" expr
           | expr "<strong>||</strong>" expr
           | "<strong>(</strong>" expr "<strong>)</strong>"
           | comp

comp     ::= word "<strong>==</strong>" word | word "<strong>eq</strong>" word
           | word "<strong>!=</strong>" word | word "<strong>ne</strong>" word
           | word "<strong>&lt;</strong>"  word | word "<strong>lt</strong>" word
           | word "<strong>&lt;=</strong>" word | word "<strong>le</strong>" word
           | word "<strong>&gt;</strong>"  word | word "<strong>gt</strong>" word
           | word "<strong>&gt;=</strong>" word | word "<strong>ge</strong>" word
           | word "<strong>in</strong>" "<strong>{</strong>" wordlist "<strong>}</strong>"
           | word "<strong>in</strong>" "<strong>PeerExtList(</strong>" word "<strong>)</strong>"
           | word "<strong>=~</strong>" regex
           | word "<strong>!~</strong>" regex

wordlist ::= word
           | wordlist "<strong>,</strong>" word

word     ::= digit
           | cstring
           | variable
           | function

digit    ::= [0-9]+
cstring  ::= "..."
variable ::= "<strong>%{</strong>" varname "<strong>}</strong>"
function ::= funcname "<strong>(</strong>" funcargs "<strong>)</strong>"
</pre>
</blockquote>
<p>Pour <code>varname</code>, toute variable décrite dans <a
href="#envvars">Variables d'environnement</a> pourra être utilisée.
Pour <code>funcname</code>, vous trouverez la liste des fonctions
disponibles dans la <a href="../expr.html#functions">documentation
ap_expr</a>.</p>

<p><em>expression</em> est interprétée et traduite
sous une forme machine interne lors du chargement de la configuration,
puis évaluée lors du traitement de la requête. Dans le contexte des
fichiers .htaccess, <em>expression</em> est interprétée et exécutée
chaque fois que le fichier .htaccess intervient lors du traitement de la
requête.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLRequire (    %{SSL_CIPHER} !~ m/^(EXP|NULL)-/                   \
            and %{SSL_CLIENT_S_DN_O} eq "Snake Oil, Ltd."          \
            and %{SSL_CLIENT_S_DN_OU} in {"Staff", "CA", "Dev"}    \
            and %{TIME_WDAY} -ge 1 and %{TIME_WDAY} -le 5          \
            and %{TIME_HOUR} -ge 8 and %{TIME_HOUR} -le 20       ) \
           or %{REMOTE_ADDR} =~ m/^192\.76\.162\.[0-9]+$/
</highlight>
</example>


<p>La fonction <code>PeerExtList(<em>identifiant objet</em>)</code>
recherche une instance d'extension de certificat X.509 identifiée par
<em>identifiant objet</em> (OID) dans le certificat client. L'expression est
évaluée à true si la partie gauche de la chaîne correspond exactement à
la valeur d'une extension identifiée par cet OID (Si plusieurs
extensions possèdent le même OID, l'une d'entre elles au moins doit
correspondre).
</p>

<example><title>Exemple</title>
<highlight language="config">
SSLRequire "foobar" in PeerExtList("1.2.3.4.5.6")
</highlight>
</example>

<note><title>Notes à propos de la fonction PeerExtList</title>

<ul>

<li><p>L'identifiant objet peut être spécifié soit comme un nom
descriptif reconnu par la bibliothèque SSL, tel que
<code>"nsComment"</code>, soit comme un OID numérique tel que
<code>"1.2.3.4.5.6"</code>.</p></li>

<li><p>Les expressions contenant des types connus de la bibliothèque
SSL sont transformées en chaînes avant comparaison. Pour les extensions
contenant un type non connu de la bibliothèque SSL, mod_ssl va essayer
d'interpréter la valeur s'il s'agit d'un des types ASN.1 primaires UTF8String,
IA5String, VisibleString, ou BMPString. Si l'extension correspond à un
de ces types, la chaîne sera convertie en UTF-8 si nécessaire, puis
comparée avec la partie gauche de l'expression.</p></li>

</ul>
</note>

</usage>
<seealso><a href="../env.html">Les variables d'environnement dans le
serveur HTTP Apache</a>, pour d'autres exemples.
</seealso>
<seealso><a href="mod_authz_core.html#reqexpr">Require expr</a></seealso>
<seealso><a href="../expr.html">Syntaxe générale des expressions dans le
serveur HTTP Apache</a>
</seealso>
</directivesynopsis>

<directivesynopsis>
<name>SSLRenegBufferSize</name>
<description>Définit la taille du tampon de renégociation
SSL</description>
<syntax>SSLRenegBufferSize <var>taille</var></syntax>
<default>SSLRenegBufferSize 131072</default>
<contextlist><context>directory</context>
<context>.htaccess</context></contextlist>
<override>AuthConfig</override>

<usage>

<p>Si une renégociation SSL est requise dans un contexte de répertoire,
par exemple avec l'utilisation de <directive
module="mod_ssl">SSLVerifyClient</directive> dans un bloc Directory ou
Location, mod_ssl doit mettre en tampon en mémoire tout corps de requête
HTTP en attendant qu'une nouvelle initialisation de connexion SSL puisse
être effectuée. Cette directive permet de définir la quantité de mémoire
à allouer pour ce tampon.</p>

<note type="warning"><p>
Notez que dans de nombreuses configurations, le client qui envoie un
corps de requête n'est pas forcément digne de confiance, et l'on doit
par conséquent prendre en considération la possibilité d'une attaque de
type déni de service lorsqu'on modifie la valeur de cette directive.
</p></note>

<example><title>Exemple</title>
<highlight language="config">
SSLRenegBufferSize 262144
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLStrictSNIVHostCheck</name>
<description>Contrôle de l'accès des clients non-SNI à un serveur virtuel à
base de nom.
</description>
<syntax>SSLStrictSNIVHostCheck on|off</syntax>
<default>SSLStrictSNIVHostCheck off</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible depuis la version 2.2.12 d'Apache</compatibility>

<usage>
<p>
Cette directive permet de contrôler l'accès des clients non-SNI à un serveur
virtuel à base de nom. Si elle est définie à <code>on</code> dans le
serveur virtuel à base de nom par défaut, les
clients non-SNI ne seront autorisés à accéder à aucun serveur virtuel
appartenant à cette combinaison IP/port. Par
contre, si elle est définie à <code>on</code> dans un serveur virtuel
quelconque, les clients non-SNI ne se verront interdire l'accès qu'à ce
serveur.
</p>

<note type="warning"><p>
Cette option n'est disponible que si httpd a été compilé avec une
version d'OpenSSL supportant SNI.
</p></note>

<example><title>Exemple</title>
<highlight language="config">
SSLStrictSNIVHostCheck on
</highlight>

</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyMachineCertificatePath</name>
<description>Répertoire des clés et certificats clients codés en PEM que
le mandataire doit utiliser</description>
<syntax>SSLProxyMachineCertificatePath <em>chemin-répertoire</em></syntax>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>
Cette directive permet de définir le répertoire où sont stockés les clés
et certificats permettant au serveur mandataire de s'authentifier auprès
des serveurs distants.
</p>
<p>Les fichiers de ce répertoire doivent être codés en PEM et ils sont
accédés via des noms de fichier sous forme de condensés ou hash. Vous
devez donc aussi créer des liens symboliques nommés
<em>valeur-de-hashage</em><code>.N</code>, et vous devez toujours vous
assurer que ce répertoire contient les liens symboliques appropriés.</p>
<note type="warning">
<p>Actuellement, les clés privées chiffrées ne sont pas supportées.</p>
</note>
<example><title>Exemple</title>
<highlight language="config">
SSLProxyMachineCertificatePath "/usr/local/apache2/conf/proxy.crt/"
</highlight>
</example>
</usage>
</directivesynopsis>


<directivesynopsis>
<name>SSLProxyMachineCertificateFile</name>
<description>Fichier contenant la concaténation des clés et certificats
clients codés en PEM que le mandataire doit utiliser</description>
<syntax>SSLProxyMachineCertificateFile <em>chemin-fichier</em></syntax>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>
Cette directive permet de définir le fichier tout-en-un où sont stockés
les clés et certificats permettant au serveur mandataire de
s'authentifier auprès des serveurs distants.
</p>
<p>
Le fichier spécifié est la simple concaténation des différents fichiers
de certificats codés en PEM, classés par ordre de préférence. Cette
directive s'utilise à la place ou en complément de la directive
<code>SSLProxyMachineCertificatePath</code>.
</p>
<note type="warning">
<p>Actuellement, les clés privées chiffrées ne sont pas supportées.</p>
</note>
<example><title>Exemple</title>
<highlight language="config">
SSLProxyMachineCertificateFile
"/usr/local/apache2/conf/ssl.crt/proxy.pem"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyMachineCertificateChainFile</name>
<description>Fichier de certificats de CA encodés PEM concaténés permettant au
mandataire de choisir un certificat</description>
<syntax>SSLProxyMachineCertificateChainFile <em>nom-fichier</em></syntax>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>
Cette directive permet de définir le fichier global où est enregistrée
la chaîne de certification pour tous les certificats clients utilisés.
Elle est nécessaire si le serveur distant présente une liste de
certificats de CA qui ne sont pas les signataires directs d'un des
certificats clients configurés.
</p>
<p>
Ce fichier contient tout simplement la concaténation des différents
fichiers de certificats encodés PEM. Au démarrage, chaque certificat
client configuré est examiné et une chaîne de certification est
construite.
</p>
<note type="warning"><title>Avertissement en matière de sécurité</title>
<p>Si cette directive est définie, tous les certificats contenus dans le
fichier spécifié seront considérés comme étant de confiance, comme s'ils
étaient aussi désignés dans la directive <directive
module="mod_ssl">SSLProxyCACertificateFile</directive>.</p>
</note>
<example><title>Exemple</title>
<highlight language="config">
SSLProxyMachineCertificateChainFile
"/usr/local/apache2/conf/ssl.crt/proxyCA.pem"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyVerify</name>
<description>Niveau de vérification du certificat du serveur
distant</description>
<syntax>SSLProxyVerify <em>niveau</em></syntax>
<default>SSLProxyVerify none</default>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>

<p>Lorsqu'un mandataire est configuré pour faire suivre les requêtes
vers un serveur SSL distant, cette directive permet de configurer la
vérification du certificat de ce serveur distant.</p>

<p>
Les valeurs de <em>niveau</em>x disponibles sont les suivantes :</p>
<ul>
<li><strong>none</strong>:
     aucun certificat n'est requis pour le serveur distant</li>
<li><strong>optional</strong>:
     le serveur distant <em>peut</em> présenter un certificat valide</li>
<li><strong>require</strong>:
     le serveur distant <em>doit</em> présenter un certificat valide</li>
<li><strong>optional_no_ca</strong>:
     le serveur distant peut présenter un certificat valide<br />
     mais il n'est pas nécessaire qu'il soit vérifiable (avec succès).</li>
</ul>
<p>En pratique, seuls les niveaux <strong>none</strong> et
<strong>require</strong> sont vraiment intéressants, car le niveau
<strong>optional</strong> ne fonctionne pas avec tous les serveurs, et
le niveau <strong>optional_no_ca</strong> va tout à fait à l'encontre de
l'idée que l'on peut se faire de l'authentification (mais peut tout de
même être utilisé pour établir des pages de test SSL, etc...).</p>

<example><title>Exemple</title>
<highlight language="config">
SSLProxyVerify require
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyVerifyDepth</name>
<description>Niveau de profondeur maximum dans les certificats de CA
lors de la vérification du certificat du serveur distant</description>
<syntax>SSLProxyVerifyDepth <em>niveau</em></syntax>
<default>SSLProxyVerifyDepth 1</default>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>
Cette directive permet de définir le niveau de profondeur maximum
jusqu'auquel mod_ssl doit aller au cours de sa vérification avant de
décider que le serveur distant ne possède pas de certificat valide.</p>
<p>
La profondeur correspond en fait au nombre maximum de fournisseurs de
certificats intermédiaires, c'est à dire le nombre maximum de
certificats
de CA que l'on peut consulter lors de la vérification du certificat du
serveur distant. Une profondeur de 0 signifie que seuls les certificats
de serveurs distants auto-signés sont acceptés, et la profondeur par
défaut de 1 que le certificat du serveur distant peut être soit
auto-signé, soit signé par une CA connue directement du serveur (en
d'autres termes, le certificat de CA est référencé par la directive
<directive module="mod_ssl">SSLProxyCACertificatePath</directive>),
etc...</p>
<example><title>Exemple</title>
<highlight language="config">
SSLProxyVerifyDepth 10
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyCheckPeerExpire</name>
<description>Configuration de la vérification de l'expiration du
certificat du serveur distant
</description>
<syntax>SSLProxyCheckPeerExpire on|off</syntax>
<default>SSLProxyCheckPeerExpire on</default>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>
Cette directive permet de définir si l'expiration du certificat du
serveur distant doit être vérifiée ou non. Si la vérification échoue, un
code d'état 502 (Bad Gateway) est envoyé.
</p>
<example><title>Exemple</title>
<highlight language="config">
SSLProxyCheckPeerExpire on
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyCheckPeerCN</name>
<description>Configuration de la vérification du champ CN du certificat
du serveur distant
</description>
<syntax>SSLProxyCheckPeerCN on|off</syntax>
<default>SSLProxyCheckPeerCN on</default>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>
Cette directive permet de définir si le champ CN du certificat du serveur
distant doit être comparé au nom de serveur de l'URL de la requête. S'ils ne
correspondent pas, un code d'état 502 (Bad Gateway) est envoyé. A partir de la
version 2.4.5, SSLProxyCheckPeerCN a été remplacé par <directive
module="mod_ssl">SSLProxyCheckPeerName</directive>.
</p>
<p>
De la version 2.4.5 à la version 2.4.20, spécifier <code>SSLProxyCheckPeerName
off</code> était suffisant pour obtenir ce comportement (car la valeur par
défaut de <code>SSLProxyCheckPeerCN</code> était <code>on</code>). Avec ces
versions, les deux directives doivent être définies à <code>off</code> pour
éviter toute validation du nom de certificat du serveur distant, et de
nombreux utilisateurs ont signalé ce comportement comme très perturbant.
</p>
<p>
A partir de la version 2.4.21, toutes les configurations qui activent au moins
une des deux directives <code>SSLProxyCheckPeerName</code> ou
<code>SSLProxyCheckPeerCN</code> adopteront le nouveau comportement de la
directive <directive module="mod_ssl">SSLProxyCheckPeerName</directive>, et
toutes les configurations qui désactivent une des deux directives
<code>SSLProxyCheckPeerName</code> ou <code>SSLProxyCheckPeerCN</code>
éviteront toute validation du nom de certificat du serveur distant. Seule la
configuration suivante permettra de retrouver la comparaison de CN
traditionnelle pour les versions 2.4.21 et supérieures :
</p>
<example><title>Exemple</title>
<highlight language="config">
SSLProxyCheckPeerCN on
SSLProxyCheckPeerName off
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyCheckPeerName</name>
<description>Configure la vérification du nom d'hôte dans les
certificats serveur distants
</description>
<syntax>SSLProxyCheckPeerName on|off</syntax>
<default>SSLProxyCheckPeerName on</default>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Disponible à partir de la version 2.4.5 du serveur HTTP
Apache<br />
Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>
<usage>
<p>
Cette directive permet de configurer la vérification du nom d'hôte pour
les certificats serveur lorsque mod_ssl agit en tant que client SSL. La
vérification réussit si le nom d'hôte de l'URI de la requête correspond à un
des attributs CN du sujet du certificat, ou à l'extension subjectAltName. Si la
vérification échoue, la requête SSL
avorte, et un code d'erreur 502 (Bad Gateway) est renvoyé.
</p>
<p>
Les caractères génériques sont supportés dans certains cas bien spécifiques :
une entrée subjectAltName de type dNSName ou les attributs CN
commençant par <code>*.</code> correspondront à tout nom d'hôte comportant
le même nombre de champs et le même suffixe ; par exemple,
<code>*.example.org</code> correspondra à <code>foo.example.org</code>,
mais pas à <code>foo.bar.example.org</code> car le nombre d'éléments dans les
nom est différent.
</p>
<p>
Cette fonctionnalité a été introduite avec la version 2.4.5 et l'emporte sur la
directive <directive module="mod_ssl">SSLProxyCheckPeerCN</directive> qui ne
comparait que la valeur exacte du premier attribut CN avec le nom d'hôte.
Cependant, de nombreux utilisateurs étaient déconcertés par le comportement
induit par l'utilisation de ces deux directives individuellement, si bien que ce
comportement a été amélioré avec la version 2.4.21. Voir la description de la
directive <directive module="mod_ssl">SSLProxyCheckPeerCN</directive> pour le
comportement original et des détails à propos de ces améliorations.
</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyEngine</name>
<description>Interrupteur marche/arrêt du moteur de mandataire
SSL</description>
<syntax>SSLProxyEngine on|off</syntax>
<default>SSLProxyEngine off</default>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>
Cette directive permet d'activer/désactiver l'utilisation du moteur de
protocole SSL/TLS pour le mandataire. On l'utilise en général à
l'intérieur d'une section <directive module="core"
type="section">VirtualHost</directive> pour activer le protocole SSL/TLS
dans le cadre d'un mandataire pour un serveur virtuel particulier. Par
défaut, le moteur de protocole SSL/TLS est désactivé pour la fonction de
mandataire du serveur principal et de tous les serveurs virtuels
configurés.</p>

<p>Notez que la directive <directive>SSLProxyEngine</directive> ne doit
généralement pas être utilisée dans le cadre d'un serveur virtuel qui agit en
tant que mandataire direct (via les directives <directive module="mod_proxy"
type="section">Proxy</directive> ou <directive
module="mod_proxy">ProxyRequests</directive>).
<directive>SSLProxyEngine</directive> n'est pas nécessaire pour activer un
serveur mandataire direct pour les requêtes SSL/TLS.</p>


<example><title>Exemple</title>
<highlight language="config">
&lt;VirtualHost _default_:443&gt;
    SSLProxyEngine on
    #...
&lt;/VirtualHost&gt;
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyProtocol</name>
<description>Définit les protocoles SSL disponibles pour la fonction de
mandataire</description>
<syntax>SSLProxyProtocol [+|-]<em>protocole</em> ...</syntax>
<default>SSLProxyProtocol all -SSLv3 (jusqu'à la version 2.4.16: all)</default>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<!-- XXX Why does this have an override and not .htaccess context? -->
<p>
Cette directive permet de définir les protocoles SSL que mod_ssl peut
utiliser lors de l'élaboration de son environnement de serveur pour la
fonction de mandataire. Il ne se connectera qu'aux serveurs utilisant un
des protocoles spécifiés.</p>
<p>Veuillez vous reporter à la directive <directive
module="mod_ssl">SSLProtocol</directive> pour plus d'informations.
</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyCipherSuite</name>
<description>Algorithmes de chiffrement disponibles pour la négociation
lors de l'initialisation d'une connexion SSL de mandataire</description>
<syntax>SSLProxyCipherSuite [<em>protocol</em>] <em>cipher-spec</em></syntax>
<default>SSLProxyCipherSuite ALL:!ADH:RC4+RSA:+HIGH:+MEDIUM:+LOW:+EXP</default>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>Cette directive est équivalente à la directive <directive
module="mod_ssl">SSLCipherSuite</directive>, mais s'applique à une connexion de
mandataire. Veuillez vous reporter à la directive <directive
module="mod_ssl">SSLCipherSuite</directive> pour plus d'informations.</p>
</usage>

</directivesynopsis>
<directivesynopsis>
<name>SSLProxyCACertificatePath</name>
<description>Répertoire des certificats de CA codés en PEM pour
l'authentification des serveurs distants</description>
<syntax>SSLProxyCACertificatePath <em>chemin-répertoire</em></syntax>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>
Cette directive permet de spécifier le répertoire où sont stockés les
certificats des Autorités de Certification (CAs) pour les serveurs
distants auxquels vous avez à faire. On les utilise pour vérifier le
certificat du serveur distant lors de l'authentification de ce
dernier.</p>
<p>
Les fichiers de ce répertoire doivent être codés en PEM et ils sont
accédés via des noms de fichier sous forme de condensés ou hash. Il ne
suffit donc pas de placer les fichiers de certificats dans ce répertoire
: vous devez aussi créer des liens symboliques nommés
<em>valeur-de-hashage</em><code>.N</code>, et vous devez toujours vous
assurer que ce répertoire contient les liens symboliques appropriés.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLProxyCACertificatePath "/usr/local/apache2/conf/ssl.crt/"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyCACertificateFile</name>
<description>Fichier contenant la concaténation des certificats de CA
codés en PEM pour l'authentification des serveurs distants</description>
<syntax>SSLProxyCACertificateFile <var>file-path</var></syntax>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>
Cette directive permet de définir le fichier <em>tout-en-un</em> où sont
stockés les certificats des Autorités de Certification (CA) pour les
<em>serveurs distants</em> auxquels vous avez à faire. On les utilise
lors de l'authentification du serveur distant. Un tel fichier contient
la simple concaténation des différents fichiers de certificats codés en
PEM, classés par ordre de préférence. On peut utiliser cette directive à
la place et/ou en complément de la directive <directive
module="mod_ssl">SSLProxyCACertificatePath</directive>.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLProxyCACertificateFile
"/usr/local/apache2/conf/ssl.crt/ca-bundle-serveur.distant.crt"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyCARevocationPath</name>
<description>Répertoire des CRLs de CA codés en PEM pour
l'authentification des serveurs distants</description>
<syntax>SSLProxyCARevocationPath <em>chemin-répertoire</em></syntax>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>
Cette directive permet de définir le répertoire où sont stockées les
Listes de Révocation de Certificats (CRL) des Autorités de Certification
(CAs) pour les serveurs distants auxquels vous avez à faire. On les
utilise pour révoquer les certificats des serveurs distants au cours de
l'authentification de ces derniers.</p>
<p>
Les fichiers de ce répertoire doivent être codés en PEM et ils sont
accédés via des noms de fichier sous forme de condensés ou hash. Il ne
suffit donc pas de placer les fichiers de CRL dans ce répertoire
: vous devez aussi créer des liens symboliques nommés
<em>valeur-de-hashage</em><code>.rN</code>, et vous devez toujours vous
assurer que ce répertoire contient les liens symboliques appropriés.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLProxyCARevocationPath "/usr/local/apache2/conf/ssl.crl/"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyCARevocationFile</name>
<description>Fichier contenant la concaténation des CRLs de CA codés en
PEM pour l'authentification des serveurs distants</description>
<syntax>SSLProxyCARevocationFile <var>file-path</var></syntax>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>
Cette directive permet de définir le fichier <em>tout-en-un</em> où sont
rassemblées les Listes de Révocation de Certificats (CRLs) des Autorités
de certification (CAs) pour les <em>serveurs distants</em> auxquels vous
avez à faire. On les utilise pour l'authentification des serveurs
distants. Un tel fichier contient la simple concaténation des différents
fichiers de CRLs codés en PEM, classés par ordre de préférence. Cette
directive peut être utilisée à la place et/ou en complément de la
directive <directive
module="mod_ssl">SSLProxyCARevocationPath</directive>.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLProxyCARevocationFile
"/usr/local/apache2/conf/ssl.crl/ca-bundle-serveur.distant.crl"
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLProxyCARevocationCheck</name>
<description>Active la vérification des révocations basée sur les CRLs
pour l'authentification du serveur distant</description>
<syntax>SSLProxyCARevocationCheck chain|leaf|none</syntax>
<default>SSLProxyCARevocationCheck none</default>
<contextlist><context>server config</context> <context>virtual host</context>
<context>proxy section</context></contextlist>
<compatibility>Le contexte d'une section proxy est supporté à partir de la
version 2.4.30 du serveur HTTP Apache</compatibility>

<usage>
<p>
Active la vérification des révocations basée sur les Listes de
révocations de Certificats (CRL) pour les <em>serveurs distants</em>
auxquels vous vous connectez. A moins une des directives <directive
module="mod_ssl">SSLProxyCARevocationFile</directive> ou <directive
module="mod_ssl">SSLProxyCARevocationPath</directive> doit être définie.
Lorsque cette directive est définie à <code>chain</code> (valeur
recommandée), les vérifications CRL sont effectuées sur tous les
certificats de la chaîne, alors que la valeur <code>leaf</code> limite
la vérification au certificat hors chaîne (la feuille).
</p>
<note>
<title>Lorsque la directive est définie à <code>chain</code> ou
<code>leaf</code>, les CRLs doivent être disponibles pour que la
validation réussisse</title>
<p>
Avant la version 2.3.15, les vérifications CRL dans mod_ssl
réussissaient même si aucune CRL n'était trouvée dans les chemins
définis par les directives <directive
module="mod_ssl">SSLProxyCARevocationFile</directive> ou <directive
module="mod_ssl">SSLProxyCARevocationPath</directive>. Le comportement a
changé avec l'introduction de cette directive : lorsque la vérification
est activée, les CRLs <em>doivent</em> être présentes pour que la
validation réussisse ; dans le cas contraire, elle échouera avec une
erreur <code>"CRL introuvable"</code>.
</p>
</note>
<example><title>Exemple</title>
<highlight language="config">
SSLProxyCARevocationCheck chain
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLUserName</name>
<description>Nom de la variable servant à déterminer le nom de
l'utilisateur</description>
<syntax>SSLUserName <em>nom-var</em></syntax>
<contextlist><context>server config</context>
<context>directory</context>
<context>.htaccess</context></contextlist>
<override>AuthConfig</override>

<usage>
<p>
Cette variable permet de définir le champ "user" de l'objet de la
requête Apache. Ce champ est utilisé par des modules de plus bas niveau
pour identifier l'utilisateur avec une chaîne de caractères. En
particulier, l'utilisation de cette directive peut provoquer la
définition de la variable d'environnement <code>REMOTE_USER</code>.
La valeur de l'argument <em>nom-var</em> peut correspondre à toute <a
href="#envvars">variable d'environnement SSL</a>.</p>

<p>Notez que cette directive est sans effet si l'option
<code>FakeBasicAuth</code> est utilisée (voir <a
href="#ssloptions">SSLOptions</a>).</p>

<example><title>Exemple</title>
<highlight language="config">
SSLUserName SSL_CLIENT_S_DN_CN
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLHonorCipherOrder</name>
<description>Option permettant de classer les algorithmes de chiffrement
du serveur par ordre de préférence</description>
<syntax>SSLHonorCipherOrder on|off</syntax>
<default>SSLHonorCipherOrder off</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>Normalement, ce sont les préférences du client qui sont prises en
compte lors du choix d'un algorithme de chiffrement au cours d'une
négociation SSLv3 ou TLSv1. Si cette directive est activée, ce sont les
préférences du serveur qui seront prises en compte à la place.</p>
<example><title>Exemple</title>
<highlight language="config">
SSLHonorCipherOrder on
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCryptoDevice</name>
<description>Active l'utilisation d'un accélérateur matériel de
chiffrement</description>
<syntax>SSLCryptoDevice <em>moteur</em></syntax>
<default>SSLCryptoDevice builtin</default>
<contextlist><context>server config</context></contextlist>

<usage>
<p>
Cette directive permet d'activer l'utilisation d'une carte accélératrice
de chiffrement qui prendra en compte certaines parties du traitement
relatif à SSL. Cette directive n'est utilisable que si la boîte à
outils SSL à été compilée avec le support "engine" ; les versions 0.9.7
et supérieures d'OpenSSL possèdent par défaut le support "engine", alors
qu'avec la version 0.9.6, il faut utiliser les distributions séparées
"-engine".</p>

<p>Pour déterminer les moteurs supportés, exécutez la commande
&quot;<code>openssl engine</code>&quot;.</p>

<example><title>Exemple</title>
<highlight language="config">
# Pour un accélérateur Broadcom :
SSLCryptoDevice ubsec
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLOCSPEnable</name>
<description>Active la validation OCSP de la chaîne de certificats du
client</description>
<syntax>SSLOCSPEnable on|leaf|off</syntax>
<default>SSLOCSPEnable off</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Le mode <em>leaf</em> est disponible à partir de la version
2.4.34 du serveur HTTP Apache</compatibility>

<usage>
<p>Cette directive permet d'activer la validation OCSP de la chaîne de
certificats du client. Si elle est activée, les certificats de la chaîne
de certificats du client seront validés auprès d'un répondeur OCSP, une
fois la vérification normale effectuée (vérification des CRLs
incluse). En mode 'leaf', seul le certificat du client sera validé.</p>

<p>Le répondeur OCSP utilisé est soit extrait du certificat lui-même,
soit spécifié dans la configuration ; voir les directives <directive
module="mod_ssl">SSLOCSPDefaultResponder</directive> et <directive
module="mod_ssl">SSLOCSPOverrideResponder</directive>.</p>

<example><title>Exemple</title>
<highlight language="config">
SSLVerifyClient on
SSLOCSPEnable on
SSLOCSPDefaultResponder "http://responder.example.com:8888/responder"
SSLOCSPOverrideResponder on
</highlight>
</example>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLOCSPDefaultResponder</name>
<description>Définit l'URI du répondeur par défaut pour la validation
OCSP</description>
<syntax>SSLOCSPDefaultResponder <em>uri</em></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>Cette directive permet de définir le répondeur OCSP par défaut. Si la
directive <directive
module="mod_ssl">SSLOCSPOverrideResponder</directive> n'est pas activée,
l'URI spécifié ne sera utilisé que si aucun URI de répondeur n'est
spécifié dans le certificat en cours de vérification.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLOCSPOverrideResponder</name>
<description>Force l'utilisation de l'URI du répondeur par défaut pour
la validation OCSP</description>
<syntax>SSLOCSPOverrideResponder on|off</syntax>
<default>SSLOCSPOverrideResponder off</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>Force l'utilisation, au cours d'une validation OCSP de certificat, du
répondeur OCSP par défaut spécifié dans la configuration, que le
certificat en cours de vérification fasse mention d'un répondeur OCSP ou
non.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLOCSPResponseTimeSkew</name>
<description>Dérive temporelle maximale autorisée pour la validation des
réponses OCSP</description>
<syntax>SSLOCSPResponseTimeSkew <em>secondes</em></syntax>
<default>SSLOCSPResponseTimeSkew 300</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>Cette option permet de définir la dérive temporelle maximale
autorisée pour les réponses OCSP (lors de la vérification des champs
<code>thisUpdate</code> et <code>nextUpdate</code>).</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLOCSPResponseMaxAge</name>
<description>Age maximum autorisé pour les réponses OCSP</description>
<syntax>SSLOCSPResponseMaxAge <em>secondes</em></syntax>
<default>SSLOCSPResponseMaxAge -1</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>Cette option permet de définir l'âge maximum autorisé (la
"fraicheur") des réponses OCSP. La valeur par défault (<code>-1</code>)
signifie qu'aucun âge maximum n'est défini ; autrement dit, les
réponses OCSP sont considérées comme valides tant que la valeur de leur
champ <code>nextUpdate</code> se situe dans le futur.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLOCSPResponderTimeout</name>
<description>Délai d'attente pour les requêtes OCSP</description>
<syntax>SSLOCSPResponderTimeout <em>secondes</em></syntax>
<default>SSLOCSPResponderTimeout 10</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>

<usage>
<p>Cette option permet de définir le délai d'attente pour les requêtes à
destination des répondeurs OCSP, lorsque la directive <directive
module="mod_ssl">SSLOCSPEnable</directive> est à on.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLOCSPNoverify</name>
<description>Evite la vérification des certificats des répondeurs OCSP</description>
<syntax>SSLOCSPNoverify <em>On/Off</em></syntax>
<default>SSLOCSPNoverify Off</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible à partir de la version 2.4.26 du serveur HTTP Apache,
sous réserve d'utiliser une version 0.9.7 ou supérieure d'OpenSSL</compatibility>
<usage>
<p>Cette directive permet d'éviter la vérification des certificats
des répondeurs OCSP, ce qui peut s'avérer utile lorsqu'on teste un serveur OCSP.</p>
</usage>
</directivesynopsis>


<directivesynopsis>
<name>SSLOCSPResponderCertificateFile</name>
<description>Fournit un jeu de certificats de confiance du répondeur OCSP avec
encodage PEM</description>
<syntax>SSLOCSPResponderCertificateFile <em>file</em></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible à partir de la version 2.4.26 du serveur HTTP Apache,
sous réserve d'utiliser une version 0.9.7 ou supérieure d'OpenSSL</compatibility>
<usage>
<p>Cette directive permet de définir un fichier contenant une liste de
certificats de confiance du répondeur OCSP à utiliser au cours de la validation
du certificat du répondeur OCSP. Les certificats fournis peuvent
être considérés comme de confiance sans avoir à effectuer de vérifications
supplémentaires. Ce processus de validation du certificat du répondeur OCSP
intervient en général lorsque ce dernier est autosigné ou tout simplement absent
de la réponse OCSP.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLOCSPProxyURL</name>
<description>Adresse de mandataire à utiliser pour les requêtes OCSP</description>
<syntax>SSLOCSPProxyURL <em>url</em></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible à partir de la version 2.4.19 du serveur HTTP Apache</compatibility>

<usage>
<p>Cette directive permet de définir l'URL d'un mandataire HTTP qui devra être
utilisé pour toutes les requêtes vers un répondeur OCSP.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLInsecureRenegotiation</name>
<description>Option permettant d'activer le support de la renégociation
non sécurisée</description>
<syntax>SSLInsecureRenegotiation on|off</syntax>
<default>SSLInsecureRenegotiation off</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible depuis httpd 2.2.15, si une version 0.9.8m
ou supérieure d'OpenSSL est utilisée</compatibility>

<usage>
<p>Comme il a été spécifié, toutes les versions des protocoles SSL et
TLS (jusqu'à la version 1.2 de TLS incluse) étaient vulnérables à une
attaque de type Man-in-the-Middle (<a
href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2009-3555">CVE-2009-3555</a>)
au cours d'une renégociation. Cette vulnérabilité permettait à un
attaquant de préfixer la requête HTTP (telle qu'elle était vue du
serveur) avec un texte choisi. Une extension du protocole a été
développée pour corriger cette vulnérabilité, sous réserve qu'elle soit
supportée par le client et le serveur.</p>

<p>Si <module>mod_ssl</module> est lié à une version 0.9.8m ou
supérieure d'OpenSSL, par défaut, la renégociation n'est accordée qu'aux
clients qui supportent la nouvelle extension du protocole. Si
cette directive est activée, la renégociation sera accordée aux anciens
clients (non patchés), quoique de manière non sécurisée</p>

<note type="warning"><title>Avertissement à propos de la sécurité</title>
<p>Si cette directive est activée, les connexions SSL seront vulnérables
aux attaques de type préfixe Man-in-the-Middle comme décrit dans <a
href="http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2009-3555">CVE-2009-3555</a>.</p>
</note>

<example><title>Exemple</title>
<highlight language="config">
SSLInsecureRenegotiation on
</highlight>
</example>

<p>La variable d'environnement <code>SSL_SECURE_RENEG</code> peut être
utilisée dans un script SSI ou CGI pour déterminer si la renégociation
sécurisée est supportée pour une connexion SSL donnée.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLUseStapling</name>
<description>Active l'ajout des réponses OCSP à la négociation TLS</description>
<syntax>SSLUseStapling on|off</syntax>
<default>SSLUseStapling off</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible si on utilise OpenSSL version 0.9.8h ou supérieure</compatibility>

<usage>
<p>Cette directive permet d'activer l'"Agrafage OCSP" (OCSP stapling)
selon la définition de l'extension TLS "Certificate Status Request"
fournie dans la RFC 6066. Si elle est activée et si le client le
demande, mod_ssl va inclure une réponse OCSP à propos de son propre
certificat dans la négociation TLS. Pour pouvoir activer l'Agrafage
OCSP, il est nécessaire de configurer un <directive
module="mod_ssl">SSLStaplingCache</directive>.</p>

<p>L'agrafage OCSP dispense le client de requérir le serveur OCSP
directement ; il faut cependant noter que selon les spécifications de la
RFC 6066, la réponse <code>CertificateStatus</code> du serveur ne peut
inclure une réponse OCSP que pour un seul certificat. Pour les
certificats de serveur comportant des certificats de CA intermédiaires
dans leur chaîne (c'est un cas typique de nos jours), l'implémentation
actuelle de l'agrafage OCSP n'atteint que partiellement l'objectif d'
"économie en questions/réponse et en ressources". Pour plus de détails,
voir la <a href="http://www.ietf.org/rfc/rfc6961.txt">RFC 6961</a> (TLS
Multiple Certificate Status Extension).
</p>

<p>Lorsque l'agrafage OCSP est activé, le mutex
<code>ssl-stapling</code> contrôle l'accès au cache de l'agrafage OCSP
afin de prévenir toute corruption, et le mutex
<code>sss-stapling-refresh</code> contrôle le raffraîchissement des
réponses OCSP. Ces mutex peuvent être configurés via la directive
<directive module="core">Mutex</directive>.
</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLStaplingCache</name>
<description>Configuration du cache pour l'agrafage OCSP</description>
<syntax>SSLStaplingCache <em>type</em></syntax>
<contextlist><context>server config</context></contextlist>
<compatibility>Disponible si on utilise OpenSSL version 0.9.8h ou supérieure</compatibility>

<usage>
<p>Si <directive module="mod_ssl">SSLUseStapling</directive> est à "on",
cette directive permet de configurer le cache destiné à stocker les
réponses OCSP incluses dans la négociation TLS. La configuration d'un
cache est obligatoire pour pouvoir utiliser l'agrafage OCSP. A
l'exception de <code>none</code> et <code>nonenotnull</code>, cette
directive supporte les mêmes types de stockage que la directive
<directive module="mod_ssl">SSLSessionCache</directive>.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLStaplingResponseTimeSkew</name>
<description>Durée de vie maximale autorisée des réponses OCSP incluses dans la
négociation TLS</description>
<syntax>SSLStaplingResponseTimeSkew <em>secondes</em></syntax>
<default>SSLStaplingResponseTimeSkew 300</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible si on utilise OpenSSL version 0.9.8h ou supérieure</compatibility>

<usage>
<p>Cette directive permet de spécifier l'intervalle de temps maximum que
mod_ssl va calculer en faisant la différence entre les contenus des
champs <code>nextUpdate</code> et <code>thisUpdate</code> des réponses
OCSP incluses dans la négociation TLS. Pour pouvoir utiliser cette
directive, <directive module="mod_ssl">SSLUseStapling</directive> doit
être à "on".</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLStaplingResponderTimeout</name>
<description>Temps d'attente maximum pour les requêtes vers les serveurs
OCSP</description>
<syntax>SSLStaplingResponderTimeout <em>secondes</em></syntax>
<default>SSLStaplingResponderTimeout 10</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible si on utilise OpenSSL version 0.9.8h ou supérieure</compatibility>

<usage>
<p>Cette directive permet de définir le temps d'attente maximum lorsque
mod_ssl envoie une requête vers un serveur OCSP afin d'obtenir une
réponse destinée à être incluse dans les négociations TLS avec les
clients (<directive module="mod_ssl">SSLUseStapling</directive> doit
avoir été activée au préalable).</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLStaplingResponseMaxAge</name>
<description>Age maximum autorisé des réponses OCSP incluses dans la
négociation TLS</description>
<syntax>SSLStaplingResponseMaxAge <em>secondes</em></syntax>
<default>SSLStaplingResponseMaxAge -1</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible si on utilise OpenSSL version 0.9.8h ou supérieure</compatibility>

<usage>
<p>Cette directive permet de définir l'âge maximum autorisé
("fraîcheur") des réponses OCSP incluses dans la négociation TLS
(<directive module="mod_ssl">SSLUseStapling</directive> doit
avoir été activée au préalable). La valeur par défaut (<code>-1</code>)
ne définit aucun âge maximum, ce qui signifie que les réponses OCSP sont
considérées comme valides à partir du moment où le contenu de leur champ
<code>nextUpdate</code> se trouve dans le futur.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLStaplingStandardCacheTimeout</name>
<description>Durée de vie des réponses OCSP dans le cache</description>
<syntax>SSLStaplingStandardCacheTimeout <em>secondes</em></syntax>
<default>SSLStaplingStandardCacheTimeout 3600</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible si on utilise OpenSSL version 0.9.8h ou supérieure</compatibility>

<usage>
<p>Cette directive permet de définir la durée de vie des réponses OCSP
dans le cache configuré via la directive <directive
module="mod_ssl">SSLStaplingCache</directive>. Elle ne s'applique qu'aux
réponse <em>valides</em>, alors que la directive <directive
module="mod_ssl">SSLStaplingErrorCacheTimeout</directive> s'applique aux
réponses invalides ou non disponibles.
</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLStaplingReturnResponderErrors</name>
<description>Transmet au client les erreurs survenues lors des requêtes
OCSP</description>
<syntax>SSLStaplingReturnResponderErrors on|off</syntax>
<default>SSLStaplingReturnResponderErrors on</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible si on utilise OpenSSL version 0.9.8h ou supérieure</compatibility>

<usage>
<p>Lorsque cette directive est activée, mod_ssl va transmettre au client les
réponses concernant les requêtes OCSP
échouées (comme les réponses avec un statut général autre que
"successful", les réponses avec un statut de certificat autre que
"good", les réponses arrivées à expiration, etc...). 
Lorsqu'elle est à <code>off</code>, seules les réponses avec un
statut de certificat égal à "good" seront incluses dans la négociation
TLS.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLStaplingFakeTryLater</name>
<description>Génère une réponse "tryLater" pour les requêtes OCSP échouées</description>
<syntax>SSLStaplingFakeTryLater on|off</syntax>
<default>SSLStaplingFakeTryLater on</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible si on utilise OpenSSL version 0.9.8h ou supérieure</compatibility>

<usage>
<p>Lorsque cette directive est activée, et si une requête vers un
serveur OCSP à des fins d'inclusion dans une négociation TLS échoue,
mod_ssl va générer une réponse "tryLater" pour le client (<directive
module="mod_ssl">SSLStaplingReturnResponderErrors</directive> doit être
activée).</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLStaplingErrorCacheTimeout</name>
<description>Durée de vie des réponses invalides dans le cache pour
agrafage OCSP</description>
<syntax>SSLStaplingErrorCacheTimeout <em>secondes</em></syntax>
<default>SSLStaplingErrorCacheTimeout 600</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible si on utilise OpenSSL version 0.9.8h ou supérieure</compatibility>

<usage>
<p>Cette directive permet de définir la durée de vie des réponses
<em>invalides</em> dans le cache pour agrafage OCSP configuré via la
directive <directive module="mod_ssl">SSLStaplingCache</directive>. Pour
définir la durée de vie des réponses valides, voir la directive
<directive module="mod_ssl">SSLStaplingStandardCacheTimeout</directive>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLStaplingForceURL</name>
<description>Remplace l'URI du serveur OCSP spécifié dans l'extension
AIA du certificat</description>
<syntax>SSLStaplingForceURL <em>uri</em></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible si on utilise OpenSSL version 0.9.8h ou supérieure</compatibility>

<usage>
<p>Cette directive permet de remplacer l'URI du serveur OCSP extraite de
l'extension authorityInfoAccess (AIA) du certificat. Elle peut s'avérer
utile lorsqu'on passe par un mandataire</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLSessionTicketKeyFile</name>
<description>Clé de chiffrement/déchiffrement permanente pour les
tickets de session TLS</description>
<syntax>SSLSessionTicketKeyFile <var>file-path</var></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible depuis la version 2.4.0 du serveur HTTP
Apache, sous réserve que l'on utilise une version 0.9.8h ou supérieure
d'OpenSSL</compatibility>

<usage>
<p>Cette directive permet de définir une clé secrète pour le chiffrement
et le déchiffrement des tickets de session TLS selon les préconisations
de la <a href="http://www.ietf.org/rfc/rfc5077.txt">RFC 5077</a>. Elle a
été conçue à l'origine pour les environnements de clusters où les
données des sessions TLS doivent être partagées entre plusieurs noeuds.
Pour les configurations ne comportant qu'une seule instance de httpd, il
est préférable d'utiliser les clés (aléatoires) générées par mod_ssl au
démarrage du serveur.</p>
<p>Le fichier doit contenir 48 octets de données aléatoires créées de
préférence par une source à haute entropie. Sur un système de type UNIX,
il est possible de créer le fichier contenant la clé de la manière
suivante :</p>

<example>
dd if=/dev/random of=/chemin/vers/fichier.tkey bs=1 count=48
</example>

<p>Ces clés doivent être renouvelées fréquemment, car il s'agit du seul
moyen d'invalider un ticket de session existant - OpenSSL ne permet pas
actuellement de spécifier une limite à la durée de
vie des tickets. Une nouvelle clé ne peut être utilisée qu'après avoir
redémarré le serveur. Tous les tickets de session existants deviennent
invalides après le redémarrage du serveur.</p>

<note type="warning">
<p>Ce fichier contient des données sensibles et doit donc être protégé
par des permissions similaires à celles du fichier spécifié par la
directive <directive module="mod_ssl">SSLCertificateKeyFile</directive>.</p>
</note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLCompression</name>
<description>Permet d'activer la compression au niveau SSL</description>
<syntax>SSLCompression on|off</syntax>
<default>SSLCompression off</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible à partir de la version 2.4.3 du serveur HTTP
Apache, si on utilise une version d'OpenSSL 0.9.8 ou supérieure ;
l'utilisation dans un contexte de serveur virtuel n'est disponible que
si on utilise une version d'OpenSSL 1.0.0 ou supérieure. La valeur par
défaut était <code>on</code> dans la version 2.4.3.</compatibility>

<usage>
<p>Cette directive permet d'activer la compression au niveau SSL.</p>
<note type="warning">
<p>L'activation de la compression est à l'origine de problèmes de
sécurité dans la plupart des configurations (l'attaque nommée CRIME).</p>
</note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLSessionTickets</name>
<description>Active ou désactive les tickets de session TLS</description>
<syntax>SSLSessionTickets on|off</syntax>
<default>SSLSessionTickets on</default>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible à partir de la version 2.4.11 du serveur HTTP
Apache, sous réserve d'utiliser OpenSSL version 0.9.8f ou supérieure.
</compatibility>

<usage>
<p>Cette directive permet d'activer ou de désactiver l'utilisation des
tickets de session TLS (RFC 5077).</p>
<note type="warning">
<p>Les tickets de session TLS sont activés par défaut. Les utiliser sans
redémarrer le serveur selon une périodicité appropriée (par exemple
quotidiennement) compromet cependant le niveau de confidentialité.</p>
</note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SSLOpenSSLConfCmd</name>
<description>Configuration des paramètres d'OpenSSL via son API <em>SSL_CONF</em></description>
<syntax>SSLOpenSSLConfCmd <em>commande</em> <em>valeur</em></syntax>
<contextlist><context>server config</context>
<context>virtual host</context></contextlist>
<compatibility>Disponible depuis la version 2.4.8 du serveur HTTP
Apache avec OpenSSL 1.0.2 ou supérieur</compatibility>

<usage>
<p>Cette directive permet à mod_ssl d'accéder à l'API <em>SSL_CONF</em>
d'OpenSSL. Il n'est ainsi plus nécessaire d'implémenter des
directives supplémentaires pour <module>mod_ssl</module> lorsque de nouvelles
fonctionnalités sont ajoutées à OpenSSL, ce qui rend la configuration de
ce dernier beaucoup plus souple.</p>

<p>Le jeu de commandes disponibles pour la directive
<directive>SSLOpenSSLConfCmd</directive> dépend de la version d'OpenSSL
utilisée pour <module>mod_ssl</module> (la version minimale 1.0.2 est un
prérequis). Pour obtenir la liste des commandes supportées, voir la
section <em>Supported configuration file commands</em> de la page de
manuel d'OpenSSL <a
href="http://www.openssl.org/docs/man1.0.2/ssl/SSL_CONF_cmd.html#SUPPORTED-CONFIGURATION-FILE-COMMANDS">SSL_CONF_cmd(3)</a>.</p>

<p>Certaines commandes peuvent remplacer des directives existantes
(comme <directive module="mod_ssl">SSLCipherSuite</directive> ou
<directive module="mod_ssl">SSLProtocol</directive>) ; notez cependant
que la syntaxe et/ou les valeurs possibles peuvent différer.</p>

<example><title>Examples</title>
<highlight language="config">
SSLOpenSSLConfCmd Options -SessionTicket,ServerPreference
SSLOpenSSLConfCmd ECDHParameters brainpoolP256r1
SSLOpenSSLConfCmd ServerInfoFile
"/usr/local/apache2/conf/server-info.pem"
SSLOpenSSLConfCmd Protocol "-ALL, TLSv1.2"
SSLOpenSSLConfCmd SignatureAlgorithms RSA+SHA384:ECDSA+SHA256
</highlight>
</example>
</usage>
</directivesynopsis>

</modulesynopsis>
