<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1874169 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mpm_common.xml.meta">

<name>mpm_common</name>
<description>Une série de directives implémentées par plusieurs
modules multi-processus (MPM)</description>
<status>MPM</status>

<directivesynopsis>
<name>CoreDumpDirectory</name>
<description>Le répertoire dans lequel le serveur HTTP Apache va tenter de se
positionner avant d'effectuer un vidage mémoire</description>
<syntax>CoreDumpDirectory <var>répertoire</var></syntax>
<default>Voir ci-dessous pour le répertoire par défaut</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module></modulelist>

<usage>
    <p>Cette directive permet de définir le répertoire dans lequel
    Apache httpd va tenter de se positionner avant d'effectuer un vidage
    mémoire sur disque.
    Si votre système d'exploitation est configuré pour créer des
    fichiers de vidage mémoire dans le répertoire de travail des
    processus qui se sont crashés,
    <directive>CoreDumpDirectory</directive> est nécessaire pour
    définir un répertoire de travail autre que le répertoire par défaut
    <directive module="core">ServerRoot</directive>, ce répertoire de
    travail ne devant pas être accessible en écriture par l'utilisateur sous
    lequel le serveur s'exécute.</p>

    <p>Si vous avez besoin d'un vidage mémoire pour le débogage, vous
    pouvez utiliser cette directive pour le placer à un endroit
    différent. Cette directive n'a aucun effet si votre système
    d'exploitation n'est pas configuré pour créer des
    fichiers de vidage mémoire dans le répertoire de travail des
    processus qui se sont crashés.</p>

    <note type="warning">
      <title>Note de sécurité pour les systèmes de type Linux</title>

      <p>Utiliser cette directive sous Linux peut permettre aux autres processus
      du système s'exécutant avec les même privilèges (comme les scripts CGI) de
      se rattacher aux processus httpd enfants via l'appel système
      <code>ptrace</code>. La protection contre certaines attaques engageant la
      sécurité peut s'en trouver affectée. Il est par conséquent déconseillé
      d'utiliser cette directive sur les systèmes en production.</p>
    </note>

    <note><title>Vidages mémoire sous Linux</title>
      <p>Si Apache httpd est démarré sous l'utilisateur root puis bascule vers
      un autre utilisateur, le noyau Linux <em>désactive</em> les
      vidages mémoire, même si le répertoire est accessible en écriture au
      processus. Apache httpd (versions 2.0.46 et supérieures) réactive les
      vidages mémoire sous Linux 2.4 et au delà, mais seulement si vous
      définissez une directive <directive>CoreDumpDirectory</directive>.</p>
    </note>

    <note>
    <title>Vidages mémoire sous BSD</title>
    <p>Pour activer le vidage mémoire des exécutables suid sur les
    systèmes de style BSD (comme FreeBSD), définissez
    <code>kern.sugid_coredump</code> à 1.
    </p>
    </note>

    <note><title>Signaux spécifiques</title>
      <p><directive>CoreDumpDirectory</directive> n'est traité qu'à la
      reception d'un certain nombre de signaux , SIGFPE, SIGILL, SIGABORT,
      SIGSEGV, et SIGBUS.</p>
      <p>
      Sur certains systèmes d'exploitation, SIGQUIT provoque aussi un
      vidage mémoire, mais n'est pas traité par les directives
      <directive>CoreDumpDirectory</directive> ou
      <directive>EnableExceptionHook</directive>, si bien que la
      définition du répertoire d'enregistrement du vidage mémoire est
      entièrement dévolue au système d'exploitation.</p>
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>EnableExceptionHook</name>
<description>Active un hook ("point d'accrochage logiciel") qui exécute des
gestionnaires d'exception après un crash</description>
<syntax>EnableExceptionHook On|Off</syntax>
<default>EnableExceptionHook Off</default>
<contextlist><context>server config</context></contextlist>
<modulelist>
<module>event</module><module>worker</module>
<module>prefork</module></modulelist>

<usage>
    <p>Pour des raisons de sécurité, cette directive n'est disponible
    que si la compilation du serveur a été configurée avec l'option
    <code>--enable-exception-hook</code>. Elle permet d'activer un hook
    ("point d'accrochage logiciel")
    qui autorise certains modules externes à effectuer un branchement et
    accomplir telle ou telle action après le crash d'un processus
    enfant.</p>

    <p>Deux modules, <code>mod_whatkilledus</code> et
    <code>mod_backtrace</code> utilisent ce hook. Veuillez vous
    référer à la <a
    href="https://emptyhammock.com/projects/httpd/diag/"
    >page EnableExceptionHook</a> de Jeff Trawick pour plus
    d'informations à leur sujet.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>GracefulShutdownTimeout</name>
<description>Spécifie le délai maximum après lequel le serveur va
s'arrêter dans le cas d'un arrêt "en douceur"</description>
<syntax>GracefulShutdownTimeout <var>seconds</var></syntax>
<default>GracefulShutdownTimeout 0</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module></modulelist>
<compatibility>Disponible dans les versions 2.2 et supérieures</compatibility>

<usage>
    <p>La directive <directive>GracefulShutdownTimeout</directive>
    permet de spécifier le temps, en secondes, pendant lequel le serveur
    va continuer à fonctionner après avoir reçu un signal
    "graceful-stop" ("Arrêt en douceur"), afin de terminer le traitement
    des connexions en cours.</p>

    <p>Définir cette valeur à zéro signifie au serveur d'attendre
    jusqu'à ce que toutes les requêtes en cours aient été traitées.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>PidFile</name>
<description>Ficher dans lequel le serveur enregistre l'identificateur
de processus du démon</description>
<syntax>PidFile <var>nom fichier</var></syntax>
<default>PidFile logs/httpd.pid</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module><module>mpm_winnt</module>
<module>mpmt_os2</module>
</modulelist>

<usage>
    <p>La directive <directive>PidFile</directive> permet de définir le
    ficher dans lequel le serveur
    enregistre l'identificateur de processus du démon. Si le chemin du
    fichier n'est pas absolu, il est considéré comme relatif au chemin
    défini par la directive <directive
    module="core">ServerRoot</directive>.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      PidFile /var/run/apache.pid
      </highlight>
    </example>

    <p>Il est souvent utile de pouvoir envoyer un signal au
    serveur afin qu'il ferme et ouvre à nouveau ses journaux
    d'<directive module="core">erreur</directive> et de <directive
    module="mod_log_config">transfert</directive>, et recharge son
    fichier de configuration. Pour ce faire, on envoie un signal SIGHUP
    (kill -1) à l'identificateur de processus enregistré dans le fichier
    défini par la directive <directive>PidFile</directive>.</p>

    <p>La directive <directive>PidFile</directive> fait l'objet des
    mêmes avertissements que ceux concernant le chemin d'enregistrement
    des fichiers journaux et la <a
    href="../misc/security_tips.html#serverroot">sécurité</a>.</p>

    <note><title>Note</title>
      <p>Depuis la version 2 du serveur HTTP Apache, nous recommandons de n'utiliser
      que le script <program>apachectl</program>, ou le script de
      démarrage fourni avec votre système d'exploitation pour (re)démarrer ou
      arrêter le serveur.</p>
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>Listen</name>
<description>Les adresses IP et ports sur lesquels le serveur écoute</description>
<syntax>Listen [<var>adresse IP</var>:]<var>numéro port</var>
[<var>protocole</var>]</syntax>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module><module>mpm_winnt</module>
<module>mpm_netware</module><module>mpmt_os2</module>
</modulelist>
<compatibility>L'argument <var>protocole</var> est supporté depuis la version
2.1.5</compatibility>

<usage>
    <p>La directive <directive>Listen</directive> permet de signifier à
    Apache httpd de ne se mettre à l'écoute que sur les adresses IP et ports spécifiés ; par
    défaut, le serveur répond aux requêtes en provenance de toutes les
    interfaces réseau. La directive <directive>Listen</directive> est
    dorénavant requise, et si elle est absente du fichier de
    configuration, le serveur refusera de démarrer. Ceci constitue un
    changement par rapport aux versions précédentes d'Apache httpd.</p>

    <p>La directive <directive>Listen</directive> signifie au serveur de
    n'accepter les requêtes entrantes que vers le port ou le couple
    adresse-port spécifié. Si seulement un port est spécifié, le serveur
    se met à l'écoute sur ce port sur toutes les interfaces réseau. Si une adresse IP
    et un port sont spécifiés, le serveur va se mettre à l'écoute sur ce port sur
    l'interface réseau correspondant à l'adresse IP.</p>

    <p>On peut utiliser autant de directives
    <directive>Listen</directive> que nécessaire pour spécifier
    plusieurs adresses et/ou ports à écouter. Le serveur répondra aux
    requêtes vers tous les adresses et ports spécifiés.</p>

    <p>Par exemple, pour que le serveur accepte les connexions sur les
    ports 80 et 8000, utilisez :</p>

    <highlight language="config">
Listen 80
Listen 8000
    </highlight>

    <p>Pour que le serveur accepte les connexions sur deux interfaces et
    ports particuliers, spécifiez :</p>

    <highlight language="config">
Listen 192.170.2.1:80
Listen 192.170.2.5:8000
    </highlight>

    <p>Les adressee IPv6 doivent être entourées de crochets, comme dans
    l'exemple suivant :</p>

    <highlight language="config">
      Listen [2001:db8::a00:20ff:fea7:ccea]:80
    </highlight>

    <p>L'argument optionnel <var>protocole</var> n'est pas nécessaire
    dans la plupart des configurations. S'il est absent,
    <code>https</code> est la valeur par défaut pour le port 443 et
    <code>http</code> l'est pour tous les autres ports. L'argument
    protocole sert à déterminer quel module doit traiter une requête, et
    à appliquer des optimisations spécifiques à certains protocoles à
    l'aide de la directive <directive
    module="core">AcceptFilter</directive>.</p>

    <p>La spécification d'un protocole n'est nécessaire que si vous
    utilisez des ports non standards. Par exemple, pour configurer un
    site en <code>https</code> sur le port 8443 :</p>

    <highlight language="config">
      Listen 192.170.2.1:8443 https
    </highlight>

    <note><title>Condition d'erreur</title>
      Plusieurs directives <directive>Listen</directive> pour les mêmes
      adresse IP/port vont provoquer l'envoi d'un message d'erreur
      <code>Address already in use</code>.
    </note>

</usage>
<seealso><a href="../dns-caveats.html">Problèmes avec DNS</a></seealso>
<seealso><a href="../bind.html">Définition des adresses et ports
qu'utilise le serveur HTTP Apache</a></seealso>
<seealso><a
href="http://wiki.apache.org/httpd/CouldNotBindToAddress">Autre
discussion à propos du message d'erreur <code>Address already in
use</code>, citant d'autres causes possibles.</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ListenCoresBucketsRatio</name>
<description>Rapport entre le nombre de coeurs de processeur activés et
le nombre de segments d'écoute</description>
<syntax>ListenCoresBucketsRatio <var>ratio</var></syntax>
<default>ListenCoresBucketsRatio 0 (disabled)</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module>
</modulelist>
<compatibility>Disponible à partir de la version 2.4.13 du serveur HTTP
Apache, avec un noyau supportant l'option de socket
<code>SO_REUSEPORT</code>, et distribuant uniformément les nouvelles
connexions aux sockets d'écoute des processus (ou threads) qui
l'utilisent (par exemple Linux versions 3.9 et ultérieures, mais pas
l'implémentation courante de <code>SO_REUSEPORT</code> par les
plateformes de type BSD.</compatibility>

<usage>
    <p>Vous pouvez utiliser la directive
    <directive>ListenCoresBucketsRatio</directive> pour spécifier un
    <var>ratio</var> entre le nombre de coeurs de CPU activés et le nombre de
    segments d'écoute (listeners' buckets) souhaités ; le serveur HTTP Apache va
    alors créer<code>num_cpu_cores / ratio</code> segments d'écoute, chacun
    contenant son propre socket d'écoute <directive
    module="mpm_common">Listen</directive> sur le ou les mêmes ports ; chaque
    processus enfant sera associé à un seul segment d'écoute (avec une
    distribution de type round-robin des segments à la création des processus
    enfants).</p>

    <note><title>Définition du terme coeur de CPU activé ("online")</title>
    <p>Sous Linux et BSD, un coeur de CPU peut être activé ou désactivé si <a
    href="https://www.kernel.org/doc/Documentation/cpu-hotplug.txt">Hotplug</a>
    a été configuré ; la directive
    <directive>ListenCoresBucketsRatio</directive> doit donc tenir compte de ce
    paramètre pour calculer le nombre de segments d'écoute à créer.</p>
    </note>

    <p>La directive <directive>ListenCoresBucketsRatio</directive> peut
    améliorer le support de la montée en charge lorsque l'arrivée de
    nouvelles connexions est/devient un goulot d'étranglement. Le test
    de cette fonctionnalité avec des machines possédant un nombre de
    coeurs de CPU important a permit de constater une amélioration des
    performances significative et des temps de réponse plus courts.</p>

    <p>Pour que cette fonctionnalité soit activée, le nombre de coeurs
    de CPU doit être égal au moins au double du <var>ratio</var>
    spécifié. Si vous spécifiez la valeur recommandée pour
    <var>ratio</var>, à savoir <code>8</code>, le nombre minimum de
    coeurs de processeurs disponibles sera alors de <code>16</code>. La valeur
    optimale de <var>ratio</var> permettant d'obtenir des performances maximales
    doit être calculée pour chaque système cible, en testant plusieurs valeurs
    et en observant les résultats.</p>

    <p>Cette directive influence le calcul des valeurs limites inférieures de
    <directive module="mpm_common">MinSpareThreads</directive> et <directive
    module="mpm_common">MaxSpareThreads</directive>. En effet, pour accepter les
    connexions de manière optimale, le nombre de processus enfants doit être un
    multiple du nombre de segments d'écoute.</p>

    <note>
    <title>Cas où plusieurs <directive>Listen</directive>ers ou serveurs HTTP
    Apache partagent la même adresse IP et port</title>
    <p>La définition de l'option <code>SO_REUSEPORT</code> pour les sockets
    d'écoute permet à plusieurs processus (partageant le même <code>EUID</code>,
    par exemple <code>root</code>) de se rattacher à la même adresse IP et port,
    sans obtenir l'erreur de rattachement que le système génère habituellement
    lorsque ce cas se produit.</p>
    <p>Cela signifie aussi que plusieurs instances d'Apache httpd configurées
    avec le même <code>IP:port</code> et avec une valeur
    <directive>ListenCoresBucketsRatio</directive> positive pourraient démarrer
    sans erreur, et fonctionner ensuite avec une répartition uniforme des
    connexions entrantes sur ces différentes instances (ce n'est PAS une
    recommandation et ne constitue pas un usage approprié à tous les cas, mais
    juste un avertissement sur le fait qu'un véritable problème de rattachement
    multiple à un <code>IP:port</code> pourrait alors être occulté).</p>
    <p>Au sein d'une même instance, Apache httpd vérifie la présence de
    directives <directive>Listen</directive> multiples avec la même adresse IP
    (ou nom d'hôte) et le même port, et refuse de démarrer si c'est le cas, ce
    qui permet d'éviter la création de segments d'écoute dupliqués qui seraient
    du coup inutiles et affecteraient les performances. Cependant, il ne peut
    pas (et n'essaiera pas de le faire) intercepter tous les cas possibles de
    recouvrement (comme un nom d'hôte correspondant à une adresse IP utilisée
    quelque part ailleurs).</p>
    </note>
    </usage>
</directivesynopsis>

<directivesynopsis>
<name>ListenBackLog</name>
<description>Longueur maximale de la liste d'attente des
connexions</description>
<syntax>ListenBackLog <var>backlog</var></syntax>
<default>ListenBackLog 511</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module><module>mpm_winnt</module>
<module>mpm_netware</module><module>mpmt_os2</module>
</modulelist>

<usage>
    <p>La longueur maximale de la liste d'attente des connexions. En
    général, aucune modification n'est nécessaire, ni même souhaitable ;
    cependant, sur certains systèmes, il peut être nécessaire
    d'en augmenter la valeur en cas d'attaque TCP SYN flood (envoi en
    masse de requêtes SYN pour saturer le serveur). Voir le paramètre
    backlog de l'appel système <code>listen(2)</code>.</p>

    <p>En fait, l'argument backlog sera souvent limité à une valeur
    inférieure en fonction du système d'exploitation. Notez aussi que de
    nombreux systèmes d'exploitation ne tiennent pas vraiment compte de
    la valeur spécifiée pour l'argument backlog, mais s'en inspirent
    seulement (et choisissent en général une valeur supérieure).</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>MaxRequestWorkers</name>
<description>Nombre maximum de connexions pouvant être traitées
simultanément</description>
<syntax>MaxRequestWorkers <var>nombre</var></syntax>
<default>Voir ci-dessous pour plus de détails</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module>
</modulelist>

<usage>
    <p>La directive <directive>MaxRequestWorkers</directive> permet de fixer le
    nombre maximum de requêtes pouvant être traitées simultanément.
    Si la limite <directive>MaxRequestWorkers</directive> est atteinte, toute
    tentative de connexion sera normalement mise dans une file
    d'attente, et ceci jusqu'à un certain nombre dépendant de la
    directive <directive module="mpm_common">ListenBacklog</directive>.
    Lorsqu'un processus enfant se libèrera suite à la fin du traitement
    d'une requête, la connexion en attente pourra être traitée à son
    tour.</p>

    <p>Pour les serveurs non threadés (<em>c'est à dire</em> utilisant
    <module>prefork</module>), la directive
    <directive>MaxRequestWorkers</directive> définit alors le nombre maximum de
    processus enfants qui pourront être lancés simultanément pour
    traiter les requêtes. La valeur par défaut est <code>256</code> ; si
    vous l'augmentez, vous devez aussi augmenter la valeur de la
    directive <directive
    module="mpm_common">ServerLimit</directive>.</p>

    <p>Pour les serveur threadés et hybrides (utilisant <em>par
    exemple</em> <module>event</module> ou <module>worker</module>),
    <directive>MaxRequestWorkers</directive> définit alors le nombre total de
    threads qui seront disponibles pour servir les clients. Dans le
    cas des MPMs hybrides, la valeur par défaut est <code>16</code>
    (directive <directive
    module="mpm_common">ServerLimit</directive>) multiplié par la valeur
    <code>25</code> (directive <directive module="mpm_common"
    >ThreadsPerChild</directive>). Par conséquent, pour affecter à la
    directive <directive>MaxRequestWorkers</directive> une valeur qui requiert
    plus de 16 processus, vous devez aussi augmenter la valeur de la
    directive <directive module="mpm_common"
    >ServerLimit</directive>.</p>

    <p>Le nom de la directive <directive>MaxRequestWorkers</directive>
    était <directive>MaxClients</directive> avant la version 2.3.13. Cet
    ancien nom est encore supporté.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>MaxMemFree</name>
<description>Quantité maximale de mémoire que l'allocateur principal est
autorisé à conserver sans appeler <code>free()</code></description>
<syntax>MaxMemFree <var>KOctets</var></syntax>
<default>MaxMemFree 2048</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module><module>mpm_winnt</module>
<module>mpm_netware</module>
</modulelist>

<usage>
    <p>La directive <directive>MaxMemFree</directive> permet de définir
    le nombre maximum de KOctets libres que tout allocateur est
    autorisé à conserver sans appeler <code>free()</code>. Dans les MPMs
    threadés, chaque thread possède son propre allocateur. Si elle est
    définie à 0, la quantité de mémoire libre que peut conserver un
    allocateur est illimitée.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>MaxConnectionsPerChild</name>
<description>Limite le nombre de connexions qu'un processus enfant va
traiter au cours de son fonctionnement</description>
<syntax>MaxConnectionsPerChild <var>number</var></syntax>
<default>MaxConnectionsPerChild 0</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module><module>mpm_winnt</module>
<module>mpm_netware</module><module>mpmt_os2</module>
</modulelist>
<compatibility>Disponible depuis la version 2.3.9 du serveur HTTP
Apache. L'ancien nom <code>MaxRequestsPerChild</code> est encore
supporté.</compatibility>

<usage>
    <p>La directive <directive>MaxConnectionsPerChild</directive> permet de
    définir le nombre maximum de connexions qu'un processus enfant va
    pouvoir traiter au cours de son fonctionnement. Lorsqu'il a traité
    <directive>MaxConnectionsPerChild</directive> connexions, le processus
    enfant est arrêté. Si <directive>MaxConnectionsPerChild</directive> est
    définie à <code>0</code>, il n'y a plus aucune limite sur le nombre
    de connexions que le processus pourra traiter.</p>

    <p>Définir <directive>MaxConnectionsPerChild</directive> à une valeur
    non nulle limite la quantité de mémoire qu'un processus peut
    consommer à cause de fuites (accidentelles) de mémoire.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>MaxSpareThreads</name>
<description>Nombre maximum de threads inactifs</description>
<syntax>MaxSpareThreads <var>nombre</var></syntax>
<default>Voir ci-dessous pour plus de détails</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>mpm_netware</module><module>mpmt_os2</module>
</modulelist>

<usage>
    <p>C'est le nombre maximum de threads inactifs. Les MPMs utilisent
    cette directive de différentes manières.</p>

    <p>Pour <module>worker</module> et <module>event</module>, la définition par défaut est
    <code>MaxSpareThreads 250</code>. Ce MPM gère les threads inactifs
    au niveau du serveur. Si le serveur possède trop de threads
    inactifs, des processus enfants seront arrêtés jusqu'à ce que le
    nombre de threads inactifs repasse en dessous de cette limite. Des
    processus/threads supplémentaires sont susceptibles d'être créés si
    <directive module="mpm_common">ListenCoresBucketsRatio</directive> est
    activée.</p>

    <p>Pour <module>mpm_netware</module>, la définition par défaut est
    <code>MaxSpareThreads 100</code>. Comme ce MPM n'exécute qu'un seul
    processus, le nombre de processus inactifs est surveillé au
    niveau du serveur.</p>

    <p><module>mpmt_os2</module> fonctionne de manière similaire à
    <module>mpm_netware</module>. Pour <module>mpmt_os2</module>, la
    valeur par défaut est <code>10</code>.</p>

    <note><title>Contraintes</title>
      <p>La gamme de valeurs pour <directive>MaxSpareThreads</directive>
      est limitée. Apache httpd corrigera automatiquement cette valeur selon
      les règles suivantes :</p>
      <ul>
        <li>Avec <module>mpm_netware</module>, <directive
        >MaxSpareThreads</directive> doit être supérieure à <directive
	module="mpm_common">MinSpareThreads</directive>.</li>

        <li>Avec
	<module>worker</module> et <module>event</module>, <directive>MaxSpareThreads</directive>
	doit être supérieure ou égale à la somme de <directive
	module="mpm_common">MinSpareThreads</directive> et <directive
	module="mpm_common">ThreadsPerChild</directive>.</li>
      </ul>
    </note>
</usage>
<seealso><directive module="mpm_common">MinSpareThreads</directive></seealso>
<seealso><directive module="mpm_common">StartServers</directive></seealso>
<seealso><directive module="prefork">MaxSpareServers</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>MinSpareThreads</name>
<description>Nombre minimum de threads inactifs qui seront disponibles
pour pouvoir traiter les pics de requêtes</description>
<syntax>MinSpareThreads <var>nombre</var></syntax>
<default>Voir ci-dessous pour plus de détails</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>mpm_netware</module><module>mpmt_os2</module>
</modulelist>

<usage>
    <p>C'est le nombre minimum de threads inactifs pour être en mesure
    de traiter les pics de requêtes. Les MPMs utilisent cette directive
    de différentes manières.</p>

    <p>Avec <module>worker</module> et <module>event</module>, la définition par défaut est
    <code>MinSpareThreads 75</code>, et le nombre de threads inactifs
    est surveillé au niveau du serveur. Si le serveur ne possède pas
    assez de threads inactifs, des processus enfants sont créés jusqu'à
    ce que le nombre de threads inactifs repasse au dessus de
    <var>nombre</var>. Des processus/threads supplémentaires peuvent
    être créés si <directive
    module="mpm_common">ListenCoresBucketsRatio</directive> est activée.</p>

    <p>Avec <module>mpm_netware</module>, la définition par défaut est
    <code>MinSpareThreads 10</code> et, comme ce MPM n'exécute qu'un
    seul processus, le nombre de threads est surveillé au niveau général du
    serveur.</p>

    <p><module>mpmt_os2</module> fonctionne de manière similaire à
    <module>mpm_netware</module>. Pour <module>mpmt_os2</module>, la
    valeur par défaut est <code>5</code>.</p>

</usage>
<seealso><directive module="mpm_common">MaxSpareThreads</directive></seealso>
<seealso><directive module="mpm_common">StartServers</directive></seealso>
<seealso><directive module="prefork">MinSpareServers</directive></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ScoreBoardFile</name>
<description>Chemin du fichier où sont stockées les données concernant
la coordination des processus enfants</description>
<syntax>ScoreBoardFile <var>chemin fichier</var></syntax>
<default>ScoreBoardFile logs/apache_runtime_status</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module><module>mpm_winnt</module>
</modulelist>

<usage>
    <p>Le serveur HTTP Apache utilise un tableau de bord pour la
    communication entre le processus parent et les processus enfants.
    Pour faciliter cette communication, certaines architectures
    nécessitent un fichier. En l'absence de cette directive, donc si
    aucun nom de fichier n'est spécifié, Apache httpd tentera tout
    d'abord de créer un tableau uniquement en mémoire (en utilisant la
    mémoire partagée anonyme) ; et si il n'y parvient pas, il tentera de
    créer un fichier sur disque (en utilisant la mémoire partagée à base
    de fichier). Si cette directive est utilisée, Apache httpd créera
    systématiquement un fichier sur disque.</p>

    <example><title>Exemple</title>
    <highlight language="config">
      ScoreBoardFile /var/run/apache_runtime_status
      </highlight>
    </example>

    <p>Une mémoire partagée sous forme de fichier est utile pour les
    applications tierces qui nécessitent un accès direct au tableau de
    bord des processus.</p>

    <p>Si vous utilisez un <directive>ScoreBoardFile</directive>, vous
    pourrez constater une amélioration des performances en le plaçant
    sur un disque virtuel en RAM. Assurez-vous cependant de tenir compte
    des mêmes avertissements que ceux concernant le chemin du fichier
    journal et la <a
    href="../misc/security_tips.html">sécurité</a>.</p>
</usage>
<seealso><a href="../stopping.html">Arrêter et redémarrer
le serveur HTTP Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>ReceiveBufferSize</name>
<description>Taille du tampon TCP en entrée</description>
<syntax>ReceiveBufferSize <var>octets</var></syntax>
<default>ReceiveBufferSize 0</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module><module>mpm_winnt</module>
<module>mpm_netware</module><module>mpmt_os2</module>
</modulelist>

<usage>
    <p>Le serveur va fixer la taille du tampon TCP en entrée au
    nombre d'octets spécifié.</p>

    <p>Si la directive est définie à <code>0</code>, le serveur va
    utiliser la valeur par défaut adoptée par le système
    d'exploitation.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>SendBufferSize</name>
<description>Taille du tampon TCP en sortie</description>
<syntax>SendBufferSize <var>octets</var></syntax>
<default>SendBufferSize 0</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module><module>mpm_winnt</module>
<module>mpm_netware</module><module>mpmt_os2</module>
</modulelist>

<usage>
    <p>Définit la taille du tampon TCP en sortie avec le nombre
    d'octets spécifié. Ceci s'avère souvent très utile pour augmenter les
    valeurs par défaut standards du passé des systèmes d'exploitation
    pour les transmissions à grande vitesse et haute densité (<em>c'est
    à dire</em> de l'ordre de 100ms comme sur les liaisons rapides
    transcontinentales).</p>

    <p>Si la directive est définie à <code>0</code>, le serveur va
    utiliser la valeur par défaut adoptée par le système
    d'exploitation.</p>

    <p>L'amélioration des performances des connexions à grande vitesse
    et à temps de latence élevé, peut nécessiter
    une intervention au niveau de la configuration de votre système
    d'exploitation.</p>

    <note><p>Sous certains systèmes d'exploitation, la modification du
    comportement TCP via une augmentation de la valeur de
    <directive>SendBufferSize</directive> risque de ne pas être
    perceptible, si la directive <directive
    module="core">EnableSendfile</directive> n'est pas définie à OFF.
    Cette interaction ne s'applique qu'aux fichiers statiques.</p> </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ServerLimit</name>
<description>Limite supérieure de la définition du nombre de
processus</description>
<syntax>ServerLimit <var>nombre</var></syntax>
<default>Voir ci-dessous pour plus de détails</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module>
</modulelist>

<usage>
    <p>Avec le MPM <module>prefork</module>, cette directive définit le
    nombre maximum que l'on peut affecter à la directive <directive
    module="mpm_common">MaxRequestWorkers</directive>, et ceci pour la
    durée de vie du processus Apache httpd. Avec les
    MPMs <module>worker</module> et <module>event</module>, cette directive, en combinaison avec
    <directive module="mpm_common">ThreadLimit</directive>, définit le
    nombre maximum que l'on peut affecter à <directive
    module="mpm_common">MaxRequestWorkers</directive>, et ceci pour la durée de
    vie du processus Apache httpd. Avec le MPM <module>event</module>, cette
    directive permet aussi de définir le nombre de processus anciens du serveur
    pouvant continuer à s'exécuter pour terminer le traitement des connexions
    ouvertes. Au cours d'un redémarrage, vous pouvez
    modifier la valeur de la directive <directive
    module="mpm_common">MaxRequestWorkers</directive>, alors que toute
    tentative de modification de la valeur de la directive <directive
    module="mpm_common">ServerLimit</directive> sera ignorée.</p>

    <p>Cette directive doit être utilisée avec précaution. Si
    <directive>ServerLimit</directive> est définie à une valeur beaucoup
    plus grande que nécessaire, de la mémoire partagée supplémentaire
    sera inutilement allouée. Si à la fois
    <directive>ServerLimit</directive> et <directive
    module="mpm_common">MaxRequestWorkers</directive> possèdent des valeurs
    supérieures à ce que le système peut supporter, ce dernier peut
    devenir instable ou Apache httpd peut tout simplement refuser de démarrer.</p>

    <p>Avec les MPMs <module>prefork</module> et <module>event</module>, n'utilisez cette directive
    que si vous devez définir <directive
    module="mpm_common">MaxRequestWorkers</directive> à une valeur supérieure à
    256 (valeur par défaut). N'affectez pas à la directive <directive
    module="mpm_common">ServerLimit</directive> une valeur supérieure à
    celle que vous avez prévu d'affecter à la directive <directive
    module="mpm_common">MaxRequestWorkers</directive>.</p>

    <p>Avec <module>worker</module>, n'utilisez cette directive que si
    la définition de vos directives <directive
    module="mpm_common">MaxRequestWorkers</directive> et <directive
    module="mpm_common">ThreadsPerChild</directive> nécessitent plus de
    16 processus serveurs (valeur par défaut). N'affectez pas à la
    directive <directive module="mpm_common">ServerLimit</directive> une
    valeur supérieure au nombre de processus requis pour la définition
    des directives <directive module="mpm_common">MaxRequestWorkers
    </directive> et <directive
    module="mpm_common">ThreadsPerChild</directive>.</p>

    <note><title>Note</title>
      <p>Il existe une limite de <code>ServerLimit 20000</code> codée en
      dur dans le serveur (200000 pour le MPM <module>prefork</module>).
      Ceci est censé éviter les effets désastreux que pourrait provoquer
      une faute de frappe. Pour dépasser cette limite, vous devez
      modifier la valeur de MAX_SERVER_LIMIT dans le fichier source du
      mpm et recompiler le serveur.</p>
    </note>
</usage>
<seealso><a href="../stopping.html">Arrêter et redémarrer
le serveur HTTP Apache</a></seealso>
</directivesynopsis>

<directivesynopsis>
<name>StartServers</name>
<description>Nombre de processus enfants du serveur créés au
démarrage</description>
<syntax>StartServers <var>nombre</var></syntax>
<default>Voir ci-dessous pour plus de détails</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>prefork</module><module>mpmt_os2</module>
</modulelist>

<usage>
    <p>La directive <directive>StartServers</directive> permet de
    définir le nombre de processus enfants du serveur créés au
    démarrage. Comme le nombre de processus est contrôlé dynamiquement
    en fonction de la charge (voir <directive
    module="mpm_common">MinSpareThreads</directive>, <directive
    module="mpm_common">MaxSpareThreads</directive>, <directive
    module="prefork">MinSpareServers</directive>, <directive
    module="prefork">MaxSpareServers</directive>), il n'est en général
    pas nécessaire d'ajuster ce paramètre.</p>

    <p>La valeur par défaut diffère d'un MPM à l'autre. Pour
    <module>worker</module> et <module>event</module>, la définition par défaut est
    <code>StartServers 3</code> ; la valeur par défaut est
    <code>5</code> pour <module>prefork</module> et <code>2</code>
    pour <module>mpmt_os2</module>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>StartThreads</name>
<description>Nombre de threads créés au démarrage</description>
<syntax>StartThreads <var>nombre</var></syntax>
<default>Voir ci-dessous pour plus de détails</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>mpm_netware</module></modulelist>

<usage>
    <p>C'est le nombre de threads créés au démarrage du serveur. Comme
    le nombre de threads est contrôlé dynamiquement
    en fonction de la charge (voir <directive
    module="mpm_common">MinSpareThreads</directive>, <directive
    module="mpm_common">MaxSpareThreads</directive>, <directive
    module="prefork">MinSpareServers</directive>, <directive
    module="prefork">MaxSpareServers</directive>), il n'est en général
    pas nécessaire d'ajuster ce paramètre.</p>

    <p>Pour <module>mpm_netware</module>, la définition par défaut est
    <code>StartThreads 50</code> et, comme il n'y a qu'un processus, il
    s'agit du nombre total de threads créés au démarrage pour servir les
    requêtes.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ThreadLimit</name>
<description>Le nombre de threads maximum que l'on peut définir par
processus enfant</description>
<syntax>ThreadLimit <var>nombre</var></syntax>
<default>Voir ci-dessous pour plus de détails</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>mpm_winnt</module>
</modulelist>

<usage>
    <p>Cette directive permet de définir le nombre maximum que l'on peut
    affecter à la directive <directive
    module="mpm_common">ThreadsPerChild</directive> pour la durée de vie
    du processus Apache httpd. La directive  <directive
    module="mpm_common">ThreadsPerChild</directive> peut être modifiée
    au cours d'un redémarrage jusqu'à la valeur de la directive <directive
    module="mpm_common">ThreadLimit</directive>, mais toute tentative
    de modification de la directive <directive
    module="mpm_common">ThreadLimit</directive> au cours d'un
    redémarrage sera ignorée.</p>

    <p>L'utilisation de cette directive doit faire l'objet de
    précautions particulières. Si <directive>ThreadLimit</directive> est
    définie à une valeur très supérieure à la directive <directive
    module="mpm_common">ThreadsPerChild</directive>, de la mémoire
    partagée supplémentaire sera inutilement allouée. Si les directives
    <directive>ThreadLimit</directive> et <directive
    module="mpm_common">ThreadsPerChild</directive> sont définies à des
    valeurs supérieures à ce que le système peut supporter, ce dernier
    peut devenir instable, ou Apache httpd peut tout simplement refuser de
    démarrer. Ne définissez pas cette directive à une valeur supérieure
    à la valeur maximale que vous pensez affecter à la directive <directive
    module="mpm_common">ThreadsPerChild</directive> pour le processus
    Apache httpd en cours d'exécution.</p>

    <p>La valeur par défaut de la directive
    <directive>ThreadLimit</directive> est <code>1920</code> avec
    <module>mpm_winnt</module>, et <code>64</code> avec les autres
    MPMs.</p>

    <note><title>Note</title>
      <p>Il existe une limite de <code>ThreadLimit 20000</code> (ou
      <code>ThreadLimit 100000</code> avec <module>event</module>,
      <code>ThreadLimit 15000</code> avec <module>mpm_winnt</module>)
      codée en dur dans le serveur. Ceci est censé éviter les effets
      désastreux que pourrait provoquer une faute de frappe. Pour
      dépasser cette limite, vous devez modifier la valeur de
      MAX_THREAD_LIMIT dans le fichier source du mpm et recompiler le
      serveur.</p>
    </note>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ThreadsPerChild</name>
<description>Nombre de threads créés par chaque processus
enfant</description>
<syntax>ThreadsPerChild <var>nombre</var></syntax>
<default>Voir ci-dessous pour plus de détails</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>mpm_winnt</module>
</modulelist>

<usage>
    <p>Cette directive permet de définir le nombre de threads que va
    créer chaque processus enfant. Un processus enfant crée ces threads
    au démarrage et n'en crée plus d'autres par la suite. Si l'on
    utilise un MPM comme <module>mpm_winnt</module> qui ne lance qu'un
    processus enfant, ce nombre doit être suffisamment grand pour
    supporter la charge du serveur. Avec un MPM comme
    <module>worker</module> qui lance plusieurs processus enfants, c'est
    le nombre <em>total</em> de threads qui doit être suffisamment grand
    pour supporter la charge du serveur.</p>

    <p>La valeur par défaut de la directive
    <directive>ThreadsPerChild</directive> est <code>64</code> avec
    <module>mpm_winnt</module>, et <code>25</code> avec les autres
    MPMs.</p>

    <p>La valeur de la directive <directive>ThreadsPerChild</directive> ne peut
    pas dépasser la valeur de la directive <directive
    module="mpm_common">ThreadLimit</directive>. Si on spécifie une valeur
    supérieure, elle sera automatiquement réduite au démarrage du serveur et un
    avertissement sera enregistré dans le journal. La relation entre ces deux
    directives est expliquée dans la <directive
    module="mpm_common">documentation de la directive ThreadLimit</directive>.</p>
</usage>
</directivesynopsis>

<directivesynopsis>
<name>ThreadStackSize</name>
<description>La taille en octets de la pile qu'utilisent les threads qui
traitent les connexions clients</description>
<syntax>ThreadStackSize <var>taille</var></syntax>
<default>65536 sous NetWare; varie en fonction des autres systèmes
d'exploitation</default>
<contextlist><context>server config</context></contextlist>
<modulelist><module>event</module><module>worker</module>
<module>mpm_winnt</module><module>mpm_netware</module>
<module>mpmt_os2</module>
</modulelist>
<compatibility>Disponible dans les versions 2.1 et supérieures
du serveur HTTP Apache</compatibility>

<usage>
    <p>La directive <directive>ThreadStackSize</directive> permet de
    définir la taille de la pile (pour les données propres) qu'utilisent
    les threads qui traitent les connexions clients en faisant appel à
    des modules. Dans la plupart des cas, la valeur par défaut de la
    taille de la pile du système d'exploitation convient, mais il existe
    certaines situations où il peut s'avérer nécessaire de l'ajuster
    :</p>

    <ul>
      <li>Sur les plates-formes qui possèdent une valeur par défaut de
      taille de la pile relativement petite (par exemple HP-UX), Apache
      httpd peut se crasher si l'on utilise certains modules tiers qui
      possèdent un quantité de données propres stockées relativement
      importante. Il se peut que ces mêmes modules fonctionnent
      correctement sur d'autres plate-formes où la valeur par défaut de
      la taille de la pile est supérieure. Ce type de crash peut être
      evité en définissant <directive>ThreadStackSize</directive> à une
      valeur supérieure à la valeur par défaut du système
      d'exploitation. Ce type d'ajustement n'est nécessaire que si le
      fournisseur du module tiers en fait mention, ou si le diagnostic
      d'un crash d'Apache httpd indique que la taille de la pile était trop
      petite.</li>

      <li>Sur les plates-formes où la taille par défaut de la pile des
      threads est sensiblement supérieure à la taille nécessaire pour la
      configuration du serveur web, il est possible de disposer d'un
      plus grand nombre de threads par processus enfant si la directive
      <directive>ThreadStackSize</directive> est définie à une valeur
      inférieure à la valeur par défaut du système d'exploitation.
      Cependant, ce
      type d'ajustement ne doit être effectué que dans un environnement
      de test permettant de qualifier le serveur web au maximum de ses
      possibilités, car il peut arriver, dans de rares cas, que des
      requêtes nécessitent une taille de pile supérieure pour pouvoir
      être traitées. La taille minimale requise pour la pile dépend
      fortement des modules utilisés, mais toute modification dans la
      configuration du serveur web peut invalider la définition courante
      de la directive <directive>ThreadStackSize</directive>.</li>

      <li>Sous Linux, cette directive ne peut être utilisée que pour
      augmenter la valeur par defaut de la taille de la pile, car
      l'appel système sous-jacent utilise cette valeur comme taille de pile
      <em>minimale</em>. C'est la limite logicielle (souvent élevée)
      pour <code>ulimit -s</code> (8Mo si aucune limite) qui est
      utilisée comme taille de pile par défaut.</li>
    </ul>

    <note>Il est recommandé de ne pas réduire
    <directive>ThreadStackSize</directive>, à moins qu'un grand nombre
    de threads par processus enfant ne soit nécessaire. Sur certaines
    plates-formes (y compris Linux), une valeur de 128000 est déjà trop
    basse et provoque des crashes avec certains modules courants.</note>
</usage>
</directivesynopsis>

</modulesynopsis>
