<?xml version='1.0' encoding='UTF-8' ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1864798 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="htpasswd.xml.meta">
<parentdocument href="./">Programmes</parentdocument>

<title>htpasswd - Gestion des fichiers d'utilisateurs pour
l'authentification de base</title>

<summary>
    <p><code>htpasswd</code> permet de créer et de maintenir les
    fichiers textes où sont stockés les noms d'utilisateurs et mots de
    passe pour l'authentification de base des utilisateurs HTTP. Si
    <code>htpasswd</code> rencontre un problème d'accès à un fichier,
    que ce soit pour écrire dans le fichier de sortie, ou pour lire le
    fichier d'entrée dans le but de le mettre à jour, il renvoie un code
    d'erreur et n'effectue aucune modification.</p>

    <p>Il est possible de limiter l'accès aux ressources du serveur HTTP
    Apache aux seuls utilisateurs présents dans les fichiers créés par
    <code>htpasswd</code>. Ce programme ne sait gérer les noms
    d'utilisateurs et mots de passe que s'ils sont stockés dans des
    fichiers textes. Il peut cependant chiffrer et afficher les mots de
    passe à des fins d'utilisation dans d'autres types de bases de
    données. Pour utiliser une base de données DBM, voir le programme
    <program>dbmmanage</program> ou <program>htdbm</program>.</p>

    <p><code>htpasswd</code> chiffre les mots de passe en utilisant soit
    bcrypt,
    une version de MD5 modifiée pour Apache, soit SHA1, soit la routine
    <code>crypt()</code> du système. Les fichiers gérés par
    <code>htpasswd</code> peuvent contenir deux types de mots de passe ;
    certaines entrées peuvent contenir des mots de passe chiffrés en
    MD5 ou bcrypt, alors que d'autres entrées du même fichier contiendront des
    mots de passe chiffrés avec <code>crypt()</code>.</p>

    <p>Cette page de manuel ne décrit que les arguments de la ligne de
    commande. Pour plus de détails à propos des directives nécessaires à
    la configuration de l'authentification des utilisateurs dans
    <program>httpd</program>, voir le manuel Apache qui est fourni avec
    la distribution ou peut être consulté à <a
    href="http://httpd.apache.org">http://httpd.apache.org/</a>.</p>
</summary>
<seealso><program>httpd</program></seealso>
<seealso><program>htdbm</program></seealso>
<seealso>Les scripts fournis avec la distibution d'Apache et situés dans
support/SHA1.</seealso>

<section id="synopsis"><title>Syntaxe</title>
    <p><code><strong>htpasswd</strong>
    [ -<strong>c</strong> ]
    [ -<strong>i</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>D</strong> ]
    [ -<strong>v</strong> ]  <var>fichier-mots-de-passe</var> <var>nom-utilisateur</var></code></p>

    <p><code><strong>htpasswd</strong> -<strong>b</strong>
    [ -<strong>c</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ]
    [ -<strong>D</strong> ]
    [ -<strong>v</strong> ]  <var>fichier-mots-de-passe</var> <var>nom-utilisateur</var>
    <var>mot-de-passe</var></code></p>

    <p><code><strong>htpasswd</strong> -<strong>n</strong>
    [ -<strong>i</strong> ]
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ] <var>nom-utilisateur</var></code></p>

    <p><code><strong>htpasswd</strong> -<strong>nb</strong>
    [ -<strong>m</strong> |
      -<strong>B</strong> |
      -<strong>d</strong> |
      -<strong>s</strong> |
      -<strong>p</strong> ]
    [ -<strong>C</strong> <var>cost</var> ] <var>nom-utilisateur</var>
    <var>mot-de-passe</var></code></p>
</section>

<section id="options"><title>Options</title>
    <dl>
    <dt><code>-b</code></dt>
    <dd>Utilise le mode batch ; c'est à dire, extrait le mot de passe de
    la ligne de commande au lieu de le demander à l'opérateur. Cette
    option doit être utilisée avec la plus grande prudence, car
    <strong>le mot de passe est visible en clair</strong> dans la ligne
    de commande. Pour utiliser un script, voir l'option
    <code>-i</code>.
    Disponible à partir de la version 2.4.4 du serveur HTTP Apache.</dd>

    <dt><code>-i</code></dt>
    <dd>Lit le mot de passe depuis stdin sans vérification (à utiliser
    dans les scripts).</dd>

    <dt><code>-c</code></dt>
    <dd>Crée le <var>fichier-mots-de-passe</var>. Si
    <var>fichier-mots-de-passe</var> existe déjà, il est réécrit et
    tronqué. Cette option ne peut pas être combinée avec l'option
    <code>-n</code>.</dd>

    <dt><code>-n</code></dt>
    <dd>Affiche le résultat du traitement sur la sortie standard au lieu
    de mettre à jour le fichier. Ceci peut s'avérer utile pour générer
    des enregistrements de mots de passe qu'Apache pourra utiliser à des
    fins d'inclusion dans des fichiers de données au format autre que
    texte. Cette option modifie la syntaxe de la ligne de commande, car
    l'argument <var>fichier-mots-de-passe</var> (en général le premier)
    est omis. Elle ne peut pas être combinée avec l'option
    <code>-c</code> option.</dd>

    <dt><code>-m</code></dt>
    <dd>Utilise le chiffrement MD5 pour les mots de passe. C'est le
    comportement par défaut (depuis la version 2.2.18).</dd>

    <dt><code>-B</code></dt>
    <dd>Utilise bcrypt pour chiffrer les mots de passe. c'est un
    algorythme de chiffrement actuellement considéré comme sûr.</dd>

    <dt><code>-C</code></dt>
    <dd>Ce drapeau n'est autorisé qu'en conjonction avec le drapeau
    <code>-B</code> (chiffrement bcrypt). Il permet de définir la durée
    de traitement pour l'algorytme bcrypt (plus elle est longue,
    meilleure sera la sécurité, mais inférieure la rapidité). La valeur
    par défaut est 5 et les valeurs autorisées vont de 4 à 17.</dd>


    <dt><code>-d</code></dt>
    <dd>Utilise le chiffrement <code>crypt()</code> pour les mots de
    passe. Cette option n'est pas supportée par le
    serveur <program>httpd</program> sous Windows ou Netware. Cet
    algorithme limite la longueur des mots de passe à 8 caractères ; il
    est considéré comme <strong>non sur</strong> du point de vue des
    standards actuels. C'était l'algorithme par défaut jusqu'à la
    version 2.2.17.</dd>

    <dt><code>-s</code></dt>
    <dd>Utilise le chiffrement SHA pour les mots de passe. Facilite la
    migration vers/depuis les serveurs Netscape qui utilisent le format
    LDAP Directory Interchange (ldif). Cet algorithme
    est considéré comme <strong>non sur</strong> du point de vue des
    standards actuels.</dd>

    <dt><code>-p</code></dt>
    <dd>Enregistre les mots de passe en clair. Bien que
    <code>htpasswd</code> supporte la création des mots de passe en
    clair sur toutes les plates-formes, le démon
    <program>httpd</program> n'accepte les mots de passe en clair que
    sous Windows et Netware.</dd>

    <dt><code>-D</code></dt>
    <dd>Supprime un utilisateur, sous réserve qu'il existe dans le
    fichier spécifié par htpasswd.</dd>

    <dt><code>-v</code></dt>
    <dd>Vérifie si le mot de passe fourni correspond au mot de passe de
    l'utilisateur enregistré dans le fichier de mots de passe spécifié.
    Disponible à partir de la version 2.4.5 du serveur HTTP Apache.</dd>

    <dt><code><var>fichier-mots-de-passe</var></code></dt>
    <dd>Le nom du fichier contenant les noms d'utilisateurs et mots de
    passe. Avec l'option <code>-c</code>, le fichier est créé s'il
    n'existe pas, ou réécrit et tronqué s'il existe déjà.</dd>

    <dt><code><var>nom-utilisateur</var></code></dt>
    <dd>Le nom d'utilisateur à créer ou mettre à jour dans le
    <var>fichier-mots-de-passe</var>. Si <var>nom-utilisateur</var>
    n'existe pas, une nouvelle entrée est ajoutée. Dans le cas
    contraire, le mot de passe est modifié.</dd>

    <dt><code><var>mot-de-passe</var></code></dt>
    <dd>Le mot de passe en clair et destiné à être chiffré puis stocké
    dans le fichier. Cet argument ne s'utilise qu'avec l'option
    <code>-b</code>.</dd>
    </dl>
</section>

<section id="exit"><title>Valeur renvoyée</title>
    <p><code>htpasswd</code> renvoie 0 ("true") si le nom d'utilisateur
    et le mot de passe ont été enregistrés ou mis à jour avec succès
    dans le <var>fichier-mots-de-passe</var>. <code>htpasswd</code>
    renvoie <code>1</code> s'il a rencontré un problème d'accès aux
    fichiers, <code>2</code> si la ligne de commande comportait une
    erreur de syntaxe, <code>3</code> si le mot de passe entré
    interactivement ne correspondait pas au nom d'utilisateur,
    <code>4</code> si l'opération a été interrompue, <code>5</code> si
    une valeur était trop longue (nom-utilisateur, nom-fichier,
    mot-de-passe, ou l'enregistrement résultant), <code>6</code> si le
    nom d'utilisateur contenait des caractères illégaux (voir la section
    <a href="#restrictions">Restrictions</a>), et <code>7</code> si le
    fichier spécifié n'était pas un fichier de mots de passe
    valide.</p>
</section>

<section id="examples"><title>Exemples</title>
    <example>
      htpasswd /usr/local/etc/apache/.utilisateurs-htpasswd jsmith
    </example>

    <p>Ajoute ou modifie le mot de passe de l'utilisateur
    <code>jsmith</code>. Le mot de passe est demandé à l'opérateur. Le
    mot de passe sera chiffré en utilisant l'algorithme MD5
    modifié pour Apache. Si le fichier spécifié
    n'existe pas, <code>htpasswd</code> renverra un code d'erreur.</p>

    <example>
      htpasswd -c /home/doe/public_html/.htpasswd jane
    </example>

    <p>Crée un nouveau fichier de mots de passe et y enregistre une
    entrée pour l'utilisateur <code>jane</code>. Le mot de passe est
    demandé à l'opérateur. Si le fichier existe et ne peut être ni lu ni
    écrit, il n'est pas modifié et <code>htpasswd</code> affichera un
    message et renverra un code d'erreur.</p>

    <example>
      htpasswd -db /usr/web/.htpasswd-tous jones Pwd4Steve
    </example>

    <p>Chiffre le mot de passe spécifié dans la ligne de commande
    (<code>Pwd4Steve</code>) en utilisant l'algorithme
    <code>crypt()</code>, et le stocke dans le fichier spécifié.</p>
</section>

<section id="security"><title>Considérations à propos de sécurité</title>
    <p>Les fichiers de mots de passe Web comme ceux que gère
    <code>htpasswd</code> ne doivent <em>pas</em> être situés dans
    l'espace d'URI du serveur Web -- en d'autres termes, il ne doit pas
    être possible d'y accéder à partir d'un navigateur.</p>

    <p>En tant qu'exécutable setuid, ce programme n'est pas sûr, et il
    ne faut par conséquent <em>pas</em> lui attribuer de permissions
    setuid.</p>

    <p>L'utilisation de l'option <code>-b</code> est déconseillée, car
    avec elle, les mots de passe apparaissent en clair dans la ligne de
    commande.</p>

    <p>Notez qu'avec l'algorithme <code>crypt()</code>, seuls les huit
    premiers caractères du mot de passe spécifié sont pris en compte. Si
    le mot de passe spécifié est plus long, les caractères
    supplémentaires sont ignorés.</p>

    <p>Le format de chiffrement SHA n'utilise pas d'amorçage aléatoire
    (salting) : à un mot de passe donné correspond une seule
    représentation chiffrée. Les formats <code>crypt()</code> et MD5
    permutent la représentation en la préfixant par une chaîne d'amorce
    aléatoire, afin de rendre les attaques de mots de passe à base de
    dictionnaires plus difficiles.</p>

    <p>Les algorithmes de chiffrement SHA et <code>crypt()</code> 
    sont considérés comme <strong>non surs</strong> du point de vue des
    standards actuels.</p>
</section>

<section id="restrictions"><title>Restrictions</title>
    <p>Sur les plates-formes Windows, la taille des mots de passe
    chiffrés avec <code>htpasswd</code> est limitée à <code>255</code>
    caractères. Les mots de passe dont la taille est supérieure seront
    tronqués.</p>

    <p>L'algorithme MD5 utilisé par <code>htpasswd</code> est spécifique
    à Apache ; les mots de passe chiffrés en utilisant cet algorithme
    seront inutilisables sur d'autres serveurs Web.</p>

    <p>La taille des noms d'utilisateurs est limitée à <code>255</code>
    octets et ceux-ci ne doivent pas contenir de caractère
    <code>:</code>.</p>

    <p>Le coût en performances de la génération de la valeur de hashage d'un mot
    de passe bcrypt augmente avec le nombre de passes spécifié par l'option
    <code>-C</code>. A partir de sa version <code>1.6.0</code>, la bibliothèque
    <code>apr-util</code> limite le nombre de passes à 17.</p>
</section>

</manualpage>
