<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1878549 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->


<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="access.xml.meta">
  <parentdocument href="./">Rewrite</parentdocument>

<title>Utiliser mod_rewrite pour le contrôle d'accès</title>

<summary>

<p>Ce document est un complément à la <a
href="../mod/mod_rewrite.html">documentation de référence</a> de
<module>mod_rewrite</module>. Il explique comment utiliser
<module>mod_rewrite</module> pour contrôler l'accès à diverses
ressources, ainsi que d'autres techniques en rapport. Il contient de
nombreux exemples d'utilisation courante de mod_rewrite avec une
description détaillée de leur fonctionnement.</p>

<note type="warning">Vous devez vous attacher à comprendre le
fonctionnement des exemples, car la plupart d'entre eux ne
fonctionneront pas sur votre système si vous vous contentez de les
copier/coller dans vos fichiers de configuration.</note>

</summary>
<seealso><a href="../mod/mod_rewrite.html">Documentation du module mod_rewrite</a></seealso>
<seealso><a href="intro.html">Introduction à mod_rewrite</a></seealso>
<seealso><a href="remapping.html">Redirection et remise en
correspondance</a></seealso>
<!-- <seealso><a href="access.html">Contrôler l'accès</a></seealso> -->
<seealso><a href="vhosts.html">Serveurs virtuels</a></seealso>
<seealso><a href="proxy.html">Serveurs mandataires</a></seealso>
<seealso><a href="rewritemap.html">Utilisation de RewriteMap</a></seealso>
<seealso><a href="advanced.html">Techniques avancées</a></seealso>
<seealso><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></seealso>

    <section id="blocked-inline-images">

      <title>Blocage du référencement à chaud (Hotlinking) d'images</title>

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Cette technique vous permet d'interdire à d'autres sites
	  d'inclure directement vos images dans leurs pages. On fait
	  souvent référence à cette pratique sous le nom de
	  référencement à chaud (Hotlinking) qui entraîne l'utilisation
	  de votre bande passante pour servir des contenus faisant
	  partie du site de quelqu'un d'autre.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
	<p>Cette technique repose sur la valeur de la variable
	optionnelle <code>HTTP_REFERER</code>. Certaines personnes
	pourront donc contourner cette limitation. Pour la plupart des
	utilisateurs cependant, la requête échouera, en ce sens que
	l'image ne sera pas affichée depuis le site tiers.</p>
	<p>Il y a plusieurs manières de gérer cette situation.</p>

	<p>Dans le premier exemple, nous rejetons tout simplement la
	requête si elle ne provenait pas d'une page appartenant à notre
	site. Pour les besoins de cet exemple, nous supposons que le nom
	de votre site est <code>www.example.com</code>.</p>

<!-- TODO: Add discussion here of why we have !^$ in there. -->

<highlight language="config">
RewriteCond "%{HTTP_REFERER}" "!^$"
RewriteCond "%{HTTP_REFERER}" "!www.example.com" [NC]
RewriteRule "\.(gif|jpg|png)$"    "-"   [F,NC]
</highlight>

	<p>Dans le second exemple, plutôt que de rejeter la requête,
	nous affichons une autre image à la place.</p>

<highlight language="config">
RewriteCond "%{HTTP_REFERER}" "!^$"
RewriteCond "%{HTTP_REFERER}" "!www.example.com" [NC]
RewriteRule "\.(gif|jpg|png)$"    "/images/go-away.png"   [R,NC]
</highlight>

	<p>Dans le troisième exemple, nous redirigeons la requête vers
	une image appartenant à un autre site.</p>

<highlight language="config">
RewriteCond "%{HTTP_REFERER}" "!^$"
RewriteCond "%{HTTP_REFERER}" "!www.example.com" [NC]
RewriteRule "\.(gif|jpg|png)$" "http://other.example.com/image.gif"   [R,NC]
</highlight>

	<p>De tous ces exemples, les deux derniers semblent les plus
	efficaces pour faire en sorte que les gens arrêtent de
	référencer vos images à chaud, car il ne verront pas les images
	qu'ils s'attendent à voir.</p>

        </dd>

        <dt>Discussion :</dt>

        <dd>
        <p>Si vous ne voulez pas rediriger la requête, mais
	simplement interdire l'accès à la ressource, vous pouvez y
	parvenir sans utiliser mod_rewrite :</p>

        <highlight language="config">
SetEnvIf Referer "example\.com" localreferer
&lt;FilesMatch "\.(jpg|png|gif)$"&gt;
    Require env localreferer
&lt;/FilesMatch&gt;
        </highlight>
        </dd>
      </dl>

    </section>

    <section id="blocking-of-robots">

      <title>Blocage des robots</title>

      <dl>
        <dt>Description :</dt>

        <dd>
        <p>
        Dans cet exemple, nous allons discuter d'une méthode permettant
	de bloquer les requêtes persistentes en provenance d'un robot
	particulier, ou d'un navigateur.</p>

        <p>La méthode classique pour exclure un robot consiste à définir
	un fichier, <code>/robots.txt</code> qui spécifie les parties de
	votre site web pour lesquelles vous voulez exclure les robots.
	Malheureusement, certains robots ne tiennent pas compte de ces
	fichiers.
        </p>

        <p>Notez qu'il existe des méthodes d'exclusion qui n'utilisent
	pas mod_rewrite. Notez aussi que toute technique qui repose sur
	le contenu de la chaîne client <code>USER_AGENT</code> peut être
	contournée très facilement car cette chaîne peut être modifiée.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
        <p>On utilise un jeu de règles qui spécifie le répertoire à
	protéger, ainsi que la chaîne client <code>USER_AGENT</code> qui
	identifie le robot malin ou envahissant.</p>

        <p>Dans cet exemple, nous bloquons un robot nommé
	<code>Vilain_Robot</code> pour le répertoire
	<code>/secret/fichiers</code>. Si vous voulez bloquer ce client
	seulement depuis une source particulière, vous pouvez aussi
	spécifier un intervalle d'adresses IP.</p>

<highlight language="config">
RewriteCond "%{HTTP_USER_AGENT}"   "^NameOfBadRobot"
RewriteCond "%{REMOTE_ADDR}"       "=123\.45\.67\.[8-9]"
RewriteRule "^/secret/files/"   "-"   [F]
</highlight>
        </dd>

      <dt>Discussion :</dt>

      <dd>
      <p>
        Vous pouvez cependant parvenir au même résultat sans utiliser
	mod_rewrite via la méthode alternative suivante :
      </p>
      <highlight language="config">
SetEnvIfNoCase User-Agent "^NameOfBadRobot" goaway
&lt;Location "/secret/files"&gt;
    &lt;RequireAll&gt;
        Require all granted
        Require not env goaway
    &lt;/RequireAll&gt;
&lt;/Location&gt;
      </highlight>
      <p>
      Comme indiqué plus haut, il est aisé de contourner cette
      technique, simplement en modifiant le contenu de l'en-tête
      <code>USER_AGENT</code>. Si vous subissez une attaque en règle,
      vous allez devoir réfléchir à un blocage à un niveau supérieur,
      par exemple une règle de filtrage de votre pare-feu.
      </p>

      </dd>

      </dl>

    </section>

<section id="host-deny">

  <title>Rejet des clients contenus dans une liste de proscrits</title>

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Nous voulons interdire l'accès à notre serveur aux clients
      contenus dans une liste de proscrits similaire à
      <code>hosts.deny</code>.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
<highlight language="config">
RewriteEngine on
RewriteMap    hosts-deny  "txt:/path/to/hosts.deny"
RewriteCond   "${hosts-deny:%{REMOTE_ADDR}|NOT-FOUND}" "!=NOT-FOUND" [OR]
RewriteCond   "${hosts-deny:%{REMOTE_HOST}|NOT-FOUND}" "!=NOT-FOUND"
RewriteRule   "^"  "-"  [F]
</highlight>

<example>
##<br />
##  hosts.deny<br />
##<br />
##  ATTENTION! Ceci est une table de correspondances, non une liste,<br />
##		même si elle est traitée comme telle. mod_rewrite<br />
##		l'interprète comme une liste de paires clé/valeur, et<br />
##		chaque entrée doit au moins posséder une valeur par<br />
##		défaut "-".<br />
<br />
193.102.180.41 -<br />
bsdti1.sdm.de  -<br />
192.76.162.40  -<br />
</example>
    </dd>

    <dt>Discussion :</dt>
    <dd>
    <p>
    La seconde condition RewriteCond présuppose que HostNameLookups est
    défini à On, de façon à ce que les adresses IP des clients puissent
    être résolues. Dans le cas contraire, vous devez supprimer la
    seconde condition, ainsi que le drapeau <code>[OR]</code> de la
    première.
    </p>
    </dd>
  </dl>

</section>

<section id="referer-deflector">

  <title>Aiguillage basé sur l'en-tête Referer</title>

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Redirige les requêtes en fonction du Referer de provenance de
      la requête, avec des cibles différentes pour chaque Referer.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
  <p>Le jeu de règles suivant utilise un fichier de correspondances pour
  associer chaque Referer à une cible de redirection.</p>

<highlight language="config">
RewriteMap  deflector "txt:/path/to/deflector.map"

RewriteCond "%{HTTP_REFERER}" !=""
RewriteCond "${deflector:%{HTTP_REFERER}}" "=-"
RewriteRule "^" "%{HTTP_REFERER}" [R,L]

RewriteCond "%{HTTP_REFERER}" !=""
RewriteCond "${deflector:%{HTTP_REFERER}|NOT-FOUND}" "!=NOT-FOUND"
RewriteRule "^" "${deflector:%{HTTP_REFERER}}" [R,L]
</highlight>

      <p>Le fichier de correspondances contient les cibles de
      redirection associées à chaque Referer, ou, si nous voulons
      simplement rediriger les requêtes vers leur Referer, un "-" est
      inscrit dans le fichier de correspondances :</p>

<highlight language="config">
##
##  deflector.map
##

http://badguys.example.com/bad/index.html    -
http://badguys.example.com/bad/index2.html   -
http://badguys.example.com/bad/index3.html   http://somewhere.example.com/
</highlight>

    </dd>
  </dl>

</section>


</manualpage>
