<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1737438 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="avoid.xml.meta">
  <parentdocument href="./">Rewrite</parentdocument>

<title>Quand ne pas utiliser mod_rewrite</title>

<summary>

<p>Ce document est un complément à la <a
href="../mod/mod_rewrite.html">Documentation de référence</a> de
<module>mod_rewrite</module>. Il décrit peut-être un des concepts les
plus importants à propos de <module>mod_rewrite</module> - à savoir, quand doit-on éviter
de l'utiliser.</p>

<p><module>mod_rewrite</module> doit être considéré comme un dernier recours,
lorsqu'aucune alternative n'est possible. Utiliser mod_rewrite lorsqu'il
existe des alternatives plus simples conduit à des configurations
confuses, fragiles, et difficiles à maintenir. La compréhension des
autres alternatives disponibles est une étape très importante sur le
chemin de la maîtrise de <module>mod_rewrite</module>.</p>

<p>Vous devez vous attacher à comprendre le
fonctionnement des exemples, car la plupart d'entre eux ne
fonctionneront pas sur votre système si vous vous contentez de les
copier/coller dans vos fichiers de configuration.</p>

<p>Le cas le plus courant dans lequel <module>mod_rewrite</module> est
l'outil approprié est la situation où la seule solution envisageable
nécessite l'accès aux fichiers de configuration du serveur, alors que
cet accès ne vous est pas accordé. Certaines directives de configuration
ne sont disponibles que dans le fichier de configuration du serveur. Si
vous ne pouvez agir que sur les fichiers .htaccess, vous devrez donc
vous tourner vers <module>mod_rewrite</module>.</p>

</summary>
<seealso><a href="../mod/mod_rewrite.html">Documentation du module mod_rewrite</a></seealso>
<seealso><a href="intro.html">Introduction à mod_rewrite</a></seealso>
<seealso><a href="remapping.html">Redirection et remise en
correspondance</a></seealso>
<seealso><a href="access.html">Contrôle d'accès</a></seealso>
<seealso><a href="vhosts.html">Serveurs virtuels</a></seealso>
<seealso><a href="proxy.html">Serveurs mandataires</a></seealso>
<seealso><a href="rewritemap.html">Utilisation de RewriteMap</a></seealso>
<seealso><a href="advanced.html">Techniques avancées</a></seealso>
<!--<seealso><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></seealso>-->

<section id="redirect">
<title>Redirection simple</title>

<p><module>mod_alias</module> fournit les directives <directive
module="mod_alias">Redirect</directive> et <directive
module="mod_alias">RedirectMatch</directive> qui permettent de
rediriger une URL vers une autre. Plutôt que d'utiliser la directive
<directive module="mod_rewrite">RewriteRule</directive> pour ce genre de
redirection simple d'une URL ou d'une classe d'URLs vers une autre, on
préfèrera l'utilisation de ces directives. En outre, avec
<code>RedirectMatch</code>, vous pouvez inclure une expression
rationnelle dans votre critère de redirection, ce qui vous permet de
bénéficier de nombreux avantages de la directive
<code>RewriteRule</code>.</p>

<p>Une utilisation courante de la directive <code>RewriteRule</code> est
la redirection de toute une classe d'URLs. Par exemple, toutes les URLs
faisant référence au répertoire <code>/un</code> doivent être
redirigées vers <code>http://un.example.com/</code>, ou toutes les
requêtes <code>http</code> doivent être redirigées vers
<code>https</code>.</p>

<p>Pour ce faire, il est préférable d'utiliser la directive
<code>Redirect</code>. Souvenez-vous que la directive
<code>Redirect</code> conserve les informations relatives au chemin. En
d'autres termes, la redirection d'une URL <code>/un</code> va aussi
rediriger toutes les URLs de niveaux inférieurs comme
<code>/un/deux.html</code> et <code>/un/trois/quatre.html</code>.</p>

<p>Pour rediriger les URLs sous <code>/un</code> vers
<code>http://un.example.com/</code>, utilisez cette définition :</p>

<highlight language="config">
Redirect /one/ http://one.example.com/
</highlight>

<p>Pour rediriger un nom d'hôte vers un autre nom d'hôte, par exemple
<code>example.com</code> vers <code>www.example.com</code>, voir la
méthode <a href="remapping.html#canonicalhost">Noms d'hôtes canoniques</a>.</p>

<p>Pour rediriger les URLs <code>http</code> vers <code>https</code>,
utilisez cette définition :</p>

<highlight language="config">
&lt;VirtualHost *:80&gt;
ServerName www.example.com
Redirect "/" "https://www.example.com/"
&lt;/VirtualHost&gt;

&lt;VirtualHost *:443&gt;
ServerName www.example.com
#  ... insérer ici la configuration SSL
&lt;/VirtualHost&gt;
</highlight>

<p>L'utilisation de la directive <code>RewriteRule</code> pour accomplir
cette tâche peut se justifier s'il existe d'autres directives
<code>RewriteRule</code> dans la même portée. En effet, lorsque des
directives <code>Redirect</code> et <code>RewriteRule</code> se trouvent
dans la même portée, les directives <code>RewriteRule</code> sont
exécutées en premier, sans tenir compte de leur ordre d'apparition dans
le fichier de configuration.</p>

<p>Dans le cas de la redirection <em>http-vers-https</em>, l'utilisation
de règles <code>RewriteRule</code> se justifie si vous n'avez pas accès
au fichier de configuration principal, et devez donc accomplir cette
tâche au sein d'un fichier <code>.htaccess</code>.</p>

</section>

<section id="alias"><title>Alias d'URL</title>
<p>La directive <directive module="mod_alias">Alias</directive> permet
de mettre en correspondance un URI avec un répertoire, ce dernier étant
en général situé en dehors de l'arborescence définie par la directive
<directive module="core">DocumentRoot</directive>. Bien qu'il soit
possible d'effectuer cette mise en correspondance avec
<module>mod_rewrite</module>, il est préférable d'utiliser la directive
<directive module="mod_alias">Alias</directive> pour des raisons de simplicité
et de performances.</p>

<example><title>Utilisation de la directive Alias</title>
<highlight language="config">
Alias "/cats" "/var/www/virtualhosts/felines/htdocs"
</highlight>
</example>

<p>
Pour effectuer cette mise en correspondance, <module>mod_rewrite</module>
s'impose si vous n'avez pas accès aux fichiers de configuration du
serveur. En effet, la directive Alias ne peut pas être utilisée dans un
fichier <code>.htaccess</code>, mais seulement dans un contexte de
serveur principal ou de serveur virtuel.
</p>

<p>En outre, vous pouvez arriver au même résultat avec les liens
symboliques, pourvu que <code>Options FollowSymLinks</code> soit activé
sur votre serveur.</p>
</section>

<section id="vhosts"><title>Hébergement virtuel</title>
<p>Bien qu'il soit possible de gérer les <a href="vhosts.html">serveurs
virtuels avec mod_rewrite</a>, il s'agit rarement de la bonne méthode.
Il est pratiquement toujours préférable de créer des blocs
<directive module="core" type="section">VirtualHost</directive> individuels.
Dans l'éventualité où vous devez gérer
un grand nombre de serveurs virtuels, vous devez vous tourner vers
<module>mod_vhost_alias</module> pour créer ces serveurs
automatiquement.</p>

<p>Il est aussi possible d'utiliser des modules comme <module>mod_macro</module> pour
créer un grand nombre de serveurs virtuels dynamiquement.</p>

<p>L'utilisation de <module>mod_rewrite</module> pour la création de
serveurs virtuels peut se révéler appropriée si votre service
d'hébergement ne vous permet pas d'accéder aux fichiers de configuration
du serveur, et que vous soyez par conséquent obligé de passer par les
fichiers <code>.htaccess</code>.</p>

<p>Voir le document <a href="vhosts.html">création de serveurs virtuels
avec mod_rewrite</a> pour plus de détails sur la manière d'y parvenir si
cela semble être tout de même la meilleure approche.</p>

</section>

<section id="proxy"><title>Mandat simple</title>

<p>La directive <directive module="mod_rewrite">RewriteRule</directive> fournit
le drapeau <a
href="flags.html#flag_p">[P]</a> qui permet de faire passer les URIs
réécrits par <module>mod_proxy</module>.</p>

<highlight language="config">
RewriteRule "^/?images(.*)" "http://serveur-images.local/images$1" [P]
</highlight>

<p>Cependant, dans les nombreux cas où aucune correspondance au modèle
n'est vraiment nécessaire, comme dans l'exemple ci-dessus, il est
préférable d'utiliser la directive <directive
module="mod_proxy">ProxyPass</directive>. L'exemple précédent pourrait
être remplacé par :</p>

<highlight language="config">
ProxyPass "/images/" "http://serveur-images.local/images/"
</highlight>

<p>Que vous utilisiez <directive
module="mod_rewrite">RewriteRule</directive> ou <directive
module="mod_proxy">ProxyPass</directive>, vous devrez dans tous les cas
utiliser aussi la directive <directive
module="mod_proxy">ProxyPassReverse</directive> pour intercepter les
redirections en provenance du serveur d'arrière-plan :</p>

<highlight language="config">
ProxyPassReverse "/images/" "http://serveur-images.local/images/"
</highlight>

<p>Vous devrez cependant tout de même utiliser <code>RewriteRule</code>
lorsque d'autres <code>RewriteRule</code>s se trouvent dans la même portée,
car elles agissent en général avant les directives
<code>ProxyPass</code>, et peuvent ainsi les court-circuiter.</p>

</section>

<section id="setenv"><title>Test de variables d'environnement</title>

<p><module>mod_rewrite</module> est souvent utilisé pour effectuer une
action en fonction de la présence ou de l'absence d'une variable
d'environnement particulière ou d'un en-tête de requête, ce qui peut
être accompli de manière plus efficace via la directive <directive
module="core" type="section">If</directive>.</p>

<p>Considérons par exemple le scénario courant où la directive
<directive>RewriteRule</directive> est utilisée pour forcer un nom
d'hôte canonique, tel que <code>www.example.com</code> au lieu de
<code>example.com</code>. Il est possible d'utiliser à la place la
directive <directive module="core" type="section">If</directive> comme
suit :</p>

<highlight language="config">
&lt;If "req('Host') != 'www.example.com'"&gt;
    Redirect "/" "http://www.example.com"
&lt;/If&gt;
</highlight>

<p>On peut utiliser cette technique dans de nombreux scénarios courant
pour remplacer <module>mod_rewrite</module> pour effectuer des actions
en fonction d'en-têtes de requêtes ou de réponses, ou de variables
d'environnement.</p>

<p>Voir en particulier la <a href="../expr.html">documentation sur
l'évaluation des expressions</a> pour une vue d'ensemble des types
d'expressions que vous pouvez utiliser dans les sections <directive
module="core" type="section">If</directive>,
ainsi que dans certaines directives.</p>

</section>

</manualpage>

