<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1874169 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="remapping.xml.meta">
  <parentdocument href="./">Rewrite</parentdocument>

<title>Redirection et remise en correspondance avec mod_rewrite</title>

<summary>

<p>Ce document est un complément à la <a
href="../mod/mod_rewrite.html">Documentation de référence</a> de
<module>mod_rewrite</module>. Il montre comment utiliser
<module>mod_rewrite</module> pour rediriger et remettre en
correspondance une requête. Il contient de
nombreux exemples d'utilisation courante de mod_rewrite avec une
description détaillée de leur fonctionnement.</p>

<note type="warning">Vous devez vous attacher à comprendre le
fonctionnement des exemples, car la plupart d'entre eux ne
fonctionneront pas sur votre système si vous vous contentez de les
copier/coller dans vos fichiers de configuration.</note>

</summary>
<seealso><a href="../mod/mod_rewrite.html">Documentation du module mod_rewrite</a></seealso>
<seealso><a href="intro.html">Introduction à mod_rewrite</a></seealso>
<!--<seealso><a href="remapping.html">Redirection et remise en
correspondance</a></seealso>-->
<seealso><a href="access.html">Contrôler l'accès</a></seealso>
<seealso><a href="vhosts.html">Serveurs virtuels</a></seealso>
<seealso><a href="proxy.html">Serveurs mandataires</a></seealso>
<seealso><a href="rewritemap.html">Utilisation de RewriteMap</a></seealso>
<seealso><a href="advanced.html">Techniques avancées</a></seealso>
<seealso><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></seealso>

<section id="old-to-new">

      <title>De l'ancienne à la nouvelle URL (en interne)</title>

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Supposons que nous ayons récemment renommé la page
	  <code>foo.html</code> en <code>bar.html</code>, et voulions
	  maintenant que l'ancienne URL soit toujours valide à des fins
	  de compatibilité ascendante. En fait, on voudrait que le
	  changement de nom soit transparent aux utilisateurs de
	  l'ancienne URL.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On réécrit l'ancienne URL en interne vers la nouvelle via
	  la règle suivante :</p>

<highlight language="config">
RewriteEngine  on
RewriteRule    "^<strong>/foo</strong>\.html$" "<strong>/bar</strong>.html" [PT]
</highlight>
    </dd>
  </dl>

</section>

<section id="old-to-new-extern">

      <title>De l'ancien au nouveau (en externe)</title>

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Supposons toujours que nous ayons récemment renommé la page
	  <code>foo.html</code> en <code>bar.html</code>, et voulions
	  maintenant que l'ancienne URL soit toujours valide à des fins
	  de compatibilité ascendante. En revanche, nous voulons cette
	  fois que la nouvelle URL soit suggérée aux utilisateurs de
	  l'ancienne URL, c'est à dire que l'adresse vue depuis leur
	  navigateur doit également être modifiée.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On force une redirection HTTP vers la nouvelle URL, ce qui
	  entraîne une modification de celle du navigateur et aussi de ce
	  que voit l'utilisateur :</p>

<highlight language="config">
RewriteEngine  on
RewriteRule    "^<strong>foo</strong>\.html$"  "<strong>bar</strong>.html"  [<strong>R</strong>]
</highlight>
</dd>

<dt>Discussion</dt>

    <dd>
    <p>Dans l'exemple <a
    href="#old-to-new-intern">interne</a>, on a utilisé mod_rewrite afin
    de dissimuler la redirection au client. Dans cet exemple, en
    revanche, on aurait pu se contenter d'une directive Redirect :</p>

    <highlight language="config">Redirect "/foo.html" "/bar.html"</highlight>

    </dd>
  </dl>

</section>

<section id="movehomedirs">

  <title>Ressource déplacée vers un autre serveur</title>

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Si une ressource a été déplacée vers un autre serveur, vous
      pouvez faire en sorte que les URLs de l'ancien serveur continuent
      de fonctionner pendant un certain temps, afin de laisser au
      utilisateurs le temps de modifier leurs favoris.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
      <p>Vous pouvez utiliser <module>mod_rewrite</module> pour
      rediriger ces URLs vers le nouveau serveur, mais vous pouvez aussi
      utiliser les directives Redirect ou RedirectMatch.</p>

<highlight language="config">#Avec mod_rewrite
RewriteEngine on
RewriteRule   "^/docs/(.+)"  "http://nouveau.example.com/docs/$1"  [R,L]
</highlight>

<highlight language="config">#Avec RedirectMatch
RedirectMatch "^/docs/(.*)" "http://nouveau.example.com/docs/$1"
</highlight>

<highlight language="config">#Avec Redirect
Redirect "/docs/" "http://nouveau.example.com/docs/"
</highlight>
    </dd>
  </dl>

</section>



<section id="static-to-dynamic">

      <title>De statique à dynamique</title>

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment transformer une page statique <code>foo.html</code>
	  en sa variante dynamique <code>foo.cgi</code> de manière
	  transparente, c'est à dire sans en avertir le
	  navigateur/utilisateur.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On réécrit simplement l'URL en script CGI et force le
	  gestionnaire de contenu à <strong>cgi-script</strong> de façon
	  à ce que le script s'exécute en tant que programme CGI.
	  Ainsi, une requête vers <code>/~quux/foo.html</code> conduit
	  en interne à l'invocation de
	  <code>/~quux/foo.cgi</code>.</p>

<highlight language="config">
RewriteEngine  on
RewriteBase    "/~quux/"
RewriteRule    "^foo\.html$"  "foo.cgi"  [H=<strong>cgi-script</strong>]
</highlight>
        </dd>
      </dl>

    </section>

<section id="backward-compatibility">

      <title>Compatibilité ascendante dans le cadre d'une modification
      d'extension de nom de fichier</title>

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment conférer une compatibilité ascendante aux URLs
	  (existant encore virtuellement) après avoir migré
	  <code>document.YYYY</code> vers <code>document.XXXX</code>,
	  c'est à dire après avoir par exemple traduit un lot de
	  fichiers <code>.html</code> en fichiers <code>.php</code>
	  ?</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On réécrit simplement le nom du fichier en son nom
	  de base et vérifie s'il existe aussi avec la nouvelle
	  extension. Si c'est le cas, on utilise ce nom, sinon on
	  réécrit l'URL sous sa forme originale.</p>


<highlight language="config">
#   jeu de règles assurant une compatibilité ascendante en réécrivant<br />
#   document.html en document.php si et seulement si document.php<br />
#   existe
&lt;Directory "/var/www/htdocs"&gt;
    RewriteEngine on
    RewriteBase "/var/www/htdocs"

    RewriteCond "$1.php" -f
    RewriteCond "$1.html" !-f
    RewriteRule "^(.*).html$" "$1.php"
&lt;/Directory&gt;
</highlight>
    </dd>

    <dt>Discussion</dt>
    <dd>
    <p>Cet exemple utilise une fonctionnalité souvent méconnue de
    mod_rewrite, en tirant avantage de l'ordre d'exécution du jeu de
    règles. En particulier, mod_rewrite évalue la partie gauche des
    règles de réécriture avant d'évaluer les directives RewriteCond. En
    conséquence, $1 est déjà défini au moment où les directives
    RewriteCond sont évaluées. Ceci nous permet de tester l'existence du
    fichier original (<code>document.html</code>) et du fichier cible
    (<code>document.php</code>) en utilisant le même nom de base.</p>

    <p>Ce jeu de règles est conçu pour une utilisation dans un contexte
    de répertoire (au sein d'une section &lt;Directory&gt; ou d'un
    fichier .htaccess), de façon à ce que les vérifications
    <code>-f</code> effectuent leurs recherches dans le bon répertoire.
    Vous serez peut-être amené à définir une directive <directive
    module="mod_rewrite">RewriteBase</directive> pour spécifier le
    répertoire de base à partir duquel vous travaillez.</p>
    </dd>
  </dl>

</section>

<section id="canonicalhost">

<title>Noms d'hôtes canoniques</title>

      <dl>
        <dt>Description :</dt>

        <dd>Le but de cette règle est de préférer l'utilisation d'un nom
	d'hôte particulier à d'autres noms d'hôte utilisables
	pour atteindre le même site. Par exemple, si vous voulez
	utiliser <strong>www.example.com</strong> à la place de
	<strong>example.com</strong>, vous pouvez utiliser une solution
	du style :</dd>

        <dt>Solution :</dt>

        <dd>

<p>Pour y parvenir, il vaut mieux se passer de mod_rewrite, et utiliser
plutôt la directive <directive module="mod_alias">Redirect</directive> dans
une section de serveur virtuel pour le/les noms d'hôte non canoniques.</p>

<highlight language="config">
&lt;VirtualHost *:80&gt;
  ServerName undesired.example.com
  ServerAlias example.com notthis.example.com

  Redirect "/" "http://www.example.com/"
&lt;/VirtualHost&gt;

&lt;VirtualHost *:80&gt;
  ServerName www.example.com
&lt;/VirtualHost&gt;
</highlight>

<p>Vous pouvez aussi utiliser la directive <directive module="core"
type="section">If</directive> :</p>

<highlight language="config">
&lt;If "%{HTTP_HOST} != 'www.example.com'"&gt;
	Redirect "/" "http://www.example.com/"
&lt;/If&gt;
</highlight>

<p>Ou, par exemple, pour rediriger une portion de votre site vers HTTPS
:</p>

<highlight language="config">
&lt;If "%{SERVER_PROTOCOL} != 'HTTPS'"&gt;
	Redirect "/admin/" "https://www.example.com/admin/"
&lt;/If&gt;
</highlight>

<p>Si, pour une raison particulière, vous voulez tout de même utiliser
<code>mod_rewrite</code> - dans le cas, par exemple, où vous avez besoin
d'un jeu plus important de règles de réécritures - vous pouvez utiliser
la recette suivante :</p>

<p>Pour les sites écoutant sur un port autre que 80:</p>
<highlight language="config">
RewriteCond "%{HTTP_HOST}"   "!^www\.example\.com" [NC]
RewriteCond "%{HTTP_HOST}"   "!^$"
RewriteCond "%{SERVER_PORT}" "!^80$"
RewriteRule "^/?(.*)"         "http://www.example.com:%{SERVER_PORT}/$1" [L,R,NE]
</highlight>

<p>Et pour un site écoutant sur le port 80</p>
<highlight language="config">
RewriteCond "%{HTTP_HOST}"   "!^www\.example\.com" [NC]
RewriteCond "%{HTTP_HOST}"   "!^$"
RewriteRule "^/?(.*)"         "http://www.example.com/$1" [L,R,NE]
</highlight>
	<p>
	Si vous souhaitez que cette règle s'applique à tous les noms de
	domaine - en d'autres termes, si vous voulez rediriger
	<strong>example.com</strong> vers
	<strong>www.example.com</strong> pour toutes les valeurs
	possibles de <strong>example.com</strong>, vous pouvez utiliser
	le jeu de règles suivants :</p>

<highlight language="config">
RewriteCond "%{HTTP_HOST}" "!^www\." [NC]
RewriteCond "%{HTTP_HOST}" "!^$"
RewriteRule "^/?(.*)" "http://www.%{HTTP_HOST}/$1" [L,R,NE]
</highlight>
	<p>
	Vous pouvez utiliser ce jeu de règles aussi bien dans le fichier
	de configuration de votre serveur principal que dans un fichier
	<code>.htaccess</code> placé dans le répertoire défini par la
	directive <directive
	module="core">DocumentRoot</directive> du serveur.</p>
        </dd>
      </dl>

    </section>

<section id="multipledirs">

  <title>Recherche de pages dans plus d'un répertoire</title>

  <dl>
    <dt>Description:</dt>

    <dd>
      <p>Une ressource peut exister dans plusieurs répertoires, et nous
      voulons rechercher cette ressource dans ces répertoires
      lorsqu'elle fait l'objet d'une requête. Il est possible que nous
      ayons récemment réorganisé la structure de notre site en
      répartissant son contenu dans plusieurs répertoires.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
      <p>Le jeu de règles suivant recherche la ressource dans deux
      répertoires, et s'il ne la trouve dans aucun des deux, il tentera
      simplement de la servir à partir de l'adresse fournie dans la
      requête.</p>

<highlight language="config">
RewriteEngine on

#   on cherche tout d'abord dans dir1/...
#   ... et si on trouve, on est content et on arrête :
RewriteCond         "%{DOCUMENT_ROOT}/<strong>dir1</strong>/%{REQUEST_URI}"  -f
RewriteRule  "^(.+)"  "%{DOCUMENT_ROOT}/<strong>dir1</strong>/$1"  [L]

#   on cherche ensuite dans dir2/...
#   ... et si on trouve, on est content et on arrête :
RewriteCond         "%{DOCUMENT_ROOT}/<strong>dir2</strong>/%{REQUEST_URI}"  -f
RewriteRule  "^(.+)"  "%{DOCUMENT_ROOT}/<strong>dir2</strong>/$1"  [L]

#   sinon, on continue la recherche avec d'autres directives Alias
#   ou ScriptAlias, etc...
RewriteRule   "^"  "-"  [PT]
</highlight>
        </dd>
      </dl>

    </section>

<section id="archive-access-multiplexer">

  <title>Redirection vers des serveurs géographiquement distribués</title>

  <dl>
    <dt>Description :</dt>

    <dd>
    <p>Notre site web possède de nombreux miroirs, et nous voulons
    rediriger les utilisateurs vers celui qui se situe dans le pays où
    ils se trouvent. </p>
    </dd>

    <dt>Solution :</dt>

    <dd>
    <p>En consultant le nom d'hôte du client demandeur, on détermine le
    pays dans lequel il se trouve. S'il est impossible d'effectuer une
    recherche sur leur adresse IP, on se rabat sur un serveur par
    défaut.</p>
    <p>Nous allons utiliser une directive <directive
    module="mod_rewrite">RewriteMap</directive> afin de construire une
    liste des serveurs que nous voulons utiliser.</p>

<highlight language="config">
HostnameLookups on
RewriteEngine on
RewriteMap    multiplex         "txt:/path/to/map.mirrors"
RewriteCond  "%{REMOTE_HOST}"     "([a-z]+)$ [NC]"
RewriteRule   "^/(.*)$"  "${multiplex:<strong>%1</strong>|http://www.example.com/}$1"  [R,L]
</highlight>

<example>
##  liste_miroirs -- Table de correspondance pays - serveurs<br />
<br />
de        http://www.exemple.de/<br />
uk        http://www.exemple.uk/<br />
com       http://www.example.com/<br />
##EOF##
</example>
    </dd>

    <dt>Discussion</dt>
    <dd>
    <note type="warning">Ce jeu de règles nécessite la définition à
    <code>on</code> de la directive <directive
    module="core">HostNameLookups</directive>, ce qui peut induire une
    baisse de performance significative.</note>

    <p>La directive <directive
    module="mod_rewrite">RewriteCond</directive> extrait la dernière
    partie du nom d'hôte du client demandeur - le code du pays - et la
    règle de réécriture qui suit utilise cette valeur pour rechercher le
    serveur miroir approprié dans le fichier de correspondances.</p>
    </dd>
  </dl>

</section>

<section id="browser-dependent-content">

      <title>Contenu dépendant du navigateur</title>

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Nous voulons fournir des contenus différents en fonction du
	  navigateur (user-agent) qui effectue la requête.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Nous devons déterminer quel contenu servir, en nous basant
	  sur l'en-tête HTTP "User-Agent". La
	  configuration suivante effectue ceci : si l'en-tête HTTP
	  "User-Agent" commence par "Mozilla/3", le nom de la page
	  <code>foo.html</code> est réécrit en <code>foo.NS.html</code>
	  et la réécriture s'arrête. Si le navigateur est "Lynx" ou
	  "Mozilla" version 1 ou 2, l'URL devient
	  <code>foo.20.html</code>. Tous les autres navigateurs
	  reçoivent la page <code>foo.32.html</code>. Tout ceci est
	  effectué par le jeu de règles suivant :</p>
<highlight language="config">
RewriteCond "%{HTTP_USER_AGENT}"  "^<strong>Mozilla/3</strong>.*"
RewriteRule "^foo\.html$"         "foo.<strong>NS</strong>.html"          [<strong>L</strong>]

RewriteCond "%{HTTP_USER_AGENT}"  "^Lynx/" [OR]
RewriteCond "%{HTTP_USER_AGENT}"  "^Mozilla/[12]"
RewriteRule "^foo\.html$"         "foo.<strong>20</strong>.html"          [<strong>L</strong>]

RewriteRule "^foo\.html$"         "foo.<strong>32</strong>.html"          [<strong>L</strong>]
</highlight>
        </dd>
      </dl>

    </section>

<section id="canonicalurl">

<title>URLs canoniques</title>

<dl>
 <dt>Description :</dt>

   <dd>
     <p>Sur certains serveurs, une ressource peut posséder plusieurs
     URLs. Il y a en général les URLs canoniques (celles qui sont
     réellement distribuées et utilisées), et celles qui correspondent à
     des raccourcis, les URLs internes, etc... Quelle que soit l'adresse
     que l'utilisateur fournit dans la requête, il devrait finalement
     voir l'URL canonique dans la barre d'adresse de son navigateur.</p>
   </dd>

   <dt>Solution :</dt>

     <dd>
       <p>Nous effectuons une redirection HTTP externe pour toutes les
       URLs non canoniques afin de les corriger dans la barre d'adresse
       du navigateur, et ceci pour toutes les requêtes futures. Dans le
       jeu de règles suivant, nous remplaçons <code>/matous</code> et
       <code>/minettes</code> par le canonique <code>/chats</code>.</p>

	<highlight language="config">RewriteRule   "^/(matous|minettes)/(.*)"    "/chats/$2"  [R]</highlight>
        </dd>

     <dt>Discussion :</dt>
     <dd>On serait mieux inspiré d'utiliser ici les directives Redirect ou
     RedirectMatch :

     <highlight language="config"> RedirectMatch "^/(matous|minettes)/(.*)" "/chats/$2" </highlight>
     </dd>
      </dl>

</section>

<section id="moveddocroot">

  <title>Déplacement du répertoire <code>DocumentRoot</code></title>

  <dl>
    <dt>Description :</dt>

    <dd>
<p>En général, le répertoire <directive
module="core">DocumentRoot</directive> du serveur web correspond à l'URL
"<code>/</code>". Ce répertoire ne contient cependant pas forcément des
ressources de première importance pour l'utilisateur. Par exemple, vous
préférerez peut-être que le répertoire d'accueil d'un visiteur accédant
pour la première fois à votre site soit un répertoire particulier
<code>/a-propos-de/</code>. Pour y parvenir, utilisez le jeu de règles
suivant :</p>
</dd>

    <dt>Solution :</dt>

    <dd>
      <p>On redirige l'URL <code>/</code> vers
      <code>/a-propos-de/</code> :
      </p>

<highlight language="config">
RewriteEngine on
RewriteRule   "^/$"  "/a-propos-de/"  [<strong>R</strong>]
</highlight>

<p>Notez que l'on peut aussi y parvenir en utilisant la directive
<directive module="mod_alias">RedirectMatch</directive> :</p>

<highlight language="config">RedirectMatch "^/$" "http://example.com/a-propos-de/"</highlight>

<p>Notez aussi que cet exemple ne réécrit que l'URL racine. En d'autres
termes, il réécrit une requête pour <code>http://example.com/</code>,
mais pas pour une requête <code>http://example.com/page.html</code>. Si
vous avez effectivement modifié la racine de vos documents - c'est à dire
si <strong>tous</strong> vos contenus se trouvent dans un
sous-répertoire, il est largement préférable de modifier simplement
votre directive <directive module="core">DocumentRoot</directive>, ou de
déplacer l'ensemble du contenu vers le répertoire supérieur, plutôt que
de réécrire les URLs.</p>
</dd>
</dl>

</section>

<section id="fallback-resource">
<title>Ressource par défaut</title>

<dl>
<dt>Description :</dt>
<dd>Vous voulez qu'une seule ressource (disons un certain fichier tel
que index.php) soit servie pour toutes les requêtes à destination d'un
certain répertoire, sauf pour celles qui concernent une ressource
existant effectivement comme une image, ou un fichier css.</dd>

<dt>Solution :</dt>
<dd>
<p>Depuis la version 2.2.16, vous pouvez y parvenir via la directive
<directive module="mod_dir">FallbackResource</directive> :</p>

<highlight language="config">
&lt;Directory "/var/www/my_blog"&gt;
  FallbackResource "index.php"
&lt;/Directory&gt;
</highlight>

<p>Cependant, si vos besoins étaient plus complexes, vous pouviez, dans
les versions plus anciennes d'Apache, utiliser un jeu de règles du style
:</p>

<highlight language="config">
&lt;Directory "/var/www/my_blog"&gt;
  RewriteBase "/my_blog"

  RewriteCond "/var/www/my_blog/%{REQUEST_FILENAME}" !-f
  RewriteCond "/var/www/my_blog/%{REQUEST_FILENAME}" !-d
  RewriteRule "^" "index.php" [PT]
&lt;/Directory&gt;
</highlight>

<p>D'autre part, si vous voulez transmettre l'URI de la requête en tant
que chaîne de paramètres à index.php, vous pouvez remplacer cette règle
de réécriture par :</p>

<highlight language="config">RewriteRule "(.*)" "index.php?$1" [PT,QSA]</highlight>

<p>Notez que l'on peut utiliser ces jeux de règles aussi bien dans un
fichier <code>.htaccess</code> que dans une section
&lt;Directory&gt;.</p>

</dd>

</dl>

</section>

<section id="rewrite-query">
<title>Rewrite query string</title>

<dl>
<dt>Description :</dt>
<dd>Vous voulez extraire une valeur particulière d'une chaîne de
paramètres d'une URL, et soit la remplacer, soit l'incorporer dans un
autre composant de l'URL.</dd>

<dt>Solutions :</dt>
<dd>
<p>Dans la plupart des solutions de cette section, on utilise la même
condition qui stocke la valeur recherchée dans la référence arrière %2.
%1 est le début de la requête, et %3 ce qui reste. Cette condition est
un peu complexe car elle introduit de la flexibilité et évite les
doubles perluettes '&amp;&amp;' dans les substitutions.</p>
<ul>
  <li>Cette solution supprime le couple clé/valeur recherché :

<highlight language="config">
# Remove mykey=???
RewriteCond "%{QUERY_STRING}" "(.*(?:^|&amp;))mykey=([^&amp;]*)&amp;?(.*)&amp;?$"
RewriteRule "(.*)" "$1?%1%3"
</highlight>
  </li>

  <li>Cette solution remplace la partie de l'URL qui suit la valeur
  recherchée par un '?' :

<highlight language="config">
# Copy from query string to PATH_INFO
RewriteCond "%{QUERY_STRING}" "(.*(?:^|&amp;))mykey=([^&amp;]*)&amp;?(.*)&amp;?$"
RewriteRule "(.*)" "$1/products/%2/?" [PT]
</highlight>
  </li>

  <li>Cette solution utilise la valeur recherchée dans une deuxième
  condition ::

<highlight language="config">
# Capture the value of mykey in the query string
RewriteCond "%{QUERY_STRING}" "(.*(?:^|&amp;))mykey=([^&amp;]*)&amp;?(.*)&amp;?$""
RewriteCond "%2" !=not-so-secret-value 
RewriteRule "(.*)" - [F]
</highlight>
  </li>

  <li>Cette solution produit l'effet inverse des précédentes ; elle
  copie des composantes du chemin (peut-être PATH_INFO) depuis l'URL
  vers sa chaîne de paramètres :
<highlight language="config">
# The desired URL might be /products/kitchen-sink, and the script expects 
# /path?products=kitchen-sink.
RewriteRule "^/?path/([^/]+)/([^/]+)" "/path?$1=$2" [PT]
</highlight>
  </li>
</ul>

</dd>

</dl>
</section>

</manualpage>
