<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1874169 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : VIncent Deffontaines -->
<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->
<manualpage metafile="rewritemap.xml.meta">
  <parentdocument href="./">Rewrite</parentdocument>
  <title>Utilisation de RewriteMap</title>
  <summary>

    <p>Ce document est un complément à la <a
    href="../mod/mod_rewrite.html">documentation de référence</a> du
    module <module>mod_rewrite</module>. Il décrit l'utilisation de la
    directive <directive module="mod_rewrite">RewriteMap</directive>, et
    fournit des exemples pour chacun des différents types de
    <directive module="mod_rewrite">RewriteMap</directive>.</p>

    <note type="warning">Notez que la plupart de ces exemples ne
    fonctionneront pas en l'état dans le contexte de votre configuration
    particulière ; vous devez donc vous attacher à les
    comprendre, plutôt que de simplement les insérer dans votre
    configuration par copier/coller.</note>

  </summary>
  <seealso><a href="../mod/mod_rewrite.html">Documentation du module
  mod_rewrite</a></seealso>
  <seealso><a href="intro.html">Introduction à mod_rewrite</a></seealso>
  <seealso><a href="remapping.html">Redirection et remise en
  correspondance</a></seealso>
  <seealso><a href="access.html">Contrôle d'accès</a></seealso>
  <seealso><a href="vhosts.html">Serveurs virtuels</a></seealso>
  <seealso><a href="proxy.html">Mise en cache</a></seealso>
  <seealso><a href="advanced.html">Techniques avancées</a></seealso>
  <seealso><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></seealso>

  <section id="introduction">
    <title>Introduction</title>

   <p>
   La directive <directive module="mod_rewrite">RewriteMap</directive>
   définit une fonction externe qui peut être appelée depuis une
   directive <directive module="mod_rewrite">RewriteRule</directive> ou
   <directive module="mod_rewrite">RewriteCond</directive> pour
   accomplir une réécriture trop compliquée, ou trop spécialisée pour
   être effectuée à partir d'expressions rationnelles. Vous trouverez
   ci-dessous les différents types disponibles pour la source de
   données, ceux-ci étant par ailleurs énumérés dans la documentation de
   référence de <directive module="mod_rewrite">RewriteMap</directive>.</p>

   <p>La syntaxe de la directive <directive module="mod_rewrite">RewriteMap</directive> est la suivante
   :</p>

<highlight language="config">RewriteMap <em>MapName</em> <em>MapType</em>:<em>MapSource</em></highlight>

    <p>L'argument <a id="mapfunc" name="mapfunc"><em>MapName</em></a>
    est un nom arbitraire que vous associez à la table de
    correspondances, et que vous
    pourrez utilisez par la suite dans les directives de réécriture. Les
    recherches dans la table de correspondance s'effectuent en
    respectant cette syntaxe :</p>

    <p class="indent">
      <strong>
        <code>${</code> <em>nom-map</em> <code>:</code>
	<em>clé-recherche</em>
        <code>}</code> <br/> <code>${</code> <em>nom-map</em> <code>:</code>
        <em>clé-recherche</em> <code>|</code> <em>DefaultValue</em> <code>}</code>
      </strong>
    </p>

    <p>Lorsque cette syntaxe est employée, la table de correspondances
    <em>nom-map</em> est consultée et la clé <em>clé-recherche</em>
    recherchée. Si la clé est trouvée, la fonction de recherche dans la
    table de correspondance est remplacée par <em>SubstValue</em>, ou
    par <em>DefaultValue</em> dans le cas contraire, ou par la chaîne
    vide si aucune <em>DefaultValue</em> n'a été spécifiée.</p>

    <p>Par exemple, vous pouvez définir une directive
    <directive module="mod_rewrite">RewriteMap</directive> comme suit :</p>
    <highlight language="config">RewriteMap examplemap "txt:/path/to/file/map.txt"</highlight>
    <p>Vous pourrez par la suite utiliser cette table de correspondances
    dans une directive <directive module="mod_rewrite">RewriteRule</directive> comme suit :</p>
<highlight language="config">RewriteRule "^/ex/(.*)" "${examplemap:$1}"</highlight>

<p>Il est possible de spécifier une valeur par défaut qui sera utilisée
si la recherche dans la table de correspondances est infructueuse :</p>

<highlight language="config">RewriteRule "^/ex/(.*)" "${examplemap:$1|/not_found.html}"</highlight>

<note><title>Contexte de répertoire et fichiers.htaccess</title>
<p>
Vous ne pouvez utiliser la directive <directive module="mod_rewrite">RewriteMap</directive> ni dans
les sections <directive module="core" type="section">Directory</directive>, ni dans les fichiers
<code>.htaccess</code>. Vous devez déclarer la table de correspondances
au niveau du serveur principal ou dans un contexte de serveur virtuel.
En revanche, si vous ne pouvez pas déclarer la table dans une section
&lt;Directory&gt; ou dans un fichier <code>.htaccess</code>, vous
pourrez y faire référence dans ces contextes, une fois cette table
créée.
</p>
</note>

<p>Les sections suivantes décrivent les différents types de tables de
correspondances <em>type-map</em> disponibles, et fournissent des
exemples pour chacun d'entre eux.</p>
  </section>

  <section id="int">
    <title>int: Fonction interne</title>

    <p>Lorsque le type-map <code>int</code> est spécifié, la source est
    une des fonctions RewriteMap internes disponibles. Les développeurs
    de modules peuvent fournir des fonctions internes supplémentaires en
    les enregistrant via l'API <code>ap_register_rewrite_mapfunc</code>.
    Les fonctions fournies par défaut sont :
    </p>

    <ul>
      <li><strong>toupper</strong>:<br/>
             Met tous les caractères de la clé en majuscules.</li>
      <li><strong>tolower</strong>:<br/>
             Met tous les caractères de la clé en minuscules.</li>
      <li><strong>escape</strong>:<br/>
             Protège les caractères spéciaux de la clé en les
	     transformant en leur code hexadécimal.</li>
      <li><strong>unescape</strong>:<br/>
             Retraduit les codes hexadécimaux de la clé en caractères
	     spéciaux.</li>
    </ul>

    <p>
    Pour utiliser une de ces fonctions, créez une
    <code>RewriteMap</code> faisant référence à cette fonction int, et
    utilisez-la dans votre règle <code>RewriteRule</code> :
    </p>

    <p> <strong>Redirige un URI vers son équivalent en minuscules</strong></p>
    <highlight language="config">
RewriteMap lc int:tolower
RewriteRule "(.*)" "${lc:$1}" [R]
    </highlight>

    <note>
    <p>Notez que cet exemple n'est fourni qu'à titre d'illustration,
    et ne constitue en aucun cas une recommandation. Si vous voulez
    rendre des URLs insensibles à la casse, vous devez plutôt vous
    tourner vers <module>mod_speling</module>.
    </p>
    </note>

  </section>

  <section id="txt">
    <title>txt: tables de correspondances au format texte</title>

    <p>Lorsqu'un type-map <code>txt</code> est utilisé, la source-map
    est un chemin du système de fichiers vers un fichier de
    correspondances au format texte, contenant sur chaque ligne une
    paire clé/valeur séparées par un espace. Il est possible d'insérer
    des commentaires sous la forme de chaînes commençant par le caractère
    '#'.</p>

    <p>Voici un exemple d'entrées valides dans un fichier de
    correspondances :</p>

    <example>
      # Ligne de commentaires<br />
      <strong><em>clé</em> <em>valeur-substitution</em></strong><br />
      <strong><em>clé</em> <em>valeur-substitution</em></strong> # commentaire<br />
    </example>

    <p>Lorsque la table de correspondance fait l'objet d'une recherche,
    la valeur spécifiée est recherchée dans le premier champ, et si elle
    est trouvée, la valeur de substitution est renvoyée.</p>

    <p>Par exemple, nous pourrions utiliser un fichier de
    correspondances pour traduire des noms de produits en identifiants
    produits pour obtenir des URLs plus simples à mémoriser, en
    utilisant la recette suivante :</p>

    <p><strong>Product to ID configuration</strong></p>
    <highlight language="config">
RewriteMap product2id "txt:/etc/apache2/productmap.txt"
RewriteRule "^/product/(.*)" "/prods.php?id=${product2id:$1|NOTFOUND}" [PT]
    </highlight>

    <p>Nous supposons ici que le script <code>prods.php</code> sait quoi
    faire lorsqu'il reçoit un argument <code>id=NOTFOUND</code>, dans
    le cas où le produit ne se trouve pas dans la table de
    correspondances.</p>

    <p>Le fichier <code>/etc/apache2/map-produit.txt</code> contient ce
    qui suit :</p>

    <example><title>Fichier de correspondances Produit - Identifiant</title>
##<br />
##  map-produit.txt - Fichier de correspondances Produit - Identifiant<br />
##<br />
<br />
TELEVISION 993<br />
STEREO     198<br />
CANNE-A-PECHE 043<br />
BALLON-BASKET 418<br />
TELEPHONE  328
    </example>

    <p>Ainsi, lorsqu'une requête pour
    <code>http://example.com/produit/TELEVISION</code> arrive, la directive
    <directive module="mod_rewrite">RewriteRule</directive> s'applique, et la
    requête est transformée en interne en <code>/prods.php?id=993</code>.</p>

    <note><title>Note: fichiers .htaccess</title>
    L'exemple donné est conçu pour être utilisé dans un contexte de
    serveur principal ou de serveur virtuel. Si vous voulez l'utiliser
    dans un fichier <code>.htaccess</code>, vous devrez supprimer le
    slash de début dans le modèle de réécriture afin que ce dernier
    puisse correspondre à toute URL :
    <highlight language="config">RewriteRule "^product/(.*)" "/prods.php?id=${product2id:$1|NOTFOUND}" [PT]</highlight>
    </note>

    <note><title>Recherches mises en cache</title>
    <p>
    Les clés de recherche sont mises en cache par httpd jusqu'à ce que
    le <code>mtime</code> (date de modification) du fichier de
    correspondances soit modifié, ou que le serveur httpd soit
    redémarré, ce qui améliore les performances pour les tables de
    correspondances consultées par de nombreuses requêtes.
    </p>
    </note>

  </section>
  <section id="rnd">
    <title>rnd: Fichier texte à valeurs de substitution multiples
    choisies de manière aléatoire</title>

    <p>Lorsque le type-map spécifié est <code>rnd</code>, la source est
    un chemin du système de fichiers vers un fichier de correspondances
    au format texte dont chaque ligne contient une clé, et une ou
    plusieurs valeurs séparées par le caractère <code>|</code>. Si une
    clé convient, une des valeurs correspondantes sera choisie de
    manière aléatoire.</p>

    <p>Par exemple, vous pouvez utiliser le fichier de correspondances
    et les directives suivants pour implémenter une répartition de
    charge aléatoire entre plusieurs serveurs d'arrière-plan, par
    l'intermédiaire d'un mandataire inverse. Les images sont envoyées
    vers un des serveurs de l'ensemble 'statique', tandis que tout le
    reste est envoyé vers un des serveurs de l'ensemble 'dynamique'.</p>

    <example><title>Fichier de correspondances</title>
##<br />
##  map.txt -- table de réécriture<br />
##<br />
<br />
statique   www1|www2|www3|www4<br />
dynamique  www5|www6
    </example>
<p><strong>Directives de configuration</strong></p>
    <highlight language="config">
RewriteMap servers "rnd:/path/to/file/map.txt"

RewriteRule "^/(.*\.(png|gif|jpg))" "http://${servers:static}/$1" [NC,P,L]
RewriteRule "^/(.*)"                "http://${servers:dynamic}/$1" [P,L]
    </highlight>


    <p>Ainsi, lorsqu'une image est demandée et que la première règle
    convient, <directive module="mod_rewrite">RewriteMap</directive> recherche la chaîne
    <code>statique</code> dans le fichier de correspondances qui
    renvoie un des noms de serveurs spécifiés de manière aléatoire,
    ce dernier étant utilisé dans la cible de la règle
    <directive module="mod_rewrite">RewriteRule</directive>.</p>

    <p>Si vous voulez qu'un des serveurs soit plus souvent sollicité que
    les autres (par exemple s'il possède plus de mémoire, et peut donc
    traiter d'avantage de requêtes), spécifiez-le plusieurs fois dans la
    liste des serveurs.</p>

    <example>
statique   www1|www1|www2|www3|www4
    </example>

  </section>

  <section id="dbm">
    <title>dbm: Fichier condensé DBM</title>

    <p>Lorsque le type-map <code>dbm</code> est utilisé, la source est
    un chemin du système de fichiers vers un fichier de données DBM
    contenant des paires clé/valeur permettant d'effectuer la
    correspondance. Le fonctionnement est identique à celui du type-map
    <code>txt</code>, mais beaucoup plus rapide car un fichier DBM est
    indexé, alors qu'un fichier texte ne l'est pas. L'accès à la clé
    recherchée est donc plus rapide.</p>

    <p>Vous pouvez éventuellement spécifier un type dbm particulier :</p>

 <highlight language="config">
RewriteMap examplemap "dbm=sdbm:/etc/apache/mapfile.dbm"
 </highlight>

    <p>Ce type peut être choisi parmi <code>sdbm</code>, <code>gdbm</code>,
    <code>ndbm</code> ou <code>db</code>. Il est
    cependant recommandé d'utiliser l'utilitaire <a
    href="../programs/httxt2dbm.html">httxt2dbm</a> fourni avec le
    serveur HTTP Apache, car il utilise la bibliothèque DBM appropriée,
    à savoir celle qui a été utilisée lors de la compilation de httpd.</p>

    <p>Pour créer un fichier dbm, créez tout d'abord un fichier de
    correspondances au format texte comme décrit dans la section <a
    href="#txt">txt</a>. Traitez ensuite ce fichier avec
    <code>httxt2dbm</code> :</p>

<example>
$ httxt2dbm -i fichier-map.txt -o fichier-map.map
</example>

<p>Vous pouvez alors faire référence au fichier obtenu dans votre
directive <directive module="mod_rewrite">RewriteMap</directive> :</p>
<highlight language="config">
RewriteMap mapname "dbm:/etc/apache/mapfile.map"
</highlight>

<note>
<p>Notez qu'avec certains types dbm, plusieurs fichiers possédant le
même nom de base sont créés. Par exemple, vous pouvez obtenir deux
fichiers nommés <code>fichier-map.map.dir</code> et
<code>fichier-map.map.pag</code>. Ceci est tout à fait normal, et vous
ne devez utiliser que le nom de base <code>fichier-map.map</code> dans votre
directive <directive module="mod_rewrite">RewriteMap</directive>.</p>
</note>

<note><title>Mise en cache des recherches</title>
<p>
    Les clés de recherche sont mises en cache par httpd jusqu'à ce que
    le <code>mtime</code> (date de modification) du fichier de
    correspondances soit modifié, ou que le serveur httpd soit
    redémarré, ce qui améliore les performances pour les tables de
    correspondances consultées par de nombreuses requêtes.
</p>
</note>

  </section>

  <section id="prg"><title>prg: Programme de réécriture externe</title>

    <p>Lorque le type-map <code>prg</code> est spécifié, la source est
    un chemin du système de fichiers vers un programme exécutable
    destiné à effectuer la mise en correspondance. Il peut s'agir d'un
    fichier binaire compilé, ou d'un programme en langage interprété
    comme Perl ou Python.</p>

    <p>Ce programme est lancé une fois au démarrage du serveur HTTP
    Apache, puis communique avec le moteur de réécriture via
    <code>STDIN</code> et <code>STDOUT</code>. En d'autres termes, pour
    chaque recherche de correspondance, il reçoit un argument via
    <code>STDIN</code>, et doit renvoyer en guise de réponse une chaîne
    terminée par un caractère nouvelle-ligne sur <code>STDOUT</code>. Si
    la recherche de correspondance est infructueuse, le programme doit
    l'indiquer en retournant la chaîne de quatre caractères
    "<code>NULL</code>".</p>

    <p>Les programmes de réécriture externes ne sont pas lancés s'il
    n'ont pas été définis dans un contexte où la directive <directive
    module="mod_rewrite">RewriteEngine</directive> est définie à
    <code>on</code>.</p>

    <p>Par défaut, les programmes de réécriture externes sont lancés par
    l'utilisateur/groupe qui a démarré httpd. Pour changer ce comportement, il
    est possible sur les systèmes de style Unix de spécifier un autre couple
    utilisateur/groupe via le troisième argument de la directive <directive
    module="mod_rewrite">RewriteMap</directive>, et ceci au format
    <code>utilisateur:groupe</code>.</p>

    <p>Cette fonctionnalité utilise le mutex <code>rewrite-map</code>
    nécessaire à la fiabilité des communications avec le programme. Le
    mécanisme de mutex et le fichier verrou peuvent être définis via la
    directive <directive module="core">Mutex</directive>.</p>

    <p>Voici un exemple simple qui remplace tous les tirets par des
    caractères de soulignement dans l'URI de la requête.</p>

    <p><strong>Configuration de la réécriture</strong></p>
    <highlight language="config">

RewriteMap d2u "prg:/www/bin/dash2under.pl" apache:apache
RewriteRule "-" "${d2u:%{REQUEST_URI}}"
    </highlight>

    <p><strong>dash2under.pl</strong></p>
    <highlight language="perl">
    #!/usr/bin/perl
    $| = 1; # Turn off I/O buffering
    while (&lt;STDIN&gt;) {
        s/-/_/g; # Remplace tous les tirets par des caractères de soulignement
        print $_;
    }
    </highlight>

<note><title>Mises en garde !</title>
<ul>
<li>Votre programme doit être le plus
simple possible. Si le programme se bloque, httpd va attendre
indéfiniment une réponse de sa part, et par conséquent ne répondra plus
aux requêtes.</li>
<li>Assurez-vous de bien désactiver la mise en tampon dans votre
programme. En Perl, ceci est effectué à la seconde ligne du script de
l'exemple - <code>$| = 1;</code> - La syntaxe sera bien entendu
différente dans
d'autres langages. Si les entrées/sorties sont mises en tampon, httpd va
attendre une sortie, et va par conséquent se bloquer.</li>
<li>Rappelez-vous qu'il n'existe qu'une copie du programme lancé au
démarrage du serveur, et que toutes les requêtes vont devoir passer par
ce goulot d'étranglement. Ceci peut provoquer des ralentissements
significatifs si de nombreuses requêtes doivent être traitées, ou si le
script lui-même est très lent.</li>
</ul>
</note>

</section>


  <section id="dbd">
    <title>dbd ou fastdbd: requête SQL</title>

    <p>Lorsque le type-map <code>dbd</code> ou <code>fastdbd</code> est
    spécifié, la source est une requête SQL SELECT qui reçoit un
    argument et renvoie une seule valeur.</p>

    <p>Pour que cette requête puisse être exécutée,
    <module>mod_dbd</module> doit être configuré pour attaquer la base
    de données concernée.</p>

    <p>Ce type-map existe sous deux formes. Avec le type-map
    <code>dbd</code>, la requête est exécutée à chaque demande, tandis
    qu'avec le type-map <code>fastdbd</code>, les recherches dans la
    base de données sont mises en cache en interne. <code>fastdbd</code>
    est donc plus efficace et donc plus rapide ; par contre, il ne
    tiendra pas compte des modifications apportées à la base de données
    jusqu'à ce que le serveur soit redémarré.</p>

    <p>Si une requête renvoie plusieurs enregistrements, un de ceux-ci
    sera sélectionné aléatoirement.</p>

    <example><title>Exemple</title>
    <highlight language="config">
RewriteMap ma-requete "fastdbd:SELECT destination FROM rewrite WHERE source = %s"
    </highlight>
    </example>

    <note><title>Note</title>
    <p>Le nom de la requête est transmis au pilote de base de données en tant
    que label pour une requête SQL préparée, et doit donc respecter toutes les
    règles imposées par votre base de données (comme la sensibilité à la casse).</p></note>

  </section>
  <section id="summary">
    <title>Résumé</title>

    <p>La directive <directive module="mod_rewrite">RewriteMap</directive> peut apparaître
    plusieurs fois. Utilisez une directive
    <directive module="mod_rewrite">RewriteMap</directive> pour chaque fonction de mise en
    correspondance pour déclarer son fichier de correspondances.</p>

    <p>Bien que l'on ne puisse pas <strong>déclarer</strong> de fonction
    de mise en correspondance dans un contexte de répertoire (fichier
    <code>.htaccess</code> ou section <directive module="core"
    type="section">Directory</directive>), il est
    possible d'utiliser cette fonction dans un tel contexte.</p>

  </section>
</manualpage>
