<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- English Revision: 1874169 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="suexec.xml.meta">

  <title>Support suEXEC</title>

  <summary>
    <p>La fonctionnalité <strong>suEXEC</strong> permet
    l'exécution des programmes <strong>CGI</strong> et
    <strong>SSI</strong> sous un utilisateur autre que celui sous
    lequel s'exécute le serveur web qui appelle ces programmes.
    Normalement, lorsqu'un programme CGI ou SSI est lancé, il
    s'exécute sous le même utilisateur que celui du serveur web qui
    l'appelle.</p>

    <p>Utilisée de manière appropriée, cette fonctionnalité peut
    réduire considérablement les risques de sécurité encourus
    lorsqu'on autorise les utilisateurs à développer et faire
    s'exécuter des programmes CGI ou SSI de leur cru. Cependant, mal
    configuré, suEXEC peut causer de nombreux problèmes et même créer
    de nouvelles failles dans la sécurité de votre ordinateur. Si
    vous n'êtes pas familier avec la gestion des programmes
    <em>setuid root</em> et les risques de sécurité qu'ils comportent,
    nous vous recommandons vivement de ne pas tenter
    d'utiliser suEXEC.</p>
  </summary>

<section id="before"><title>Avant de commencer</title>

    <p>Avant de foncer tête baissée dans la lecture de ce document,
    vous devez tenir compte de certaines hypothèses concernant vous-même
    et l'environnement dans lequel vous allez utiliser suexec.</p>

    <p>Premièrement, vous devez utiliser un système d'exploitation
    UNIX ou dérivé, capable d'effectuer des opérations
    <strong>setuid</strong> et <strong>setgid</strong>. Tous les
    exemples de commande sont donnés en conséquence. D'autres
    plates-formes, même si elles supportent suEXEC, peuvent
    avoir une configuration différente.</p>

    <p>Deuxièmement, vous devez être familier avec les concepts de base
    relatifs à la sécurité de votre ordinateur et son administration.
    Ceci implique la compréhension des opérations
    <strong>setuid/setgid</strong> et des différents effets qu'elles
    peuvent produire sur votre système et son niveau de sécurité.</p>

    <p>Troisièmement, vous devez utiliser une version
    <strong>non modifiée</strong> du code de suEXEC. L'ensemble du
    code de suEXEC a été scruté et testé avec soin par les développeurs
    et de nombreux bêta testeurs. Toutes les précautions ont été prises
    pour s'assurer d'une base sûre de code non seulement simple, mais
    aussi solide. La modification de ce code peut causer des problèmes
    inattendus et de nouveaux risques de sécurité. Il est
    <strong>vivement</strong> recommandé de ne pas modifier le code de
    suEXEC, à moins que vous ne soyez un programmeur spécialiste des
    particularités liées à la sécurité, et souhaitez partager votre
    travail avec l'équipe de développement du serveur HTTP Apache afin
    de pouvoir en discuter.</p>

    <p>Quatrièmement et dernièrement, l'équipe de développement du
    serveur HTTP Apache a décidé de ne
    <strong>PAS</strong> inclure suEXEC dans l'installation par défaut
    d'Apache httpd. Pour pouvoir mettre en oeuvre suEXEC, l'administrateur
    doit porter la plus grande attention aux détails. Après avoir bien
    réfléchi aux différents points de la configuration de suEXEC,
    l'administrateur peut l'installer selon les méthodes classiques.
    Les valeurs des paramètres de configuration doivent être
    déterminées et spécifiées avec soin par l'administrateur, afin de
    maintenir la sécurité du système de manière appropriée lors de
    l'utilisation de la fonctionnalité suEXEC. C'est par le biais de
    ce processus minutieux que nous espérons réserver
    l'installation de suEXEC aux administrateurs prudents et
    suffisamment déterminés à vouloir l'utiliser.</p>

    <p>Vous êtes encore avec nous ? Oui ? Bien.
    Alors nous pouvons continuer !</p>
</section>

<section id="model"><title>Modèle de sécurité de suEXEC</title>

    <p>Avant d'installer et configurer suEXEC, nous allons tout d'abord
    décrire le modèle de sécurité que vous êtes sur le point
    d'implémenter. Vous devriez ainsi mieux comprendre ce qui se passe
    vraiment à l'intérieur de suEXEC et quelles précautions ont été
    prises pour préserver la sécurité de votre système.</p>

    <p><strong>suEXEC</strong> est basé sur un programme "conteneur"
    (wrapper) setuid qui est appelé par le serveur HTTP Apache principal.
    Ce conteneur est appelé quand une requête HTTP concerne
    un programme CGI ou SSI que l'administrateur
    a décidé de faire s'exécuter
    sous un utilisateur autre que celui du serveur principal.
    Lorsqu'il reçoit une telle requête, Apache httpd fournit au conteneur
    suEXEC le nom du programme, ainsi que les identifiants utilisateur
    et groupe sous lesquels le programme doit s'exécuter.</p>

    <p>Le conteneur effectue ensuite les vérifications suivantes afin
    de déterminer la réussite ou l'échec du processus -- si une seule
    de ces conditions n'est pas vérifiée, le programme journalise
    l'erreur et se termine en retournant un code d'erreur, sinon il
    continue :</p>

    <ol>
      <li>
        <strong>L'utilisateur qui exécute le conteneur est-il un
	utilisateur valide de ce système ?</strong>

        <p class="indent">
          Ceci permet de s'assurer que l'utilisateur qui exécute le
	  conteneur est vraiment un utilisateur appartenant au système.
        </p>
     </li>

     <li>
        <strong>Le conteneur a-t-il été appelé avec un nombre
	d'arguments correct ?</strong>

        <p class="indent">
          Le conteneur ne s'exécutera que si on lui fournit un nombre
	  d'arguments correct. Le serveur HTTP apache sait quel est le
	  bon format des arguments. Si le conteneur ne reçoit pas un
	  nombre d'arguments correct, soit il a été modifié,
	  soit quelque chose ne va pas dans la portion suEXEC de
	  votre binaire Apache httpd.
        </p>
      </li>

      <li>
        <strong>Cet utilisateur valide est-il autorisé à exécuter le
	conteneur ?</strong>

        <p class="indent">
          Cet utilisateur est-il celui autorisé à exécuter le
	  conteneur ? Un seul utilisateur (celui d'Apache) est
	  autorisé à exécuter ce programme.
        </p>
      </li>

      <li>
        <strong>Le chemin du programme CGI ou SSI cible est-il
	non sûr ?</strong>

        <p class="indent">
          Le chemin du programme CGI ou SSI cible débute-t-il par un
	  '/' ou contient-il une référence arrière '..' ? Ceci est
	  interdit ; le programme CGI ou SSI cible doit se trouver dans
	  la hiérarchie de la racine des documents de suEXEC (voir
	  <code>--with-suexec-docroot=<em>DIR</em></code> ci-dessous).
        </p>
      </li>

      <li>
        <strong>Le nom utilisateur cible est-il valide ?</strong>

        <p class="indent">
          L'utilisateur cible existe-t-il ?
        </p>
      </li>

      <li>
        <strong>Le nom du groupe cible est-il valide ?</strong>

        <p class="indent">
          Le groupe cible existe-t-il ?
        </p>
      </li>

      <li>
        <strong>L'utilisateur cible n'est-il <em>PAS</em>
	superutilisateur ?</strong>


        <p class="indent">
          suEXEc ne permet pas à
	  <code><em>root</em></code> d'exécuter des programmes CGI/SSI.
        </p>
      </li>

      <li>
        <strong>Le numéro de l'identifiant de l'utilisateur cible
	est-il <em>SUPERIEUR</em> au numéro d'identifiant
	minimum ?</strong>

        <p class="indent">
          Le numéro d'identifiant utilisateur minimum est défini à
	  l'exécution du script configure. Ceci vous permet de définir
	  le numéro d'identifiant utilisateur le plus bas qui sera
	  autorisé à éxécuter des programmes CGI/SSI. En particulier,
	  cela permet d'écarter les comptes système.
        </p>
      </li>

      <li>
        <strong>Le groupe cible n'est-il <em>PAS</em> le groupe
	superutilisateur ?</strong>

        <p class="indent">
          Actuellement, suEXEC ne permet pas au groupe
	  <code><em>root</em></code> d'exécuter des programmes CGI/SSI.
        </p>
      </li>

      <li>
        <strong> Le numéro d'identifiant du groupe cible est-il
	<em>SUPERIEUR</em> au numéro d'identifiant minimum ?</strong>

        <p class="indent">
          Le numéro d'identifiant de groupe minimum est spécifié lors
	  de l'exécution du script configure. Ceci vous permet de
	  définir l'identifiant de groupe le plus bas possible qui sera
	  autorisé à exécuter des programmes CGI/SSI, et est
	  particulièrement utile pour écarter les groupes "système".
        </p>
      </li>

      <li>
        <strong>Le conteneur peut-il obtenir avec succès l'identité
	des utilisateur et groupe cibles ?</strong>

        <p class="indent">
          C'est ici que le programme obtient l'identité des utilisateur
	  et groupe cibles via des appels à setuid et setgid. De même,
	  la liste des accès groupe est initialisée avec tous les
	  groupes auxquels l'utilisateur cible appartient.
        </p>
      </li>

      <li>
        <strong>Peut-on se positionner dans le répertoire dans dequel
	sont situés les programmes CGI/SSI ?</strong>

        <p class="indent">
          S'il n'existe pas, il ne peut pas contenir de fichier. Et si
	  l'on ne peut pas s'y positionner, il n'existe probablement
	  pas.
        </p>
      </li>

      <li>
        <strong>Le répertoire est-il dans l'espace web
	de httpd ?</strong>

        <p class="indent">
          Si la requête concerne une portion de la racine du serveur,
	  le répertoire demandé est-il dans la hiérarchie de la racine
	  des documents de suEXEC ? Si la requête concerne un
	 <directive module="mod_userdir"
          >UserDir</directive>, le répertoire demandé est-il dans
	  la hiérarchie du répertoire défini comme le répertoire
	  utilisateur de suEXEC (voir les
	  <a href="#install">options de configuration de suEXEC</a>) ?
        </p>
      </li>

      <li>
        <strong>L'écriture dans le répertoire est-elle interdite pour
	un utilisateur autre que le propriétaire </strong>

        <p class="indent">
          Le répertoire ne doit pas être ouvert aux autres
	  utilisateurs ; seul l'utilisateur propriétaire doit pouvoir
	  modifier le contenu du répertoire.
        </p>
      </li>

      <li>
        <strong>Le programme CGI/SSI cible existe-t-il ?</strong>

        <p class="indent">
          S'il n'existe pas, il ne peut pas être exécuté.
        </p>
      </li>

      <li>
        <strong>Les utilisateurs autres que le propriétaire n'ont-ils
	<em>PAS</em> de droits en écriture sur le programme
	CGI/SSI ?</strong>

        <p class="indent">
          Les utilisateurs autres que le propriétaire ne doivent pas
	  pouvoir modifier le programme CGI/SSI.
        </p>
      </li>

      <li>
        <strong>Le programme CGI/SSI n'est-il <em>PAS</em> setuid ou
	setgid ?</strong>

        <p class="indent">
          Les programmes cibles ne doivent pas pouvoir modifier à
	  nouveau les identifiants utilisateur/groupe.
        </p>
      </li>

      <li>
        <strong>Le couple utilisateur/groupe cible est-il le même que
	celui du programme ?</strong>

        <p class="indent">
          L'utilisateur est-il le propriétaire du fichier ?
        </p>
      </li>

      <li>
        <strong>Peut-on nettoyer avec succès l'environnement des
	processus afin de garantir la sûreté des opérations ?</strong>

        <p class="indent">
          suExec nettoie l'environnement des processus en établissant
	  un chemin d'exécution sûr (défini lors de la configuration),
	  et en ne passant que les variables dont les noms font partie
	  de la liste de l'environnement sûr (créée de même lors de la
	  configuration).
        </p>
      </li>

      <li>
        <strong>Le conteneur peut-il avec succès se substituer au
	programme CGI/SSI cible et s'exécuter ?</strong>

        <p class="indent">
          C'est là où l'exécution de suEXEC s'arrête et où commence
	  celle du programme CGI/ssi cible.
        </p>
      </li>
    </ol>

    <p>Ce sont les opérations standards effectuées par le modèle de
    sécurité du conteneur suEXEC. Il peut paraître strict et est
    susceptible d'imposer de nouvelles limitations et orientations
    dans la conception des programmes CGI/SSI, mais il a été développé
    avec le plus grand soin, étape par étape, en se focalisant sur
    la sécurité.</p>

    <p>Pour plus d'informations sur la mesure dans laquelle ce modèle
    de sécurité peut limiter vos possibilités au regard de la
    configuration du serveur, ainsi que les risques de sécurité qui
    peuvent être évités grâce à une configuration appropriée de suEXEC,
    se référer à la section <a
    href="#jabberwock">"Avis à la population !"</a> de ce document.</p>
</section>

<section id="install"><title>Configurer et installer suEXEC</title>

    <p>C'est ici que nous entrons dans le vif du sujet.</p>

    <p><strong>Options de configuration de suEXEC</strong><br />
    </p>

    <dl>
      <dt><code>--enable-suexec</code></dt>

      <dd>Cette option active la fonctionnalité suEXEC qui n'est
      jamais installée ou activée par défaut. Au moins une option
      <code>--with-suexec-xxxxx</code> doit accompagner l'option
      <code>--enable-suexec</code> pour qu'APACI (l'utilitaire de
      configuration de la compilation d'Apache) accepte votre demande
      d'utilisation de la fonctionnalité suEXEC.</dd>

      <dt><code>--with-suexec-bin=<em>PATH</em></code></dt>

      <dd>Le chemin du binaire <code>suexec</code> doit être codé en
      dur dans le serveur pour des raisons de sécurité. Cette option
      vous permet de modifier le chemin par défaut.
      <em>Par exemple</em>
      <code>--with-suexec-bin=/usr/sbin/suexec</code></dd>

      <dt><code>--with-suexec-caller=<em>UID</em></code></dt>

      <dd>L'<a href="mod/mpm_common.html#user">utilisateur</a> sous
      lequel httpd s'exécute habituellement. C'est le seul utilisateur
      autorisé à exécuter le wrapper suEXEC.</dd>

      <dt><code>--with-suexec-userdir=<em>DIR</em></code></dt>

      <dd>Cette option définit le sous-répertoire de la hiérarchie des
      répertoires utilisateurs dans lequel l'utilisation
      de suEXEC sera autorisée. Tous les exécutables situés dans ce
      répertoire seront exécutables par suEXEC sous l'utilisateur
      cible ; ces programmes doivent donc être sûrs. Si vous utilisez
      une directive <directive module="mod_userdir">UserDir</directive>
      "simple" (c'est à dire ne contenant pas de
      "*"), l'option --with-suexec-userdir
      devra contenir la même valeur. SuEXEC ne fonctionnera pas
      correctement si la directive <directive
      module="mod_userdir">UserDir</directive> contient une valeur
      différente du répertoire home de l'utilisateur tel qu'il est
      défini dans le fichier <code>passwd</code>. la valeur par défaut
      est "<code>public_html</code>".<br />
      Si vous avez plusieurs hôtes virtuels avec une directive
      <directive module="mod_userdir">UserDir</directive> différente
      pour chacun d'entre eux, vous devrez faire en sorte que chaque
      UserDir possède un répertoire parent commun ; donnez alors à
      l'option --with-suexec-userdir le nom
      de ce répertoire commun. <strong>Si tout ceci n'est pas défini
      correctement, les requêtes CGI "~userdir" ne fonctionneront
      pas !</strong></dd>

      <dt><code>--with-suexec-docroot=<em>DIR</em></code></dt>

      <dd>Cette option fonctionne comme la directive DocumentRoot pour
      httpd. Il s'agit de la seule hiérarchie (en dehors des directives
      <directive module="mod_userdir"
      >UserDir</directive>) dans laquelle la fonctionnalité suEXEC
      pourra être utilisée. La valeur par défaut est la valeur de
      <code>--datadir</code> accompagnée du suffixe
      "<code>/htdocs</code>" ;
      <em>Par exemple</em>, si vous exécutez configure avec
      "<code>--datadir=/home/apache</code>", la valeur
      "<code>/home/apache/htdocs</code>" sera utilisée par défaut comme
      racine des documents pour le conteneur suEXEC.</dd>

      <dt><code>--with-suexec-uidmin=<em>UID</em></code></dt>

      <dd>Cette option définit l'identifiant utilisateur le plus bas
      avec lequel un utilisateur pourra être la cible de
      suEXEC. 500 ou 100 sont des valeurs courantes sur la plupart des
      systèmes. la valeur par défaut est 100.</dd>

      <dt><code>--with-suexec-gidmin=<em>GID</em></code></dt>

      <dd>Cette option définit l'identifiant de groupe le plus bas
      avec lequel un utilisateur pourra être la cible de
      suEXEC. 100 est une valeur courante sur la plupart des
      systèmes et est par conséquent la valeur par défaut.</dd>

      <dt><code>--with-suexec-logfile=<em>FILE</em></code></dt>

      <dd>Cette option permet de définir le fichier dans lequel
      toutes les transactions et erreurs de suEXEC seront journalisées
      (à des fins d'analyse ou de débogage). Par défaut, le fichier
      journal se nomme "<code>suexec_log</code>" et se trouve dans votre
      répertoire standard des fichiers journaux défini par
      <code>--logfiledir</code></dd>

      <dt><code>--with-suexec-safepath=<em>PATH</em></code></dt>

      <dd>Cette option permet de définir une variable d'environnement
      PATH sûre à passer aux exécutables CGI. La valeur par défaut
      est "<code>/usr/local/bin:/usr/bin:/bin</code>".</dd>
    </dl>

    <section>
      <title>Compilation et installation du conteneur suEXEC</title>

    <p>Si vous avez activé la fonctionnalité suEXEC à l'aide de
     l'option <code>--enable-suexec</code>, le binaire
     <code>suexec</code> sera automatiquement construit (en même temps
     que httpd) lorsque vous exécuterez la commande
     <code>make</code>.</p>

     <p>Lorsque tous les composants auront été construits, vous pourrez
     exécuter la commande <code>make install</code> afin de les
     installer. Le binaire <code>suexec</code> sera installé dans le
     répertoire défini à l'aide de l'option <code>--sbindir</code>. La
     localisation par défaut est "/usr/local/apache2/bin/suexec".</p>
     <p>Veuillez noter que vous aurez besoin des
     <strong><em>privilèges root</em></strong> pour passer l'étape de
     l'installation. Pour que le conteneur puisse changer
     l'identifiant utilisateur, il doit avoir comme propriétaire
     <code><em>root</em></code>, et les droits du fichier doivent
     inclure le bit d'exécution setuserid.</p>
   </section>

   <section>
	<title>>Mise en place de permissions pour
    paranoïaque</title>
    <p>Bien que le conteneur suEXEC vérifie que l'utilisateur qui
    l'appelle correspond bien à l'utilisateur spécifié à l'aide de
    l'option <code>--with-suexec-caller</code> du programme
    <program>configure</program>, il subsiste toujours le risque qu'un
    appel système ou une bibliothèque fasse appel à suEXEC avant que
    cette vérification ne soit exploitable sur votre système. Pour
    tenir compte de ceci, et parce que c'est en général la meilleure
    pratique, vous devez utiliser les permissions du système de
    fichiers afin de vous assurer que seul le groupe sous lequel
    s'exécute httpd puisse faire appel à suEXEC.</p>

    <p>Si, par exemple, votre serveur web est configuré pour
    s'exécuter en tant que :</p>

<highlight language="config">
User www
Group webgroup
      </highlight>

    <p>et <program>suexec</program> se trouve à
    "/usr/local/apache2/bin/suexec", vous devez exécuter les
    commandes</p>

<example>
    chgrp webgroup /usr/local/apache2/bin/suexec<br />
    chmod 4750 /usr/local/apache2/bin/suexec<br />
</example>

    <p>Ceci permet de s'assurer que seul le groupe sous lequel httpd
    s'exécute (ici webgroup) puisse faire appel au conteneur
    suEXEC.</p>
  </section>
</section>

<section id="enable"><title>Activation et désactivation
de suEXEC</title>

    <p>Au démarrage, httpd vérifie la présence du fichier
    <program>suexec</program> dans le répertoire défini par
    l'option <code>--sbindir</code> du script configure (le
    répertoire par défaut est "/usr/local/apache/sbin/suexec"). Si
    httpd trouve un conteneur suEXEC correctement configuré, il
    enregistrera le message suivant dans le journal des erreurs :</p>

<example>
    [notice] suEXEC mechanism enabled (wrapper: <var>/path/to/suexec</var>)
</example>

    <p>Si ce message n'est pas généré au démarrage du serveur, ce
    dernier ne trouve probablement pas le programme conteneur à
    l'endroit où il est sensé être, ou l'exécutable suexec n'est pas
    installé en <em>setuid root</em>.</p>

     <p>Si le serveur HTTP Apache est déjà en cours d'exécution, et si
     vous activez le mécanisme suEXEC pour la première fois, vous
     devez arrêter et redémarrer httpd. Un redémarrage
     à l'aide d'un simple signal HUP ou USR1 suffira. </p>
     <p>Pour désactiver suEXEC, vous devez supprimer le fichier
     <program>suexec</program>, puis arrêter et redémarrer
     httpd.</p>
</section>

<section id="usage"><title>Utilisation de suEXEC</title>

    <p>Les requêtes pour des programmes CGI ne feront appel au
    conteneur suEXEC que si elles concernent un hôte virtuel
    contenant une directive <directive
    module="mod_suexec">SuexecUserGroup</directive>, ou si elles sont
    traitées par <module>mod_userdir</module>.</p>

    <p><strong>Hôtes virtuels :</strong><br /> Une des méthodes
    d'utilisation du conteneur suEXEC consiste à insérer une
    directive <directive
    module="mod_suexec">SuexecUserGroup</directive> dans une section
    <directive module="core">VirtualHost</directive>. En définissant
    des valeurs différentes de celles du serveur principal, toutes les
    requêtes pour des ressources CGI seront exécutées sous
    les <em>User</em> et <em>Group</em> définis pour cette section
    <directive
    module="core" type="section">VirtualHost</directive>. Si cette
    directive est absente de la section <directive module="core"
    type="section">VirtualHost</directive>, l'utilisateur du
    serveur principal sera pris par défaut</p>

    <p><strong>Répertoires des utilisateurs :</strong><br /> Avec
    cette méthode, les
    requêtes traitées par <module>mod_userdir</module> appelleront le
    conteneur suEXEC pour exécuter le programme CGI sous l'identifiant
    utilisateur du répertoire utilisateur concerné. Seuls prérequis
    pour pouvoir accéder à cette fonctionnalité : l'exécution des CGI
    doit être activée pour l'utilisateur concerné, et le script doit
    passer avec succès le test des <a href="#model">vérifications de
    sécurité</a> décrit plus haut. Voir aussi l'
    <a href="#install">option de compilation</a>
    <code>--with-suexec-userdir</code>.</p> </section>

<section id="debug"><title>Débogage de suEXEC</title>

    <p>Le conteneur suEXEC va écrire ses informations de journalisation
    dans le fichier défini par l'option de compilation
    <code>--with-suexec-logfile</code> comme indiqué plus haut. Si vous
    pensez avoir configuré et installé correctement le conteneur,
    consultez ce journal, ainsi que le journal des erreurs du serveur
    afin de déterminer l'endroit où vous avez fait fausse route.</p>

</section>

<section id="jabberwock"><title>Avis à la population !
    Avertissements et exemples</title>

    <p><strong>NOTE !</strong> Cette section est peut-être
    incomplète.</p>

    <p>Quelques points importants du conteneur peuvent
    imposer des contraintes du point de vue de la configuration du
    serveur. Veuillez en prendre connaissance avant de soumettre un
    rapport de bogue à propos de suEXEC.</p>

    <p><strong>Points importants à propos de suEXEC</strong></p>
    <ul>
 
      <li>
        Limitations concernant la hiérarchie.

        <p class="indent">
          Pour des raisons de sécurité et d'efficacité, toutes les
	  requêtes suEXEC ne doivent concerner que des ressources
	  situées dans la racine des documents définie pour les
	  requêtes concernant un hôte virtuel, ou des ressources
	  situées dans la racine des documents définies pour les
	  requêtes concernant un répertoire utilisateur. Par exemple,
	  si vous avez configuré quatre hôtes virtuels, vous devrez
	  définir la structure des racines de documents de vos hôtes
	  virtuels en dehors d'une hiérarchie de documents principale
	  de httpd, afin de tirer parti de suEXEC dans le contexte des
	  hôtes virtuels (Exemple à venir).
        </p>
      </li>

      <li>
        La variable d'environnement PATH de suEXEC

        <p class="indent">
          Modifier cette variable peut s'avérer dangereux. Assurez-vous
	  que tout chemin que vous ajoutez à cette variable est un
	  répertoire <strong>de confiance</strong>. Vous n'avez
	  probablement pas l'intention d'ouvrir votre serveur de façon
	  à ce que l'on puisse y exécuter un cheval de Troie.
        </p>
      </li>

      <li>
        Modification de suEXEC

        <p class="indent">
          Encore une fois, ceci peut vous causer de
	  <strong>graves ennuis</strong> si vous vous y essayez sans
	  savoir ce que vous faites. Evitez de vous y risquer dans la
	  mesure du possible.
        </p>
      </li>
    </ul>

</section>

</manualpage>
