<?xml version='1.0' ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1873272 -->
<!-- French translation by Vincent Deffontaines, review by alain B -->
<!-- Updated by Lucien Gentis -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="fd-limits.xml.meta">
<parentdocument href="./">Serveurs Virtuels</parentdocument>
  <title>Limites des descripteurs de fichiers</title>

<summary>

    <p>Quand de nombreux serveurs virtuels sont créés, Apache peut
    dépasser les limites en descripteurs de fichiers ('file descriptors',
    également appelés <cite>gestionnaires de fichiers</cite>) si chacun
    des serveurs virtuels utilise ses propres fichiers journaux. Le
    nombre total de descripteurs de fichiers utilisés par Apache est
    d'un par fichier journal, un pour chacune des autres directives
    de fichiers journaux, plus un nombre constant compris entre 10 et 20
    pour son fonctionnement interne. Les systèmes d'exploitation Unix
    limitent le nombre de descripteurs de fichiers utilisables par
    processus&nbsp;; une valeur courante pour cette limite est de 64, et
    cette valeur peut le plus souvent être augmentée.</p>

    <p>Apache tente d'accroître cette valeur limite si nécessaire, mais
    sans y parvenir dans les cas suivants&nbsp;:</p>

    <ol>
      <li>Le système d'exploitation ne permet pas l'utilisation d'appels
      systèmes <code>setrlimit()</code>.</li>

      <li>L'appel <code>setrlimit(RLIMIT_NOFILE)</code> ne fonctionne pas
      sur votre système d'exploitation (c'est le cas sous Solaris 2.3).</li>

      <li>Le nombre de descripteurs de fichiers nécessaires à Apache
      dépasse la limite physique du matériel.</li>

      <li>Le système impose d'autres limites sur l'utilisation des
      descripteurs de fichiers, comme par exemple une limite sur les
      flux stdio, utilisables uniquement sur les descripteurs de
      fichiers inférieurs à 256. (sous Solaris 2).</li>
    </ol>

    <p>En cas de problème, Vous pouvez&nbsp;:</p>

    <ul>
      <li>Réduire le nombre de fichiers journaux, en ne spécifiant
      aucun fichier journal dans les sections
      <directive type="section" module="core">VirtualHost</directive>,
      en donc en envoyant les informations aux fichiers journaux du
      serveur principal (Voir <a href="#splitlogs">Éclatement des
      fichiers journaux</a> ci-dessous pour plus d'informations sur
      cette possibilité).</li>

      <li>
        Dans les cas 1 ou 2 (évoqués ci-dessus), augmentez la limite sur
        les descripteurs de fichiers avant le démarrage d'Apache, au
        moyen d'un script comme

        <example>
          <code>#!/bin/sh<br />
           ulimit -S -n 100<br />
           exec httpd</code>
        </example>
      </li>
    </ul>

<!-- the document misc/descriptors.xml does not exist yet in 2.1
    <p>Veuillez noter que le document
    <a href="../misc/descriptors.html">Descripteurs et Apache</a>
    contient plus de détails concernant les problèmes de descripteurs
    de fichiers et comment les résoudre en fonction de votre système
    d'exploitation.</p>
-->

</summary>

<section id="splitlogs"><title>Éclatement des fichiers journaux</title>

<p>Lorsque vous choisissez d'enregistrer les informations émanant de
plusieurs serveurs virtuels dans un même fichier journal, vous voudrez
ensuite pouvoir scinder ces informations à des fins de statistiques, par
exemple, sur les différents serveurs virtuels. Il est possible de procéder
de la manière suivante&nbsp;:</p>

<p>Tout d'abord, vous devez ajouter le nom du serveur virtuel à chaque
entrée du journal. Ceci se paramètre au moyen de la directive
<directive module="mod_log_config"> LogFormat</directive> et de la
variable <code>%v</code>. Ajoutez cette variable au début de la chaîne
de définition du format de journalisations&nbsp;:</p>

<highlight language="config">
LogFormat "%v %h %l %u %t \"%r\" %&gt;s %b" vhost
CustomLog logs/multiple_vhost_log vhost
</highlight>

<p>Cette configuration va provoquer la création d'un fichier de
journalisation au format standard (CLF&nbsp;: 'Common Log Format'), mais dont
chaque ligne débutera par le nom canonique du serveur virtuel (spécifié
par la directive <directive module="core">ServerName</directive>).
(Voir <module>mod_log_config</module> pour d'autres informations sur la
personnalisation des fichiers journaux.)</p>

<p>Au moment de séparer les informations du fichier journal en un fichier
par serveur virtuel, le programme <code>
<a href="../programs/other.html">split-logfile</a></code> peut être
utilisé. Ce programme peut être trouvé dans le répertoire
<code>support</code> de la distribution d'Apache.</p>

<p>Exécutez ce programme au moyen de la commande&nbsp;:</p>

<example>
split-logfile &lt; /logs/multiple_vhost_log
</example>

<p>Une fois exécuté avec le nom du fichier contenant tous les journaux,
ce programme va générer un fichier pour chacun des serveurs virtuels
qui apparaît dans le fichier d'entrée. Chaque fichier en sortie est
nommé <code>nomduserveur.log</code>.</p>

</section>
</manualpage>

