/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InclusiveIntRange {
    private final int min;
    private final int max;

    private InclusiveIntRange(int n, int n2) {
        this.min = n;
        this.max = n2;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public static InclusiveIntRange fromTo(int n, int n2) {
        return new InclusiveIntRange(n, n2);
    }

    public static InclusiveIntRange from(int n) {
        return new InclusiveIntRange(n, Integer.MAX_VALUE);
    }

    public List<InclusiveIntRange> getValuesNotIn(List<InclusiveIntRange> list) {
        if (list.isEmpty()) {
            return Collections.singletonList(this);
        }
        int n = this.min;
        List<InclusiveIntRange> list2 = null;
        for (InclusiveIntRange inclusiveIntRange : list) {
            int n2 = inclusiveIntRange.max;
            if (n > n2) continue;
            int n3 = inclusiveIntRange.min;
            if (n < inclusiveIntRange.min) {
                if (list2 == null) {
                    list2 = new ArrayList<InclusiveIntRange>();
                }
                list2.add(InclusiveIntRange.fromTo(n, n3 - 1));
            }
            if (n2 >= this.max) {
                return list2 != null ? list2 : Collections.emptyList();
            }
            n = n2 + 1;
        }
        if (n <= this.max) {
            if (list2 == null) {
                list2 = new ArrayList<InclusiveIntRange>(1);
            }
            list2.add(InclusiveIntRange.fromTo(n, this.max));
        }
        return list2 != null ? list2 : Collections.emptyList();
    }

    public String toString() {
        return "[" + this.min + ", " + (this.max < Integer.MAX_VALUE ? this.max + "]" : "\u221e)");
    }
}

