Original article can be found at [https://opensource.org/links](https://opensource.org/links) and is available under [Creative Commons Attribution 4.0 International License](http://creativecommons.org/licenses/by/4.0/).

#Open Source Bibliography 

There are many resources (good and bad) on the web offering information, advice, and interpretation concerning Open Source. The following are references that we, the OSI Board, have found useful, either for informing ourselves or for helping others begin their education about open source. And as you explore these links, be mindful of these words attributed to the Buddha, 

> "Believe nothing, no matter where you read it, or who said it, no matter if I have said it, unless it agrees with your own reason and your own common sense..."

### Rich References

* Open Source on [Wikipedia](http://en.wikipedia.org/wiki/Open_source). Note that Wikipedia itself is implemented using [MediaWiki](http://www.mediawiki.org/wiki/MediaWiki) software, which is covered by the [GNU GPL](http://www.gnu.org/licenses/licenses.html#GPL), a popular license that is both a [free software](http://www.gnu.org/philosophy/free-sw.html) license and also approved by the OSI as an Open Source license.
* David Wheeler's [Why OSS? Just look at the numbers!](http://www.dwheeler.com/oss_fs_why.html).
* David Wheeler's [References](http://www.dwheeler.com/oss_fs_refs.html).

### Books

* The Cathedral and the Bazaar ([online]((http://www.catb.org/~esr/writings/cathedral-bazaar/) and [book](http://www.oreilly.com/catalog/cb/)), Eric S. Raymond, 1997.
* [Open Sources: Voices from the Open Source Revolution](http://www.oreilly.com/catalog/opensources/), Chris DiBona, Sam Ockman, and Mark Stone, 1999.
* [Open Sources 2.0: The Continuing Evolution](http://www.oreilly.com/catalog/opensources/>, Chris DiBona, Mark Stone, and Danese Cooper, 2005.
* [The Success of Open Source](http://www.hup.harvard.edu/catalog/WEBSUC.html), Steven Weber, 2004.
* [Producing Open Source Software](http://producingoss.com/), Karl Fogel, 2005.
* [Open Source Licensing](http://www.rosenlaw.com/oslbook.htm), Larry Rosen, 2004.
* [Collaborative Ownership and the Digital Economy](http://mitpress.mit.edu/catalog/item/default.asp?tid=10459&amp;ttype=2), Rishab Aiyer Ghosh, 2005.

### Open Source Software

* [The Free Software Directory](http://directory.fsf.org/) Lists over 5,000 packages. (Yes, Free Software is also Open Source Software)
* [sourceforge.net](http://sourceforge.net/) Lists over 120,000 projects in varying stages of development. Mainly for developers. The public sourceforge.net site only hosts projects [covered by an OSI-approved license](http://sourceforge.net/docs/about/02/)
* [freshmeat.net](<http://freshmeat.net/") Lists over 60,000 new releases of Open Source packages. Mainly for people who want to download the latest releases from developers. freshmeat.net strongly prefers software [covered by an OSI-approved license](http://freshmeat.net/about/) (but will host non-open source software in exchange for a fee).
* [OSDir](http://osdir.com/) OSDir's [list](http://osdir.com/Downloads.phtml) of stable open source software.
* [50 proprietary software packages and their open source alternatives](http://whdb.com/2008/the-top-50-proprietary-programs-that-drive-you-crazy-and-their-open-source-alternatives/). This list is <em>one</em> author's opinion.</li>

### Open Source Conferences and User Groups

* [OSCON](<http://conferences.oreillynet.com/oscon/). Note that O'Reilly Media put on many other conferences, most of which have strong open source components and/or constitutents.
* [FOSS4G](http://www.foss4g2007.org/). Free and Open Source Geospatial Information Systems conference.
* [Blender Conference](http://www.blender3d.com/cms/Blender_Conference.52.0.html). There are other regional versions of this conference that can be found at the [blender.org](<a href="http://blender.org/">) website.
* The Ottawa [Linux Symposium](http://www.linuxsymposium.org/2006/). A premier event for [hackers](http://en.wikipedia.org/wiki/Hacker) to discuss implementation experiences and chart the future of Linux.
* The [Wizards of OS]("http://www.wizards-of-os.org/) conference in Berlin.
* The [FISL](http://fisl.softwarelivre.org/) conference in Porto Alegre, Brazil.
* The [FOSSSL](http://www.foss.lk/events/) conference (and other events) in Colombo, Sri Lanka.
* There are hundreds of conferences per year all over the world that advertise "Open Source" as a topic. Alas, these have varying degrees of quality and felicity and the OSI does not vouch for (nor recommend against) the ones not listed in this section. Check to see whether an OSI-affiliated speaker is listed as presenting if you wish to hear the OSI's thoughts or positions.
* User groups tend to focus on software or groups of software used in a particular context: Linux users in Northern Virginia ([NOVALUG](http://novalug.tux.org/)), GIS developers and users who formed the [Indian Chapter of OSGeo](http://wiki.osgeo.org/index.php/India), or the dozens of [topic-specific users](https://stat.ethz.ch/mailman/listinfo) of the [R](http://www.r-project.org/) package and its extensions. There are many thousands of user groups, and the best way to find the one that's right for you is to search the web, find the mailing lists, and make contact.

### Research

* The [Economic impact of FLOSS on innovation and competitiveness of the EU ICT sector](http://ec.europa.eu/enterprise/ict/policy/doc/2006-11-20-flossimpact.pdf) study, published 20 November 2006 by UNU-Merit.
* Use of Game Theory to explain why [free riders do not destroy open source software projects](http://opensource.mit.edu/papers/baldwinclark.pdf).
* [Open Source Software Projects as Virtual Organizations: Competency Rallying for Software Development](http://floss.syr.edu/publications/iee2002.pdf), published 2002 in the [IEE Proceedings Software](http://www.iee.org/Publish/Journals/Profjourn/Proc/sen/), Volume [149(1)](http://scitation.aip.org/dbt/dbt.jsp?KEY=IPSEFU&amp;Volume=149&amp;Issue=1#P000001000001), pages 3-17, which uses the framework of Katzy's [Design and Implementation of Virtual Organizations](http://portal.cetim.org/file/1/67/Katzy-1998-Design-and-Implementation-of-Virtual-Organizations.pdf).

Many more papers about open source can be found at MIT's [Free/Open Research Community](http://opensource.mit.edu/).

### Packaged Open Source Software

Hundreds, if not thousands, of companies now sell commercially packaged and supported open source software. While many open source software packages do run on proprietary systems ([Apache](http://apache.org/) is quite popular on <i>all</i> operating systems platforms), Linux distributions provide a complete (and in some cases, exclusively) open source environment suitable for hand-held, desktop, server, and high-end enterprise/cluster/mainframe use.

The OSI website is built with and runs exclusively open source software, including [Apache](http://apache.org) (web server), [Drupal](http://drupal.org) (content management and blogs), the [PHP](http://www.php.net/) scripting language, the [MySQL](http://mysql.com/) database, to name a few of the more well-known packages.

### Open Source News

* [Linux Weekly News](http://lwn.net/)
* [OSDir](http://osdir.com/)
* [LXer.com](http://lxer.com)
