module.exports = {
  ModulePage: {
    modules_tab: '//*[@id="subtab-AdminModulesManage"]',
    upload_button: '//*[@id="page-header-desc-configuration-add_module"]',
    zip_file_input: '//*[@id="importDropzone"]/input',
    installed_message: '//*[@id="importDropzone"]/div[3]/p[1]',
    close_modal_button: '//*[@id="module-modal-import-closing-cross"]',
    search_input: 'div.pstaggerAddTagWrapper > input',
    search_button: '.btn.btn-primary.pull-right.search-button',
    page_loaded: '.module-search-result-title',
    modules_search_input: '.pstaggerAddTagInput',
    module_selection_input: '//input[contains(@class,"pstaggerAddTagInput ")]',
    modules_search_button: '//*[@id="main-div"]//button[contains(@class,"search-button")]',
    configure_module_button: '//form[contains(@action, "action/configure/%moduleTechName")]//button[@data-confirm_modal="module-modal-confirm-%moduleTechName-configure"]',
    configure_module_theme_button: '//*[@data-tech-name="%moduleTechName"]//a[contains(@href,"configure/%moduleTechName")]',
    success_install_message: '//*[@id="importDropzone"]/div[3]/i',
    action_dropdown: '//div[@data-tech-name="%moduleTechName"]//button[contains(@class,"dropdown-toggle")]',
    uninstall_button: '//form[contains(@action, "action/uninstall/%moduleTechName")]//button[@data-confirm_modal="module-modal-confirm-%moduleTechName-uninstall"]',
    uninstall_confirmation: '//*[@id="module-modal-confirm-prestafraud-uninstall"]//a[contains(@class,"module_action_modal_uninstall")]',
    built_in_module_span: '//*[@id="built-in_modules"]',
    installed_module_span: '//*[@id="installed_modules"]',
    theme_module_span: '//*[@id="theme_modules"]',
    selection_search_button: '//*[@id="module-search-button"]',
    install_button: '//*[@id="modules-list-container-all"]//div[@data-tech-name="%moduleTechName"]//button',
    config_legend_adwords: '//*[@id="content"]//h4[contains(@class,"page-subtitle")]',
    uninstall_adwords_module: '//*[@id="module-modal-confirm-gadwords-uninstall"]//a[contains(@class,"module_action_modal_uninstall")]',
    more_option_button: '//*[@id="upgradeButtonBlock"]//input',
    channel_select: '//*[@id="advanced"]/select',
    archive_select: '//*[@id="for-useArchive"]//select',
    save_button: '//*[@id="advanced"]//input[contains(@class,"btn-primary")]',
    save_message: '//*[@id="configResult"]',
    version_number: '//*[@id="for-useArchive"]//input',
    upgrade_button: '//*[@id="upgradeNow"]',
    loader_tag: '//*[@id="pleaseWait" and contains(@style,"display: none;")]',
    upgrade_block: '//*[@id="upgradeButtonBlock"]',
    refresh_button: '(//*[@id="upgradeButtonBlock"]//a)[2]',
    module_import_success: '//*[@id="importDropzone"]/div[3]/p[1]',
    config_legend: '//*[@id="content"]//ul[contains(@class, "breadcrumb")]/li[text()="%moduleTechName"]',
    uninstall_module_modal: '//a[contains(@class,"module_action_modal_uninstall")]',
    disable_module: '//form[contains(@action, "action/disable/%moduleTechName")]//button[@data-confirm_modal="module-modal-confirm-%moduleTechName-disable"]',
    confirmation_disable_module: '(//a[contains(@class,"module_action_modal_disable")])[1]',
    module_autoUpgrade_menu: '//*[@id="subtab-AdminSelfUpgrade"]/a',
    rollback_selection: '//*[@id="restoreBackupContainer"]//select',
    rollback_version: '//*[@id="restoreBackupContainer"]//option[2]',
    rollback_button: '//*[@id="rollback"]',
    success_msg: '(//p[contains(@class,"alert-success")])[1]/p',
    module_list: '(//*[@id="modules-list-container-all"]/div[@data-type="module" or @data-type="service" ])[%I]',
    sort_select: '//select[contains(@class,"sort-component")]',
    maintenance_shop: '//*[@id="currentConfiguration"]//input[contains(@name,"putUnderMaintenance")]',
    confirm_maintenance_shop_icon: '(//*[@id="currentConfiguration"]//img)[5]',
    enable_module: '//form[contains(@action, "action/enable/%moduleTechName")]//button[@data-confirm_modal="module-modal-confirm-%moduleTechName-enable"]',
    reset_module: '//form[contains(@action, "action/reset/%moduleTechName")]//button[@data-confirm_modal="module-modal-confirm-%moduleTechName-reset"]',
    reset_button_modal: '//*[@id="module-modal-confirm-%moduleTechName-reset"]//a[contains(@class, "module_action_modal_reset")]',
    backdrop_modale: '//div[contains(@class, "fade show")]',
    installed_module_div: '//div[@data-tech-name="%moduleTechName"]',
    module_action_href: '//*[contains(@id,"modules-list-container")]//button[contains(@class, "primary module_action_menu")] | //*[contains(@id,"modules-list-container")]//a[contains(@class, "btn-primary-reverse btn-outline-primary")]',
    //List of modules after search
    list_module: '//*[@id="modules-list-container-all"]/div[%I]',
    modules_number_span: '//*[@id="selected_modules"]',
    discover_button: '//*[@id="modules-list-container-all"]/div[@data-tech-name="pm_advancedtopmenu"]//a[contains(text(),"Discover")]',
    //List of modules in notifications tab
    configure_module: '//*[@id="modules-list-container-notification"]//button[@data-confirm_modal="module-modal-confirm-%moduleTechName-configure"]',
    modules_number_to_configure: '//*[@id="module-short-list-configure"]/span[1]',
    notification_number: '//*[@id="subtab-AdminModulesNotifications"]//span[@class="notification-counter" and string-length(text())>0]',
    update_notification_number_span: '//*[@id="subtab-AdminModulesUpdates"]//span[@class="notification-counter" and string-length(text())>0]',
    selection_tab: '//*[@id="head_tabs"]/a[1]',
    discover_amazon_module_button: '//*[@id="modules-list-container-all"]//a[contains(@href,"amazon-market-place")]',
    ModuleBankTransferPage: {
      account_owner_input: '//*[@id="BANK_WIRE_OWNER"]',
      account_details_textarea: '//*[@id="BANK_WIRE_DETAILS"]',
      bank_address_textarea: '//*[@id="BANK_WIRE_ADDRESS"]',
      save_button: '//*[@id="module_form_submit_btn"]'
    },
    MainMenuPage: {
      available_item_list: '//*[@id="availableItems"]//option[@value="CAT%ID"]',
      add_item_button: '//*[@id="addItem"]',
      selected_item_list: '//*[@id="items"]//option[@value="CAT%ID"]',
      save_button: '//*[@id="module_form_submit_btn"]'
    },
    ReadMoreModal: {
      read_more_link: '//*[@id="modules-list-container-all"]/div[contains(@data-tech-name, "%moduleTechName")]//a[text()="Read more"]',
      overview_content: '//*[@id="overview-%moduleTechName"]/p',
      additional_content: '//*[@id="additional-%moduleTechName"]',
      features_content: '//*[@id="features-%moduleTechName"]',
      changelog_content: '//*[@id="changelog-%moduleTechName"]',
      module_readmore_tabs: '//*[@id="modules-list-container-all"]/div[contains(@data-tech-name, "%moduleTechName")]//a[contains(text(), "%NAME")]',
      close_modal_button: '//*[@id="module-modal-read-more-%moduleTechName"]//button[@class="close"]'
    },

    //Module name in "addons.prestashop.com" after clicking on "Dicover" button
    module_name: '//*[@id="product_content"]/div[@class="product_head"]//h1',
    ContactFormPage: {
      send_confirmation_email_button: '//*[@id="fieldset_0"]//label[@for="CONTACTFORM_SEND_CONFIRMATION_EMAIL_%S"]',
      receive_customers_messages_label: '//*[@id="fieldset_0"]//label[@for="CONTACTFORM_SEND_NOTIFICATION_EMAIL_%S"]',
      save_button: '//*[@id="module_form_submit_btn"]'
    },
    see_more_link: '//*[@id="main-div"]//button[contains(@class,"see-more")]',
    configure_link: '(//*[@id="main-div"]//div[@data-tech-name="%moduleTechName"]//a[contains(@href,"/action/configure")])',
    upgrade_module_button: '//*[@id="modules-list-container-update"]//button[contains(@data-confirm_modal,"%moduleTechName-upgrade")]',
    module_bloc: '(//*[@id="modules-list-container-update"]//div[contains(@class,"module-item-list")])[1]',
    check_configure: '//*[@id="cab-getstarted"]/h2',
    categories_list: '(//*[@id="categories"]) | (//*[@id="catDropdown"])',
    categories_option_link: '//div[contains(@class,"module-category-selector")]//li[@data-category-display-name="%CAT"]/a',
    categories_option_number_span: '//div[contains(@class,"module-category-selector")]//li[@data-category-display-name="%CAT"]//span',
    categories_by_name_option: '//div[contains(@class,"module-category-selector")]//li[@data-category-display-name="%CAT"]',
    category_list: '#main-div div[aria-labelledby*=categories] ul',
    categories_element_option: '//*[@id="main-div"]//div[contains(@aria-labelledby,"categories")]//li[%ID]',
    categories_element_number_span: '//*[@id="main-div"]//div[contains(@aria-labelledby,"categories")]//li[%ID]//span',
    see_more_by_category_link: '//*[@id="main-div"]//button[@data-category="%ID" and contains(@class,"see-more")]',
    module_list_container_bloc: '#modules-list-container-%ID',
    module_list_container_empty_bloc: '//*[@id="main-div"]//div[contains(@class,"module-list-empty") and @data-name="%ID"]',
    first_module_bloc: '(//div[contains(@class,"module-item")])[1]',
    module_action_link: '(//div[@data-tech-name="%moduleTechName"]//div[contains(@class,"module-actions")]/a) |  (//div[@data-tech-name="%moduleTechName"]//form/button[@data-confirm_modal="module-modal-confirm-%moduleTechName-disable"])',
    status_list: '//*[@id="module-status-dropdown"]',
    status_option_link: '//*[@id="main-div"]//ul[contains(@class,"module-status-selector")]/li[@data-status-ref="%ID"]/a',
    price_module_span: '(//*[@id="modules-list-container-all"]/div[@data-type="module" or @data-type="service"])[%I]//div[contains(@class,"module-price")]//span',
    price_module_div: '(//*[@id="modules-list-container-all"]/div[@data-type="module" or @data-type="service"])[%I]//div[contains(@class,"module-price")]',
    category_price_module_span: '(//*[@id="modules-list-container-all"]/div[@data-type="module" and @data-categories="%IND"])[%I]//div[contains(@class,"module-price")]',
    category_module_list: '(//*[@id="modules-list-container-all"]/div[(@data-type="module" or @data-type="service") and @data-categories="%IND"])[%I]',
  }
};
