<?php

namespace App\Test\Fakers;

use Faker\Generator;
use App\Entities\User;
use App\Models\UserModel;

class UserFaker extends UserModel {
  /**
   * Faked data for Fabricator.
   *
   * @param Generator $faker
   *
   * @return User
   */
  public function fake(Generator &$faker): User {
    return new User([
      'email' => $faker->email,
      'username' => $faker->userName,
      'password' => bin2hex(random_bytes(16)),
    ]);
  }
}
