/*!
 * Width mode toggler for TeamCal Neo
 * Copyright 2011-2024 George Lewe
 */
(()=>{'use strict';const getStoredWidth=()=>localStorage.getItem('width');const setStoredWidth=width=>localStorage.setItem('width',width);const getPreferredWidth=()=>{const storedWidth=getStoredWidth();if(storedWidth){return storedWidth}
return document.documentElement.getAttribute('data-width')};const setWidth=width=>{let newWidth='';if(width==='wide'){newWidth='wide'}else if(width==='narrow'){newWidth='narrow'}else{newWidth=document.documentElement.getAttribute('data-width')}
if(newWidth==='wide'){const containers=document.querySelectorAll('div.container');containers.forEach(container=>{container.classList.remove('container');container.classList.add('container-fluid')})}else{const containers=document.querySelectorAll('div.container-fluid');containers.forEach(container=>{container.classList.remove('container-fluid');container.classList.add('container')})}
document.documentElement.setAttribute('data-width',newWidth)};setWidth(getPreferredWidth());const showActiveWidth=(width,focus=!1)=>{const myActiveWidthIcon=document.querySelector('.width-icon-active');myActiveWidthIcon.className='';switch(width){case 'wide':myActiveWidthIcon.classList.add('width-icon-active','bi-fullscreen');break;case 'narrow':myActiveWidthIcon.classList.add('width-icon-active','bi-fullscreen-exit');break;default:myActiveWidthIcon.classList.add('width-icon-active','bi-fullscreen-exit');break}
const widthSwitcher=document.querySelector('#bd-width');if(!widthSwitcher){return}
const widthSwitcherText=document.querySelector('#bd-width-text');const activeWidthIcon=document.querySelector('.width-icon-active use');const btnToActive=document.querySelector(`[data-width-value="${width}"]`);const svgOfActiveBtn=btnToActive.querySelector('svg use').getAttribute('href');document.querySelectorAll('[data-width-value]').forEach(element=>{element.classList.remove('active');element.setAttribute('aria-pressed','false')});btnToActive.classList.add('active');btnToActive.setAttribute('aria-pressed','true');activeWidthIcon.setAttribute('href',svgOfActiveBtn);const widthSwitcherLabel=`${widthSwitcherText.textContent} (${btnToActive.dataset.bsWidthValue})`;widthSwitcher.setAttribute('aria-label',widthSwitcherLabel);if(focus){widthSwitcher.focus()}};window.matchMedia('(prefers-width-scheme: narrow)').addEventListener('change',()=>{const storedWidth=getStoredWidth();if(storedWidth!=='wide'&&storedTheme!=='narrow'){setWidth(getPreferredWidth())}});window.addEventListener('DOMContentLoaded',()=>{showActiveWidth(getPreferredWidth());document.querySelectorAll('[data-width-value]').forEach(toggle=>{toggle.addEventListener('click',()=>{const width=toggle.getAttribute('data-width-value');setStoredWidth(width);setWidth(width);showActiveWidth(width,!0)})})})})()