export default function( elem ) {

	// Support: IE <=11+ (trac-14150)
	// In IE popup's `window` is the opener window which makes `window.getComputedStyle( elem )`
	// break. Using `elem.ownerDocument.defaultView` avoids the issue.
	var view = elem.ownerDocument.defaultView;

	// `document.implementation.createHTMLDocument( "" )` has a `null` `defaultView`
	// property; check `defaultView` truthiness to fallback to window in such a case.
	if ( !view ) {
		view = window;
	}

	return view.getComputedStyle( elem );
}
