.  ./.gh-api-examples.conf

# https://docs.github.com/en/rest/reference/pulls#create-a-pull-request
# POST /repos/:owner/:repo/pulls

json_file="tmp/create-pull-request.json"

# If the script is passed an argument $1 use that as the name
if [ -z "$1" ]
  then
    repo=$repo
  else
    repo=$1
fi

# If the script is passed an argument $1 use that as the name
if [ -z "$2" ]
  then
    base_branch=${base_branch}
  else
    base_branch=$2
fi


# The list */tmp/head_branches* is generated by `generate-branches-for-many-pull-requests.sh`
for head_branch in $(cat /tmp/head_branches)
do
    title="Great new PR from ${head_branch} merge it for the win."
    body=$(cat lorem-pull-request.md)
    jq -n \
           --arg title "${title}" \
           --arg body "${body}" \
           --arg head_branch "${head_branch}" \
           --arg base "${base_branch}"\
           '{
             title: $title,
             body: $body,
             head: $head_branch,
             base: $base
           }' > ${json_file}

    curl ${curl_custom_flags} \
         -H "Authorization: Bearer ${GITHUB_TOKEN}" \
         -H "Accept: application/vnd.github.v3+json" \
            ${GITHUB_API_BASE_URL}/repos/${org}/${repo}/pulls --data @${json_file}
done
