.  ./.gh-api-examples.conf

# A Dependabot alert can be closed by dismissing or fixing an alert.
# When the alert is dismissed, the `dismissedAt` field will be populated.
# Similarly, the `fixedAt` field will be populated when an alert is fixed.

read -r -d '' graphql_script <<- EOF
{
  repository(owner: "$org", name: "$repo") {
    vulnerabilityAlerts(first: 100) {
      nodes {
        dismissedAt
        fixedAt
      }
    }
  }
}
EOF

# Escape quotes and reformat script to a single line
graphql_script="$(echo ${graphql_script//\"/\\\"})"


curl ${curl_custom_flags} \
     -H "Accept: application/vnd.github.v3+json" \
     -H "Authorization: Bearer ${GITHUB_TOKEN}" \
        ${GITHUB_APIV4_BASE_URL} -d "{ \"query\": \"$graphql_script\"}"

