.  ./.gh-api-examples.conf

# https://docs.github.com/en/enterprise-cloud@latest/rest/repos/repos?apiVersion=2022-11-28#get-a-repository
# GET /repos/{owner}/{repo}


# If the script is passed an argument $1 use that as the name
if [ -z "$1" ]
  then
    repo=$repo
  else
    repo=$1
fi

# If the script is passed an argument $2 use that as the org
if [ -z "$2" ]
  then
    org=${org}
  else
    org=${2}
fi

if [ "${preferred_client}" = "gh" ]; then
    echo gh api /repos/{owner}/{repo} ${gh_custom_flags}
else
    curl ${curl_custom_flags} \
         -H "Accept: application/vnd.github.v3+json" \
         -H "Authorization: Bearer ${GITHUB_TOKEN}" \
            "${GITHUB_API_BASE_URL}/repos/${owner}/${repo}"
fi

