.  ./.gh-api-examples.conf

# https://docs.github.com/en/rest/actions/self-hosted-runners#list-runner-applications-for-a-repository
# GET /repos/{owner}/{repo}/actions/runners/downloads
#
gh_path="/repos/{owner}/{repo}/actions/runners/downloads"

preferred_client=gh

# If the script is passed an argument $1 use that as the name
if [ -z "$1" ]
  then
    repo=$repo
  else
    repo=$1
fi


if [ ${preferred_client} == "gh" ]; then
    echo gh api ${gh_custom_flags} ${gh_path}
else
    curl ${curl_custom_flags} \
         -H "Accept: application/vnd.github.v3+json" \
         -H "Authorization: Bearer ${GITHUB_TOKEN}" \
            ${GITHUB_API_BASE_URL}/repos/${owner}/${repo}/actions/runners/downloads
fi
