%% ODF Import
%
%%
% MTEX support the following formats for storing and importing of ODFs:
%
% * .mat file - lossless, specific for MTEX, binary format
% * MTEX file - lossless, specific for MTEX, ASCII format
% * VPSC file - not lossless, ASCII format
% * .txt file - not lossless, ASCII format
%
% Importing ODF data into MTEX means to create an ODF variable from data
% files containing Euler angles and weights. Once such an variable has been
% created the data can be analyzed and processed in many ways. See e.g.
% <ODFCharacteristics.html ODFCalculations>. The most simplest way to import
% ODF data is to use the import wizard, which can be started either by
% typing into the command line

import_wizard('ODF')

%% Interpolation


%%
% The import wizard provides a gui to import data of almost all ASCII
% data formats and allows to save the imported data as an ODF variable to
% the workspace or to generate a m-file loading the data automatically.
%
% A script generated by the import wizard typically look as follows.

% define crystal and specimen symmetry
cs = crystalSymmetry('cubic');

% the file name
fname = [mtexDataPath '/ODF/odf.txt'];

% TODO: write about halfwidth and the missing 1-1 relationship between ODF
% and single orientations.
% the resolution used for the reconstruction of the ODF
res = 10*degree;

% load the data
odf = ODF.load(fname,cs,'resolution',res,'Bunge',...
  'ColumnNames',{'Euler 1','Euler 2','Euler 3','weights'});

% plot data
plot(odf,'sections',6,'silent')

%% Density Estimation



%%
% So far ODFs may only exported from and imported into ASCII files that
% consists of a table of orientations and weights. The orientations may
% be given either as Euler angles or as quaternions. The weight may either
% represent the value of the ODF at this specific orientation or it may
% represent the volume of a bell shaped function centered at this
% orientation.
%
