%% Plotting in MTEX
%
%%
% In MTEX you can plot almost any type data. Simply apply the *plot*
% command to any variable and MTEX tries to plot the content of the
% variable in the most intuitive way. In this way, you can plot three
% Miller indices, rotations, pole figures, or ODFs. MTEX also offers you a
% wide range of possibilities to customize your plots, e.g. by changing the
% <PlotTypes.html plot style>, the <SphericalProjections.html spherical
% projection>, the <ColorMaps.html color coding>, or by adding
% <Annotations.html colorbars or other annotations> to the plot. You can
% even <CombinedPlots.html combine plots> of different ODFs or EBSD
% data. This way MTEX allows you to create publication-ready plots which
% can be exported to almost any format using the commands <saveFigure.html
% saveFigure>.
%
%% Plot Types
%
% In general, MTEX knows the following <PlotTypes.html plot types>
%
% * contour plots
% * filled contour plots
% * smoots plots
% * scatter plots
% * line plots
%
% Contour plots are plots consisting only of contour lines and mainly used
% for pole figure or ODF plots. For raw pole figure data, MTEX uses by
% default a plot where each datapoint is represented by a single dot colored
% accordingly to the intensity. Line plots are used by MTEX for one-
% dimensional ODF plots, plots of Fourier coefficients and plots of kernel
% functions

%% Spherical Projections
% Whenever MTEX plots pole figures, ODFs, or crystal or specimen directions
% MTEX uses spherical projections to map the spherical data to the plane. By
% doing so MTEX supports a wide variety of <SphericalProjections.html
% spherical projections>, i.e.,
%
% * equal area projection (Schmidt)
% * equal distance projection
% * equal angle projection (stereographic)
% * plain
% * 3d plots
%
%% Color Coding
% A central issue when interpreting plots is to have a consistent
% <ColorMaps.html color coding> among all plots. In MTEX this can be
% achieved in two ways. If the minimum and maximum values are known then
% one can use one of the following syntaxes to have a consistent color
% coding.
%
% * Specifying the colorrange
% * Setting a logarithmic color scale
% * Switching to a monochrome color scale
% *
% See also <EBSDSpatialPlots Spatial EBSD Plots>.
%
%% Plot Annotations
%
% After generating a plot with MTEX it is possible to modify it
% interactively using the MATLAB plotting tools in the plotting figure. This
% includes
%
% * adding a colorbar
% * adding a legend
% * adding annotations
% * resizing / shifting parts of the plot
%
% This is described in more detail <Annotations.html here.>
%
%% Combined Plots
%
% Sometimes it is useful to combine several plots, e.g. plotting on the
% top of an inverse pole figure some important crystal directions. This
% can be performed by the command <matlab:doc('hold') hold all>,
% which preserves MATLAB from replacing the old plot by the new one. This
% technique is described in more detail <CombinedPlots.html here.>
%
%% Exporting Plots
%
% Plots generated by MTEX can be exported to a wide range of formats using
% the MATLAB function *save as* in the figure menu or using the command
% <saveFigure.html saveFigure>
%

