function Q = qmatrix(q)
% returns the quaternion multiplication matrix
%

q = reshape(q,1,1,[]);
a = q.a; b = q.b; c = q.c; d = q.d;
Q = cat(1,...
  [a -b -c -d],...
  [b  a -d  c] ,...
  [c  d  a -b],...
  [d -c  b  a]);