function l = pointGroupList

l = struct('Schoen',{},'Inter',{},'lattice',{},'properId',{},'LaueId',{},'Inversion',{},'altNames',{});

% Schoen, Inter, latticeType, properId, LaueId, inversion, alternative names
l = addSym(l,'C1' ,'1'    ,1, 1, 2,  1);                     %1
l = addSym(l,'Ci' ,'-1'   ,1, 1, 2, [1;-1],'S2');            %2
%====================================================================
l = addSym(l,'C2' ,'211'   ,2, 3, 5,  1);                    %3
l = addSym(l,'Cs' ,'m11'   ,2, 1, 5, -1,'C1h');              %4
l = addSym(l,'C2h','2/m11' ,2, 3, 5, [1;-1]);                %5

l = addSym(l,'C2' ,'121'   ,2, 6, 8,  1,'2');                %6
l = addSym(l,'Cs' ,'1m1'   ,2, 1, 8, -1,'m');                %7
l = addSym(l,'C2h','12/m1' ,2, 6, 8, [1;-1],'2/m');          %8

l = addSym(l,'C2' ,'112'   ,2, 9, 11,  1);                   %9
l = addSym(l,'Cs' ,'11m'   ,2, 1, 11, -1);                   %10
l = addSym(l,'C2h','112/m' ,2, 9, 11, [1;-1]);               %11
%====================================================================
l = addSym(l,'D2' ,'222'  ,3, 12, 16, [1 1], '22','V');      %12
l = addSym(l,'C2v','2mm'  ,3, 3, 16, [1 -1]);               %13
l = addSym(l,'C2v','m2m'  ,3, 6, 16, [-1 -1]);              %14
l = addSym(l,'C2v','mm2'  ,3, 9, 16, [-1 1]);               %15
l = addSym(l,'D2h','mmm'  ,3, 12, 16, [[1 1]; [-1 -1]], '2/m2/m2/m','Vh'); %16
%------------------------------------------------------------------------
l = addSym(l,'C3' ,'3'    ,4, 17,18, 1);                     %17
l = addSym(l,'C3i','-3'   ,4, 17,18, [1;-1],'S6');           %18

l = addSym(l,'D3' ,'321'   ,4,19,21, [ 1 1],'32');           %19
l = addSym(l,'C3v','3m1'   ,4,17,21, [-1 1],'3m');           %20
l = addSym(l,'D3d','-3m1'  ,4,19,21, [[1 1];[-1 -1]],'-32/m','-3m'); %21

l = addSym(l,'D3' ,'312'   ,4,22,24, [ 1 1]);                %22
l = addSym(l,'C3v','31m'   ,4,17,24, [-1 1]);                %23
l = addSym(l,'D3d','-31m'  ,4,22,24, [[1 1];[-1 -1]]);       %24
%-------------------------------------------------------------------------
l = addSym(l,'C4' ,'4'    ,5,25,27, 1);
l = addSym(l,'S4' ,'-4'   ,5,9,27,-1);
l = addSym(l,'C4h','4/m'  ,5,25,27, [1;-1]);

l = addSym(l,'D4' ,'422'  ,5,28,32, [1 1],'42');
l = addSym(l,'C4v','4mm'  ,5,25,32, [-1 1]);
l = addSym(l,'D2d','-42m' ,5,12,32, [1 -1],'Vd');
l = addSym(l,'D2d','-4m2' ,5,12,32, [-1 -1]);
l = addSym(l,'D4h','4/mmm',5,28,32, [[1 1];[-1 -1]],'4/m2/m2/m');
%---------------------------------------------------------------------------
l = addSym(l,'C6' ,'6'    ,6,33,35, 1);
l = addSym(l,'C3h','-6'   ,6,17,35, -1);
l = addSym(l,'C6h','6/m'  ,6,33,35, [1;-1]);

l = addSym(l,'D6' ,'622'  ,6,36,40, [1 1],'62');
l = addSym(l,'C6v','6mm'  ,6,33,40, [-1 1]);
l = addSym(l,'D3h','-62m' ,6,19,40, [1 -1]);
l = addSym(l,'D3h','-6m2' ,6,22,40, [-1 -1]);
l = addSym(l,'D6h','6/mmm',6,36,40,[[1 1];[-1 -1]],'6/m2/m2/m');
%---------------------------------------------------------------------------
l = addSym(l,'T'  ,'23'   ,7,41,42,[1 1 1]);
l = addSym(l,'Th' ,'m-3'  ,7,41,42,[[1 1 1];[-1 -1 -1]],'m3','2/m-3');

l = addSym(l,'O'  ,'432'  ,7,43,45,[1 1 1],'43');
l = addSym(l,'Td' ,'-43m' ,7,41,45,[1 -1 -1]);
l = addSym(l,'Oh' ,'m-3m' ,7,43,45,[[1 1 1];[-1 -1 -1]],'m3m','4/m-32/m');


function nl = addSym(l,Schoen,Inter,latticeId,properId,LaueId,inv,varargin)

s = struct('Schoen',Schoen,'Inter',Inter,'lattice',latticeType(latticeId),...
  'properId',properId,'LaueId',LaueId,'Inversion',inv,'altNames',{varargin});

nl = [l,s];
