/*
 * Decompiled with CFR 0.152.
 */
package co.uproot.css.domimpl;

import co.uproot.css.domimpl.AbstractCSSRule;
import co.uproot.css.domimpl.CSSUtils;
import co.uproot.css.domimpl.JStyleSheetWrapper;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.StyleSheet;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

final class CSSStyleDeclarationImpl
implements CSSStyleDeclaration {
    private final List<Declaration> declarations;
    private final AbstractCSSRule parentRule;

    CSSStyleDeclarationImpl(List<Declaration> declarations, AbstractCSSRule parentRule) {
        this.declarations = declarations;
        this.parentRule = parentRule;
    }

    @Override
    public String getCssText() {
        return this.declarations.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        StyleSheet jSheet = CSSUtils.parse("*{" + cssText + "}");
        this.declarations.clear();
        for (RuleBlock rule : jSheet) {
            this.declarations.addAll((Collection<Declaration>)((RuleSet)rule));
        }
        JStyleSheetWrapper styleSheet = this.parentRule.containingStyleSheet;
        styleSheet.informChanged();
    }

    @Override
    public String getPropertyValue(String propertyName) {
        Declaration propertyValueTerm = this.getPropertyValueTerm(propertyName);
        return propertyValueTerm == null ? null : propertyValueTerm.asList().toString();
    }

    private Declaration getPropertyValueTerm(String propertyName) {
        for (Declaration d : this.declarations) {
            if (!d.getProperty().equalsIgnoreCase(propertyName)) continue;
            return d;
        }
        return null;
    }

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        throw new DOMException(9, "This operation is not supported");
    }

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        Declaration currDecl;
        if (!this.declarations.isEmpty() && (currDecl = this.getPropertyValueTerm(propertyName)) != null) {
            String val = currDecl.toString();
            int index = this.declarations.indexOf(currDecl);
            this.declarations.remove(index);
            JStyleSheetWrapper styleSheet = this.parentRule.containingStyleSheet;
            styleSheet.informChanged();
            return val;
        }
        return "";
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        throw new DOMException(9, "This operation is not supported");
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        StyleSheet jSheet = this.parseStyle(propertyName, value, priority);
        for (RuleBlock rule : jSheet) {
            RuleSet rs = (RuleSet)rule;
            for (Declaration decl : rs) {
                Declaration currDec = this.getPropertyValueTerm(propertyName);
                if (currDec == null) {
                    this.declarations.add(decl);
                    continue;
                }
                currDec.clear();
                currDec.addAll((Collection)decl);
            }
        }
    }

    @Override
    public int getLength() {
        return this.declarations.size();
    }

    @Override
    public String item(int index) {
        return this.declarations.get(index).getProperty();
    }

    @Override
    public CSSRule getParentRule() {
        return this.parentRule;
    }

    private StyleSheet parseStyle(String propertyName, String value, String priority) {
        return CSSUtils.parse("* { " + propertyName + ": " + value + "; }");
    }

    public String toString() {
        return this.declarations.toString();
    }
}

