/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList.rule;

import de.malkusch.whoisServerList.publicSuffixList.rule.LabelMatcher;
import de.malkusch.whoisServerList.publicSuffixList.util.DomainUtil;
import in.co.uproot.util.ArrayUtils;

final class RuleMatcher {
    private final String[] reversedLabels;

    RuleMatcher(String[] labels) {
        this.reversedLabels = (String[])labels.clone();
        ArrayUtils.reverse(this.reversedLabels);
    }

    RuleMatcher(String pattern) {
        this(DomainUtil.splitLabels(pattern));
    }

    String match(String domain) {
        if (domain == null) {
            return null;
        }
        String[] reversedDomainLabels = DomainUtil.splitLabels(domain);
        ArrayUtils.reverse(reversedDomainLabels);
        if (reversedDomainLabels.length < this.reversedLabels.length) {
            return null;
        }
        String[] reversedMatchedLabels = new String[this.reversedLabels.length];
        for (int i = 0; i < this.reversedLabels.length; ++i) {
            if (i > reversedDomainLabels.length) {
                return null;
            }
            String matchLabel = this.reversedLabels[i];
            LabelMatcher matcher = new LabelMatcher(matchLabel);
            String domainLabel = reversedDomainLabels[i];
            if (!matcher.isMatch(domainLabel)) {
                return null;
            }
            reversedMatchedLabels[i] = domainLabel;
        }
        ArrayUtils.reverse(reversedMatchedLabels);
        return DomainUtil.joinLabels(reversedMatchedLabels);
    }

    String getPattern() {
        String[] labels = (String[])this.reversedLabels.clone();
        ArrayUtils.reverse(labels);
        return DomainUtil.joinLabels(labels);
    }

    public String toString() {
        return this.getPattern();
    }
}

