/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.AlterTableAlterStep;
import org.jooq.AlterTableDropStep;
import org.jooq.AlterTableFinalStep;
import org.jooq.AlterTableStep;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DSL;

class AlterTableImpl
extends AbstractQuery
implements AlterTableStep,
AlterTableDropStep,
AlterTableAlterStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_TABLE};
    private final Table<?> table;
    private Field<?> add;
    private DataType<?> addType;
    private Field<?> alter;
    private DataType<?> alterType;
    private Field<?> alterDefault;
    private Field<?> drop;
    private boolean dropCascade;

    AlterTableImpl(Configuration configuration, Table<?> table) {
        super(configuration);
        this.table = table;
    }

    @Override
    public final AlterTableImpl add(String field, DataType<?> type) {
        return this.add((Field)DSL.field(field, type), (DataType)type);
    }

    @Override
    public final <T> AlterTableImpl add(Field<T> field, DataType<T> type) {
        this.add = field;
        this.addType = type;
        return this;
    }

    public final AlterTableImpl alter(String field) {
        return this.alter((Field)DSL.field(field));
    }

    public final <T> AlterTableImpl alter(Field<T> field) {
        this.alter = field;
        return this;
    }

    public final AlterTableImpl set(DataType type) {
        this.alterType = type;
        return this;
    }

    public final AlterTableImpl defaultValue(Object literal) {
        return this.defaultValue((Field)DSL.inline(literal));
    }

    public final AlterTableImpl defaultValue(Field expression) {
        this.alterDefault = expression;
        return this;
    }

    @Override
    public final AlterTableImpl drop(String field) {
        return this.drop((Field)DSL.field(field));
    }

    @Override
    public final AlterTableImpl drop(Field<?> field) {
        this.drop = field;
        return this;
    }

    @Override
    public final AlterTableFinalStep cascade() {
        this.dropCascade = true;
        return this;
    }

    @Override
    public final AlterTableFinalStep restrict() {
        this.dropCascade = false;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        SQLDialect family = ctx.configuration().dialect().family();
        this.accept0(ctx);
    }

    private final void accept0(Context<?> ctx) {
        SQLDialect family = ctx.configuration().dialect().family();
        ctx.start(Clause.ALTER_TABLE_TABLE).keyword("alter table").sql(" ").visit(this.table).end(Clause.ALTER_TABLE_TABLE);
        if (this.add != null) {
            ctx.start(Clause.ALTER_TABLE_ADD).sql(" ").keyword("add").sql(" ").qualify(false).visit(this.add).sql(" ").qualify(true).keyword(this.addType.getCastTypeName(ctx.configuration()));
            if (!this.addType.nullable()) {
                ctx.sql(" ").keyword("not null");
            } else if (family != SQLDialect.FIREBIRD) {
                ctx.sql(" ").keyword("null");
            }
            ctx.end(Clause.ALTER_TABLE_ADD);
        } else if (this.alter != null) {
            ctx.start(Clause.ALTER_TABLE_ALTER);
            switch (family) {
                case MARIADB: 
                case MYSQL: {
                    ctx.sql(" ").keyword("change column").sql(" ").qualify(false).visit(this.alter).qualify(true);
                    break;
                }
                default: {
                    ctx.sql(" ").keyword("alter");
                }
            }
            ctx.sql(" ").qualify(false).visit(this.alter).qualify(true);
            if (this.alterType != null) {
                switch (family) {
                    case POSTGRES: {
                        ctx.sql(" ").keyword("type");
                    }
                }
                ctx.sql(" ").keyword(this.alterType.getCastTypeName(ctx.configuration()));
                if (!this.alterType.nullable()) {
                    ctx.sql(" ").keyword("not null");
                }
            } else if (this.alterDefault != null) {
                ctx.start(Clause.ALTER_TABLE_ALTER_DEFAULT);
                switch (family) {
                    default: 
                }
                ctx.sql(" ").keyword("set default");
                ctx.sql(" ").visit(this.alterDefault).end(Clause.ALTER_TABLE_ALTER_DEFAULT);
            }
            ctx.end(Clause.ALTER_TABLE_ALTER);
        } else if (this.drop != null) {
            ctx.start(Clause.ALTER_TABLE_DROP);
            switch (family) {
                default: 
            }
            ctx.sql(" ").keyword("drop");
            ctx.sql(" ").qualify(false).visit(this.drop).qualify(true);
            if (this.dropCascade) {
                ctx.sql(" ").keyword("cascade");
            }
            ctx.end(Clause.ALTER_TABLE_DROP);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

