/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Connection;
import java.sql.SQLException;
import org.jooq.Batch;
import org.jooq.Configuration;
import org.jooq.Query;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.SettingsEnabledPreparedStatement;
import org.jooq.impl.Utils;

class BatchMultiple
implements Batch {
    private static final long serialVersionUID = -7337667281292354043L;
    private final Configuration configuration;
    private final Query[] queries;

    public BatchMultiple(Configuration configuration, Query ... queries) {
        this.configuration = configuration;
        this.queries = queries;
    }

    @Override
    public final int size() {
        return this.queries.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int[] execute() {
        DefaultExecuteContext ctx = new DefaultExecuteContext(this.configuration, this.queries);
        ExecuteListeners listener = new ExecuteListeners(ctx);
        Connection connection = ctx.connection();
        try {
            int[] nArray;
            ctx.statement(new SettingsEnabledPreparedStatement(connection));
            String[] batchSQL = ctx.batchSQL();
            for (int i = 0; i < this.queries.length; ++i) {
                listener.renderStart(ctx);
                batchSQL[i] = DSL.using(this.configuration).renderInlined(this.queries[i]);
                listener.renderEnd(ctx);
            }
            for (String sql : batchSQL) {
                ctx.sql(sql);
                listener.prepareStart(ctx);
                ctx.statement().addBatch(sql);
                listener.prepareEnd(ctx);
                ctx.sql(null);
            }
            try {
                listener.executeStart(ctx);
                int[] result = ctx.statement().executeBatch();
                int[] batchRows = ctx.batchRows();
                for (int i = 0; i < batchRows.length && i < result.length; ++i) {
                    batchRows[i] = result[i];
                }
                listener.executeEnd(ctx);
                nArray = result;
            }
            catch (Throwable throwable) {
                try {
                    Utils.consumeWarnings(ctx, listener);
                    throw throwable;
                }
                catch (RuntimeException e) {
                    ctx.exception(e);
                    listener.exception(ctx);
                    throw ctx.exception();
                }
                catch (SQLException e) {
                    ctx.sqlException(e);
                    listener.exception(ctx);
                    throw ctx.exception();
                }
            }
            Utils.consumeWarnings(ctx, listener);
            return nArray;
        }
        finally {
            Utils.safeClose(listener, ctx);
        }
    }
}

