/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Meta;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractKeys;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.TableImpl;
import org.jooq.tools.JooqLogger;

class MetaImpl
implements Meta,
Serializable {
    private static final long serialVersionUID = 3582980783173033809L;
    private static final JooqLogger log = JooqLogger.getLogger(MetaImpl.class);
    private final DSLContext create;
    private final Configuration configuration;
    private volatile transient DatabaseMetaData meta;

    MetaImpl(Configuration configuration) {
        this.create = DSL.using(configuration);
        this.configuration = configuration;
    }

    private final DatabaseMetaData meta() {
        if (this.meta == null) {
            ConnectionProvider provider = this.configuration.connectionProvider();
            Connection connection = null;
            try {
                connection = provider.acquire();
                this.meta = connection.getMetaData();
            }
            catch (SQLException e) {
                throw new DataAccessException("Error while accessing DatabaseMetaData", e);
            }
            finally {
                if (connection != null) {
                    provider.release(connection);
                }
            }
        }
        return this.meta;
    }

    @Override
    public final List<Catalog> getCatalogs() {
        try {
            ArrayList<Catalog> result = new ArrayList<Catalog>();
            if (!Arrays.asList(SQLDialect.MYSQL, SQLDialect.MARIADB).contains((Object)this.configuration.dialect().family())) {
                Result<Record> catalogs = this.create.fetch(this.meta().getCatalogs(), SQLDataType.VARCHAR);
                for (String name : catalogs.getValues(0, String.class)) {
                    result.add(new MetaCatalog(name));
                }
            }
            if (result.isEmpty()) {
                result.add(new MetaCatalog(""));
            }
            return result;
        }
        catch (SQLException e) {
            throw new DataAccessException("Error while accessing DatabaseMetaData", e);
        }
    }

    @Override
    public final List<Schema> getSchemas() {
        ArrayList<Schema> result = new ArrayList<Schema>();
        for (Catalog catalog : this.getCatalogs()) {
            result.addAll(catalog.getSchemas());
        }
        return result;
    }

    @Override
    public final List<Table<?>> getTables() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.getSchemas()) {
            result.addAll(schema.getTables());
        }
        return result;
    }

    @Override
    public final List<UniqueKey<?>> getPrimaryKeys() {
        ArrayList result = new ArrayList();
        for (Table<?> table : this.getTables()) {
            UniqueKey<?> pk = table.getPrimaryKey();
            if (pk == null) continue;
            result.add(pk);
        }
        return result;
    }

    private class MetaTable
    extends TableImpl<Record> {
        private static final long serialVersionUID = 4843841667753000233L;

        MetaTable(String name, Schema schema, Result<Record> columns) {
            super(name, schema);
            if (columns != null) {
                this.init(columns);
            }
        }

        @Override
        public final List<UniqueKey<Record>> getKeys() {
            return Collections.unmodifiableList(Arrays.asList(this.getPrimaryKey()));
        }

        @Override
        public final UniqueKey<Record> getPrimaryKey() {
            SQLDialect family = MetaImpl.this.configuration.dialect().family();
            String schema = this.getSchema() == null ? null : this.getSchema().getName();
            try {
                ResultSet rs = !Arrays.asList(SQLDialect.MYSQL, SQLDialect.MARIADB).contains((Object)family) ? MetaImpl.this.meta().getPrimaryKeys(null, schema, this.getName()) : MetaImpl.this.meta().getPrimaryKeys(schema, null, this.getName());
                Result<Record> result = MetaImpl.this.create.fetch(rs, String.class, String.class, String.class, String.class, Integer.TYPE, String.class);
                result.sortAsc(4);
                return this.createPrimaryKey(result, 3);
            }
            catch (SQLException e) {
                throw new DataAccessException("Error while accessing DatabaseMetaData", e);
            }
        }

        private final UniqueKey<Record> createPrimaryKey(Result<Record> result, int columnName) {
            if (result.size() > 0) {
                TableField[] fields = new TableField[result.size()];
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = (TableField)this.field(((Record)result.get(i)).getValue(columnName, String.class));
                }
                return AbstractKeys.createUniqueKey(this, fields);
            }
            return null;
        }

        private final void init(Result<Record> columns) {
            for (Record column : columns) {
                String columnName = column.getValue(3, String.class);
                String typeName = column.getValue(5, String.class);
                int precision = column.getValue(6, Integer.TYPE);
                int scale = column.getValue(8, Integer.TYPE);
                DataType<Object> type = null;
                try {
                    type = DefaultDataType.getDataType(MetaImpl.this.configuration.dialect(), typeName, precision, scale);
                    type = type.precision(precision, scale);
                    type = type.length(precision);
                }
                catch (SQLDialectNotSupportedException e) {
                    type = SQLDataType.OTHER;
                }
                MetaTable.createField(columnName, type, this);
            }
        }
    }

    private class MetaSchema
    extends SchemaImpl {
        private static final long serialVersionUID = -2621899850912554198L;
        private volatile transient List<Table<?>> tableCache;
        private volatile transient Map<Name, Result<Record>> columnCache;

        MetaSchema(String name) {
            super(name);
        }

        @Override
        public final synchronized List<Table<?>> getTables() {
            if (this.tableCache != null) {
                return this.tableCache;
            }
            try {
                String[] types = null;
                switch (MetaImpl.this.configuration.dialect().family()) {
                    case SQLITE: {
                        types = new String[]{"TABLE", "VIEW"};
                    }
                }
                ResultSet rs = !Arrays.asList(SQLDialect.MYSQL, SQLDialect.MARIADB).contains((Object)MetaImpl.this.configuration.dialect().family()) ? MetaImpl.this.meta().getTables(null, this.getName(), "%", types) : MetaImpl.this.meta().getTables(this.getName(), null, "%", types);
                ArrayList result = new ArrayList();
                Result<Record> tables = MetaImpl.this.create.fetch(rs, SQLDataType.VARCHAR, SQLDataType.VARCHAR, SQLDataType.VARCHAR, SQLDataType.VARCHAR);
                for (Record table : tables) {
                    String schema = table.getValue(1, String.class);
                    String name = table.getValue(2, String.class);
                    result.add(new MetaTable(name, this, this.getColumns(schema, name)));
                }
                return result;
            }
            catch (SQLException e) {
                throw new DataAccessException("Error while accessing DatabaseMetaData", e);
            }
        }

        private final Result<Record> getColumns(String schema, String table) throws SQLException {
            if (this.columnCache == null && MetaImpl.this.configuration.dialect() != SQLDialect.SQLITE) {
                Result<Record> columns = this.getColumns0(schema, "%");
                Field<?> tableSchem = columns.field(1);
                Field<?> tableName = columns.field(2);
                Map<Record, Result<Record>> groups = columns.intoGroups(new Field[]{tableSchem, tableName});
                this.columnCache = new LinkedHashMap<Name, Result<Record>>();
                for (Map.Entry<Record, Result<Record>> entry : groups.entrySet()) {
                    Record key = entry.getKey();
                    Result<Record> value = entry.getValue();
                    this.columnCache.put(DSL.name((String)key.getValue(tableSchem), (String)key.getValue(tableName)), value);
                }
            }
            if (this.columnCache != null) {
                return this.columnCache.get(DSL.name(schema, table));
            }
            return this.getColumns0(schema, table);
        }

        private final Result<Record> getColumns0(String schema, String table) throws SQLException {
            ResultSet rs = !Arrays.asList(SQLDialect.MYSQL, SQLDialect.MARIADB).contains((Object)MetaImpl.this.configuration.dialect().family()) ? MetaImpl.this.meta().getColumns(null, schema, table, "%") : MetaImpl.this.meta().getColumns(schema, null, table, "%");
            return MetaImpl.this.create.fetch(rs, String.class, String.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE, String.class, Integer.TYPE);
        }
    }

    private class MetaCatalog
    extends CatalogImpl {
        private static final long serialVersionUID = -2821093577201327275L;

        MetaCatalog(String name) {
            super(name);
        }

        @Override
        public final List<Schema> getSchemas() {
            try {
                ArrayList<Schema> result = new ArrayList<Schema>();
                if (!Arrays.asList(SQLDialect.MYSQL, SQLDialect.MARIADB).contains((Object)MetaImpl.this.configuration.dialect().family())) {
                    Result<Record> schemas = MetaImpl.this.create.fetch(MetaImpl.this.meta().getSchemas(), SQLDataType.VARCHAR);
                    for (String name : schemas.getValues(0, String.class)) {
                        result.add(new MetaSchema(name));
                    }
                } else {
                    Result<Record> schemas = MetaImpl.this.create.fetch(MetaImpl.this.meta().getCatalogs(), SQLDataType.VARCHAR);
                    for (String name : schemas.getValues(0, String.class)) {
                        result.add(new MetaSchema(name));
                    }
                }
                if (result.isEmpty()) {
                    result.add(new MetaSchema(""));
                }
                return result;
            }
            catch (SQLException e) {
                throw new DataAccessException("Error while accessing DatabaseMetaData", e);
            }
        }
    }
}

