/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.csskit.antlr.CSSLexerState;
import cz.vutbr.web.csskit.antlr.CSSToken;
import cz.vutbr.web.csskit.antlr.TreeUtil;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.slf4j.Logger;

public class CSSTreeNodeRecovery {
    private final Parser parser;
    private final TokenStream input;
    private final RecognizerSharedState state;
    private final TreeAdaptor adaptor;
    private final Logger log;

    public CSSTreeNodeRecovery(Parser parser, TokenStream input, RecognizerSharedState state, TreeAdaptor adaptor, Logger log) {
        this.parser = parser;
        this.input = input;
        this.state = state;
        this.adaptor = adaptor;
        this.log = log;
    }

    public Object invalidFallback(int ttype, String ttext, RecognitionException re) {
        this.parser.reportError(re);
        this.parser.recover((IntStream)this.input, re);
        return this.invalidReplacement(ttype, ttext);
    }

    public Object invalidFallbackGreedy(int ttype, String ttext, BitSet follow, RecognitionException re) {
        this.parser.reportError(re);
        if (this.state.lastErrorIndex == this.input.index()) {
            this.input.consume();
        }
        this.state.lastErrorIndex = this.input.index();
        this.parser.beginResync();
        this.consumeUntilGreedy(this.input, follow);
        this.parser.endResync();
        return this.invalidReplacement(ttype, ttext);
    }

    public Object invalidFallback(int ttype, String ttext, BitSet follow, CSSLexerState.RecoveryMode mode, CSSLexerState ls, RecognitionException re) {
        this.parser.reportError(re);
        if (this.state.lastErrorIndex == this.input.index()) {
            this.input.consume();
        }
        this.state.lastErrorIndex = this.input.index();
        this.parser.beginResync();
        this.consumeUntil(this.input, follow, mode, ls);
        this.parser.endResync();
        return this.invalidReplacement(ttype, ttext);
    }

    public Object invalidFallbackGreedy(int ttype, String ttext, BitSet follow, CSSLexerState.RecoveryMode mode, CSSLexerState ls, RecognitionException re) {
        this.parser.reportError(re);
        if (this.state.lastErrorIndex == this.input.index()) {
            this.input.consume();
        }
        this.state.lastErrorIndex = this.input.index();
        this.parser.beginResync();
        this.consumeUntilGreedy(this.input, follow, mode, ls);
        this.parser.endResync();
        return this.invalidReplacement(ttype, ttext);
    }

    private Object invalidReplacement(int ttype, String ttext) {
        Object root = this.adaptor.nil();
        Object node = this.adaptor.create(ttype, ttext);
        this.adaptor.addChild(root, node);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Invalid fallback with: {}", (Object)TreeUtil.toStringTree((CommonTree)root));
        }
        return root;
    }

    private void consumeUntilGreedy(TokenStream input, BitSet follow) {
        Token next;
        CSSToken t = null;
        while ((next = input.LT(1)) instanceof CSSToken) {
            t = (CSSToken)input.LT(1);
            this.log.trace("Skipped greedy: {} follow: {}", (Object)t, (Object)follow);
            input.consume();
            if (!t.getLexerState().isBalanced() || !follow.member(t.getType())) continue;
        }
    }

    private void consumeUntilGreedy(TokenStream input, BitSet follow, CSSLexerState.RecoveryMode mode, CSSLexerState ls) {
        Token next;
        CSSToken t = null;
        while ((next = input.LT(1)) instanceof CSSToken) {
            t = (CSSToken)input.LT(1);
            this.log.trace("Skipped greedy: {}", (Object)t);
            input.consume();
            if (!t.getLexerState().isBalanced(mode, ls, t) || !follow.member(t.getType())) continue;
        }
    }

    private void consumeUntil(TokenStream input, BitSet follow, CSSLexerState.RecoveryMode mode, CSSLexerState ls) {
        Token next;
        CSSToken t = null;
        boolean finish = false;
        while ((next = input.LT(1)) instanceof CSSToken) {
            t = (CSSToken)input.LT(1);
            boolean bl = finish = t.getLexerState().isBalanced(mode, ls, t) && follow.member(t.getType());
            if (!finish) {
                this.log.trace("Skipped: {}", (Object)t);
                input.consume();
            }
            if (!finish) continue;
        }
    }
}

