/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.MatchCondition;
import cz.vutbr.web.css.MediaSpec;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.ElementUtil;
import cz.vutbr.web.domassign.AnalyzerUtil;
import cz.vutbr.web.domassign.AssignedDeclaration;
import cz.vutbr.web.domassign.DeclarationMap;
import cz.vutbr.web.domassign.StyleMap;
import cz.vutbr.web.domassign.Traversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class Analyzer {
    private static final Logger log = LoggerFactory.getLogger(Analyzer.class);
    protected List<StyleSheet> sheets;
    protected int currentOrder;
    protected Holder rules;
    private MatchCondition matchCond = null;

    public Analyzer(StyleSheet sheet) {
        this.sheets = new ArrayList<StyleSheet>(1);
        this.sheets.add(sheet);
    }

    public Analyzer(List<StyleSheet> sheets) {
        this.sheets = sheets;
    }

    public final void registerMatchCondition(MatchCondition matchCond) {
        this.matchCond = matchCond;
    }

    public final MatchCondition getMatchCondition() {
        return this.matchCond;
    }

    public StyleMap evaluateDOM(Document doc, MediaSpec media, final boolean inherit) {
        DeclarationMap declarations = this.assingDeclarationsToDOM(doc, media, inherit);
        StyleMap nodes = new StyleMap(declarations.size());
        Traversal<StyleMap> traversal = new Traversal<StyleMap>(doc, (Object)declarations, 1){

            @Override
            protected void processNode(StyleMap result, Node current, Object source) {
                NodeData main = CSSFactory.createNodeData();
                List declarations = (List)((DeclarationMap)source).get((Element)current, null);
                if (declarations != null) {
                    for (Declaration d : declarations) {
                        main.push(d);
                    }
                    if (inherit) {
                        main.inheritFrom((NodeData)result.get((Element)this.walker.parentNode(), null));
                    }
                }
                result.put((Element)current, null, main.concretize());
                for (Selector.PseudoDeclaration pseudo : ((DeclarationMap)source).pseudoSet((Element)current)) {
                    NodeData pdata = CSSFactory.createNodeData();
                    declarations = (List)((DeclarationMap)source).get((Element)current, pseudo);
                    if (declarations != null) {
                        for (Declaration d : declarations) {
                            pdata.push(d);
                        }
                        pdata.inheritFrom(main);
                    }
                    result.put((Element)current, pseudo, pdata.concretize());
                }
            }
        };
        traversal.levelTraversal(nodes);
        return nodes;
    }

    public StyleMap evaluateDOM(Document doc, String media, boolean inherit) {
        return this.evaluateDOM(doc, new MediaSpec(media), inherit);
    }

    protected DeclarationMap assingDeclarationsToDOM(Document doc, MediaSpec media, boolean inherit) {
        this.classifyAllSheets(media);
        DeclarationMap declarations = new DeclarationMap();
        if (this.rules != null && !this.rules.isEmpty()) {
            Traversal<DeclarationMap> traversal = new Traversal<DeclarationMap>(doc, (Object)this.rules, 1){

                @Override
                protected void processNode(DeclarationMap result, Node current, Object source) {
                    Analyzer.this.assignDeclarationsToElement(result, this.walker, (Element)current, (Holder)source);
                }
            };
            if (!inherit) {
                traversal.listTraversal(declarations);
            } else {
                traversal.levelTraversal(declarations);
            }
        }
        return declarations;
    }

    protected void assignDeclarationsToElement(DeclarationMap declarations, TreeWalker walker, Element e, Holder holder) {
        List<OrderedRule> rules;
        List<OrderedRule> rules2;
        if (log.isDebugEnabled()) {
            log.debug("Traversal of {} {}.", (Object)e.getNodeName(), (Object)e.getNodeValue());
        }
        HashSet<OrderedRule> candidates = new HashSet<OrderedRule>();
        for (String cname : ElementUtil.elementClasses(e)) {
            rules2 = holder.get(HolderItem.CLASS, cname.toLowerCase());
            if (rules2 == null) continue;
            candidates.addAll(rules2);
        }
        log.trace("After CLASSes {} total candidates.", (Object)candidates.size());
        String id = ElementUtil.elementID(e);
        if (id != null && id.length() != 0 && (rules = holder.get(HolderItem.ID, id.toLowerCase())) != null) {
            candidates.addAll(rules);
        }
        log.trace("After IDs {} total candidates.", (Object)candidates.size());
        String name = ElementUtil.elementName(e);
        if (name != null && (rules2 = holder.get(HolderItem.ELEMENT, name.toLowerCase())) != null) {
            candidates.addAll(rules2);
        }
        log.trace("After ELEMENTs {} total candidates.", (Object)candidates.size());
        candidates.addAll(holder.get(HolderItem.OTHER, null));
        ArrayList clist = new ArrayList(candidates);
        Collections.sort(clist);
        log.debug("Totally {} candidates.", (Object)candidates.size());
        log.trace("With values: {}", clist);
        ArrayList<AssignedDeclaration> eldecl = new ArrayList<AssignedDeclaration>();
        HashSet<Selector.PseudoDeclaration> pseudos = new HashSet<Selector.PseudoDeclaration>();
        for (OrderedRule orule : clist) {
            RuleSet rule = orule.getRule();
            StyleSheet sheet = rule.getStyleSheet();
            if (sheet == null) {
                log.warn("No source style sheet set for rule: {}", (Object)rule.toString());
            }
            StyleSheet.Origin origin = sheet == null ? StyleSheet.Origin.AGENT : sheet.getOrigin();
            CombinedSelector[] combinedSelectorArray = rule.getSelectors();
            int n = combinedSelectorArray.length;
            int n2 = 0;
            while (n2 < n) {
                CombinedSelector s = combinedSelectorArray[n2];
                if (!this.matchSelector(s, e, walker)) {
                    log.trace("CombinedSelector \"{}\" NOT matched!", (Object)s);
                } else {
                    log.trace("CombinedSelector \"{}\" matched", (Object)s);
                    Selector.PseudoDeclaration pseudo = s.getPseudoElement();
                    CombinedSelector.Specificity spec = s.computeSpecificity();
                    if (pseudo == null) {
                        for (Declaration d : rule) {
                            eldecl.add(new AssignedDeclaration(d, spec, origin));
                        }
                    } else {
                        pseudos.add(pseudo);
                        for (Declaration d : rule) {
                            declarations.addDeclaration(e, pseudo, new AssignedDeclaration(d, spec, origin));
                        }
                    }
                }
                ++n2;
            }
        }
        Collections.sort(eldecl);
        log.debug("Sorted {} declarations.", (Object)eldecl.size());
        log.trace("With values: {}", eldecl);
        for (Selector.PseudoDeclaration p : pseudos) {
            declarations.sortDeclarations(e, p);
        }
        declarations.put(e, null, eldecl);
    }

    protected boolean elementSelectorMatches(Selector s, Element e) {
        return this.matchCond == null ? s.matches(e) : s.matches(e, this.matchCond);
    }

    protected boolean matchSelector(CombinedSelector sel, Element e, TreeWalker w) {
        Node current = w.getCurrentNode();
        boolean retval = false;
        Selector.Combinator combinator = null;
        int i = sel.size() - 1;
        while (i >= 0) {
            Selector s = (Selector)sel.get(i);
            if (combinator == null) {
                retval = this.elementSelectorMatches(s, e);
            } else if (combinator == Selector.Combinator.ADJACENT) {
                Element adjacent = (Element)w.previousSibling();
                retval = false;
                if (adjacent != null) {
                    retval = this.elementSelectorMatches(s, adjacent);
                }
            } else if (combinator == Selector.Combinator.PRECEDING) {
                Element preceding;
                retval = false;
                while (!retval && (preceding = (Element)w.previousSibling()) != null) {
                    retval = this.elementSelectorMatches(s, preceding);
                }
            } else if (combinator == Selector.Combinator.DESCENDANT) {
                Element ancestor;
                retval = false;
                while (!retval && (ancestor = (Element)w.parentNode()) != null) {
                    retval = this.elementSelectorMatches(s, ancestor);
                }
            } else if (combinator == Selector.Combinator.CHILD) {
                Element parent = (Element)w.parentNode();
                retval = false;
                if (parent != null) {
                    retval = this.elementSelectorMatches(s, parent);
                }
            }
            combinator = s.getCombinator();
            if (!retval) break;
            --i;
        }
        w.setCurrentNode(current);
        return retval;
    }

    protected void classifyAllSheets(MediaSpec mediaspec) {
        this.rules = new Holder();
        AnalyzerUtil.classifyAllSheets(this.sheets, this.rules, mediaspec);
    }

    public static class Holder {
        private List<Map<String, List<OrderedRule>>> items = new ArrayList<Map<String, List<OrderedRule>>>(HolderItem.values().length - 1);
        private List<OrderedRule> others;

        public Holder() {
            HolderItem[] holderItemArray = HolderItem.values();
            int n = holderItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                HolderItem hi = holderItemArray[n2];
                if (hi == HolderItem.OTHER) {
                    this.others = new ArrayList<OrderedRule>();
                } else {
                    this.items.add(new HashMap());
                }
                ++n2;
            }
        }

        public boolean isEmpty() {
            HolderItem[] holderItemArray = HolderItem.values();
            int n = holderItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                HolderItem hi = holderItemArray[n2];
                if (hi == HolderItem.OTHER ? !this.others.isEmpty() : !this.items.get(hi.type).isEmpty()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public static Holder union(Holder one, Holder two) {
            Holder union = new Holder();
            if (one == null) {
                one = new Holder();
            }
            if (two == null) {
                two = new Holder();
            }
            HolderItem[] holderItemArray = HolderItem.values();
            int n = holderItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                HolderItem hi = holderItemArray[n2];
                if (hi == HolderItem.OTHER) {
                    union.others.addAll(one.others);
                    union.others.addAll(two.others);
                } else {
                    Map<String, List<OrderedRule>> oneMap = one.items.get(hi.type);
                    Map<String, List<OrderedRule>> twoMap = two.items.get(hi.type);
                    Map<String, List<OrderedRule>> unionMap = union.items.get(hi.type);
                    unionMap.putAll(oneMap);
                    for (String key : twoMap.keySet()) {
                        if (unionMap.containsKey(key)) {
                            unionMap.get(key).addAll((Collection<OrderedRule>)twoMap.get(key));
                            continue;
                        }
                        unionMap.put(key, twoMap.get(key));
                    }
                }
                ++n2;
            }
            return union;
        }

        public void insert(HolderItem item, String key, OrderedRule value) {
            if (item == HolderItem.OTHER) {
                this.others.add(value);
                return;
            }
            Map<String, List<OrderedRule>> map = this.items.get(item.type);
            List<OrderedRule> list = map.get(key);
            if (list == null) {
                list = new ArrayList<OrderedRule>();
                map.put(key, list);
            }
            list.add(value);
        }

        public List<OrderedRule> get(HolderItem item, String key) {
            if (item == HolderItem.OTHER) {
                return this.others;
            }
            return this.items.get(item.type()).get(key);
        }

        public String contentCount() {
            StringBuilder sb = new StringBuilder();
            HolderItem[] holderItemArray = HolderItem.values();
            int n = holderItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                HolderItem hi = holderItemArray[n2];
                if (hi == HolderItem.OTHER) {
                    sb.append(hi.name()).append(": ").append(this.others.size()).append(" ");
                } else {
                    sb.append(hi.name()).append(":").append(this.items.get(hi.type).size()).append(" ");
                }
                ++n2;
            }
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            HolderItem[] holderItemArray = HolderItem.values();
            int n = holderItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                HolderItem hi = holderItemArray[n2];
                if (hi == HolderItem.OTHER) {
                    sb.append(hi.name()).append(" (").append(this.others.size()).append("): ").append(this.others).append("\n");
                } else {
                    sb.append(hi.name()).append(" (").append(this.items.get(hi.type).size()).append("): ").append(this.items.get(hi.type)).append("\n");
                }
                ++n2;
            }
            return sb.toString();
        }
    }

    protected static enum HolderItem {
        ELEMENT(0),
        ID(1),
        CLASS(2),
        OTHER(3);

        private int type;

        private HolderItem(int type) {
            this.type = type;
        }

        public int type() {
            return this.type;
        }
    }

    protected static class HolderSelector {
        public HolderItem item;
        public String key;

        public HolderSelector(HolderItem item, String key) {
            this.item = item;
            this.key = key;
        }
    }

    public static final class OrderedRule
    implements Comparable<OrderedRule> {
        private final RuleSet rule;
        private final int order;

        public OrderedRule(RuleSet rule, int order) {
            this.rule = rule;
            this.order = order;
        }

        public RuleSet getRule() {
            return this.rule;
        }

        public int getOrder() {
            return this.order;
        }

        @Override
        public int compareTo(OrderedRule o) {
            return this.getOrder() - o.getOrder();
        }

        public String toString() {
            return "OR" + this.order + ", " + this.rule;
        }
    }
}

