/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.InsertQuery;
import org.jooq.Record;
import org.jooq.Row;
import org.jooq.StoreQuery;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableRecord;
import org.jooq.UpdatableRecord;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.Fields;
import org.jooq.impl.RecordDelegate;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.RowImpl;
import org.jooq.impl.Utils;

public class TableRecordImpl<R extends TableRecord<R>>
extends AbstractRecord
implements TableRecord<R> {
    private static final long serialVersionUID = 3216746611562261641L;
    private final Table<R> table;

    public TableRecordImpl(Table<R> table) {
        super(table.fields());
        this.table = table;
    }

    @Override
    public final Table<R> getTable() {
        return this.table;
    }

    @Override
    public Row fieldsRow() {
        return this.fields;
    }

    @Override
    public Row valuesRow() {
        return new RowImpl(Utils.fields(this.intoArray(), this.fields.fields.fields()));
    }

    @Override
    public final R original() {
        return (R)((TableRecord)super.original());
    }

    @Override
    public final <O extends UpdatableRecord<O>> O fetchParent(ForeignKey<R, O> key) {
        return (O)((UpdatableRecord)key.fetchParent(this));
    }

    @Override
    public final int insert() {
        return this.insert(this.fields.fields.fields);
    }

    @Override
    public final int insert(Field<?> ... storeFields) {
        return this.storeInsert(storeFields);
    }

    final int storeInsert(final Field<?>[] storeFields) {
        final int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.INSERT).operate(new RecordOperation<Record, RuntimeException>(){

            @Override
            public Record operate(Record record) throws RuntimeException {
                result[0] = TableRecordImpl.this.storeInsert0(storeFields);
                return record;
            }
        });
        return result[0];
    }

    final int storeInsert0(Field<?>[] storeFields) {
        int result;
        DSLContext create = this.create();
        InsertQuery<R> insert = create.insertQuery(this.getTable());
        this.addChangedValues(storeFields, insert);
        if (!insert.isExecutable()) {
            return 0;
        }
        BigInteger version = this.addRecordVersion(insert);
        Timestamp timestamp = this.addRecordTimestamp(insert);
        Collection<Field<?>> key = null;
        if (!Boolean.TRUE.equals(create.configuration().data("org.jooq.configuration.omit-returning-clause"))) {
            key = this.getReturning();
            insert.setReturning(key);
        }
        if ((result = insert.execute()) > 0) {
            this.setRecordVersionAndTimestamp(version, timestamp);
            if (key != null && !key.isEmpty() && insert.getReturnedRecord() != null) {
                for (Field field : key) {
                    int index = Utils.indexOrFail(this.fieldsRow(), field);
                    Object value = ((TableRecord)insert.getReturnedRecord()).getValue(field);
                    this.values[index] = value;
                    this.originals[index] = value;
                }
            }
            for (Field<?> storeField : storeFields) {
                this.changed(storeField, false);
            }
            this.fetched = true;
        }
        return result;
    }

    final void setRecordVersionAndTimestamp(BigInteger version, Timestamp timestamp) {
        Object value;
        int fieldIndex;
        TableField<R, Serializable> field;
        if (version != null) {
            field = this.getTable().getRecordVersion();
            fieldIndex = Utils.indexOrFail(this.fieldsRow(), field);
            value = field.getDataType().convert((Object)version);
            this.values[fieldIndex] = value;
            this.originals[fieldIndex] = value;
            this.changed.clear(fieldIndex);
        }
        if (timestamp != null) {
            field = this.getTable().getRecordTimestamp();
            fieldIndex = Utils.indexOrFail(this.fieldsRow(), field);
            value = field.getDataType().convert((Object)timestamp);
            this.values[fieldIndex] = value;
            this.originals[fieldIndex] = value;
            this.changed.clear(fieldIndex);
        }
    }

    final void addChangedValues(Field<?>[] storeFields, StoreQuery<R> query) {
        Fields f = new Fields(storeFields);
        for (Field<?> field : this.fields.fields.fields) {
            if (!this.changed(field) || f.field(field) == null) continue;
            this.addValue(query, field);
        }
    }

    final <T> void addValue(StoreQuery<?> store, Field<T> field, Object value) {
        store.addValue(field, Utils.field(value, field));
    }

    final <T> void addValue(StoreQuery<?> store, Field<T> field) {
        this.addValue(store, field, this.getValue(field));
    }

    final Timestamp addRecordTimestamp(StoreQuery<?> store) {
        TableField<R, Date> timestamp;
        Timestamp result = null;
        if (this.isTimestampOrVersionAvailable() && (timestamp = this.getTable().getRecordTimestamp()) != null) {
            result = new Timestamp(System.currentTimeMillis());
            this.addValue(store, timestamp, result);
        }
        return result;
    }

    final BigInteger addRecordVersion(StoreQuery<?> store) {
        TableField<R, Number> version;
        BigInteger result = null;
        if (this.isTimestampOrVersionAvailable() && (version = this.getTable().getRecordVersion()) != null) {
            Number value = (Number)this.getValue(version);
            result = value == null ? BigInteger.ONE : new BigInteger(value.toString()).add(BigInteger.ONE);
            this.addValue(store, version, result);
        }
        return result;
    }

    final boolean isTimestampOrVersionAvailable() {
        return this.getTable().getRecordTimestamp() != null || this.getTable().getRecordVersion() != null;
    }

    final Collection<Field<?>> getReturning() {
        LinkedHashSet result = new LinkedHashSet();
        Identity<R, Number> identity = this.getTable().getIdentity();
        if (identity != null) {
            result.add(identity.getField());
        }
        result.addAll(this.getPrimaryKey().getFields());
        return result;
    }
}

