/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.tools.jdbc;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Statement;
import org.jooq.SQLDialect;

public class JDBCUtils {
    public static final SQLDialect dialect(Connection connection) {
        SQLDialect result = SQLDialect.SQL99;
        try {
            DatabaseMetaData m = connection.getMetaData();
            String url = m.getURL();
            result = JDBCUtils.dialect(url);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (result == SQLDialect.SQL99) {
            // empty if block
        }
        return result;
    }

    public static final SQLDialect dialect(String url) {
        if (url.startsWith("jdbc:cubrid:")) {
            return SQLDialect.CUBRID;
        }
        if (url.startsWith("jdbc:derby:")) {
            return SQLDialect.DERBY;
        }
        if (url.startsWith("jdbc:firebirdsql:")) {
            return SQLDialect.FIREBIRD;
        }
        if (url.startsWith("jdbc:h2:")) {
            return SQLDialect.H2;
        }
        if (url.startsWith("jdbc:hsqldb:")) {
            return SQLDialect.HSQLDB;
        }
        if (url.startsWith("jdbc:mariadb:")) {
            return SQLDialect.MARIADB;
        }
        if (url.startsWith("jdbc:mysql:") || url.startsWith("jdbc:google:")) {
            return SQLDialect.MYSQL;
        }
        if (url.startsWith("jdbc:postgresql:")) {
            return SQLDialect.POSTGRES;
        }
        if (url.startsWith("jdbc:sqlite:")) {
            return SQLDialect.SQLITE;
        }
        return SQLDialect.SQL99;
    }

    public static final void safeClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void safeClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void safeClose(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void safeClose(ResultSet resultSet, PreparedStatement statement) {
        JDBCUtils.safeClose(resultSet);
        JDBCUtils.safeClose(statement);
    }

    public static final void safeFree(Blob blob) {
        if (blob != null) {
            try {
                blob.free();
            }
            catch (Exception ignore) {
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
    }

    public static final void safeFree(Clob clob) {
        if (clob != null) {
            try {
                clob.free();
            }
            catch (Exception ignore) {
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
    }

    public static final <T> T wasNull(SQLInput stream, T value) throws SQLException {
        return stream.wasNull() ? null : (T)value;
    }

    public static final <T> T wasNull(ResultSet rs, T value) throws SQLException {
        return rs.wasNull() ? null : (T)value;
    }

    public static final <T> T wasNull(CallableStatement statement, T value) throws SQLException {
        return statement.wasNull() ? null : (T)value;
    }

    private JDBCUtils() {
    }
}

