# Contributing to gngr

### Avoid +1s on issues
Please avoid spamming issues with `+1`s. Unfortunately, Github doesn't have a way to vote on an issue. Shoot a mail to
[them](mailto:support@github.com) if you agree that ability to vote on an issue is essential.

### Testing and reporting issues
This is the simplest way of contributing to `gngr`: use it and when you find bugs shoot us an issue report on GitHub.

We also need help in running systematic tests (such as tests from W3C). We will write more about that later.

### Triaging
When an issue is reported by a user, we need help in diagnosing the root cause and breaking it down to a small
test-case. This often requires familiarity with the browser stack (HTTP, HTML, CSS, JS, etc), while knowledge of
`gngr`'s implementation is usually not required.

To help with triaging, [search for issues with the `need-triage` label](https://github.com/UprootLabs/gngr/labels/need-triage).

### Advice
We often need advice / guidance from experts in browser and related technologies.
Please [search for issues with the `need-advice` label](https://github.com/UprootLabs/gngr/labels/need-advice).

### Code
Everyone is welcome to contribute. Issues that can be easily picked up are marked with the
following tags:
* [need-code](https://github.com/UprootLabs/gngr/labels/need-code) : if you are ready to jump in with code.
* [need-advice](https://github.com/UprootLabs/gngr/labels/need-advice) : if you have expertise on the topic.
* [need-triage](https://github.com/UprootLabs/gngr/labels/need-triage) : if you would like to help test or analyse a particular issue.

Ofcourse, you are welcome to take up something that is not listed above, but please co-ordinate with us first
before you spend effort on it.

You can also contribute to our [upstream projects](https://gngr.info/doc/credits.html).
