/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.beans.ConstructorProperties;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jooq.Attachable;
import org.jooq.AttachableInternal;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.RecordType;
import org.jooq.exception.MappingException;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.Utils;
import org.jooq.tools.Convert;
import org.jooq.tools.reflect.Reflect;

public class DefaultRecordMapper<R extends Record, E>
implements RecordMapper<R, E> {
    private final Field<?>[] fields;
    private final Class<? extends E> type;
    private final Configuration configuration;
    private transient E instance;
    private RecordMapper<R, E> delegate;

    public DefaultRecordMapper(RecordType<R> rowType, Class<? extends E> type) {
        this(rowType, type, null, null);
    }

    DefaultRecordMapper(RecordType<R> rowType, Class<? extends E> type, Configuration configuration) {
        this(rowType, type, null, configuration);
    }

    DefaultRecordMapper(RecordType<R> rowType, Class<? extends E> type, E instance) {
        this(rowType, type, (E)instance, null);
    }

    DefaultRecordMapper(RecordType<R> rowType, Class<? extends E> type, E instance, Configuration configuration) {
        this.fields = rowType.fields();
        this.type = type;
        this.instance = instance;
        this.configuration = configuration;
        this.init();
    }

    private final void init() {
        if (this.type.isArray()) {
            this.delegate = new ArrayMapper();
            return;
        }
        if (this.type.isPrimitive() || DefaultDataType.types().contains(this.type)) {
            this.delegate = new ValueTypeMapper();
            return;
        }
        if (Modifier.isAbstract(this.type.getModifiers())) {
            this.delegate = new ProxyMapper();
            return;
        }
        if (AbstractRecord.class.isAssignableFrom(this.type)) {
            this.delegate = new RecordToRecordMapper();
            return;
        }
        try {
            this.delegate = new MutablePOJOMapper(this.type.getDeclaredConstructor(new Class[0]));
            return;
        }
        catch (NoSuchMethodException ignore) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = this.type.getDeclaredConstructors()) {
                ConstructorProperties properties = constructor.getAnnotation(ConstructorProperties.class);
                if (properties == null) continue;
                this.delegate = new ImmutablePOJOMapperWithConstructorProperties(constructor, properties);
                return;
            }
            for (Constructor<?> constructor : constructors) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != this.fields.length) continue;
                this.delegate = new ImmutablePOJOMapper(constructor, parameterTypes);
                return;
            }
            throw new MappingException("No matching constructor found on type " + this.type + " for record " + this);
        }
    }

    @Override
    public final E map(R record) {
        if (record == null) {
            return null;
        }
        try {
            return DefaultRecordMapper.attach(this.delegate.map(record), record);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingException("An error ocurred when mapping record to " + this.type, e);
        }
    }

    private static <E> E attach(E attachable, Record record) {
        if (attachable instanceof Attachable && record instanceof AttachableInternal) {
            Attachable a = (Attachable)attachable;
            AttachableInternal r = (AttachableInternal)((Object)record);
            if (Utils.attachRecords(r.configuration())) {
                a.attach(r.configuration());
            }
        }
        return attachable;
    }

    private class ImmutablePOJOMapperWithConstructorProperties
    implements RecordMapper<R, E> {
        private final Constructor<E> constructor;
        private final Class<?>[] parameterTypes;
        private final Object[] parameterValues;
        private final List<String> propertyNames;
        private final boolean useAnnotations;
        private final List<java.lang.reflect.Field>[] members;
        private final Method[] methods;

        ImmutablePOJOMapperWithConstructorProperties(Constructor<E> constructor, ConstructorProperties properties) {
            this.constructor = constructor;
            this.propertyNames = Arrays.asList(properties.value());
            this.useAnnotations = Utils.hasColumnAnnotations(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type);
            this.parameterTypes = constructor.getParameterTypes();
            this.parameterValues = new Object[this.parameterTypes.length];
            this.members = new List[DefaultRecordMapper.this.fields.length];
            this.methods = new Method[DefaultRecordMapper.this.fields.length];
            for (int i = 0; i < DefaultRecordMapper.this.fields.length; ++i) {
                Field field = DefaultRecordMapper.this.fields[i];
                if (this.useAnnotations) {
                    this.members[i] = Utils.getAnnotatedMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, field.getName());
                    this.methods[i] = Utils.getAnnotatedGetter(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, field.getName());
                    continue;
                }
                this.members[i] = Utils.getMatchingMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, field.getName());
                this.methods[i] = Utils.getMatchingGetter(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, field.getName());
            }
        }

        @Override
        public final E map(R record) {
            try {
                for (int i = 0; i < DefaultRecordMapper.this.fields.length; ++i) {
                    String name;
                    int index;
                    for (java.lang.reflect.Field member : this.members[i]) {
                        int index2 = this.propertyNames.indexOf(member.getName());
                        if (index2 < 0) continue;
                        this.parameterValues[index2] = record.getValue(i);
                    }
                    if (this.methods[i] == null || (index = this.propertyNames.indexOf(name = Utils.getPropertyName(this.methods[i].getName()))) < 0) continue;
                    this.parameterValues[index] = record.getValue(i);
                }
                Object[] converted = Convert.convert(this.parameterValues, this.parameterTypes);
                return Reflect.accessible(this.constructor).newInstance(converted);
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record to " + DefaultRecordMapper.this.type, e);
            }
        }
    }

    private class ImmutablePOJOMapper
    implements RecordMapper<R, E> {
        private final Constructor<E> constructor;
        private final Class<?>[] parameterTypes;

        public ImmutablePOJOMapper(Constructor<E> constructor, Class<?>[] parameterTypes) {
            this.constructor = Reflect.accessible(constructor);
            this.parameterTypes = parameterTypes;
        }

        @Override
        public final E map(R record) {
            try {
                Object[] converted = Convert.convert(record.intoArray(), this.parameterTypes);
                return this.constructor.newInstance(converted);
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record to " + DefaultRecordMapper.this.type, e);
            }
        }
    }

    private class MutablePOJOMapper
    implements RecordMapper<R, E> {
        private final Constructor<? extends E> constructor;
        private final boolean useAnnotations;
        private final List<java.lang.reflect.Field>[] members;
        private final List<Method>[] methods;

        MutablePOJOMapper(Constructor<? extends E> constructor) {
            this.constructor = Reflect.accessible(constructor);
            this.useAnnotations = Utils.hasColumnAnnotations(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type);
            this.members = new List[DefaultRecordMapper.this.fields.length];
            this.methods = new List[DefaultRecordMapper.this.fields.length];
            for (int i = 0; i < DefaultRecordMapper.this.fields.length; ++i) {
                Field field = DefaultRecordMapper.this.fields[i];
                if (this.useAnnotations) {
                    this.members[i] = Utils.getAnnotatedMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, field.getName());
                    this.methods[i] = Utils.getAnnotatedSetters(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, field.getName());
                    continue;
                }
                this.members[i] = Utils.getMatchingMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, field.getName());
                this.methods[i] = Utils.getMatchingSetters(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, field.getName());
            }
        }

        @Override
        public final E map(R record) {
            try {
                Object result = DefaultRecordMapper.this.instance != null ? DefaultRecordMapper.this.instance : this.constructor.newInstance(new Object[0]);
                for (int i = 0; i < DefaultRecordMapper.this.fields.length; ++i) {
                    for (java.lang.reflect.Field member : this.members[i]) {
                        if ((member.getModifiers() & 0x10) != 0) continue;
                        this.map((Record)record, result, member, i);
                    }
                    for (Method method : this.methods[i]) {
                        method.invoke(result, record.getValue(i, method.getParameterTypes()[0]));
                    }
                }
                return result;
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record to " + DefaultRecordMapper.this.type, e);
            }
        }

        private final void map(Record record, Object result, java.lang.reflect.Field member, int index) throws IllegalAccessException {
            Class<?> mType = member.getType();
            if (mType.isPrimitive()) {
                if (mType == Byte.TYPE) {
                    member.setByte(result, record.getValue(index, Byte.TYPE));
                } else if (mType == Short.TYPE) {
                    member.setShort(result, record.getValue(index, Short.TYPE));
                } else if (mType == Integer.TYPE) {
                    member.setInt(result, record.getValue(index, Integer.TYPE));
                } else if (mType == Long.TYPE) {
                    member.setLong(result, record.getValue(index, Long.TYPE));
                } else if (mType == Float.TYPE) {
                    member.setFloat(result, record.getValue(index, Float.TYPE).floatValue());
                } else if (mType == Double.TYPE) {
                    member.setDouble(result, record.getValue(index, Double.TYPE));
                } else if (mType == Boolean.TYPE) {
                    member.setBoolean(result, record.getValue(index, Boolean.TYPE));
                } else if (mType == Character.TYPE) {
                    member.setChar(result, record.getValue(index, Character.TYPE).charValue());
                }
            } else {
                member.set(result, record.getValue(index, mType));
            }
        }
    }

    private class RecordToRecordMapper
    implements RecordMapper<R, AbstractRecord> {
        private RecordToRecordMapper() {
        }

        @Override
        public final AbstractRecord map(R record) {
            try {
                if (record instanceof AbstractRecord) {
                    return (AbstractRecord)((AbstractRecord)record).intoRecord(DefaultRecordMapper.this.type);
                }
                throw new MappingException("Cannot map record " + record + " to type " + DefaultRecordMapper.this.type);
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record to " + DefaultRecordMapper.this.type, e);
            }
        }
    }

    private class ProxyMapper
    implements RecordMapper<R, E> {
        private final MutablePOJOMapper localDelegate;

        ProxyMapper() {
            this.localDelegate = new MutablePOJOMapper(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final E map(R record) {
            Object previous = DefaultRecordMapper.this.instance;
            try {
                DefaultRecordMapper.this.instance = Reflect.on(HashMap.class).create().as(DefaultRecordMapper.this.type);
                Object e = this.localDelegate.map(record);
                return e;
            }
            finally {
                DefaultRecordMapper.this.instance = previous;
            }
        }
    }

    private class ValueTypeMapper
    implements RecordMapper<R, E> {
        private ValueTypeMapper() {
        }

        @Override
        public final E map(R record) {
            int size = record.size();
            if (size != 1) {
                throw new MappingException("Cannot map multi-column record of degree " + size + " to value type " + DefaultRecordMapper.this.type);
            }
            return record.getValue(0, DefaultRecordMapper.this.type);
        }
    }

    private class ArrayMapper
    implements RecordMapper<R, E> {
        private ArrayMapper() {
        }

        @Override
        public final E map(R record) {
            int size = record.size();
            Class<?> componentType = DefaultRecordMapper.this.type.getComponentType();
            Object[] result = (Object[])(DefaultRecordMapper.this.instance != null ? DefaultRecordMapper.this.instance : Array.newInstance(componentType, size));
            if (size > result.length) {
                result = (Object[])Array.newInstance(componentType, size);
            }
            for (int i = 0; i < size; ++i) {
                result[i] = Convert.convert(record.getValue(i), componentType);
            }
            return result;
        }
    }
}

