/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RecordType;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.Utils;

class Fields<R extends Record>
extends AbstractQueryPart
implements RecordType<R> {
    private static final long serialVersionUID = -6911012275707591576L;
    Field<?>[] fields;

    Fields(Field<?> ... fields) {
        this.fields = fields;
    }

    Fields(Collection<? extends Field<?>> fields) {
        this.fields = fields.toArray(new Field[fields.size()]);
    }

    @Override
    public final int size() {
        return this.fields.length;
    }

    @Override
    public final <T> Field<T> field(Field<T> field) {
        if (field == null) {
            return null;
        }
        for (Field<?> f : this.fields) {
            if (!f.equals(field)) continue;
            return f;
        }
        String name = field.getName();
        for (Field<?> f1 : this.fields) {
            if (!f1.getName().equals(name)) continue;
            return f1;
        }
        return null;
    }

    @Override
    public final Field<?> field(String name) {
        if (name == null) {
            return null;
        }
        for (Field<?> f : this.fields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    @Override
    public final Field<?> field(int index) {
        if (index >= 0 && index < this.fields.length) {
            return this.fields[index];
        }
        return null;
    }

    @Override
    public final Field<?>[] fields() {
        return this.fields;
    }

    @Override
    public final Field<?>[] fields(Field<?> ... f) {
        Field[] result = new Field[f.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.field(f[i]);
        }
        return result;
    }

    @Override
    public final Field<?>[] fields(String ... f) {
        Field[] result = new Field[f.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.field(f[i]);
        }
        return result;
    }

    @Override
    public final Field<?>[] fields(int ... f) {
        Field[] result = new Field[f.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.field(f[i]);
        }
        return result;
    }

    @Override
    public final int indexOf(Field<?> field) {
        Field<?> compareWith = this.field(field);
        if (compareWith != null) {
            int size = this.fields.length;
            for (int i = 0; i < size; ++i) {
                if (!this.fields[i].equals(compareWith)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final int indexOf(String fieldName) {
        return this.indexOf(this.field(fieldName));
    }

    @Override
    public final Class<?>[] types() {
        int size = this.fields.length;
        Class[] result = new Class[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.field(i).getType();
        }
        return result;
    }

    @Override
    public final Class<?> type(int fieldIndex) {
        return fieldIndex >= 0 && fieldIndex < this.size() ? this.field(fieldIndex).getType() : null;
    }

    @Override
    public final Class<?> type(String fieldName) {
        return this.type(Utils.indexOrFail(this, fieldName));
    }

    @Override
    public final DataType<?>[] dataTypes() {
        int size = this.fields.length;
        DataType[] result = new DataType[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.field(i).getDataType();
        }
        return result;
    }

    @Override
    public final DataType<?> dataType(int fieldIndex) {
        return fieldIndex >= 0 && fieldIndex < this.size() ? this.field(fieldIndex).getDataType() : null;
    }

    @Override
    public final DataType<?> dataType(String fieldName) {
        return this.dataType(Utils.indexOrFail(this, fieldName));
    }

    final int[] indexesOf(Field<?> ... f) {
        int[] result = new int[f.length];
        for (int i = 0; i < f.length; ++i) {
            result[i] = Utils.indexOrFail(this, f[i]);
        }
        return result;
    }

    final int[] indexesOf(String ... fieldNames) {
        int[] result = new int[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            result[i] = Utils.indexOrFail(this, fieldNames[i]);
        }
        return result;
    }

    @Override
    public final void accept(Context<?> ctx) {
        new QueryPartList((QueryPart[])this.fields).accept(ctx);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    final void add(Field<?> f) {
        Field[] result = new Field[this.fields.length + 1];
        System.arraycopy(this.fields, 0, result, 0, this.fields.length);
        result[this.fields.length] = f;
        this.fields = result;
    }
}

