/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QuantifiedSelect;
import org.jooq.QueryPartInternal;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.Quantifier;

class QuantifiedSelectImpl<R extends Record>
extends AbstractQueryPart
implements QuantifiedSelect<R> {
    private static final long serialVersionUID = -1224570388944748450L;
    private final Quantifier quantifier;
    private final Select<R> query;
    private final Field<? extends Object[]> array;

    QuantifiedSelectImpl(Quantifier quantifier, Select<R> query) {
        this.quantifier = quantifier;
        this.query = query;
        this.array = null;
    }

    QuantifiedSelectImpl(Quantifier quantifier, Field<? extends Object[]> array) {
        this.quantifier = quantifier;
        this.query = null;
        this.array = array;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (ctx.subquery()) {
            ctx.keyword(this.quantifier.toSQL()).sql(" (").formatIndentStart().formatNewLine().visit(this.delegate(ctx.configuration())).formatIndentEnd().formatNewLine().sql(")");
        } else {
            ctx.keyword(this.quantifier.toSQL()).sql(" (").subquery(true).formatIndentStart().formatNewLine().visit(this.delegate(ctx.configuration())).formatIndentEnd().formatNewLine().subquery(false).sql(")");
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.delegate(ctx.configuration()).clauses(ctx);
    }

    private final QueryPartInternal delegate(Configuration ctx) {
        if (this.query != null) {
            return (QueryPartInternal)((Object)this.query);
        }
        switch (ctx.dialect()) {
            case POSTGRES: {
                return (QueryPartInternal)((Object)this.array);
            }
        }
        return (QueryPartInternal)((Object)this.create(ctx).select(new Field[0]).from(DSL.table(this.array)));
    }
}

