/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.tools.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jooq.tools.jdbc.JDBC41Statement;
import org.jooq.tools.jdbc.MockConnection;
import org.jooq.tools.jdbc.MockDataProvider;
import org.jooq.tools.jdbc.MockExecuteContext;
import org.jooq.tools.jdbc.MockResult;
import org.jooq.tools.jdbc.MockResultSet;

public class MockStatement
extends JDBC41Statement
implements CallableStatement {
    private final MockConnection connection;
    private final MockDataProvider data;
    private final List<String> sql;
    private final List<List<Object>> bindings;
    private MockResult[] result;
    private int resultIndex;
    private boolean isClosed;
    int resultSetType = 1003;
    int resultSetConcurrency = 1007;
    int resultSetHoldability = 2;
    int autoGeneratedKeys = 2;
    int[] columnIndexes;
    String[] columnNames;
    private int queryTimeout;
    private int maxRows;

    public MockStatement(MockConnection connection, MockDataProvider data) {
        this(connection, data, null);
    }

    public MockStatement(MockConnection connection, MockDataProvider data, String sql) {
        this.connection = connection;
        this.data = data;
        this.sql = new ArrayList<String>();
        this.bindings = new ArrayList<List<Object>>();
        if (sql != null) {
            this.sql.add(sql);
        }
        this.bindings.add(new ArrayList());
    }

    private List<Object> bindings() {
        return this.bindings.get(this.bindings.size() - 1);
    }

    private void ensureBindingsCapacity(int index) {
        List<Object> b = this.bindings();
        if (b.size() < index) {
            b.addAll(Collections.nCopies(index - b.size(), null));
        }
    }

    private void checkNotClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is already closed");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    private boolean execute0(String localSql, int localResultSetType, int localResultSetConcurrency, int localResultSetHoldability, int localAutoGeneratedKeys, int[] localColumnIndexes, String[] localColumnNames) throws SQLException {
        this.checkNotClosed();
        MockExecuteContext context = new MockExecuteContext(new String[]{localSql}, new Object[][]{this.bindings().toArray()}, localAutoGeneratedKeys, localColumnIndexes, localColumnNames);
        this.result = this.data.execute(context);
        return this.result != null && this.result.length > 0 && this.result[this.resultIndex].data != null;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.getResultSet();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.result != null && ++this.resultIndex < this.result.length;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        return this.result != null && this.resultIndex < this.result.length && this.result[this.resultIndex].data != null ? new MockResultSet(this.result[this.resultIndex].data, this.maxRows) : null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkNotClosed();
        return this.result != null && this.result.length > 0 ? this.result[this.resultIndex].rows : 0;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.sql.get(0));
    }

    @Override
    public ResultSet executeQuery(String localSql) throws SQLException {
        this.execute0(localSql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability, this.autoGeneratedKeys, this.columnIndexes, this.columnNames);
        return this.getResultSet();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.sql.get(0));
    }

    @Override
    public boolean execute(String localSql) throws SQLException {
        return this.execute0(localSql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability, this.autoGeneratedKeys, this.columnIndexes, this.columnNames);
    }

    @Override
    public boolean execute(String localSql, int localAutoGeneratedKeys) throws SQLException {
        return this.execute0(localSql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability, localAutoGeneratedKeys, null, null);
    }

    @Override
    public boolean execute(String localSql, int[] localColumnIndexes) throws SQLException {
        return this.execute0(localSql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability, 1, localColumnIndexes, null);
    }

    @Override
    public boolean execute(String localSql, String[] localColumnNames) throws SQLException {
        return this.execute0(localSql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability, 1, null, localColumnNames);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.sql.get(0));
    }

    @Override
    public int executeUpdate(String localSql) throws SQLException {
        this.execute0(localSql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability, this.autoGeneratedKeys, this.columnIndexes, this.columnNames);
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String localSql, int localAutoGeneratedKeys) throws SQLException {
        this.execute0(localSql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability, localAutoGeneratedKeys, null, null);
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String localSql, int[] localColumnIndexes) throws SQLException {
        this.execute0(localSql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability, 1, localColumnIndexes, null);
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String localSql, String[] localColumnNames) throws SQLException {
        this.execute0(localSql, this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability, 1, null, localColumnNames);
        return this.getUpdateCount();
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkNotClosed();
        this.bindings.add(new ArrayList());
    }

    @Override
    public void addBatch(String localSql) throws SQLException {
        this.checkNotClosed();
        this.sql.add(localSql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        this.sql.clear();
        this.bindings.clear();
        this.bindings.add(new ArrayList());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        Object[][] matrix = new Object[this.bindings.size() - 1][];
        for (int i = 0; i < this.bindings.size() - 1; ++i) {
            matrix[i] = this.bindings.get(i).toArray();
        }
        this.result = this.data.execute(new MockExecuteContext(this.sql.toArray(new String[this.sql.size()]), matrix));
        int[] rows = new int[this.result.length];
        for (int i = 0; i < this.result.length; ++i) {
            rows[i] = this.result[i].rows;
        }
        return rows;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkNotClosed();
        List<Object> b = this.bindings();
        for (int i = 0; i < b.size(); ++i) {
            b.set(i, null);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, null);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, value);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
        this.bindings().set(parameterIndex - 1, x.getArray());
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkNotClosed();
        this.ensureBindingsCapacity(parameterIndex);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return false;
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return 0;
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return 0;
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return 0;
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return 0L;
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return 0.0f;
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return null;
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public void cancel() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkNotClosed();
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkNotClosed();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkNotClosed();
        this.queryTimeout = seconds;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        throw new SQLException("Can this be ignored?");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Unsupported Operation");
    }
}

