/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

final class NativeError
extends IdScriptableObject {
    static final long serialVersionUID = -5338413581437645187L;
    private static final Object ERROR_TAG = "Error";
    private RhinoException stackProvider;
    private static final int ConstructorId_captureStackTrace = -1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int MAX_PROTOTYPE_ID = 3;

    NativeError() {
    }

    static void init(Scriptable scope, boolean sealed) {
        NativeError obj = new NativeError();
        ScriptableObject.putProperty((Scriptable)obj, "name", (Object)"Error");
        ScriptableObject.putProperty((Scriptable)obj, "message", (Object)"");
        ScriptableObject.putProperty((Scriptable)obj, "fileName", (Object)"");
        ScriptableObject.putProperty((Scriptable)obj, "lineNumber", (Object)0);
        obj.setAttributes("name", 2);
        obj.setAttributes("message", 2);
        obj.exportAsJSClass(3, scope, sealed);
    }

    static NativeError make(Context cx, Scriptable scope, IdFunctionObject ctorObj, Object[] args) {
        Scriptable proto = (Scriptable)ctorObj.get("prototype", (Scriptable)ctorObj);
        NativeError obj = new NativeError();
        obj.setPrototype(proto);
        obj.setParentScope(scope);
        int arglen = args.length;
        if (arglen >= 1) {
            if (args[0] != Undefined.instance) {
                ScriptableObject.putProperty((Scriptable)obj, "message", (Object)ScriptRuntime.toString(args[0]));
            }
            if (arglen >= 2) {
                ScriptableObject.putProperty((Scriptable)obj, "fileName", args[1]);
                if (arglen >= 3) {
                    int line = ScriptRuntime.toInt32(args[2]);
                    ScriptableObject.putProperty((Scriptable)obj, "lineNumber", (Object)line);
                }
            }
        }
        return obj;
    }

    public String getClassName() {
        return "Error";
    }

    public String toString() {
        Object toString = NativeError.js_toString(this);
        return toString instanceof String ? (String)toString : super.toString();
    }

    protected void initPrototypeId(int id) {
        String s;
        int arity;
        switch (id) {
            case 1: {
                arity = 1;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(ERROR_TAG, id, s, arity);
    }

    protected void fillConstructorProperties(IdFunctionObject ctor) {
        this.addIdFunctionProperty(ctor, ERROR_TAG, -1, "captureStackTrace", 2);
        super.fillConstructorProperties(ctor);
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(ERROR_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case -1: {
                return NativeError.js_captureStackTrace(cx, scope, args);
            }
            case 1: {
                return NativeError.make(cx, scope, f, args);
            }
            case 2: {
                return NativeError.js_toString(thisObj);
            }
            case 3: {
                return NativeError.js_toSource(cx, scope, thisObj);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    public void setStackProvider(RhinoException re) {
        if (this.stackProvider == null) {
            this.stackProvider = re;
            try {
                this.defineProperty("stack", this, NativeError.class.getMethod("getStack", Scriptable.class), NativeError.class.getMethod("setStack", Scriptable.class, Object.class), 0);
            }
            catch (NoSuchMethodException nsm) {
                throw new RuntimeException(nsm);
            }
        }
    }

    public Object getStack() {
        return this.getStack(this);
    }

    public Object getStack(Scriptable obj) {
        while (obj != null && !(obj instanceof NativeError)) {
            obj = obj.getPrototype();
        }
        if (obj == null) {
            return NOT_FOUND;
        }
        NativeError er = (NativeError)obj;
        if (er.stackProvider == null) {
            return NOT_FOUND;
        }
        Object value = er.stackProvider.getPreparedScriptStackTrace(Context.getCurrentContext(), this, this);
        this.setStack(obj, value);
        return value;
    }

    public void setStack(Object value) {
        this.setStack(this, value);
    }

    public void setStack(Scriptable obj, Object value) {
        while (obj != null && !(obj instanceof NativeError)) {
            obj = obj.getPrototype();
        }
        if (obj != null) {
            NativeError er = (NativeError)obj;
            if (er.stackProvider != null) {
                er.stackProvider = null;
                er.delete("stack");
            }
            er.put("stack", (Scriptable)this, value);
        }
    }

    private static Object js_toString(Scriptable thisObj) {
        Object name = ScriptableObject.getProperty(thisObj, "name");
        name = name == NOT_FOUND || name == Undefined.instance ? "Error" : ScriptRuntime.toString(name);
        Object msg = ScriptableObject.getProperty(thisObj, "message");
        msg = msg == NOT_FOUND || msg == Undefined.instance ? "" : ScriptRuntime.toString(msg);
        if (name.toString().length() == 0) {
            return msg;
        }
        if (msg.toString().length() == 0) {
            return name;
        }
        return (String)name + ": " + (String)msg;
    }

    private static String js_toSource(Context cx, Scriptable scope, Scriptable thisObj) {
        Object name = ScriptableObject.getProperty(thisObj, "name");
        Object message = ScriptableObject.getProperty(thisObj, "message");
        Object fileName = ScriptableObject.getProperty(thisObj, "fileName");
        Object lineNumber = ScriptableObject.getProperty(thisObj, "lineNumber");
        StringBuilder sb = new StringBuilder();
        sb.append("(new ");
        if (name == NOT_FOUND) {
            name = Undefined.instance;
        }
        sb.append(ScriptRuntime.toString(name));
        sb.append("(");
        if (message != NOT_FOUND || fileName != NOT_FOUND || lineNumber != NOT_FOUND) {
            if (message == NOT_FOUND) {
                message = "";
            }
            sb.append(ScriptRuntime.uneval(cx, scope, message));
            if (fileName != NOT_FOUND || lineNumber != NOT_FOUND) {
                int line;
                sb.append(", ");
                if (fileName == NOT_FOUND) {
                    fileName = "";
                }
                sb.append(ScriptRuntime.uneval(cx, scope, fileName));
                if (lineNumber != NOT_FOUND && (line = ScriptRuntime.toInt32(lineNumber)) != 0) {
                    sb.append(", ");
                    sb.append(ScriptRuntime.toString(line));
                }
            }
        }
        sb.append("))");
        return sb.toString();
    }

    private static Object js_captureStackTrace(Context cx, Scriptable scope, Object[] args) {
        Scriptable obj;
        if (args.length < 1) {
            throw ScriptRuntime.typeError("first argument must be an Object");
        }
        try {
            obj = (Scriptable)args[0];
        }
        catch (ClassCastException cce) {
            throw ScriptRuntime.typeError("err must be an Object");
        }
        EvaluatorException exc = new EvaluatorException(null);
        exc.fillInStackTrace();
        obj.put("stack", obj, exc.getPreparedScriptStackTrace(cx, scope, obj));
        return Undefined.instance;
    }

    private static String getString(Scriptable obj, String id) {
        Object value = ScriptableObject.getProperty(obj, id);
        if (value == NOT_FOUND) {
            return "";
        }
        return ScriptRuntime.toString(value);
    }

    protected int findPrototypeId(String s) {
        int id;
        block6: {
            id = 0;
            String X = null;
            int s_length = s.length();
            if (s_length == 8) {
                char c = s.charAt(3);
                if (c == 'o') {
                    X = "toSource";
                    id = 3;
                } else if (c == 't') {
                    X = "toString";
                    id = 2;
                }
            } else if (s_length == 11) {
                X = "constructor";
                id = 1;
            }
            if (X == null || X == s || X.equals(s)) break block6;
            id = 0;
        }
        return id;
    }
}

