/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.arrays;

import java.io.Serializable;
import org.mozilla.javascript.ScriptRuntime;

public abstract class ExternalArray
implements Serializable {
    public abstract int getLength();

    public boolean inRange(int index) {
        return index < this.getLength() && index >= 0;
    }

    public Object get(int index) {
        return this.getElement(index);
    }

    public void put(int index, Object value) {
        try {
            this.putElement(index, value);
        }
        catch (ClassCastException cce) {
            throw ScriptRuntime.typeError("Invalid object type for external array");
        }
    }

    public int copyIds(Object[] ids) {
        int i;
        for (i = 0; i < this.getLength(); ++i) {
            ids[i] = i;
        }
        return i;
    }

    protected abstract Object getElement(int var1);

    protected abstract void putElement(int var1, Object var2);
}

