/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.arrays;

import java.nio.ShortBuffer;
import org.mozilla.javascript.arrays.ExternalArray;

public final class ExternalUnsignedShortArray
extends ExternalArray {
    private static final long serialVersionUID = -5341065722456287177L;
    private final ShortBuffer array;

    public ExternalUnsignedShortArray(ShortBuffer array) {
        this.array = array;
    }

    public ShortBuffer getArray() {
        return this.array;
    }

    protected Object getElement(int index) {
        short val = this.array.get(this.array.position() + index);
        return val & 0xFFFF;
    }

    protected void putElement(int index, Object value) {
        int val = ((Number)value).intValue();
        this.array.put(this.array.position() + index, (short)(val & 0xFFFF));
    }

    public int getLength() {
        return this.array.remaining();
    }
}

