/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList;

import de.malkusch.whoisServerList.publicSuffixList.index.Index;
import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import de.malkusch.whoisServerList.publicSuffixList.util.DomainUtil;
import de.malkusch.whoisServerList.publicSuffixList.util.PunycodeAutoDecoder;
import in.co.uproot.util.StringUtils;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public final class PublicSuffixList {
    private final URL url;
    private final Charset charset;
    private final Index index;

    PublicSuffixList(Index index, URL uRL, Charset charset) {
        this.index = index;
        this.url = uRL;
        this.charset = charset;
    }

    public String getRegistrableDomain(String string) {
        String string2;
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        if (string.charAt(0) == '.') {
            return null;
        }
        PunycodeAutoDecoder punycodeAutoDecoder = new PunycodeAutoDecoder();
        String string3 = punycodeAutoDecoder.decode(string);
        if (StringUtils.equals(string3, string2 = this.getPublicSuffix(string3))) {
            return null;
        }
        String[] stringArray = DomainUtil.splitLabels(string2);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = DomainUtil.splitLabels(string3);
        int n = stringArray2.length - stringArray.length - 1;
        String string4 = DomainUtil.joinLabels(Arrays.copyOfRange(stringArray2, n, stringArray2.length));
        return punycodeAutoDecoder.recode(string4);
    }

    public boolean isRegistrable(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The domain must not be null");
        }
        return string.equals(this.getRegistrableDomain(string));
    }

    public String getPublicSuffix(String string) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        PunycodeAutoDecoder punycodeAutoDecoder = new PunycodeAutoDecoder();
        String string2 = punycodeAutoDecoder.recode(string);
        Rule rule = this.index.findRule(string2);
        if (rule == null) {
            return null;
        }
        return punycodeAutoDecoder.decode(rule.match(string2));
    }

    public boolean isPublicSuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The domain must not be null");
        }
        return string.equals(this.getPublicSuffix(string));
    }

    public Charset getCharset() {
        return this.charset;
    }

    public URL getURL() {
        return this.url;
    }

    public List<Rule> getRules() {
        return this.index.getRules();
    }
}

