/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList;

import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixList;
import de.malkusch.whoisServerList.publicSuffixList.index.Index;
import de.malkusch.whoisServerList.publicSuffixList.index.IndexFactory;
import de.malkusch.whoisServerList.publicSuffixList.parser.Parser;
import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;

public final class PublicSuffixListFactory {
    public static final String PROPERTY_URL = "psl.url";
    public static final String PROPERTY_CHARSET = "psl.charset";
    public static final String PROPERTY_LIST_FILE = "psl.file";
    @Deprecated
    public static final String PROPERTY_INDEX = "psl.index";
    public static final String PROPERTY_INDEX_FACTORY = "psl.indexFactory";
    public static final String PROPERTY_FILE = "/psl.properties";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties getDefaults() {
        try (InputStream inputStream = this.getClass().getResourceAsStream(PROPERTY_FILE);){
            Properties properties = new Properties();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PublicSuffixList build(Properties properties) throws IOException, ClassNotFoundException {
        String string = properties.getProperty(PROPERTY_LIST_FILE);
        try (InputStream inputStream = this.getClass().getResourceAsStream(string);){
            PublicSuffixList publicSuffixList;
            URL uRL = new URL(properties.getProperty(PROPERTY_URL));
            Charset charset = Charset.forName(properties.getProperty(PROPERTY_CHARSET));
            Parser parser = new Parser();
            List<Rule> list = parser.parse(inputStream, charset);
            list.add(Rule.DEFAULT);
            String string2 = properties.getProperty(PROPERTY_INDEX_FACTORY);
            Class<?> clazz = Class.forName(string2);
            IndexFactory indexFactory = (IndexFactory)clazz.newInstance();
            Index index = indexFactory.build(list);
            PublicSuffixList publicSuffixList2 = publicSuffixList = new PublicSuffixList(index, uRL, charset);
            return publicSuffixList2;
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public PublicSuffixList build() {
        try {
            return this.build(this.getDefaults());
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }
}

