/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList.index.tree;

import de.malkusch.whoisServerList.publicSuffixList.index.tree.Node;
import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;

final class ImmutableNode
extends Node<ImmutableNode> {
    private final Rule rule;

    ImmutableNode(String string, Map<String, ImmutableNode> map, Rule rule) {
        super(string, Collections.unmodifiableMap(map));
        this.rule = rule;
    }

    @Override
    Rule getRule() {
        return this.rule;
    }

    Collection<ImmutableNode> findNodes(String string) {
        return this.findNodes(this.convertDomain(string));
    }

    Collection<ImmutableNode> findNodes(Deque<String> deque) {
        ImmutableNode immutableNode;
        LinkedList<ImmutableNode> linkedList = new LinkedList<ImmutableNode>();
        if (deque.isEmpty()) {
            return linkedList;
        }
        String string = deque.removeLast();
        ImmutableNode immutableNode2 = (ImmutableNode)this.getChild(string);
        if (immutableNode2 != null) {
            linkedList.add(immutableNode2);
        }
        if ((immutableNode = (ImmutableNode)this.getWildcard()) != null) {
            linkedList.add(immutableNode);
        }
        for (ImmutableNode immutableNode3 : new ArrayList<ImmutableNode>(linkedList)) {
            linkedList.addAll(immutableNode3.findNodes(new LinkedList<String>(deque)));
        }
        return linkedList;
    }

    Collection<ImmutableNode> getDescendants() {
        ArrayList<ImmutableNode> arrayList = new ArrayList<ImmutableNode>(this.getChildren());
        for (ImmutableNode immutableNode : this.getChildren()) {
            arrayList.addAll(immutableNode.getDescendants());
        }
        return arrayList;
    }
}

