/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList.index.tree;

import de.malkusch.whoisServerList.publicSuffixList.index.tree.TreeIndex;
import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import de.malkusch.whoisServerList.publicSuffixList.util.DomainUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

abstract class Node<T extends Node<T>> {
    private final String label;
    private final Map<String, T> children;

    Node(String string) {
        this(string, new HashMap());
    }

    Node(String string, Map<String, T> map) {
        this.label = TreeIndex.getCanonicalLabel(string);
        this.children = map;
    }

    T getChild(String string) {
        return (T)((Node)this.children.get(TreeIndex.getCanonicalLabel(string)));
    }

    Collection<T> getChildren() {
        return this.children.values();
    }

    String getLabel() {
        return this.label;
    }

    void addChild(T t) {
        Node.addChild(t, this.children);
    }

    static <T extends Node<T>> void addChild(T t, Map<String, T> map) {
        map.put(t.getLabel(), t);
    }

    abstract Rule getRule();

    T getWildcard() {
        return (T)((Node)this.children.get("*"));
    }

    Deque<String> convertDomain(String string) {
        String[] stringArray = DomainUtil.splitLabels(string);
        return new LinkedList<String>(Arrays.asList(stringArray));
    }

    public String toString() {
        return this.label;
    }
}

