/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList.parser;

import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import de.malkusch.whoisServerList.publicSuffixList.rule.RuleFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Parser {
    private static Pattern ruleLine = Pattern.compile("^(\\S+)");
    private static Pattern commentLine = Pattern.compile("^//.*$");
    private static Pattern whiteSpaceLine = Pattern.compile("^\\s*$");
    private final RuleFactory ruleFactory = new RuleFactory();

    public List<Rule> parse(InputStream inputStream, Charset charset) throws IOException {
        String string;
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
        while ((string = bufferedReader.readLine()) != null) {
            Rule rule = this.parseLine(string);
            if (rule == null) continue;
            arrayList.add(this.parseLine(string));
        }
        return arrayList;
    }

    public Rule parseLine(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (commentLine.matcher(string2).matches()) {
            return null;
        }
        if (whiteSpaceLine.matcher(string2).matches()) {
            return null;
        }
        Matcher matcher = ruleLine.matcher(string2);
        if (!matcher.find()) {
            return null;
        }
        return this.ruleFactory.build(matcher.group(1));
    }
}

