/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList.rule;

import de.malkusch.whoisServerList.publicSuffixList.rule.RuleMatcher;
import de.malkusch.whoisServerList.publicSuffixList.util.DomainUtil;
import java.util.Arrays;

public final class Rule {
    public static final char EXCEPTION_TOKEN = '!';
    public static final String WILDCARD = "*";
    public static final Rule DEFAULT = new Rule("*");
    private final RuleMatcher matcher;
    private final boolean exceptionRule;

    public Rule(String string) {
        this(string, false);
    }

    public Rule(String string, boolean bl) {
        this.matcher = new RuleMatcher(string);
        this.exceptionRule = bl;
    }

    public int getLabelCount() {
        return DomainUtil.splitLabels(this.matcher.getPattern()).length;
    }

    public String getPattern() {
        return this.matcher.getPattern();
    }

    public String toString() {
        String string = this.matcher.toString();
        return this.isExceptionRule() ? '!' + string : string;
    }

    public boolean isExceptionRule() {
        return this.exceptionRule;
    }

    public String match(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.matcher.match(string);
        if (string2 == null) {
            return null;
        }
        if (!this.isExceptionRule()) {
            return string2;
        }
        String[] stringArray = DomainUtil.splitLabels(string2);
        String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
        return DomainUtil.joinLabels(stringArray2);
    }
}

