# Contributing to gngr

### Avoid +1s on issues
Please avoid spamming issues with `+1`s. Unfortunately, Github doesn't have a way to vote on an issue. Shoot a mail to
[them](mailto:support@github.com) if you agree that ability to vote on an issue is essential.

### Testing and reporting issues
This is the simplest way of contributing to `gngr`: use `gngr` and when you find bugs shoot us an issue report on GitHub.

We also need help in running systematic tests (such as tests from W3C). We will write more about that later.

### Triaging
When an issue is reported by a user, we need help in diagnosing the root cause and breaking it down to a small
test-case. This often requires familiarity with the browser stack (HTTP, HTML, CSS, JS, etc), but no knowledge of
`gngr`'s implementation is required.

To help with triaging, [search for issues with the `need-triage` label](https://github.com/UprootLabs/gngr/labels/need-triage).

### Advice
We often need advice / guidance from experts in browser and related technologies.
Please [search for issues with the `need-advice` label](https://github.com/UprootLabs/gngr/labels/need-advice).

### Code
At the moment we are not prepared for code contributions since there are major architectual changes afoot. If you would
like to contribute code discuss with us first to avoid wasted efforts.

If you really desire to contribute some code, please contribute to our [upstream projects](https://gngr.info/doc/credits.html).
