/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jooq.Configuration;
import org.jooq.Converter;
import org.jooq.Cursor;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.FutureResult;
import org.jooq.Record;
import org.jooq.RecordHandler;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.CursorImpl;
import org.jooq.impl.Fields;
import org.jooq.impl.FutureResultImpl;
import org.jooq.impl.MetaDataFieldProvider;
import org.jooq.impl.ResultImpl;
import org.jooq.impl.Utils;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;

abstract class AbstractResultQuery<R extends Record>
extends AbstractQuery
implements ResultQuery<R> {
    private static final long serialVersionUID = -5588344253566055707L;
    private static final JooqLogger log = JooqLogger.getLogger(AbstractResultQuery.class);
    private int maxRows;
    private int fetchSize;
    private int resultSetConcurrency;
    private int resultSetType;
    private int resultSetHoldability;
    private transient boolean lazy;
    private transient boolean many;
    private transient Cursor<R> cursor;
    private Result<R> result;
    private List<Result<Record>> results;
    private int[] internIndexes;
    private Field<?>[] internFields;
    private String[] internNames;

    AbstractResultQuery(Configuration configuration) {
        super(configuration);
    }

    protected abstract Field<?>[] getFields(ResultSetMetaData var1) throws SQLException;

    @Override
    public final ResultQuery<R> bind(String param, Object value) throws IllegalArgumentException, DataTypeException {
        return (ResultQuery)super.bind(param, value);
    }

    @Override
    public final ResultQuery<R> bind(int index, Object value) throws IllegalArgumentException, DataTypeException {
        return (ResultQuery)super.bind(index, value);
    }

    @Override
    public final ResultQuery<R> queryTimeout(int timeout) {
        return (ResultQuery)super.queryTimeout(timeout);
    }

    @Override
    public final ResultQuery<R> keepStatement(boolean k) {
        return (ResultQuery)super.keepStatement(k);
    }

    @Override
    public final ResultQuery<R> maxRows(int rows) {
        this.maxRows = rows;
        return this;
    }

    @Override
    public final ResultQuery<R> fetchSize(int rows) {
        this.fetchSize = rows;
        return this;
    }

    @Override
    public final ResultQuery<R> resultSetConcurrency(int concurrency) {
        this.resultSetConcurrency = concurrency;
        return this;
    }

    @Override
    public final ResultQuery<R> resultSetType(int type) {
        this.resultSetType = type;
        return this;
    }

    @Override
    public final ResultQuery<R> resultSetHoldability(int holdability) {
        this.resultSetHoldability = holdability;
        return this;
    }

    @Override
    public final ResultQuery<R> intern(Field<?> ... fields) {
        this.internFields = fields;
        return this;
    }

    @Override
    public final ResultQuery<R> intern(int ... fieldIndexes) {
        this.internIndexes = fieldIndexes;
        return this;
    }

    @Override
    public final ResultQuery<R> intern(String ... fieldNames) {
        this.internNames = fieldNames;
        return this;
    }

    private final int[] internIndexes(Field<?>[] fields) {
        if (this.internIndexes != null) {
            return this.internIndexes;
        }
        if (this.internFields != null) {
            return new Fields(fields).indexesOf(this.internFields);
        }
        if (this.internNames != null) {
            return new Fields(fields).indexesOf(this.internNames);
        }
        return null;
    }

    @Override
    protected final void prepare(ExecuteContext ctx) throws SQLException {
        if (this.resultSetConcurrency != 0 || this.resultSetType != 0 || this.resultSetHoldability != 0) {
            int concurrency;
            int type = this.resultSetType != 0 ? this.resultSetType : 1003;
            int n = concurrency = this.resultSetConcurrency != 0 ? this.resultSetConcurrency : 1007;
            if (this.resultSetHoldability == 0) {
                ctx.statement(ctx.connection().prepareStatement(ctx.sql(), type, concurrency));
            } else {
                ctx.statement(ctx.connection().prepareStatement(ctx.sql(), type, concurrency, this.resultSetHoldability));
            }
        } else if (this.isForUpdate() && Arrays.asList(SQLDialect.CUBRID).contains((Object)ctx.configuration().dialect().family())) {
            ctx.data("org.jooq.configuration.lock-rows-for-update", true);
            ctx.statement(ctx.connection().prepareStatement(ctx.sql(), 1005, 1008));
        } else {
            ctx.statement(ctx.connection().prepareStatement(ctx.sql()));
        }
        if (this.fetchSize != 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting fetch size", this.fetchSize);
            }
            ctx.statement().setFetchSize(this.fetchSize);
        }
        if (this.maxRows != 0) {
            ctx.statement().setMaxRows(this.maxRows);
        }
    }

    @Override
    protected final int execute(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        try {
            listener.executeStart(ctx);
            if (ctx.statement().execute()) {
                ctx.resultSet(ctx.statement().getResultSet());
            }
            listener.executeEnd(ctx);
        }
        finally {
            Utils.consumeWarnings(ctx, listener);
        }
        if (!this.many) {
            if (ctx.resultSet() != null) {
                Field<?>[] fields = this.getFields(ctx.resultSet().getMetaData());
                this.cursor = new CursorImpl<R>(ctx, listener, fields, this.internIndexes(fields), this.keepStatement(), this.keepResultSet(), this.getRecordType());
                if (!this.lazy) {
                    this.result = this.cursor.fetch();
                    this.cursor = null;
                }
            } else {
                this.result = new ResultImpl(ctx.configuration(), new Field[0]);
            }
        } else {
            this.results = new ArrayList<Result<Record>>();
            boolean anyResults = false;
            while (ctx.resultSet() != null) {
                anyResults = true;
                Field<?>[] fields = new MetaDataFieldProvider(ctx.configuration(), ctx.resultSet().getMetaData()).getFields();
                CursorImpl c = new CursorImpl(ctx, listener, fields, this.internIndexes(fields), true, false);
                this.results.add(c.fetch());
                if (ctx.statement().getMoreResults()) {
                    ctx.resultSet(ctx.statement().getResultSet());
                    continue;
                }
                ctx.resultSet(null);
            }
            if (anyResults) {
                ctx.statement().getMoreResults(3);
            }
        }
        return this.result != null ? this.result.size() : 0;
    }

    @Override
    protected final boolean keepResultSet() {
        return this.lazy;
    }

    abstract boolean isSelectingRefCursor();

    abstract boolean isForUpdate();

    @Override
    public final Result<R> fetch() {
        this.execute();
        return this.result;
    }

    @Override
    public final ResultSet fetchResultSet() {
        return this.fetchLazy().resultSet();
    }

    @Override
    public final Cursor<R> fetchLazy() {
        return this.fetchLazy(0);
    }

    @Override
    @Deprecated
    public final Cursor<R> fetchLazy(int size) {
        this.lazy = true;
        this.fetchSize = size;
        try {
            this.execute();
        }
        finally {
            this.lazy = false;
            this.fetchSize = 0;
        }
        return this.cursor;
    }

    @Override
    public final List<Result<Record>> fetchMany() {
        this.many = true;
        try {
            this.execute();
        }
        finally {
            this.many = false;
        }
        return this.results;
    }

    @Override
    public final <T> List<T> fetch(Field<T> field) {
        return this.fetch().getValues(field);
    }

    @Override
    public final <T> List<T> fetch(Field<?> field, Class<? extends T> type) {
        return this.fetch().getValues(field, type);
    }

    @Override
    public final <T, U> List<U> fetch(Field<T> field, Converter<? super T, U> converter) {
        return this.fetch().getValues(field, converter);
    }

    @Override
    public final List<?> fetch(int fieldIndex) {
        return this.fetch().getValues(fieldIndex);
    }

    @Override
    public final <T> List<T> fetch(int fieldIndex, Class<? extends T> type) {
        return this.fetch().getValues(fieldIndex, type);
    }

    @Override
    public final <U> List<U> fetch(int fieldIndex, Converter<?, U> converter) {
        return this.fetch().getValues(fieldIndex, converter);
    }

    @Override
    public final List<?> fetch(String fieldName) {
        return this.fetch().getValues(fieldName);
    }

    @Override
    public final <T> List<T> fetch(String fieldName, Class<? extends T> type) {
        return this.fetch().getValues(fieldName, type);
    }

    @Override
    public final <U> List<U> fetch(String fieldName, Converter<?, U> converter) {
        return this.fetch().getValues(fieldName, converter);
    }

    @Override
    public final <T> T fetchOne(Field<T> field) {
        R record = this.fetchOne();
        return record == null ? null : (T)record.getValue(field);
    }

    @Override
    public final <T> T fetchOne(Field<?> field, Class<? extends T> type) {
        return Convert.convert(this.fetchOne(field), type);
    }

    @Override
    public final <T, U> U fetchOne(Field<T> field, Converter<? super T, U> converter) {
        return Convert.convert(this.fetchOne(field), converter);
    }

    @Override
    public final Object fetchOne(int fieldIndex) {
        R record = this.fetchOne();
        return record == null ? null : record.getValue(fieldIndex);
    }

    @Override
    public final <T> T fetchOne(int fieldIndex, Class<? extends T> type) {
        return Convert.convert(this.fetchOne(fieldIndex), type);
    }

    @Override
    public final <U> U fetchOne(int fieldIndex, Converter<?, U> converter) {
        return Convert.convert(this.fetchOne(fieldIndex), converter);
    }

    @Override
    public final Object fetchOne(String fieldName) {
        R record = this.fetchOne();
        return record == null ? null : record.getValue(fieldName);
    }

    @Override
    public final <T> T fetchOne(String fieldName, Class<? extends T> type) {
        return Convert.convert(this.fetchOne(fieldName), type);
    }

    @Override
    public final <U> U fetchOne(String fieldName, Converter<?, U> converter) {
        return Convert.convert(this.fetchOne(fieldName), converter);
    }

    @Override
    public final R fetchOne() {
        return Utils.fetchOne(this.fetchLazy());
    }

    @Override
    public final Map<String, Object> fetchOneMap() {
        R record = this.fetchOne();
        return record == null ? null : record.intoMap();
    }

    @Override
    public final Object[] fetchOneArray() {
        R record = this.fetchOne();
        return record == null ? null : record.intoArray();
    }

    @Override
    public final <E> E fetchOneInto(Class<? extends E> type) {
        R record = this.fetchOne();
        return (E)(record == null ? null : record.into(type));
    }

    @Override
    public final <Z extends Record> Z fetchOneInto(Table<Z> table) {
        R record = this.fetchOne();
        return record == null ? null : (Z)record.into(table);
    }

    @Override
    public final <T> T fetchAny(Field<T> field) {
        R record = this.fetchAny();
        return record == null ? null : (T)record.getValue(field);
    }

    @Override
    public final <T> T fetchAny(Field<?> field, Class<? extends T> type) {
        return Convert.convert(this.fetchAny(field), type);
    }

    @Override
    public final <T, U> U fetchAny(Field<T> field, Converter<? super T, U> converter) {
        return Convert.convert(this.fetchAny(field), converter);
    }

    @Override
    public final Object fetchAny(int fieldIndex) {
        R record = this.fetchAny();
        return record == null ? null : record.getValue(fieldIndex);
    }

    @Override
    public final <T> T fetchAny(int fieldIndex, Class<? extends T> type) {
        return Convert.convert(this.fetchAny(fieldIndex), type);
    }

    @Override
    public final <U> U fetchAny(int fieldIndex, Converter<?, U> converter) {
        return Convert.convert(this.fetchAny(fieldIndex), converter);
    }

    @Override
    public final Object fetchAny(String fieldName) {
        R record = this.fetchAny();
        return record == null ? null : record.getValue(fieldName);
    }

    @Override
    public final <T> T fetchAny(String fieldName, Class<? extends T> type) {
        return Convert.convert(this.fetchAny(fieldName), type);
    }

    @Override
    public final <U> U fetchAny(String fieldName, Converter<?, U> converter) {
        return Convert.convert(this.fetchAny(fieldName), converter);
    }

    @Override
    public final R fetchAny() {
        Cursor<R> c = this.fetchLazy();
        try {
            R r = c.fetchOne();
            return r;
        }
        finally {
            c.close();
        }
    }

    @Override
    public final Map<String, Object> fetchAnyMap() {
        R record = this.fetchAny();
        return record == null ? null : record.intoMap();
    }

    @Override
    public final Object[] fetchAnyArray() {
        R record = this.fetchAny();
        return record == null ? null : record.intoArray();
    }

    @Override
    public final <E> E fetchAnyInto(Class<? extends E> type) {
        R record = this.fetchAny();
        return (E)(record == null ? null : record.into(type));
    }

    @Override
    public final <Z extends Record> Z fetchAnyInto(Table<Z> table) {
        R record = this.fetchAny();
        return record == null ? null : (Z)record.into(table);
    }

    @Override
    public final <K> Map<K, R> fetchMap(Field<K> key) {
        return this.fetch().intoMap(key);
    }

    @Override
    public final <K, V> Map<K, V> fetchMap(Field<K> key, Field<V> value) {
        return this.fetch().intoMap(key, value);
    }

    @Override
    public final Map<Record, R> fetchMap(Field<?>[] keys) {
        return this.fetch().intoMap(keys);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(Field<?>[] keys, Class<? extends E> type) {
        return this.fetch().intoMap(keys, type);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(Field<?>[] keys, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keys, mapper);
    }

    @Override
    public final <K, E> Map<K, E> fetchMap(Field<K> key, Class<? extends E> type) {
        return this.fetch().intoMap(key, type);
    }

    @Override
    public final <K, E> Map<K, E> fetchMap(Field<K> key, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(key, mapper);
    }

    @Override
    public final List<Map<String, Object>> fetchMaps() {
        return this.fetch().intoMaps();
    }

    @Override
    public final <K> Map<K, Result<R>> fetchGroups(Field<K> key) {
        return this.fetch().intoGroups(key);
    }

    @Override
    public final <K, V> Map<K, List<V>> fetchGroups(Field<K> key, Field<V> value) {
        return this.fetch().intoGroups(key, value);
    }

    @Override
    public final Map<Record, Result<R>> fetchGroups(Field<?>[] keys) {
        return this.fetch().intoGroups(keys);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(Field<?>[] keys, Class<? extends E> type) {
        return this.fetch().intoGroups(keys, type);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(Field<?>[] keys, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keys, mapper);
    }

    @Override
    public final <K, E> Map<K, List<E>> fetchGroups(Field<K> key, Class<? extends E> type) {
        return this.fetch().intoGroups(key, type);
    }

    @Override
    public final <K, E> Map<K, List<E>> fetchGroups(Field<K> key, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(key, mapper);
    }

    @Override
    public final Object[][] fetchArrays() {
        return this.fetch().intoArray();
    }

    @Override
    public final Object[] fetchArray(int fieldIndex) {
        return this.fetch().intoArray(fieldIndex);
    }

    @Override
    public final <T> T[] fetchArray(int fieldIndex, Class<? extends T> type) {
        return this.fetch().intoArray(fieldIndex, type);
    }

    @Override
    public final <U> U[] fetchArray(int fieldIndex, Converter<?, U> converter) {
        return this.fetch().intoArray(fieldIndex, converter);
    }

    @Override
    public final Object[] fetchArray(String fieldName) {
        return this.fetch().intoArray(fieldName);
    }

    @Override
    public final <T> T[] fetchArray(String fieldName, Class<? extends T> type) {
        return this.fetch().intoArray(fieldName, type);
    }

    @Override
    public final <U> U[] fetchArray(String fieldName, Converter<?, U> converter) {
        return this.fetch().intoArray(fieldName, converter);
    }

    @Override
    public final <T> T[] fetchArray(Field<T> field) {
        return this.fetch().intoArray(field);
    }

    @Override
    public final <T> T[] fetchArray(Field<?> field, Class<? extends T> type) {
        return this.fetch().intoArray(field, type);
    }

    @Override
    public final <T, U> U[] fetchArray(Field<T> field, Converter<? super T, U> converter) {
        return this.fetch().intoArray(field, converter);
    }

    @Override
    public Class<? extends R> getRecordType() {
        return null;
    }

    @Override
    public final <T> List<T> fetchInto(Class<? extends T> type) {
        return this.fetch().into(type);
    }

    @Override
    public final <Z extends Record> Result<Z> fetchInto(Table<Z> table) {
        return this.fetch().into(table);
    }

    @Override
    public final <H extends RecordHandler<? super R>> H fetchInto(H handler) {
        return this.fetch().into(handler);
    }

    @Override
    public final <E> List<E> fetch(RecordMapper<? super R, E> mapper) {
        return this.fetch().map(mapper);
    }

    @Override
    @Deprecated
    public final FutureResult<R> fetchLater() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future future = executor.submit(new ResultQueryCallable());
        return new FutureResultImpl(future, executor);
    }

    @Override
    @Deprecated
    public final FutureResult<R> fetchLater(ExecutorService executor) {
        Future future = executor.submit(new ResultQueryCallable());
        return new FutureResultImpl(future);
    }

    @Override
    public final Result<R> getResult() {
        return this.result;
    }

    private final class ResultQueryCallable
    implements Callable<Result<R>> {
        private ResultQueryCallable() {
        }

        @Override
        public final Result<R> call() throws Exception {
            return AbstractResultQuery.this.fetch();
        }
    }
}

