/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DSLContext;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.Identity;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.StoreQuery;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.conf.RenderNameStyle;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.CursorImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.Fields;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.ResultImpl;
import org.jooq.impl.Utils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.util.sqlite.SQLiteDSL;

abstract class AbstractStoreQuery<R extends Record>
extends AbstractQuery
implements StoreQuery<R> {
    private static final long serialVersionUID = 6864591335823160569L;
    final Table<R> into;
    final QueryPartList<Field<?>> returning;
    Result<R> returned;

    AbstractStoreQuery(Configuration configuration, Table<R> into) {
        super(configuration);
        this.into = into;
        this.returning = new QueryPartList();
    }

    protected abstract Map<Field<?>, Field<?>> getValues();

    final Table<R> getInto() {
        return this.into;
    }

    @Override
    public final void setRecord(R record) {
        for (int i = 0; i < record.size(); ++i) {
            if (!record.changed(i)) continue;
            this.addValue(record.field(i), record.getValue(i));
        }
    }

    final <T> void addValue(R record, Field<T> field) {
        this.addValue(field, record.getValue(field));
    }

    @Override
    public final <T> void addValue(Field<T> field, T value) {
        this.getValues().put(field, Utils.field(value, field));
    }

    @Override
    public final <T> void addValue(Field<T> field, Field<T> value) {
        this.getValues().put(field, Utils.field(value, field));
    }

    @Override
    public final void setReturning() {
        this.setReturning(this.getInto().fields());
    }

    @Override
    public final void setReturning(Identity<R, ? extends Number> identity) {
        if (identity != null) {
            this.setReturning(identity.getField());
        }
    }

    @Override
    public final void setReturning(Field<?> ... fields) {
        this.setReturning(Arrays.asList(fields));
    }

    @Override
    public final void setReturning(Collection<? extends Field<?>> fields) {
        this.returning.clear();
        this.returning.addAll((Collection<Field<?>>)fields);
    }

    @Override
    public final R getReturnedRecord() {
        if (this.getReturnedRecords().size() == 0) {
            return null;
        }
        return (R)((Record)this.getReturnedRecords().get(0));
    }

    @Override
    public final Result<R> getReturnedRecords() {
        if (this.returned == null) {
            this.returned = new ResultImpl(this.configuration(), this.returning);
        }
        return this.returned;
    }

    final void toSQLReturning(Context<?> ctx) {
        if (!this.returning.isEmpty()) {
            switch (ctx.configuration().dialect()) {
                case FIREBIRD: 
                case POSTGRES: {
                    ctx.formatSeparator().keyword("returning").sql(" ").visit(this.returning);
                    break;
                }
            }
        }
    }

    @Override
    protected final void prepare(ExecuteContext ctx) throws SQLException {
        Connection connection = ctx.connection();
        if (this.returning.isEmpty()) {
            super.prepare(ctx);
            return;
        }
        switch (ctx.configuration().dialect().family()) {
            case FIREBIRD: 
            case POSTGRES: 
            case SQLITE: 
            case CUBRID: {
                super.prepare(ctx);
                return;
            }
            case DERBY: 
            case H2: 
            case MARIADB: 
            case MYSQL: {
                ctx.statement(connection.prepareStatement(ctx.sql(), 1));
                return;
            }
        }
        ArrayList<String> names = new ArrayList<String>();
        RenderNameStyle style = this.configuration().settings().getRenderNameStyle();
        for (Field<?> field : this.returning) {
            if (style == RenderNameStyle.UPPER) {
                names.add(field.getName().toUpperCase());
                continue;
            }
            if (style == RenderNameStyle.LOWER) {
                names.add(field.getName().toLowerCase());
                continue;
            }
            names.add(field.getName());
        }
        ctx.statement(connection.prepareStatement(ctx.sql(), names.toArray(new String[names.size()])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final int execute(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        ResultSet rs;
        if (this.returning.isEmpty()) {
            return super.execute(ctx, listener);
        }
        int result = 1;
        switch (ctx.configuration().dialect().family()) {
            case SQLITE: {
                try {
                    listener.executeStart(ctx);
                    result = ctx.statement().executeUpdate();
                    ctx.rows(result);
                    listener.executeEnd(ctx);
                }
                finally {
                    Utils.consumeWarnings(ctx, listener);
                }
                DSLContext create = DSL.using(ctx.configuration());
                this.returned = create.select(this.returning).from(this.getInto()).where(SQLiteDSL.rowid().equal(SQLiteDSL.rowid().getDataType().convert((Object)create.lastID()))).fetchInto(this.getInto());
                return result;
            }
            case CUBRID: {
                try {
                    listener.executeStart(ctx);
                    result = ctx.statement().executeUpdate();
                    ctx.rows(result);
                    listener.executeEnd(ctx);
                }
                finally {
                    Utils.consumeWarnings(ctx, listener);
                }
                this.selectReturning(ctx.configuration(), this.create(ctx.configuration()).lastID());
                return result;
            }
            case DERBY: 
            case H2: 
            case MARIADB: 
            case MYSQL: {
                try {
                    listener.executeStart(ctx);
                    result = ctx.statement().executeUpdate();
                    ctx.rows(result);
                    listener.executeEnd(ctx);
                }
                finally {
                    Utils.consumeWarnings(ctx, listener);
                }
                ResultSet rs2 = ctx.statement().getGeneratedKeys();
                try {
                    ArrayList<Object> list = new ArrayList<Object>();
                    if (rs2 != null) {
                        while (rs2.next()) {
                            list.add(rs2.getObject(1));
                        }
                    }
                    this.selectReturning(ctx.configuration(), list.toArray());
                    int n = result;
                    return n;
                }
                finally {
                    JDBCUtils.safeClose(rs2);
                }
            }
            case FIREBIRD: 
            case POSTGRES: {
                try {
                    listener.executeStart(ctx);
                    rs = ctx.statement().executeQuery();
                    listener.executeEnd(ctx);
                    break;
                }
                finally {
                    Utils.consumeWarnings(ctx, listener);
                }
            }
            default: {
                try {
                    listener.executeStart(ctx);
                    result = ctx.statement().executeUpdate();
                    ctx.rows(result);
                    listener.executeEnd(ctx);
                }
                finally {
                    Utils.consumeWarnings(ctx, listener);
                }
                rs = ctx.statement().getGeneratedKeys();
            }
        }
        DefaultExecuteContext ctx2 = new DefaultExecuteContext(ctx.configuration());
        ExecuteListeners listener2 = new ExecuteListeners(ctx2);
        ctx2.resultSet(rs);
        this.returned = new CursorImpl(ctx2, listener2, Utils.fieldArray(this.returning), null, false, true).fetch().into(this.getInto());
        return result;
    }

    private final void selectReturning(Configuration configuration, Object ... values) {
        if (values != null && values.length > 0 && this.into.getIdentity() != null) {
            final TableField<R, Number> field = this.into.getIdentity().getField();
            Number[] ids = new Number[values.length];
            for (int i = 0; i < values.length; ++i) {
                ids[i] = (Number)field.getDataType().convert(values[i]);
            }
            if (this.returning.size() == 1 && new Fields(this.returning).field(field) != null) {
                for (final Number id : ids) {
                    this.getReturnedRecords().add(Utils.newRecord(true, this.into, configuration).operate(new RecordOperation<R, RuntimeException>(){

                        @Override
                        public R operate(R record) throws RuntimeException {
                            int index = record.fieldsRow().indexOf(field);
                            ((AbstractRecord)record).values[index] = id;
                            ((AbstractRecord)record).originals[index] = id;
                            return record;
                        }
                    }));
                }
            } else {
                this.returned = this.create(configuration).select(this.returning).from(this.into).where(field.in(ids)).fetchInto(this.into);
            }
        }
    }
}

